/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.frames;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.frames.CBaseStatusBar;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CLookAndFeels;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class CStatusBar
extends CBaseStatusBar {
    public static final int TIMER_INITIAL_DELAY = 0;
    public static final int TIMER_DELAY = 1000;
    private CClientInfo m_rClientInfo;
    private JLabel m_cUserInfo;
    private JLabel m_cConnectionInfo;
    private long m_lStart;
    private long m_lEnd;
    private Timer m_Timer;

    public CStatusBar(CClientInfo rClientInfo) {
        this.InitVars(rClientInfo);
    }

    private void InitVars(CClientInfo rClientInfo) {
        this.m_rClientInfo = rClientInfo;
        this.m_lStart = System.currentTimeMillis();
        this.m_lEnd = System.currentTimeMillis();
        this.m_Timer = this.CreateTimer();
        if (this.GetResizeArea() != null) {
            this.GetResizeArea().setIcon(CMainFrame.GetJARImage("Resize.png"));
        }
        this.m_cUserInfo = new JLabel();
        if (this.GetUserCtrl() != null) {
            this.GetUserCtrl().setText(String.format(CString.LoadString("IDS_USER_ID_FMT"), this.GetLoginID()));
        }
        this.m_cConnectionInfo = new JLabel();
        this.UpdateBorder(this.GetUserCtrl());
        this.UpdateBorder(this.GetConnectionCtrl());
        this.LayoutControls();
        this.UpdateDuration();
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
    }

    private Timer CreateTimer() {
        Timer objTimer = new Timer(true);
        objTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                CStatusBar.this.OnUpdateDuration();
            }
        }, 0L, 1000L);
        return objTimer;
    }

    @Override
    protected void LayoutControls() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(2).addComponent(this.GetStatusArea(), -1, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetUserCtrl(), -1, -2, -2).addComponent(this.GetConnectionCtrl(), -1, -2, 160).addComponent(this.GetResizeArea(), -1, -2, -2));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(this.GetStatusArea(), -1, -2, Short.MAX_VALUE).addComponent(this.GetUserCtrl(), -1, -2, Short.MAX_VALUE).addComponent(this.GetConnectionCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetResizeArea(), -1, -2, -2)));
    }

    private void UpdateBorder(JComponent rComp) {
        if (rComp != null) {
            Color clrTL = rComp.getBackground();
            Color clrBR = rComp.getBackground();
            if (!CColorUtils.IsADarkColor(rComp.getBackground())) {
                clrTL = clrTL.darker().darker().darker();
                clrBR = clrBR.brighter();
            } else {
                clrTL = clrTL.brighter();
                clrBR = clrBR.darker().darker().darker();
            }
            LookAndFeel rLnF = UIManager.getLookAndFeel();
            if (rLnF.getID() != null && rLnF.getID().equals("Windows")) {
                clrBR = (Color)UIManager.get("Table.background");
            }
            MatteBorder borderTL = BorderFactory.createMatteBorder(1, 1, 0, 0, clrTL);
            MatteBorder borderBR = BorderFactory.createMatteBorder(0, 0, 1, 1, clrBR);
            CompoundBorder border = BorderFactory.createCompoundBorder(borderTL, borderBR);
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 2, 0, 2));
            rComp.setBorder(border);
        }
    }

    private JLabel GetUserCtrl() {
        return this.m_cUserInfo;
    }

    private JLabel GetConnectionCtrl() {
        return this.m_cConnectionInfo;
    }

    public void OnUpdateDuration() {
        this.m_lEnd = System.currentTimeMillis();
        this.UpdateDuration();
    }

    private void UpdateDuration() {
        ImageIcon icoImage = null;
        String sTemp = CString.LoadString("IDS_STATUS_FMT_DURATION");
        if (this.IsSecure()) {
            sTemp = CString.LoadString("IDS_STATUS_FMT_DURATION_SSL");
            icoImage = CMainFrame.GetJARImage("Lock.png");
        }
        long lElapsedMillis = this.m_lEnd - this.m_lStart;
        long lSecs = lElapsedMillis / 1000L % 60L;
        long lMins = lElapsedMillis / 60000L % 60L;
        long lHours = lElapsedMillis / 3600000L;
        sTemp = String.format(sTemp, lHours, lMins, lSecs);
        if (this.GetConnectionCtrl() != null) {
            this.GetConnectionCtrl().setText(sTemp);
            this.GetConnectionCtrl().setIcon(icoImage);
        }
        CMainFrame.GET_APP().OnUpdateFocus();
    }

    private CClientInfo GetClientInfo() {
        return this.m_rClientInfo;
    }

    private String GetLoginID() {
        String sLoginID = "";
        if (this.GetClientInfo() != null) {
            sLoginID = this.GetClientInfo().GetLoginID();
        }
        return sLoginID;
    }

    private boolean IsSecure() {
        boolean bIsSecure = false;
        if (this.GetClientInfo() != null) {
            bIsSecure = this.GetClientInfo().IsSecure();
        }
        return bIsSecure;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.IsWindowsOfficeLnF()) {
            Office2003Painter.getInstance().paintStatusBarBackground(this, g2, rect, 0, 0);
        } else {
            Graphics2D g22 = (Graphics2D)g2;
            g22.setColor(this.GetBackClr());
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private boolean IsWindowsOfficeLnF() {
        return CLookAndFeels.IsWindowsOffice();
    }

    private Color GetBackClr() {
        Color clr = UIDefaultsLookup.getColor("Panel.background");
        if (clr == null) {
            clr = Color.LIGHT_GRAY;
        }
        return clr;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 9205: {
                    if (rEvent.GetEventObj() == null || !(rEvent.GetEventObj() instanceof String)) break;
                    String sStatus = (String)rEvent.GetEventObj();
                    this.SetStatus(sStatus);
                    break;
                }
            }
        }
    }
}

