/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.events;

import com.jidesoft.docking.DockableFrame;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.events.CLockNavInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class CLockNavsMenuItem
extends JMenuItem {
    private boolean m_bLocked;
    private DockableFrame m_rDockFrameSource;
    private String m_sLockTxt;
    private String m_sUnlockTxt;
    private ImageIcon m_iLockedIcon;
    private ImageIcon m_iUnlockedIcon;

    public CLockNavsMenuItem(DockableFrame rDockFrameSource) {
        this.setAction(CMainFrame.GET_APP().GetAction(9625));
        this.setToolTipText(null);
        this.m_sLockTxt = CString.LoadString("IDS_LOCK_NAV_MENU");
        this.m_sUnlockTxt = CString.LoadString("IDS_UNLOCK_NAV_MENU");
        this.m_iLockedIcon = CMainFrame.GetJARImage("LockNavLocked16.png");
        this.m_iUnlockedIcon = CMainFrame.GetJARImage("LockNavUnlocked16.png");
        this.m_bLocked = false;
        this.m_rDockFrameSource = rDockFrameSource;
        this.UpdateText();
        this.UpdateIcon();
    }

    @Override
    protected void processEvent(AWTEvent event) {
        block6: {
            block5: {
                CRhinoEvent rEvent = null;
                if (event instanceof CRhinoEvent) {
                    rEvent = (CRhinoEvent)event;
                }
                if (rEvent == null) break block5;
                switch (event.getID()) {
                    case 9629: {
                        CLockNavInfo rLockNavInfo = (CLockNavInfo)rEvent.GetEventObj();
                        if (rLockNavInfo != null) {
                            boolean bIsLocked = rLockNavInfo.IsLocked();
                            this.SetLocked(bIsLocked);
                            break;
                        }
                        break block6;
                    }
                    default: {
                        super.processEvent(event);
                        break;
                    }
                }
                break block6;
            }
            super.processEvent(event);
        }
    }

    public void SetLocked(boolean bLocked) {
        this.m_bLocked = bLocked;
        this.UpdateIcon();
        this.UpdateText();
    }

    public void UpdateIcon() {
        ImageIcon icon = this.m_iUnlockedIcon;
        if (this.IsLocked()) {
            icon = this.m_iLockedIcon;
        }
        this.setIcon(icon);
    }

    public void UpdateText() {
        String sText = this.m_sLockTxt;
        if (this.IsLocked()) {
            sText = this.m_sUnlockTxt;
        }
        this.setText(sText);
    }

    public boolean IsLocked() {
        return this.m_bLocked;
    }

    public DockableFrame GetDockFrameSource() {
        return this.m_rDockFrameSource;
    }

    public void SetDockFrameSource(DockableFrame rDockFrame) {
        this.m_rDockFrameSource = rDockFrame;
    }
}

