/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.events;

import com.rhinosoft.fvjv.gui.events.CFVJVAction;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import javax.swing.ImageIcon;

public class CActionFactory {
    public static final String THUMB_SIZE_75x75 = "75x75";
    public static final String THUMB_SIZE_100x100 = "100x100";
    public static final String THUMB_SIZE_150x150 = "150x150";
    public static final String THUMB_SIZE_200x200 = "200x200";
    public static final String THUMB_SIZE_250x250 = "250x250";

    private CActionFactory() {
    }

    public static CFVJVAction CreateOnAction(int nEventID) {
        CFVJVAction action = new CFVJVAction(nEventID);
        return action;
    }

    public static CFVJVAction CreateAction(int nEventID) {
        CFVJVAction action = null;
        switch (nEventID) {
            case 2000: {
                action = CActionFactory.CreateFile();
                break;
            }
            case 2001: {
                action = CActionFactory.CreateNewLocalBrowser();
                break;
            }
            case 2002: {
                action = CActionFactory.CreateNewRemoteBrowser();
                break;
            }
            case 2003: {
                action = CActionFactory.CreateNewFolder();
                break;
            }
            case 2004: {
                action = CActionFactory.CreateOpen();
                break;
            }
            case 2005: {
                action = CActionFactory.CreateDelete();
                break;
            }
            case 2006: {
                action = CActionFactory.CreateRename();
                break;
            }
            case 2007: {
                action = CActionFactory.CreateProperties();
                break;
            }
            case 2240: {
                action = CActionFactory.CreateAvailableDirSize();
                break;
            }
            case 2241: {
                action = CActionFactory.CreateCancelAvailableDirSize();
                break;
            }
            case 2008: {
                action = CActionFactory.CreateUpload();
                break;
            }
            case 2009: {
                action = CActionFactory.CreateDownload();
                break;
            }
            case 2010: {
                action = CActionFactory.CreateStop();
                break;
            }
            case 2012: {
                action = CActionFactory.CreateSaveLogin();
                break;
            }
            case 2013: {
                action = CActionFactory.CreateChangePword();
                break;
            }
            case 2014: {
                action = CActionFactory.CreateChangeEmail();
                break;
            }
            case 2015: {
                action = CActionFactory.CreateExit();
                break;
            }
            case 2020: {
                action = CActionFactory.CreateEdit();
                break;
            }
            case 2021: {
                action = CActionFactory.CreateSelectAll();
                break;
            }
            case 2022: {
                action = CActionFactory.CreateInvertSelection();
                break;
            }
            case 2023: {
                action = CActionFactory.CreateFindInFiles();
                break;
            }
            case 2011: {
                action = CActionFactory.CreateSyncFolders();
                break;
            }
            case 2024: {
                action = CActionFactory.CreatePreferences();
                break;
            }
            case 2025: {
                action = CActionFactory.CreateEditBrowserTemplate();
                break;
            }
            case 2030: {
                action = CActionFactory.CreateView();
                break;
            }
            case 2031: {
                action = CActionFactory.CreateStyle();
                break;
            }
            case 2032: {
                action = CActionFactory.CreateLnfMetal();
                break;
            }
            case 2033: {
                action = CActionFactory.CreateLnfNimbus();
                break;
            }
            case 2034: {
                action = CActionFactory.CreateLnfEclipse3x();
                break;
            }
            case 2035: {
                action = CActionFactory.CreateLnfEclipse();
                break;
            }
            case 2040: {
                action = CActionFactory.CreateLnfWindows();
                break;
            }
            case 2041: {
                action = CActionFactory.CreateLnfWindowsDefault();
                break;
            }
            case 2042: {
                action = CActionFactory.CreateLnfWindowsVSNET();
                break;
            }
            case 2043: {
                action = CActionFactory.CreateLnfWindowsOffice();
                break;
            }
            case 2044: {
                action = CActionFactory.CreateLnfWindowsOfficeDefault();
                break;
            }
            case 2045: {
                action = CActionFactory.CreateLnfWindowsOfficeGray();
                break;
            }
            case 2046: {
                action = CActionFactory.CreateLnfWindowsOfficeHomestead();
                break;
            }
            case 2047: {
                action = CActionFactory.CreateLnfWindowsOfficeMetallic();
                break;
            }
            case 2048: {
                action = CActionFactory.CreateLnfWindowsOfficeBlue();
                break;
            }
            case 2060: {
                action = CActionFactory.CreateLnfXerto();
                break;
            }
            case 2070: {
                action = CActionFactory.CreateLnfNixGTKPlus();
                break;
            }
            case 2080: {
                action = CActionFactory.CreateLnfMacAqua();
                break;
            }
            case 2090: {
                action = CActionFactory.CreateToolbars();
                break;
            }
            case 2091: {
                action = CActionFactory.CreateShowToolbarMain();
                break;
            }
            case 2092: {
                action = CActionFactory.CreateShowCrumbBar();
                break;
            }
            case 2093: {
                action = CActionFactory.CreateShowToolbar();
                break;
            }
            case 2097: {
                action = CActionFactory.CreatePanes();
                break;
            }
            case 2098: {
                action = CActionFactory.CreateShowTreePane();
                break;
            }
            case 2099: {
                action = CActionFactory.CreateShowPreviewPane();
                break;
            }
            case 2100: {
                action = CActionFactory.CreateViews();
                break;
            }
            case 2101: {
                action = CActionFactory.CreateViewLargeIcons();
                break;
            }
            case 2102: {
                action = CActionFactory.CreateViewSmallIcons();
                break;
            }
            case 2103: {
                action = CActionFactory.CreateViewList();
                break;
            }
            case 2104: {
                action = CActionFactory.CreateViewDetails();
                break;
            }
            case 2105: {
                action = CActionFactory.CreateViewThumbs();
                break;
            }
            case 2106: 
            case 2107: 
            case 2108: 
            case 2109: 
            case 2110: {
                action = CActionFactory.CreateViewThumb(nEventID);
                break;
            }
            case 2111: {
                action = CActionFactory.CreateGoto();
                break;
            }
            case 2112: {
                action = CActionFactory.CreateBack();
                break;
            }
            case 2113: {
                action = CActionFactory.CreateForward();
                break;
            }
            case 2230: {
                action = CActionFactory.CreateNavHistory();
                break;
            }
            case 2114: {
                action = CActionFactory.CreateUpDir();
                break;
            }
            case 2115: {
                action = CActionFactory.CreateRefresh();
                break;
            }
            case 2120: {
                action = CActionFactory.CreateWindows();
                break;
            }
            case 2121: {
                action = CActionFactory.CreateFrameClose();
                break;
            }
            case 2122: {
                action = CActionFactory.CreateFrameFloating();
                break;
            }
            case 2123: {
                action = CActionFactory.CreateFrameAutoHide();
                break;
            }
            case 2124: {
                action = CActionFactory.CreateFrameAutoHideHide();
                break;
            }
            case 2125: {
                action = CActionFactory.CreateFrameAutoHideShow();
                break;
            }
            case 2126: {
                action = CActionFactory.CreateFrameDockable();
                break;
            }
            case 2127: {
                action = CActionFactory.CreateFrameAutoHideAll();
                break;
            }
            case 2128: {
                action = CActionFactory.CreateFrameCloseAll();
                break;
            }
            case 2129: {
                action = CActionFactory.CreateFrameResetLayout();
                break;
            }
            case 2130: {
                action = CActionFactory.CreateFrameActivate();
                break;
            }
            case 2135: {
                action = CActionFactory.CreateShowWindowsDlg();
                break;
            }
            case 2140: {
                action = CActionFactory.CreateHelp();
                break;
            }
            case 2141: {
                action = CActionFactory.CreateHelpTopics();
                break;
            }
            case 2142: {
                action = CActionFactory.CreateHelpOverview();
                break;
            }
            case 2143: {
                action = CActionFactory.CreateSupport();
                break;
            }
            case 2144: {
                action = CActionFactory.CreateAbout();
                break;
            }
            case 2150: {
                action = CActionFactory.CreateCustomize();
                break;
            }
            case 2160: {
                action = CActionFactory.CreateTransferStopAtNextFile();
                break;
            }
            case 2161: {
                action = CActionFactory.CreateTransferSkipFile();
                break;
            }
            case 2162: {
                action = CActionFactory.CreateTransferPause();
                break;
            }
            case 2163: {
                action = CActionFactory.CreateTransferResume();
                break;
            }
            case 2164: {
                action = CActionFactory.CreateTransferCancel();
                break;
            }
            case 2165: {
                action = CActionFactory.CreateTransferRemove();
                break;
            }
            case 2166: {
                action = CActionFactory.CreateTransferRemoveAllCompleted();
                break;
            }
            case 2167: {
                action = CActionFactory.CreateTransferRemoveAllCancelled();
                break;
            }
            case 2170: {
                action = CActionFactory.CreateResetToolbar();
                break;
            }
            case 2171: {
                action = CActionFactory.CreateNewLocalBrowserVisible();
                break;
            }
            case 2172: {
                action = CActionFactory.CreateNewRemoteBrowserVisible();
                break;
            }
            case 2173: {
                action = CActionFactory.CreateStopVisible();
                break;
            }
            case 2174: {
                action = CActionFactory.CreateSaveLoginVisible();
                break;
            }
            case 2175: {
                action = CActionFactory.CreateChangePwordVisible();
                break;
            }
            case 2176: {
                action = CActionFactory.CreateChangeEmailVisible();
                break;
            }
            case 2177: {
                action = CActionFactory.CreateExitVisible();
                break;
            }
            case 2178: {
                action = CActionFactory.CreateSelectAllVisible();
                break;
            }
            case 2179: {
                action = CActionFactory.CreateInvertSelectionVisible();
                break;
            }
            case 2180: {
                action = CActionFactory.CreateSyncFoldersVisible();
                break;
            }
            case 2181: {
                action = CActionFactory.CreatePreferencesVisible();
                break;
            }
            case 2193: {
                action = CActionFactory.CreateNewFolderVisible();
                break;
            }
            case 2194: {
                action = CActionFactory.CreateOpenVisible();
                break;
            }
            case 2195: {
                action = CActionFactory.CreateDeleteVisible();
                break;
            }
            case 2196: {
                action = CActionFactory.CreateRenameVisible();
                break;
            }
            case 2197: {
                action = CActionFactory.CreatePropertiesVisible();
                break;
            }
            case 2182: {
                action = CActionFactory.CreateHelpTopicsVisible();
                break;
            }
            case 2183: {
                action = CActionFactory.CreateHelpOverviewVisible();
                break;
            }
            case 2184: {
                action = CActionFactory.CreateSupportVisible();
                break;
            }
            case 2185: {
                action = CActionFactory.CreateAboutVisible();
                break;
            }
            case 2198: {
                action = CActionFactory.CreateUploadVisible();
                break;
            }
            case 2199: {
                action = CActionFactory.CreateDownloadVisible();
                break;
            }
            case 2200: {
                action = CActionFactory.CreateViewsVisible();
                break;
            }
            case 2201: {
                action = CActionFactory.CreateViewLargeIconsVisible();
                break;
            }
            case 2202: {
                action = CActionFactory.CreateViewSmallIconsVisible();
                break;
            }
            case 2203: {
                action = CActionFactory.CreateViewListVisible();
                break;
            }
            case 2204: {
                action = CActionFactory.CreateViewDetailsVisible();
                break;
            }
            case 2205: {
                action = CActionFactory.CreateViewThumbsVisible();
                break;
            }
            case 2206: {
                action = CActionFactory.CreateBackVisible();
                break;
            }
            case 2207: {
                action = CActionFactory.CreateForwardVisible();
                break;
            }
            case 2231: {
                action = CActionFactory.CreateNavHistoryVisible();
                break;
            }
            case 2208: {
                action = CActionFactory.CreateUpDirVisible();
                break;
            }
            case 2209: {
                action = CActionFactory.CreateRefreshVisible();
                break;
            }
            case 2220: {
                action = CActionFactory.CreateTransferStopAtNextFileVisible();
                break;
            }
            case 2221: {
                action = CActionFactory.CreateTransferSkipFileVisible();
                break;
            }
            case 2222: {
                action = CActionFactory.CreateTransferPauseVisible();
                break;
            }
            case 2223: {
                action = CActionFactory.CreateTransferResumeVisible();
                break;
            }
            case 2224: {
                action = CActionFactory.CreateTransferCancelVisible();
                break;
            }
            case 2225: {
                action = CActionFactory.CreateTransferRemoveVisible();
                break;
            }
            case 2226: {
                action = CActionFactory.CreateTransferRemoveAllCompletedVisible();
                break;
            }
            case 2227: {
                action = CActionFactory.CreateTransferRemoveAllCancelledVisible();
                break;
            }
            case 8000: {
                action = CActionFactory.CreateMediaPlayerPlay();
                break;
            }
            case 8001: {
                action = CActionFactory.CreateMediaPlayerPlayVisible();
                break;
            }
            case 8002: {
                action = CActionFactory.CreateMediaPlayerPause();
                break;
            }
            case 8003: {
                action = CActionFactory.CreateMediaPlayerPauseVisible();
                break;
            }
            case 8004: {
                action = CActionFactory.CreateMediaPlayerStop();
                break;
            }
            case 8005: {
                action = CActionFactory.CreateMediaPlayerStopVisible();
                break;
            }
            case 8006: {
                action = CActionFactory.CreateMediaPlayerSeekReverse();
                break;
            }
            case 8007: {
                action = CActionFactory.CreateMediaPlayerSeekReverseVisible();
                break;
            }
            case 8008: {
                action = CActionFactory.CreateMediaPlayerSeekForward();
                break;
            }
            case 8009: {
                action = CActionFactory.CreateMediaPlayerSeekForwardVisible();
                break;
            }
            case 8010: {
                action = CActionFactory.CreateMediaPlayerPreviousTrack();
                break;
            }
            case 8011: {
                action = CActionFactory.CreateMediaPlayerPreviousTrackVisible();
                break;
            }
            case 8012: {
                action = CActionFactory.CreateMediaPlayerNextTrack();
                break;
            }
            case 8013: {
                action = CActionFactory.CreateMediaPlayerNextTrackVisible();
                break;
            }
            case 8014: {
                action = CActionFactory.CreateMediaPlayerRepeat();
                break;
            }
            case 8015: {
                action = CActionFactory.CreateMediaPlayerRepeatVisible();
                break;
            }
            case 8016: {
                action = CActionFactory.CreateMediaPlayerMute();
                break;
            }
            case 8017: {
                action = CActionFactory.CreateMediaPlayerMuteVisible();
                break;
            }
            case 8018: {
                action = CActionFactory.CreateMediaPlayerShowPlaylist();
                break;
            }
            case 8019: {
                action = CActionFactory.CreateMediaPlayerShowPlaylistVisible();
                break;
            }
            case 8020: {
                action = CActionFactory.CreateMediaPlayerPlaylistRemove();
                break;
            }
            case 8021: {
                action = CActionFactory.CreateMediaPlayerPlaylistRemoveVisible();
                break;
            }
            case 8100: {
                action = CActionFactory.CreatePlayerAddToPlaylist();
                break;
            }
            case 9501: {
                action = CActionFactory.CreateSearchSearch();
                break;
            }
            case 9502: {
                action = CActionFactory.CreateSearchCancel();
                break;
            }
            case 9503: {
                action = CActionFactory.CreateSearchPause();
                break;
            }
            case 9625: {
                action = CActionFactory.CreateLockNavInitSource();
                break;
            }
            case 9626: {
                action = CActionFactory.CreateLockNavInitSourceVisible();
                break;
            }
            case 9630: {
                action = CActionFactory.CreateLockNavUnlock();
                break;
            }
        }
        return action;
    }

    public static CFVJVAction CreateFile() {
        CFVJVAction rAction = new CFVJVAction(2000);
        rAction.SetName(CString.LoadString("IDS_FILE_MENU", false));
        rAction.SetLongDesc(CString.LoadString("IDS_FILE_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateNewLocalBrowser() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2001);
        rAction.SetName(CString.LoadString("IDS_NEW_LOCAL_BROWSER_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_NEW_LOCAL_BROWSER_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_NEW_LOCAL_BROWSER_STATUS"));
        rAction.SetAccelerator(117);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Computer.png"));
        return rAction;
    }

    public static CFVJVAction CreateNewRemoteBrowser() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2002);
        rAction.SetName(CString.LoadString("IDS_NEW_REMOTE_BROWSER_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_NEW_REMOTE_BROWSER_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_NEW_REMOTE_BROWSER_STATUS"));
        rAction.SetAccelerator(118);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ComputerRemote.png"));
        return rAction;
    }

    public static CFVJVAction CreateNewFolder() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2003);
        rAction.SetName(CString.LoadString("IDS_NEW_FOLDER_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_NEW_FOLDER_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_NEW_FOLDER_STATUS"));
        rAction.SetAccelerator(78, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderNew.png"));
        return rAction;
    }

    public static CFVJVAction CreateOpen() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2004);
        rAction.SetName(CString.LoadString("IDS_OPEN_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_OPEN_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_OPEN_STATUS"));
        rAction.SetAccelerator(79, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderOpened.png"));
        return rAction;
    }

    public static CFVJVAction CreateDelete() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2005);
        rAction.SetName(CString.LoadString("IDS_DELETE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_DELETE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_DELETE_STATUS"));
        rAction.SetAccelerator(127);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Delete.png"));
        return rAction;
    }

    public static CFVJVAction CreateRename() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2006);
        rAction.SetName(CString.LoadString("IDS_RENAME_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_RENAME_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_RENAME_STATUS"));
        rAction.SetAccelerator(113);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileRename.png"));
        return rAction;
    }

    public static CFVJVAction CreateProperties() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2007);
        rAction.SetName(CString.LoadString("IDS_PROPERTIES_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_PROPERTIES_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_PROPERTIES_STATUS"));
        rAction.SetAccelerator(10, 512);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileProperties.png"));
        return rAction;
    }

    public static CFVJVAction CreateAvailableDirSize() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2240);
        rAction.SetName(CString.LoadString("IDS_CALCULATE_AVAIL_DIR_SIZE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CALCULATE_AVAIL_DIR_SIZE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CALCULATE_AVAIL_DIR_SIZE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Refresh.png"));
        return rAction;
    }

    public static CFVJVAction CreateCancelAvailableDirSize() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2241);
        rAction.SetName(CString.LoadString("IDS_CANCEL_AVAIL_DIR_SIZE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CANCEL_AVAIL_DIR_SIZE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CANCEL_AVAIL_DIR_SIZE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Delete.png"));
        return rAction;
    }

    public static CFVJVAction CreateUpload() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2008);
        rAction.SetName(CString.LoadString("IDS_UPLOAD_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_UPLOAD_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_UPLOAD_STATUS"));
        rAction.SetAccelerator(85, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileUpload.png"));
        return rAction;
    }

    public static CFVJVAction CreateDownload() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2009);
        rAction.SetName(CString.LoadString("IDS_DOWNLOAD_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_DOWNLOAD_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_DOWNLOAD_STATUS"));
        rAction.SetAccelerator(68, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileDownload.png"));
        return rAction;
    }

    public static CFVJVAction CreateStop() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2010);
        rAction.SetName(CString.LoadString("IDS_STOP_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_STOP_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_STOP_STATUS"));
        rAction.SetAccelerator(116, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Stop.png"));
        return rAction;
    }

    public static CFVJVAction CreateSaveLogin() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2012);
        rAction.SetName(CString.LoadString("IDS_SAVE_LOGIN_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SAVE_LOGIN_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_SAVE_LOGIN_STATUS"));
        rAction.SetAccelerator(121, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("SaveLogin.png"));
        return rAction;
    }

    public static CFVJVAction CreateChangePword() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2013);
        rAction.SetName(CString.LoadString("IDS_CHANGE_PASSWORD_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CHANGE_PASSWORD_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CHANGE_PASSWORD_STATUS"));
        rAction.SetAccelerator(121);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Keys.png"));
        return rAction;
    }

    public static CFVJVAction CreateChangeEmail() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2014);
        rAction.SetName(CString.LoadString("IDS_CHANGE_EMAIL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CHANGE_EMAIL_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CHANGE_EMAIL_STATUS"));
        rAction.SetAccelerator(121, 64);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ChangeEmail.png"));
        return rAction;
    }

    public static CFVJVAction CreateExit() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2015);
        rAction.SetName(CString.LoadString("IDS_EXIT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_EXIT_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_EXIT_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Exit.png"));
        return rAction;
    }

    public static CFVJVAction CreateEdit() {
        CFVJVAction rAction = new CFVJVAction(2020);
        rAction.SetName(CString.LoadString("IDS_EDIT_MENU", false));
        rAction.SetLongDesc(CString.LoadString("IDS_EDIT_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateSelectAll() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2021);
        rAction.SetName(CString.LoadString("IDS_SELECT_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SELECT_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_SELECT_ALL_STATUS"));
        rAction.SetAccelerator(65, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("RowsSelectAll16.png"));
        return rAction;
    }

    public static CFVJVAction CreateInvertSelection() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2022);
        rAction.SetName(CString.LoadString("IDS_INVERT_SELECTION_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_INVERT_SELECTION_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_INVERT_SELECTION_STATUS"));
        rAction.SetAccelerator(73, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("RowsInvertSelection16.png"));
        return rAction;
    }

    public static CFVJVAction CreateFindInFiles() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2023);
        rAction.SetName(CString.LoadString("IDS_FIND_IN_FILES_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FIND_IN_FILES_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FIND_IN_FILES_STATUS"));
        rAction.SetAccelerator(70, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MagnifingGlass16.png"));
        return rAction;
    }

    public static CFVJVAction CreateSyncFolders() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2011);
        rAction.SetName(CString.LoadString("IDS_SYNC_FOLDERS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SYNC_FOLDERS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_SYNC_FOLDERS_STATUS"));
        rAction.SetAccelerator(83, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderSync16.png"));
        return rAction;
    }

    public static CFVJVAction CreatePreferences() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2024);
        rAction.SetName(CString.LoadString("IDS_PREFERENCES_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_PREFERENCES_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_PREFERENCES_STATUS"));
        rAction.SetAccelerator(120);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Preferences.png"));
        return rAction;
    }

    public static CFVJVAction CreateEditBrowserTemplate() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2025);
        rAction.SetName(CString.LoadString("IDS_EDIT_BROWSER_TEMPLATE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_EDIT_BROWSER_TEMPLATE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_EDIT_BROWSER_TEMPLATE_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateView() {
        CFVJVAction rAction = new CFVJVAction(2030);
        rAction.SetName(CString.LoadString("IDS_VIEW_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEW_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEW_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateStyle() {
        CFVJVAction rAction = new CFVJVAction(2031);
        rAction.SetName(CString.LoadString("IDS_STYLE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_STYLE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_STYLE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfMetal() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2032);
        rAction.SetName(CString.LoadString("IDS_LNF_METAL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_METAL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Metal.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfNimbus() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2033);
        rAction.SetName(CString.LoadString("IDS_LNF_NIMBUS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_NIMBUS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Nimbus.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfEclipse3x() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2034);
        rAction.SetName(CString.LoadString("IDS_LNF_ECLIPSE3X_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_ECLIPSE3X_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Eclipse3x.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfEclipse() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2035);
        rAction.SetName(CString.LoadString("IDS_LNF_ECLIPSE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_ECLIPSE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Eclipse.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindows() {
        CFVJVAction rAction = new CFVJVAction(2040);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Windows.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsDefault() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2041);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_DEFAULT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_DEFAULT_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Windows_Default.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsVSNET() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2042);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_VSNET_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_VSNET_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Windows_VSNet.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsOffice() {
        CFVJVAction rAction = new CFVJVAction(2043);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Office.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsOfficeDefault() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2044);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_DEFAULT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_DEFAULT_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Office2003_Default.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsOfficeGray() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2045);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_GRAY_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_GRAY_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Office2003_Gray.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsOfficeHomestead() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2046);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_HOMESTEAD_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_HOMESTEAD_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Office2003_Homestead.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsOfficeMetallic() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2047);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_METALLIC_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_METALLIC_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Office2003_Metallic.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfWindowsOfficeBlue() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2048);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_BLUE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_BLUE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Office2003_Blue.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfXerto() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2060);
        rAction.SetName(CString.LoadString("IDS_LNF_XERTO_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_XERTO_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Xerto.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfNixGTKPlus() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2070);
        rAction.SetName(CString.LoadString("IDS_LNF_NIX_GTK_PLUS", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_NIX_GTK_PLUS"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_GTK.png"));
        return rAction;
    }

    public static CFVJVAction CreateLnfMacAqua() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2080);
        rAction.SetName(CString.LoadString("IDS_LNF_MAC_AQUA", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_MAC_AQUA"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Style_Aqua.png"));
        return rAction;
    }

    public static CFVJVAction CreateToolbars() {
        CFVJVAction rAction = new CFVJVAction(2090);
        rAction.SetName(CString.LoadString("IDS_TOOLBARS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TOOLBARS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TOOLBARS_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Toolbars.png"));
        return rAction;
    }

    public static CFVJVAction CreateShowToolbarMain() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2091);
        rAction.SetName(CString.LoadString("IDS_TOOLBARS_MAIN_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TOOLBARS_MAIN_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TOOLBARS_MAIN_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Tbar_Main.png"));
        rAction.SetSelected(false);
        return rAction;
    }

    public static CFVJVAction CreatePanes() {
        CFVJVAction rAction = new CFVJVAction(2097);
        rAction.SetName(CString.LoadString("IDS_PANES_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_PANES_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_PANES_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Panes.png"));
        return rAction;
    }

    public static CFVJVAction CreateViews() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2100);
        rAction.SetName(CString.LoadString("IDS_VIEWS_BTN", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEWS_BTN"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEWS_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("View.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewLargeIcons() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2101);
        rAction.SetName(CString.LoadString("IDS_VIEW_LARGE_ICONS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEW_LARGE_ICONS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEW_LARGE_ICONS_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewLargeIcons.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewSmallIcons() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2102);
        rAction.SetName(CString.LoadString("IDS_VIEW_SMALL_ICONS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEW_SMALL_ICONS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEW_SMALL_ICONS_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewSmallIcons.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewList() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2103);
        rAction.SetName(CString.LoadString("IDS_VIEW_LIST_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEW_LIST_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEW_LIST_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewList.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewDetails() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2104);
        rAction.SetName(CString.LoadString("IDS_VIEW_DETAILS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEW_DETAILS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEW_DETAILS_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewDetails.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewThumbs() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2105);
        rAction.SetName(CString.LoadString("IDS_VIEW_THUMBS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEW_THUMBS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEW_THUMBS_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewThumbs.png"));
        return rAction;
    }

    public static CFVJVAction CreateGoto() {
        CFVJVAction rAction = new CFVJVAction(2111);
        rAction.SetName(CString.LoadString("IDS_GOTO_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_GOTO_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_GOTO_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderGoTo.png"));
        return rAction;
    }

    public static CFVJVAction CreateBack() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2112);
        rAction.SetName(CString.LoadString("IDS_BACK_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_BACK_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_BACK_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderBack.png"));
        return rAction;
    }

    public static CFVJVAction CreateForward() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2113);
        rAction.SetName(CString.LoadString("IDS_FORWARD_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FORWARD_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FORWARD_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderForward.png"));
        return rAction;
    }

    public static CFVJVAction CreateNavHistory() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2230);
        rAction.SetName(CString.LoadString("IDS_NAV_HISTORY_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_NAV_HISTORY_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_NAV_HISTORY_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderBack.png"));
        return rAction;
    }

    public static CFVJVAction CreateUpDir() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2114);
        rAction.SetName(CString.LoadString("IDS_UP_DIR_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_UP_DIR_BTN"));
        rAction.SetLongDesc(CString.LoadString("IDS_UP_DIR_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderUpDir.png"));
        return rAction;
    }

    public static CFVJVAction CreateRefresh() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2115);
        rAction.SetName(CString.LoadString("IDS_REFRESH_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REFRESH_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REFRESH_STATUS"));
        rAction.SetAccelerator(116);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Refresh.png"));
        return rAction;
    }

    public static CFVJVAction CreateHelp() {
        CFVJVAction rAction = new CFVJVAction(2140);
        rAction.SetName(CString.LoadString("IDS_HELP_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateHelpTopics() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2141);
        rAction.SetName(CString.LoadString("IDS_HELP_TOPICS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_TOPICS_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_TOPICS_STATUS"));
        rAction.SetAccelerator(112);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("HelpTopics.png"));
        return rAction;
    }

    public static CFVJVAction CreateHelpOverview() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2142);
        rAction.SetName(CString.LoadString("IDS_HELP_OVERVIEW_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_OVERVIEW_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_OVERVIEW_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("HelpOverview.png"));
        return rAction;
    }

    public static CFVJVAction CreateSupport() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2143);
        rAction.SetName(CString.LoadString("IDS_HELP_SUPPORT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_SUPPORT_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_SUPPORT_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TechSupport.png"));
        return rAction;
    }

    public static CFVJVAction CreateAbout() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2144);
        String sName = CString.LoadString("IDS_ABOUT_MENU", false);
        sName = String.format(sName, "FTP Voyager JV");
        rAction.SetName(sName);
        rAction.SetShortDesc(CString.LoadString("IDS_ABOUT_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_ABOUT_STATUS"));
        rAction.SetAccelerator(123);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("About.png"));
        return rAction;
    }

    public static CFVJVAction CreateCustomize() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2150);
        rAction.SetName(CString.LoadString("IDS_CUSTOMIZE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CUSTOMIZE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CUSTOMIZE_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateTransferStopAtNextFile() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2160);
        rAction.SetName(CString.LoadString("IDS_TRANSFER_STOP_AT_NEXT_FILE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TRANSFER_STOP_AT_NEXT_FILE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TRANSFER_STOP_AT_NEXT_FILE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferStopped.png"));
        rAction.SetSelected(false);
        return rAction;
    }

    public static CFVJVAction CreateTransferSkipFile() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2161);
        rAction.SetName(CString.LoadString("IDS_TRANSFER_SKIP_FILE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TRANSFER_SKIP_FILE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TRANSFER_SKIP_FILE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferSkipped.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferPause() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2162);
        rAction.SetName(CString.LoadString("IDS_TRANSFER_PAUSE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TRANSFER_PAUSE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_TRANSFER_PAUSE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferPaused.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferResume() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2163);
        rAction.SetName(CString.LoadString("IDS_RESUME_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_RESUME_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_RESUME_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferResume.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferCancel() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2164);
        rAction.SetName(CString.LoadString("IDS_CANCEL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CANCEL_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CANCEL_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferCancelled.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferRemove() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2165);
        rAction.SetName(CString.LoadString("IDS_REMOVE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferDelete.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferRemoveAllCompleted() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2166);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_COMPLETED_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_COMPLETED_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_COMPLETED_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferRemoveAllDone.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferRemoveAllCancelled() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2167);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_CANCELLED_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_CANCELLED_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_CANCELLED_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferRemoveAllCancelled.png"));
        return rAction;
    }

    public static String FormatVisibleStatus(String sName) {
        String sRet = CString.LoadString("IDS_FMT_SHOW_HIDE_STATUS");
        if (sRet != null) {
            sRet = String.format(sRet, CString.RemoveMnemonic(sName));
        }
        return sRet;
    }

    public static String FormatVisibleTip(String sName) {
        String sRet = CString.LoadString("IDS_FMT_SHOW_HIDE_TIP");
        if (sRet != null) {
            sRet = String.format(sRet, CString.RemoveMnemonic(sName));
        }
        return sRet;
    }

    public static CFVJVAction CreateResetToolbar() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2170);
        rAction.SetName(CString.LoadString("IDS_RESET_TOOLBAR_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_RESET_TOOLBAR_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_RESET_TOOLBAR_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ResetToolbar.png"));
        return rAction;
    }

    public static CFVJVAction CreateNewLocalBrowserVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2171);
        String sName = CString.LoadString("IDS_NEW_LOCAL_BROWSER_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Computer.png"));
        return rAction;
    }

    public static CFVJVAction CreateNewRemoteBrowserVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2172);
        String sName = CString.LoadString("IDS_NEW_REMOTE_BROWSER_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ComputerRemote.png"));
        return rAction;
    }

    public static CFVJVAction CreateStopVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2173);
        String sName = CString.LoadString("IDS_STOP_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Stop.png"));
        return rAction;
    }

    public static CFVJVAction CreateSaveLoginVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2174);
        String sName = CString.LoadString("IDS_SAVE_LOGIN_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("SaveLogin.png"));
        return rAction;
    }

    public static CFVJVAction CreateChangePwordVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2175);
        String sName = CString.LoadString("IDS_CHANGE_PASSWORD_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Keys.png"));
        return rAction;
    }

    public static CFVJVAction CreateChangeEmailVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2176);
        String sName = CString.LoadString("IDS_CHANGE_EMAIL_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ChangeEmail.png"));
        return rAction;
    }

    public static CFVJVAction CreateExitVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2177);
        String sName = CString.LoadString("IDS_EXIT_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Exit.png"));
        return rAction;
    }

    public static CFVJVAction CreateSelectAllVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2178);
        String sName = CString.LoadString("IDS_SELECT_ALL_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("RowsSelectAll16.png"));
        return rAction;
    }

    public static CFVJVAction CreateInvertSelectionVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2179);
        String sName = CString.LoadString("IDS_INVERT_SELECTION_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("RowsInvertSelection16.png"));
        return rAction;
    }

    public static CFVJVAction CreateSyncFoldersVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2180);
        String sName = CString.LoadString("IDS_SYNC_FOLDERS_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderSync16.png"));
        return rAction;
    }

    public static CFVJVAction CreatePreferencesVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2181);
        String sName = CString.LoadString("IDS_PREFERENCES_BTN", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Preferences.png"));
        return rAction;
    }

    public static CFVJVAction CreateHelpTopicsVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2182);
        String sName = CString.LoadString("IDS_HELP_TOPICS_BTN", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("HelpTopics.png"));
        return rAction;
    }

    public static CFVJVAction CreateHelpOverviewVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2183);
        String sName = CString.LoadString("IDS_HELP_OVERVIEW_BTN", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("HelpOverview.png"));
        return rAction;
    }

    public static CFVJVAction CreateSupportVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2184);
        String sName = CString.LoadString("IDS_HELP_SUPPORT_BTN", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TechSupport.png"));
        return rAction;
    }

    public static CFVJVAction CreateAboutVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2185);
        String sName = CString.LoadString("IDS_ABOUT_BTN", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("About.png"));
        return rAction;
    }

    public static CFVJVAction CreateNewFolderVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2193);
        String sName = CString.LoadString("IDS_NEW_FOLDER_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderNew.png"));
        return rAction;
    }

    public static CFVJVAction CreateOpenVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2194);
        String sName = CString.LoadString("IDS_OPEN_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderOpened.png"));
        return rAction;
    }

    public static CFVJVAction CreateDeleteVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2195);
        String sName = CString.LoadString("IDS_DELETE_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Delete.png"));
        return rAction;
    }

    public static CFVJVAction CreateRenameVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2196);
        String sName = CString.LoadString("IDS_RENAME_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileRename.png"));
        return rAction;
    }

    public static CFVJVAction CreatePropertiesVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2197);
        String sName = CString.LoadString("IDS_PROPERTIES_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileProperties.png"));
        return rAction;
    }

    public static CFVJVAction CreateUploadVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2198);
        String sName = CString.LoadString("IDS_UPLOAD_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileUpload.png"));
        return rAction;
    }

    public static CFVJVAction CreateDownloadVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2199);
        String sName = CString.LoadString("IDS_DOWNLOAD_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FileDownload.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewsVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2200);
        String sName = CString.LoadString("IDS_VIEWS_BTN", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("View.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewLargeIconsVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2201);
        String sName = CString.LoadString("IDS_VIEW_LARGE_ICONS_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewLargeIcons.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewSmallIconsVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2202);
        String sName = CString.LoadString("IDS_VIEW_SMALL_ICONS_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewSmallIcons.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewListVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2203);
        String sName = CString.LoadString("IDS_VIEW_LIST_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewList.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewDetailsVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2204);
        String sName = CString.LoadString("IDS_VIEW_DETAILS_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSelected(true);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewDetails.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewThumbsVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2205);
        String sName = CString.LoadString("IDS_VIEW_THUMBS_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("ViewThumbs.png"));
        return rAction;
    }

    public static CFVJVAction CreateBackVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2206);
        String sName = CString.LoadString("IDS_BACK_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderBack.png"));
        return rAction;
    }

    public static CFVJVAction CreateForwardVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2207);
        String sName = CString.LoadString("IDS_FORWARD_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderForward.png"));
        return rAction;
    }

    public static CFVJVAction CreateNavHistoryVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2231);
        String sName = CString.LoadString("IDS_NAV_HISTORY_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderBack.png"));
        return rAction;
    }

    public static CFVJVAction CreateUpDirVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2208);
        String sName = CString.LoadString("IDS_UP_DIR_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderUpDir.png"));
        return rAction;
    }

    public static CFVJVAction CreateRefreshVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2209);
        String sName = CString.LoadString("IDS_REFRESH_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Refresh.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferStopAtNextFileVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2220);
        String sName = CString.LoadString("IDS_TRANSFER_STOP_AT_NEXT_FILE_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferStopped.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferSkipFileVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2221);
        String sName = CString.LoadString("IDS_TRANSFER_SKIP_FILE_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferSkipped.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferPauseVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2222);
        String sName = CString.LoadString("IDS_TRANSFER_PAUSE_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferPaused.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferResumeVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2223);
        String sName = CString.LoadString("IDS_RESUME_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferResume.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferCancelVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2224);
        String sName = CString.LoadString("IDS_CANCEL_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferCancelled.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferRemoveVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2225);
        String sName = CString.LoadString("IDS_REMOVE_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferDelete.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferRemoveAllCompletedVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2226);
        String sName = CString.LoadString("IDS_REMOVE_ALL_COMPLETED_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferRemoveAllDone.png"));
        return rAction;
    }

    public static CFVJVAction CreateTransferRemoveAllCancelledVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2227);
        String sName = CString.LoadString("IDS_REMOVE_ALL_CANCELLED_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("TransferRemoveAllCancelled.png"));
        return rAction;
    }

    public static CFVJVAction CreateWindows() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2120);
        rAction.SetName(CString.LoadString("IDS_WINDOWS_MENU", false));
        rAction.SetLongDesc(CString.LoadString("IDS_WINDOWS_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateFrameFloating() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2122);
        rAction.SetName(CString.LoadString("IDS_FRAME_FLOATING_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_FLOATING_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_FLOATING_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Windows_Floating.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameDockable() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2126);
        rAction.SetName(CString.LoadString("IDS_FRAME_DOCKABLE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_DOCKABLE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_DOCKABLE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Windows_Dockable.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameAutoHide() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2123);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Windows_AutoHide.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameAutoHideHide() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2124);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_HIDE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_HIDE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_HIDE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Windows_AutoHide_Hide.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameAutoHideShow() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2125);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_SHOW_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_SHOW_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_SHOW_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Windows_AutoHide_Show.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameClose() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2121);
        rAction.SetName(CString.LoadString("IDS_FRAME_CLOSE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_CLOSE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_CLOSE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Close.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameAutoHideAll() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2127);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_ALL_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Windows_AutoHide_All.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameCloseAll() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2128);
        rAction.SetName(CString.LoadString("IDS_FRAME_CLOSE_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_CLOSE_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_CLOSE_ALL_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Windows_CloseAllFrames.png"));
        return rAction;
    }

    public static CFVJVAction CreateFrameResetLayout() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2129);
        rAction.SetName(CString.LoadString("IDS_FRAME_RESET_LAYOUT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_RESET_LAYOUT_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_RESET_LAYOUT_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateFrameActivate() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2130);
        rAction.SetName(CString.LoadString("IDS_FRAME_ACTIVATE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_ACTIVATE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_ACTIVATE_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateShowCrumbBar() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2092);
        rAction.SetName(CString.LoadString("IDS_FRAME_SHOW_CRUMB_BAR", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_SHOW_CRUMB_BAR"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_SHOW_CRUMB_BAR_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Tbar_Navigation.png"));
        return rAction;
    }

    public static CFVJVAction CreateShowToolbar() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2093);
        rAction.SetName(CString.LoadString("IDS_FRAME_SHOW_TOOLBAR", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_SHOW_TOOLBAR"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_SHOW_TOOLBAR_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Tbar_Toolbar.png"));
        return rAction;
    }

    public static CFVJVAction CreateShowTreePane() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2098);
        rAction.SetName(CString.LoadString("IDS_FRAME_SHOW_TREE_PANE", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_SHOW_TREE_PANE"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_SHOW_TREE_PANE_STATUS"));
        rAction.SetAccelerator(113, 64);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FolderOpen16.png"));
        return rAction;
    }

    public static CFVJVAction CreateShowPreviewPane() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2099);
        rAction.SetName(CString.LoadString("IDS_FRAME_SHOW_PREVIEW_PANE", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_SHOW_PREVIEW_PANE"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_SHOW_PREVIEW_PANE_STATUS"));
        rAction.SetAccelerator(115, 64);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("FilmStrip16.png"));
        return rAction;
    }

    public static CFVJVAction CreateShowWindowsDlg() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(2135);
        rAction.SetName(CString.LoadString("IDS_SHOW_WINDOWS_DLG_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SHOW_WINDOWS_DLG_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_SHOW_WINDOWS_DLG_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("WindowsDlg.png"));
        return rAction;
    }

    public static CFVJVAction CreateViewThumb(int nEventID) {
        CFVJVAction rAction = new CFVJVAction(nEventID);
        String sName = "";
        String sShortDesc = "";
        String sLongDesc = CString.LoadString("IDS_VIEW_THUMBS_STATUS");
        ImageIcon ico = null;
        switch (nEventID) {
            case 2106: {
                sName = THUMB_SIZE_75x75;
                sShortDesc = THUMB_SIZE_75x75;
                ico = CMainFrame.GetJARImage("Thumbs_75.png");
                break;
            }
            case 2108: {
                sName = THUMB_SIZE_150x150;
                sShortDesc = THUMB_SIZE_150x150;
                ico = CMainFrame.GetJARImage("Thumbs_150.png");
                break;
            }
            case 2109: {
                sName = THUMB_SIZE_200x200;
                sShortDesc = THUMB_SIZE_200x200;
                ico = CMainFrame.GetJARImage("Thumbs_200.png");
                break;
            }
            case 2110: {
                sName = THUMB_SIZE_250x250;
                sShortDesc = THUMB_SIZE_250x250;
                ico = CMainFrame.GetJARImage("Thumbs_250.png");
                break;
            }
            default: {
                sName = THUMB_SIZE_100x100;
                sShortDesc = THUMB_SIZE_100x100;
                ico = CMainFrame.GetJARImage("Thumbs_100.png");
            }
        }
        rAction.SetName(sName);
        rAction.SetShortDesc(sShortDesc);
        rAction.SetLongDesc(sLongDesc);
        rAction.SetSmallIcon(ico);
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPlay() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8000);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_PLAY", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_PLAY"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_PLAY_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPlay.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPlayVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8001);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_PLAY", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPlay.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPause() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8002);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_PAUSE", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_PAUSE"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_PAUSE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPause.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPauseVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8003);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_PAUSE", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPause.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerStop() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8004);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_STOP", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_STOP"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_STOP_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaStop.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerStopVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8003);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_STOP", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaStop.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerSeekReverse() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8006);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_SEEK_REVERSE", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_SEEK_REVERSE"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_SEEK_REVERSE_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerSeekReverseVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8006);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_SEEK_REVERSE", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerSeekForward() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8008);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_SEEK_FORWARD", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_SEEK_FORWARD"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_SEEK_FORWARD_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerSeekForwardVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8008);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_SEEK_FORWARD", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPreviousTrack() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8010);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_PREVIOUS_TRACK", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_PREVIOUS_TRACK"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_PREVIOUS_TRACK_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPrevious.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPreviousTrackVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8010);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_PREVIOUS_TRACK", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPrevious.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerNextTrack() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8012);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_NEXT_TRACK", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_NEXT_TRACK"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_NEXT_TRACK_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaNext.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerNextTrackVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8012);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_NEXT_TRACK", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaNext.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerRepeat() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8014);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_REPEAT", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_REPEAT"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_REPEAT_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerRepeatVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8014);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_REPEAT", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerMute() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8016);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_MUTE", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_MUTE"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_MUTE_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerMuteVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8016);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_MUTE", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerShowPlaylist() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8018);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_SHOW_PLAYLIST", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_SHOW_PLAYLIST"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_SHOW_PLAYLIST_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPlaylist.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerShowPlaylistVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8019);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_SHOW_PLAYLIST", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MediaPlaylist.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPlaylistRemove() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8020);
        rAction.SetName(CString.LoadString("IDS_MEDIA_PLAYER_PLAYLIST_REMOVE", false));
        rAction.SetShortDesc(CString.LoadString("IDS_MEDIA_PLAYER_PLAYLIST_REMOVE"));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_PLAYER_PLAYLIST_REMOVE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Delete.png"));
        return rAction;
    }

    public static CFVJVAction CreateMediaPlayerPlaylistRemoveVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8021);
        String sName = CString.LoadString("IDS_MEDIA_PLAYER_PLAYLIST_REMOVE", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("Delete.png"));
        return rAction;
    }

    public static CFVJVAction CreatePlayerAddToPlaylist() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(8100);
        String sName = CString.LoadString("IDS_MEDIA_ADD_TO_PLAYLIST", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CString.LoadString("IDS_MEDIA_ADD_TO_PLAYLIST_STATUS"));
        return rAction;
    }

    public static CFVJVAction CreateSearchSearch() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(9501);
        String sName = CString.LoadString("IDS_SEARCH_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(sName);
        rAction.SetLongDesc(CString.LoadString("IDS_SEARCH_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("MagnifingGlass16.png"));
        return rAction;
    }

    public static CFVJVAction CreateSearchCancel() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(9502);
        String sName = CString.LoadString("IDS_SEARCH_CANCEL_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(sName);
        rAction.SetLongDesc(CString.LoadString("IDS_SEARCH_CANCEL_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("SearchStop.png"));
        return rAction;
    }

    public static CFVJVAction CreateSearchPause() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(9503);
        String sName = CString.LoadString("IDS_SEARCH_PAUSE_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(sName);
        rAction.SetLongDesc(CString.LoadString("IDS_SEARCH_PAUSE_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("SearchPause.png"));
        return rAction;
    }

    public static CFVJVAction CreateLockNavInitSource() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(9625);
        rAction.SetName(CString.LoadString("IDS_LOCK_NAV_MAIN_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LOCK_NAV_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LOCK_NAV_STATUS"));
        rAction.SetAccelerator(76, 128);
        rAction.SetSmallIcon(CMainFrame.GetJARImage("LockNavUnlocked16.png"));
        return rAction;
    }

    public static CFVJVAction CreateLockNavInitSourceVisible() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(9626);
        String sName = CString.LoadString("IDS_LOCK_NAV_MENU", false);
        rAction.SetName(sName);
        rAction.SetShortDesc(CActionFactory.FormatVisibleTip(sName));
        rAction.SetLongDesc(CActionFactory.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("LockNavUnlocked16.png"));
        return rAction;
    }

    public static CFVJVAction CreateLockNavUnlock() {
        CFVJVAction rAction = CActionFactory.CreateOnAction(9630);
        rAction.SetName(CString.LoadString("IDS_UNLOCK_NAV_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_UNLOCK_NAV_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LOCK_NAV_STATUS"));
        rAction.SetSmallIcon(CMainFrame.GetJARImage("LockNavLocked16.png"));
        return rAction;
    }
}

