/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.gui.CRhinoProperties;
import com.rhinosoft.fvjv.gui.dialogs.CTreeCtrlModel;
import com.rhinosoft.fvjv.gui.dialogs.CTreeCtrlRenderer;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class CTreeCtrl
extends JTree
implements TreeSelectionListener {
    public static final String DEFAULT_ROOT_LABEL = "DEFAULT_ROOT";
    public static final String DATA_KEY_STARTUP_TREE_PATH = "StartupTreePath";
    private CTreeCtrlModel m_jModel;
    private CTreeCtrlRenderer m_jRenderer;
    private String m_sStartupPath;

    public CTreeCtrl(boolean bShowRoot) {
        this(bShowRoot, DEFAULT_ROOT_LABEL);
    }

    public CTreeCtrl(boolean bShowRoot, String sRootLabel) {
        this.InitModel(sRootLabel);
        this.InitRenderer();
        this.setRootVisible(bShowRoot);
        this.setShowsRootHandles(true);
    }

    private void InitModel(String sRootLabel) {
        this.m_jModel = new CTreeCtrlModel(new DefaultMutableTreeNode(sRootLabel));
        this.setModel(this.m_jModel);
    }

    private void InitRenderer() {
        this.m_jRenderer = new CTreeCtrlRenderer();
        this.setCellRenderer(this.m_jRenderer);
    }

    public void LoadPage(CRhinoProperties aUserProps) {
        TreePath jTreePath;
        String sStartupPath;
        boolean bSelectionSet = false;
        if (aUserProps != null && (sStartupPath = aUserProps.GetValue(DATA_KEY_STARTUP_TREE_PATH, "")) != null) {
            this.m_sStartupPath = sStartupPath;
        }
        if (this.m_sStartupPath != null && (jTreePath = this.GetTreePath(this.m_sStartupPath)) != null) {
            this.collapsePath(jTreePath);
            this.setSelectionPath(jTreePath);
            this.scrollPathToVisible(jTreePath);
            bSelectionSet = true;
        }
        if (!bSelectionSet) {
            this.setSelectionRow(0);
        }
        this.addTreeSelectionListener(this);
    }

    public void SavePage(CRhinoProperties aUserProps) {
        if (aUserProps != null) {
            aUserProps.SetValue(DATA_KEY_STARTUP_TREE_PATH, this.m_sStartupPath, "");
        }
    }

    public String GetCurSelTreePath() {
        TreePath jTreePath = this.getSelectionPath();
        return this.FormatTreePath(jTreePath);
    }

    public String FormatTreePath(TreePath jTreePath) {
        CTreeCtrlModel jModel;
        String sTreePath = null;
        if (jTreePath != null) {
            sTreePath = jTreePath.toString();
        }
        if ((jModel = this.GetModel()) != null) {
            sTreePath = jModel.FormatTreePath(sTreePath);
        }
        return sTreePath;
    }

    public boolean AddNode(String sTreePath, Icon rIcon) {
        boolean bAdded = false;
        CTreeCtrlModel jModel = this.GetModel();
        if (jModel != null) {
            bAdded = jModel.AddNode(sTreePath, rIcon);
        }
        return bAdded;
    }

    public boolean RemoveNode(TreePath jRemoveTreePath) {
        return this.RemoveNode(jRemoveTreePath.toString());
    }

    public boolean RemoveNode(String sRemoveTreePath) {
        boolean bRemoved = false;
        CTreeCtrlModel jModel = this.GetModel();
        if (jModel != null) {
            bRemoved = jModel.RemoveNode(sRemoveTreePath);
        }
        return bRemoved;
    }

    public DefaultMutableTreeNode GetNode(String sTreePath) {
        DefaultMutableTreeNode jTreeNode = null;
        CTreeCtrlModel jModel = this.GetModel();
        if (jModel != null) {
            jTreeNode = jModel.GetNode(sTreePath);
        }
        return jTreeNode;
    }

    private TreePath GetTreePath(String sDelimitedPath) {
        TreePath jTreePath = null;
        int nRowCount = this.getRowCount();
        if (nRowCount > 0 && sDelimitedPath != null && sDelimitedPath.length() > 0) {
            int nRow = 0;
            String[] sNodes = sDelimitedPath.split(",");
            for (int nIdx = 0; nIdx < sNodes.length; ++nIdx) {
                String sNode = sNodes[nIdx];
                if (sNode == null || (jTreePath = this.getNextMatch(sNode = sNode.trim(), nRow, Position.Bias.Forward)) == null) continue;
                this.expandPath(jTreePath);
                nRow = this.getRowForPath(jTreePath);
            }
        }
        return jTreePath;
    }

    protected CTreeCtrlModel GetModel() {
        return this.m_jModel;
    }

    protected CTreeCtrlRenderer GetRenderer() {
        return this.m_jRenderer;
    }

    public void SetShowCellIcons(boolean bShow) {
        if (this.m_jRenderer != null) {
            this.m_jRenderer.SetShowCellIcons(bShow);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent jEvent) {
        TreePath jOldTreePath = jEvent.getOldLeadSelectionPath();
        TreePath jNewTreePath = jEvent.getNewLeadSelectionPath();
        if (jNewTreePath != null) {
            this.m_sStartupPath = this.FormatTreePath(jNewTreePath);
        }
    }

    public void SetStartupPath(String sTreePath) {
        this.m_sStartupPath = sTreePath;
    }

    public String GetStartupPath() {
        return this.m_sStartupPath;
    }

    public void ExpandNode(String sTreePath) {
        TreePath rPath = this.GetTreePath(sTreePath);
        if (rPath != null) {
            this.expandPath(rPath);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rPath = null");
        }
    }

    public void SetSelectionPath(String sTreePath) {
        TreePath rPath = this.GetTreePath(sTreePath);
        if (rPath != null) {
            this.setSelectionPath(rPath);
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rPath = null");
        }
    }
}

