/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.cipher.CDESCipher;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.dialogs.CBaseLoginPanel;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmRenameOverwriteDlg;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CMsgBox;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;

public class CSaveLoginDlgMainPanel
extends CBaseLoginPanel
implements DocumentListener {
    private JLabel m_cPrivatePortLabel;
    private JTextField m_cPrivatePortField;
    private JLabel m_cVerifyPasswordLabel;
    private JPasswordField m_cVerifyPasswordField;
    private JLabel m_cDestinationLabel;
    private JTextField m_cDestinationField;
    private JButton m_cBrowseForDestBtn;
    private String m_sAbsDestFolder;
    private long m_lPrivatePort;
    private CDESCipher m_Cipher;

    public CSaveLoginDlgMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_lPrivatePort = -1L;
        this.m_sAbsDestFolder = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        this.m_Cipher = new CDESCipher("ft0S0nihr", CMainFrame.DEBUG);
    }

    private CDESCipher GetCipher() {
        return this.m_Cipher;
    }

    private JLabel GetPrivatePortLabel() {
        return this.m_cPrivatePortLabel;
    }

    private JTextField GetPrivatePortField() {
        return this.m_cPrivatePortField;
    }

    private JLabel GetVerifyPasswordLabel() {
        return this.m_cVerifyPasswordLabel;
    }

    private JPasswordField GetVerifyPasswordField() {
        return this.m_cVerifyPasswordField;
    }

    private JLabel GetDestLabel() {
        return this.m_cDestinationLabel;
    }

    private JTextField GetDestField() {
        return this.m_cDestinationField;
    }

    private JButton GetBrowseForDestBtn() {
        return this.m_cBrowseForDestBtn;
    }

    public long GetPrivatePort() {
        return this.GetPrivatePort(true);
    }

    protected long GetPrivatePort(boolean bFromGUI) {
        long lPrivatePort = this.m_lPrivatePort;
        if (bFromGUI && this.GetPublicPortField() != null) {
            lPrivatePort = this.GetValueLong(this.GetPrivatePortField().getText());
        }
        return lPrivatePort;
    }

    public void SetPrivatePort(long lPrivatePort) {
        this.m_lPrivatePort = lPrivatePort;
        this.UpdateFieldLong(this.GetPrivatePortField(), this.GetPrivatePort());
    }

    @Override
    protected void UpdateData(boolean bUpdateGUI) {
        if (bUpdateGUI) {
            if (this.GetPrivatePortField() != null) {
                this.GetPrivatePortField().setText(Long.toString(this.GetPrivatePort(false)));
            }
            if (this.GetDestField() != null) {
                this.GetDestField().setText(this.GetPathJNLPFile());
            }
        } else if (this.GetPrivatePortField() != null) {
            this.SetPrivatePort(this.GetValueLong(this.GetPrivatePortField().getText()));
        }
        super.UpdateData(bUpdateGUI);
    }

    @Override
    public void OnCreate() {
        CDialog rDlg;
        super.OnCreate();
        String sMsg = String.format(CString.LoadString("IDS_SAVE_LOGIN_DLG_MSG"), "FTP Voyager JV");
        if (this.GetMainMsgCtrl() != null) {
            this.GetMainMsgCtrl().setText(sMsg);
        }
        this.SetBtnTxt(this.GetOKBtn(), CString.LoadString("IDS_CREATE", false));
        this.m_cPrivatePortLabel = new JLabel(CString.LoadString("IDS_SAVE_LOGIN_DLG_PORT"));
        this.m_cPrivatePortField = new JTextField();
        this.UpdateFieldLong(this.GetPrivatePortField(), this.GetPrivatePort(false));
        if (this.GetPasswordField() != null && this.GetPasswordField().getDocument() != null) {
            this.GetPasswordField().getDocument().addDocumentListener(this);
        }
        this.m_cVerifyPasswordLabel = new JLabel(CString.LoadString("IDS_VERIFY_NEW_PASSWORD_LABEL"));
        this.m_cVerifyPasswordField = new JPasswordField();
        this.m_cDestinationLabel = new JLabel(CString.LoadString("IDS_SAVE_LOGIN_DLG_DESTINATION"));
        this.m_cDestinationField = new JTextField();
        this.m_cBrowseForDestBtn = new JButton(CString.LoadString("IDS_BROWSE_DOTS"));
        if (this.GetBrowseForDestBtn() != null) {
            this.GetBrowseForDestBtn().addActionListener(this);
        }
        this.CheckEnableVerifyPasswordField();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        if (this.GetDestField() != null) {
            Dimension dimPrefSize = this.GetDestField().getPreferredSize();
            dimPrefSize.width = 300;
            JComponent[] aSizeComps = new JComponent[]{this.GetUserLabel(), this.GetUserField(), this.GetPasswordLabel(), this.GetPasswordField(), this.GetVerifyPasswordLabel(), this.GetVerifyPasswordField(), this.GetDestField()};
            for (int nIdx = 0; nIdx < aSizeComps.length; ++nIdx) {
                JComponent rComp = aSizeComps[nIdx];
                if (rComp == null) continue;
                rComp.setPreferredSize(dimPrefSize);
            }
        }
        if ((rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
            int nDlgWidth = rDlg.getWidth();
            int nGap = 5;
            int nMultiplier = 4;
            int nWidth = nDlgWidth / nMultiplier - nGap * nMultiplier;
            int nHeight = this.GetHostField().getHeight();
            Dimension dimPrefSize = new Dimension(nDlgWidth, nHeight);
            JComponent[] aSizeComps = new JComponent[]{this.GetHostLabel(), this.GetHostField(), this.GetPublicPortLabel(), this.GetPublicPortField(), this.GetPrivatePortLabel(), this.GetPrivatePortField(), this.GetIsSecureCheckBox()};
            for (int nIdx = 0; nIdx < aSizeComps.length; ++nIdx) {
                JComponent rComp = aSizeComps[nIdx];
                if (rComp == null) continue;
                rComp.setPreferredSize(dimPrefSize);
            }
        }
        int nMaxLabelWidth = 100;
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetMainMsgImage(), -1, -2, -2).addComponent(this.GetMainMsgScrollCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetHostLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetHostField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPublicPortLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPublicPortField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetIsSecureCheckBox(), -1, -2, -2).addComponent(this.GetLanguageLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetLanguageComboBox(), -1, -2, Short.MAX_VALUE).addComponent(this.GetUserLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetUserField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPasswordLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetPasswordField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetVerifyPasswordLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetVerifyPasswordField(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetMainMsgImage(), -1, -2, -2).addComponent(this.GetMainMsgScrollCtrl(), -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addComponent(this.GetHostLabel(), -1, -2, -2).addComponent(this.GetHostField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetPublicPortLabel(), -1, -2, -2).addComponent(this.GetPublicPortField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetIsSecureCheckBox(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetLanguageLabel(), -1, -2, -2).addComponent(this.GetLanguageComboBox(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetUserLabel(), -1, -2, -2).addComponent(this.GetUserField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetPasswordLabel(), -1, -2, -2).addComponent(this.GetPasswordField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.GetVerifyPasswordLabel(), -1, -2, -2).addComponent(this.GetVerifyPasswordField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        Component[] aDisabled = new Component[]{this.GetHostField(), this.GetPublicPortField(), this.GetIsSecureCheckBox(), this.GetUserField()};
        for (int nIdx = 0; nIdx < aDisabled.length; ++nIdx) {
            aDisabled[nIdx].setEnabled(false);
        }
        this.TrackDlgSize();
        this.RecalcLayout();
        this.TrackDlgSize();
        this.UpdateDestField();
    }

    @Override
    protected void OnOK() {
        boolean bCreateFile = true;
        String sPassword = null;
        if (this.VerifyPassword()) {
            sPassword = this.GetPassword();
        } else {
            bCreateFile = false;
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            CMsgBox dlg = new CMsgBox(rDlg, true, -1L, -1, 0);
            dlg.setTitle(CString.LoadString("IDS_SAVE_LOGIN_DLG_PASSWORDS_DIFFER_TITLE"));
            if (rDlg != null && rDlg.getIconImages() != null && rDlg.getIconImages().size() > 0) {
                dlg.setIconImage(rDlg.getIconImages().get(0));
            }
            dlg.SetMainMsg(CString.LoadString("IDS_SAVE_LOGIN_DLG_PASSWORDS_DIFFER_MSG"));
            Dimension dimSize = new Dimension(320, 120);
            if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                dimSize.width += 100;
                dimSize.height += 50;
            }
            dlg.setPreferredSize(dimSize);
            dlg.setResizable(false);
            dlg.setVisible(true);
            if (this.GetPasswordField() != null) {
                this.GetPasswordField().selectAll();
            }
            if (this.GetVerifyPasswordField() != null) {
                this.GetVerifyPasswordField().selectAll();
            }
        }
        String sAbsFileName = null;
        if (this.GetDestField() != null) {
            sAbsFileName = this.GetDestField().getText();
        }
        if (bCreateFile) {
            bCreateFile = this.VerifyFileName(sAbsFileName);
            if (bCreateFile) {
                bCreateFile = this.VerifyParentFolder(CString.GetFilePath(sAbsFileName, true));
            }
            if (bCreateFile) {
                bCreateFile = this.VerifyValidPort(this.GetPublicPort());
            }
        }
        if (bCreateFile) {
            String sHost = this.GetHost(false);
            long lPublicPort = this.GetPublicPort(false);
            long lPrivatePort = this.GetPrivatePort(false);
            String sUserID = this.GetUser(false);
            String sLanguageCode = this.GetLanguageCode();
            String sCountryCode = this.GetCountryCode();
            boolean bIsSecure = this.GetIsSecure(false);
            String sJNLPFile = sAbsFileName;
            if (this.CanOverwrite(sJNLPFile)) {
                String sMsg = "";
                int nOption = 1;
                if (this.CreateJNLPFile(sJNLPFile, sHost, lPrivatePort, lPublicPort, sUserID, sPassword, sLanguageCode, sCountryCode, bIsSecure)) {
                    sMsg = String.format(CString.LoadString("IDS_SAVE_LOGIN_DLG_JNLP_CREATED"), "FTP Voyager JV", sJNLPFile);
                    nOption = 1;
                } else {
                    sMsg = String.format(CString.LoadString("IDS_SAVE_LOGIN_DLG_JNLP_FAILED"), sJNLPFile);
                    nOption = 0;
                }
                CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
                CMsgBox dlg = new CMsgBox(rDlg, true, -1L, -1, nOption);
                dlg.setTitle(CString.LoadString("IDS_SAVE_LOGIN_DLG_TITLE"));
                if (rDlg != null && rDlg.getIconImages() != null && rDlg.getIconImages().size() > 0) {
                    dlg.setIconImage(rDlg.getIconImages().get(0));
                }
                dlg.SetMainMsg(sMsg);
                Dimension dimSize = new Dimension(350, 200);
                if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                    dimSize.width += 100;
                    dimSize.height += 50;
                }
                dlg.setPreferredSize(dimSize);
                dlg.setMinimumSize(dimSize);
                dlg.setResizable(false);
                dlg.setVisible(true);
                if (rDlg != null) {
                    rDlg.OnClose(0);
                }
            }
        }
    }

    @Override
    protected void OnCancel() {
        CDialog rDlg;
        super.OnCancel();
        if (this.GetPrivatePortField() != null) {
            this.GetPrivatePortField().setText(null);
        }
        if ((rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
            rDlg.OnClose(2);
        }
    }

    private boolean VerifyPassword() {
        boolean bIsValid = false;
        if (this.GetPasswordField() != null && this.GetVerifyPasswordField() != null) {
            String sTemp1 = new String(this.GetPasswordField().getPassword());
            String sTemp2 = new String(this.GetVerifyPasswordField().getPassword());
            if (sTemp1 != null && sTemp2 != null && sTemp1.equals(sTemp2)) {
                bIsValid = true;
            }
        }
        return bIsValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CreateJNLPFile(String sAbsCreatePath, String sHost, long lPort, long lHeaderPort, String sUserID, String sPassword, String sLanguageCode, String sCountryCode, boolean bIsSecure) {
        boolean bSuccessful = false;
        if (this.IsValid(sAbsCreatePath) && this.IsValid(sHost) && lPort > 0L && this.IsValid(sUserID)) {
            File fJNLPFile;
            if (sPassword == null) {
                sPassword = "";
            }
            if (!this.IsValid(sLanguageCode)) {
                sLanguageCode = Locale.US.getLanguage();
            }
            if (!this.IsValid(sCountryCode)) {
                sCountryCode = Locale.US.getCountry();
            }
            if ((fJNLPFile = new File(sAbsCreatePath)).getParentFile().exists() && !fJNLPFile.isDirectory()) {
                if (!fJNLPFile.exists()) {
                    try {
                        if (!fJNLPFile.createNewFile()) {
                            fJNLPFile = null;
                        }
                    }
                    catch (IOException ioe) {
                        fJNLPFile = null;
                    }
                }
                if (fJNLPFile != null && fJNLPFile.exists()) {
                    FileOutputStream outStream = null;
                    PrintWriter outWriter = null;
                    fJNLPFile.setWritable(true);
                    try {
                        outStream = new FileOutputStream(fJNLPFile);
                        outWriter = new PrintWriter(outStream, true);
                        String sProtocol = "http://";
                        if (bIsSecure) {
                            sProtocol = "https://";
                        }
                        String sHeaderURL = "";
                        sHeaderURL = !bIsSecure && lHeaderPort == 80L || bIsSecure && lHeaderPort == 443L ? String.format("%s%s", sProtocol, sHost) : String.format("%s%s:%d", sProtocol, sHost, lHeaderPort);
                        String sText = "<!--#include \"../Common/Strings/Strings.strings\"-->";
                        sText = sText + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
                        this.Println(outWriter, sText);
                        String sCodebase = CString.EnsureLastCharIsNotAForwardSlash(sHeaderURL);
                        sCodebase = sCodebase + "/FVJV/";
                        sText = String.format("<jnlp spec=\"1.0+\" codebase=\"%s\">", sCodebase);
                        this.Println(outWriter, sText);
                        sText = "\t<information>";
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<title>%s</title>", "FTP Voyager JV");
                        this.Println(outWriter, sText);
                        sText = "\t\t<vendor>Rhino Software, Inc.</vendor>";
                        this.Println(outWriter, sText);
                        String sImagesPath = "/FVJV/Images/";
                        sText = String.format("\t\t<icon kind=\"splash\" href=\"%s%s%s\" width=\"64\" height=\"64\" />", sHeaderURL, sImagesPath, "FVJV_64x64.png");
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<icon href=\"%s%s%s\" width=\"48\" height=\"48\" />", sHeaderURL, sImagesPath, "FVJV_48x48.png");
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<icon href=\"%s%s%s\" width=\"32\" height=\"32\" />", sHeaderURL, sImagesPath, "FVJV_32x32.png");
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<icon href=\"%s%s%s\" width=\"24\" height=\"24\" />", sHeaderURL, sImagesPath, "FVJV_24x24.png");
                        this.Println(outWriter, sText);
                        sText = "\t</information>";
                        this.Println(outWriter, sText);
                        sText = "\t<security>";
                        this.Println(outWriter, sText);
                        sText = "\t\t<all-permissions/>";
                        this.Println(outWriter, sText);
                        sText = "\t</security>";
                        this.Println(outWriter, sText);
                        sText = "\t<resources>";
                        this.Println(outWriter, sText);
                        sText = "\t\t<j2se version=\"1.6+\"/>";
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<jar href=\"%s/FVJV/FTP_Voyager_JV.jar\" main=\"true\"/>", sHeaderURL);
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<jar href=\"%s/FVJV/lib/jide-action.jar\"/>", sHeaderURL);
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<jar href=\"%s/FVJV/lib/jide-common.jar\"/>", sHeaderURL);
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<jar href=\"%s/FVJV/lib/jide-dock.jar\"/>", sHeaderURL);
                        this.Println(outWriter, sText);
                        if (CMainFrame.DEBUG_MEDIA) {
                            sText = "\t\t<extension name=\"JavaFX Runtime\" href=\"http://dl.javafx.com/javafx-rt.jnlp\"/>";
                            this.Println(outWriter, sText);
                        }
                        sText = "\t</resources>";
                        this.Println(outWriter, sText);
                        sText = "\t<application-desc>";
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<argument>%s</argument>", "-login");
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<argument>%s,%s</argument>", "-hh", sHost);
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<argument>%s,%d</argument>", "-sp", lPort);
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<argument>%s,%d</argument>", "-hp", lHeaderPort);
                        this.Println(outWriter, sText);
                        String sEncoded = CUtils.UrlEncode(sUserID);
                        if (sEncoded == null) {
                            sEncoded = "";
                        }
                        sText = String.format("\t\t<argument>%s,%s</argument>", "-li", sEncoded);
                        this.Println(outWriter, sText);
                        String sEncrypted = this.GetCipher().Encrypt(sPassword);
                        if (sEncrypted == null) {
                            sEncrypted = "";
                        }
                        sText = String.format("\t\t<argument>%s,%s</argument>", "-pw", sEncrypted);
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<argument>%s,%s,%s</argument>", "-hl", sLanguageCode, sCountryCode);
                        this.Println(outWriter, sText);
                        sText = String.format("\t\t<argument>%s,%s</argument>", "-is", bIsSecure ? "1" : "0");
                        this.Println(outWriter, sText);
                        sText = "\t</application-desc>";
                        this.Println(outWriter, sText);
                        sText = "</jnlp>";
                        this.Println(outWriter, sText);
                        if (outWriter.checkError()) {
                            if (CMainFrame.DEBUG) {
                                System.out.println("PrintWriter encountered an error");
                            }
                        } else {
                            bSuccessful = true;
                        }
                    }
                    catch (Exception e) {
                        if (CMainFrame.DEBUG) {
                            CMainFrame.Warning("Failed to write data to JNLP file");
                        }
                    }
                    finally {
                        block39: {
                            block38: {
                                try {
                                    if (outWriter != null) {
                                        outWriter.close();
                                    }
                                }
                                catch (Exception e) {
                                    if (!CMainFrame.DEBUG) break block38;
                                    CMainFrame.Warning("Failed to close PrintWriter");
                                }
                            }
                            try {
                                if (outStream != null) {
                                    outStream.close();
                                }
                            }
                            catch (Exception e) {
                                if (!CMainFrame.DEBUG) break block39;
                                CMainFrame.Warning("Failed to close OutputStream");
                            }
                        }
                    }
                }
            }
        }
        return bSuccessful;
    }

    private boolean Print(PrintWriter outWriter, String sText) {
        boolean bSuccessful = false;
        if (outWriter != null) {
            outWriter.print(sText);
            bSuccessful = outWriter.checkError();
        }
        return bSuccessful;
    }

    private boolean Println(PrintWriter outWriter, String sText) {
        boolean bSuccessful = false;
        if (outWriter != null) {
            outWriter.println(sText);
            bSuccessful = outWriter.checkError();
        }
        return bSuccessful;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.GetBrowseForDestBtn()) {
            int nRc;
            File fCurDir;
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            if (this.GetPathDestFolder() != null && (fCurDir = new File(this.GetPathDestFolder())) != null && fCurDir.exists()) {
                fc.setCurrentDirectory(fCurDir);
            }
            if ((nRc = fc.showOpenDialog(this)) == 0 && fc.getSelectedFile() != null) {
                this.SetPathDestFolder(fc.getSelectedFile().getAbsolutePath(), true);
            }
        } else {
            super.actionPerformed(event);
        }
    }

    private boolean CanOverwrite(String sAbsJNLP) {
        boolean bCanOverwrite = false;
        File fFile = new File(sAbsJNLP);
        if (fFile != null && fFile.exists()) {
            CConfirmRenameOverwriteDlg dlg = new CConfirmRenameOverwriteDlg((Frame)CMainFrame.GET_APP(), true, -1L);
            String sMsg = String.format(CString.LoadString("IDS_CONFIRM_OVERWRITE_DLG_MSG1"), sAbsJNLP);
            dlg.SetMainMsg(sMsg);
            sMsg = CString.LoadString("IDS_CONFIRM_REPLACE_DLG_MSG2");
            dlg.SetBtnMsg(sMsg);
            dlg.setVisible(true);
            int nRc = dlg.GetExitCode();
            switch (nRc) {
                case 0: {
                    bCanOverwrite = true;
                    break;
                }
            }
        } else {
            bCanOverwrite = true;
        }
        return bCanOverwrite;
    }

    private void CheckEnableVerifyPasswordField() {
        boolean bEnableVerify = false;
        if (this.GetPasswordField() != null && this.GetPasswordField().getPassword().length > 0) {
            bEnableVerify = true;
        }
        if (this.GetVerifyPasswordField() != null) {
            this.GetVerifyPasswordField().setEnabled(bEnableVerify);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        if (this.GetPasswordField() != null && this.GetPasswordField().getDocument() != null && event.getDocument() == this.GetPasswordField().getDocument()) {
            this.CheckEnableVerifyPasswordField();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        if (this.GetPasswordField() != null && this.GetPasswordField().getDocument() != null && event.getDocument() == this.GetPasswordField().getDocument()) {
            this.CheckEnableVerifyPasswordField();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    private String GetPathJNLPFile() {
        String sJNLPFile = this.GetPathDestFolder();
        sJNLPFile = CString.EnsureLastCharIsAFileSeparator(sJNLPFile);
        String sFileName = "FTP Voyager JV";
        String sHost = this.GetHost(false);
        if ((sHost = CClientInfo.FormatHostForPath(sHost)) != null) {
            sFileName = String.format(CString.LoadString("IDS_SAVE_LOGIN_DLG_FMT_FILE_NAME"), "FTP Voyager JV", sHost);
        }
        sJNLPFile = sJNLPFile + sFileName;
        sJNLPFile = sJNLPFile + ".jnlp";
        return sJNLPFile;
    }

    private String GetPathDestFolder() {
        return this.m_sAbsDestFolder;
    }

    private void SetPathDestFolder(String sDestFolder, boolean bUpdateGUI) {
        this.m_sAbsDestFolder = sDestFolder;
        if (bUpdateGUI) {
            this.UpdateDestField();
        }
    }

    private void UpdateDestField() {
        if (this.GetDestField() != null) {
            this.GetDestField().setText(this.GetPathJNLPFile());
        }
    }

    private boolean VerifyFileName(String sAbsFileName) {
        int nLastFileExtIndex;
        boolean bIsValid = false;
        boolean bHasJNLPExtension = false;
        boolean bHasAName = false;
        if (sAbsFileName != null && !sAbsFileName.isEmpty() && (nLastFileExtIndex = sAbsFileName.lastIndexOf(".")) > 0 && nLastFileExtIndex < sAbsFileName.length()) {
            int nLastFilePathIndex;
            String sFileExt = sAbsFileName.substring(nLastFileExtIndex + 1);
            if (sFileExt != null && !sFileExt.isEmpty() && (sFileExt = sFileExt.toLowerCase()).equals("jnlp")) {
                bHasJNLPExtension = true;
            }
            if ((nLastFilePathIndex = sAbsFileName.lastIndexOf(File.separator)) > 0 && nLastFilePathIndex < sAbsFileName.length() && nLastFilePathIndex + 1 < nLastFileExtIndex) {
                bHasAName = true;
            }
        }
        if (!bHasJNLPExtension || !bHasAName) {
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            CMsgBox dlg = new CMsgBox(rDlg, true, -1L, -1, 0);
            dlg.setTitle(CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_REQUIREMENTS"));
            if (rDlg != null && rDlg.getIconImages() != null && rDlg.getIconImages().size() > 0) {
                dlg.setIconImage(rDlg.getIconImages().get(0));
            }
            String sMainMsg = CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_FILE_DEF");
            sMainMsg = !bHasJNLPExtension ? CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_FILE_EXT") : CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_FILE_NAME");
            dlg.SetMainMsg(sMainMsg);
            Dimension dimSize = new Dimension(300, 150);
            if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                dimSize.width += 100;
                dimSize.height += 50;
            }
            dlg.setPreferredSize(dimSize);
            dlg.setMinimumSize(dimSize);
            dlg.setResizable(false);
            dlg.setVisible(true);
        } else {
            bIsValid = true;
        }
        return bIsValid;
    }

    private boolean VerifyParentFolder(String sAbsParentPath) {
        File fDir;
        boolean bIsValid = false;
        boolean bMissingDest = true;
        if (sAbsParentPath != null && !sAbsParentPath.isEmpty() && (fDir = new File(sAbsParentPath)).exists()) {
            bMissingDest = false;
        }
        if (bMissingDest) {
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            CMsgBox dlg = new CMsgBox(rDlg, true, -1L, -1, 0);
            dlg.setTitle(CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_REQUIREMENTS"));
            if (rDlg != null && rDlg.getIconImages() != null && rDlg.getIconImages().size() > 0) {
                dlg.setIconImage(rDlg.getIconImages().get(0));
            }
            dlg.SetMainMsg(CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_PARENT_FOLDER"));
            Dimension dimSize = new Dimension(300, 150);
            if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                dimSize.width += 100;
                dimSize.height += 50;
            }
            dlg.setPreferredSize(dimSize);
            dlg.setMinimumSize(dimSize);
            dlg.setResizable(false);
            dlg.setVisible(true);
        } else {
            bIsValid = true;
        }
        return bIsValid;
    }

    private boolean VerifyValidPort(long lPort) {
        boolean bIsValid = false;
        boolean bMissingPort = true;
        if (lPort >= 0L && lPort < 65535L) {
            bMissingPort = false;
        }
        if (bMissingPort) {
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            CMsgBox dlg = new CMsgBox(rDlg, true, -1L, -1, 0);
            dlg.setTitle(CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_REQUIREMENTS"));
            if (rDlg != null && rDlg.getIconImages() != null && rDlg.getIconImages().size() > 0) {
                dlg.setIconImage(rDlg.getIconImages().get(0));
            }
            dlg.SetMainMsg(CString.LoadString("IDS_SAVE_LOGIN_DLG_MISSING_PORT"));
            Dimension dimSize = new Dimension(300, 150);
            if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                dimSize.width += 100;
                dimSize.height += 50;
            }
            dlg.setPreferredSize(dimSize);
            dlg.setMinimumSize(dimSize);
            dlg.setResizable(false);
            dlg.setVisible(true);
            if (this.GetPublicPortField() != null) {
                this.GetPublicPortField().selectAll();
                this.GetPublicPortField().requestFocus();
            }
        } else {
            bIsValid = true;
        }
        return bIsValid;
    }

    @Override
    protected void InitEscapeListeners() {
        super.InitEscapeListeners();
        this.AddEscapeKeyListener(this.m_cPrivatePortLabel);
        this.AddEscapeKeyListener(this.m_cPrivatePortField);
        this.AddEscapeKeyListener(this.m_cVerifyPasswordLabel);
        this.AddEscapeKeyListener(this.m_cVerifyPasswordField);
        this.AddEscapeKeyListener(this.m_cDestinationLabel);
        this.AddEscapeKeyListener(this.m_cDestinationField);
        this.AddEscapeKeyListener(this.m_cBrowseForDestBtn);
    }
}

