/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.FilePanel.CFileTableCellRenderer;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.files.CLocalFile;
import com.rhinosoft.fvjv.gui.dialogs.CRhinoOverwriteBtn;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class CRhinoOverwriteFileBtn
extends CRhinoOverwriteBtn {
    public static final String THREAD_NAME_OVERWRITE_THUMB = "OverwriteThumbThread";
    public static final int THUMB_WIDTH = 60;
    public static final int THUMB_HEIGHT = 60;
    private JLabel m_cThumb;
    private JLabel m_cFileName;
    private JLabel m_cFileNameEx;
    private JLabel m_cFileSize;
    private JLabel m_cModifiedTimestamp;
    private String m_sAbsPathForThumb;
    private CBaseThread m_tLocalThumbThread;
    private CBaseThread m_tRemoteThumbThread;

    public CRhinoOverwriteFileBtn(String sTitle, String sDesc) {
        super(sTitle, sDesc);
        this._CRhinoOverwriteFileBtn();
    }

    private void _CRhinoOverwriteFileBtn() {
        if (CMainFrame.GET_APP() != null) {
            this.m_tLocalThumbThread = CMainFrame.GET_APP().CreateLocalThread(THREAD_NAME_OVERWRITE_THUMB);
            this.m_tRemoteThumbThread = CMainFrame.GET_APP().CreateRemoteThread(THREAD_NAME_OVERWRITE_THUMB);
        }
        this.m_cThumb = new JLabel();
        this.m_cThumb.setHorizontalAlignment(0);
        this.m_cThumb.setVerticalAlignment(0);
        this.m_cFileName = new JLabel("<FileName>");
        this.m_cFileNameEx = new JLabel("<Absolute FileName>");
        this.m_cFileNameEx.setForeground(this.GetBlueClr());
        this.m_cFileSize = new JLabel("<File Size>");
        this.m_cModifiedTimestamp = new JLabel("<File Modified Timestamp>");
        if (this.CanChangeFont()) {
            Font font = this.m_cFileName.getFont();
            font = new Font(font.getName(), 1, font.getSize() + 1);
            this.m_cFileName.setFont(font);
            JLabel[] aLbls = new JLabel[]{this.m_cFileNameEx, this.m_cFileSize, this.m_cModifiedTimestamp};
            for (int nIdx = 0; nIdx < aLbls.length; ++nIdx) {
                JLabel rLbl = aLbls[nIdx];
                if (rLbl == null) continue;
                font = rLbl.getFont();
                font = new Font(font.getName(), 0, font.getSize());
                rLbl.setFont(font);
            }
        }
        this.m_cThumb.setPreferredSize(new Dimension(60, 50));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.GetArrowLabel(), -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.GetTitleLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetDescLabel(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cThumb, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cFileName, -1, -2, Short.MAX_VALUE).addComponent(this.m_cFileNameEx, -1, -2, Short.MAX_VALUE).addComponent(this.m_cFileSize, -1, -2, Short.MAX_VALUE).addComponent(this.m_cModifiedTimestamp, -1, -2, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetArrowLabel(), -1, -2, -2).addComponent(this.GetTitleLabel(), -1, -2, -2)).addComponent(this.GetDescLabel(), -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cThumb, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_cFileName, -1, -2, -2).addComponent(this.m_cFileNameEx, -1, -2, -2).addComponent(this.m_cFileSize, -1, -2, -2).addComponent(this.m_cModifiedTimestamp, -1, -2, -2))));
    }

    @Override
    public void SetPath(CPath rSource) {
        if (rSource != null) {
            CFile fRoot = null;
            CBaseThread tThread = null;
            if (rSource.IsLocal()) {
                fRoot = CMainFrame.GET_APP().GetLocalRoot();
                tThread = this.m_tLocalThumbThread;
            } else {
                fRoot = CMainFrame.GET_APP().GetRemoteRoot();
                tThread = this.m_tRemoteThumbThread;
            }
            if (fRoot != null) {
                CFile fChild = fRoot.FindFile(rSource.GetPath(), false);
                if (fChild == null && rSource.IsLocal()) {
                    fChild = new CLocalFile(new File(rSource.GetPath()));
                }
                String sAbsPath = rSource.GetPath();
                String sName = CString.GetFileName(sAbsPath);
                this.m_cFileName.setText(sName);
                int nPeriod = sName.lastIndexOf(46);
                if (nPeriod > -1 && nPeriod < sName.length()) {
                    sName = sName.substring(0, nPeriod);
                }
                String sParentPath = CString.GetFilePath(sAbsPath, true);
                this.m_cFileNameEx.setText(String.format("%s (%s)", sName, sParentPath));
                this.m_cFileSize.setText("");
                this.m_cModifiedTimestamp.setText("");
                if (fChild != null) {
                    ImageIcon icon = fChild.GetIconThumb(60, 60);
                    this.UpdateThumbImage(icon, fChild);
                    if (icon == null) {
                        this.m_sAbsPathForThumb = fChild.GetPath();
                        fChild.GetThumb(tThread, this, false, 60, 60, true, false, true);
                    }
                    long lSize = fChild.GetSize();
                    String sSize = CFile.FormatFileSize(lSize);
                    this.m_cFileSize.setText(String.format(CString.LoadString("IDS_FMT_OVERWRITE_BTN_FILE_SIZE"), sSize));
                    Date dtModified = fChild.GetModifiedDate();
                    String sModifiedTimestamp = CFileTableCellRenderer.FmtDisplayDate(dtModified, CMainFrame.GET_APP().GetArchive(), false);
                    this.m_cModifiedTimestamp.setText(String.format(CString.LoadString("IDS_FMT_OVERWRITE_BTN_FILE_MODIFIED"), sModifiedTimestamp));
                }
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        this.OnMessage(event);
    }

    protected void OnMessage(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 3021: {
                    CThreadMsgThumb rThumbMsg;
                    CPath rFromPath;
                    String sPath;
                    CThreadMsg rMsg;
                    if (rEvent.getSource() != this || !(rEvent.GetEventObj() instanceof CThreadMsg) || (rMsg = (CThreadMsg)rEvent.GetEventObj()).GetMsgID() != 22 || !(rMsg instanceof CThreadMsgThumb) || (sPath = (rFromPath = (rThumbMsg = (CThreadMsgThumb)rMsg).GetFromPath(rThumbMsg.GetPathIndex())).GetPath()) == null || this.m_sAbsPathForThumb == null || !this.m_sAbsPathForThumb.equals(sPath)) break;
                    this.UpdateThumbImage(rThumbMsg.GetThumbImage(), null);
                    break;
                }
                case 6009: {
                    Object[] aItems = (Object[])rEvent.GetEventObj();
                    if (aItems == null || aItems.length != 3 || !(aItems[0] instanceof CFile)) break;
                    CFile fFile = (CFile)aItems[0];
                    String sRequestedPath = this.m_cFileName.getText();
                    if (this.m_sAbsPathForThumb == null || fFile.GetPath() == null || !this.m_sAbsPathForThumb.equals(fFile.GetPath())) break;
                    this.UpdateThumbImage(fFile.GetIconThumb(60, 60), fFile);
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    private void UpdateThumbImage(Icon rIcon, CFile fFile) {
        if (fFile != null) {
            if (rIcon == null) {
                rIcon = fFile.GetIcon32();
            }
            if (rIcon == null) {
                rIcon = fFile.GetIcon16();
            }
        }
        if (this.m_cThumb != null && rIcon != null) {
            this.m_cThumb.setIcon(rIcon);
        }
    }
}

