/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmCloseDlg;
import com.rhinosoft.fvjv.gui.dialogs.CRhinoOverwriteBtn;
import com.rhinosoft.fvjv.gui.dialogs.CRhinoOverwriteFileBtn;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CRhinoOverwriteDlg
extends JDialog
implements ActionListener,
WindowListener,
MouseListener,
KeyListener {
    private Component m_rOwner;
    private Color m_clrBlue;
    private JLabel m_cTitle;
    private JLabel m_cDesc;
    private CRhinoOverwriteFileBtn m_cOverwriteTargetBtn;
    private CRhinoOverwriteFileBtn m_cDoNothingBtn;
    private CRhinoOverwriteBtn m_cResumeSourceBtn;
    private CRhinoOverwriteBtn m_cRenameTargetBtn;
    private JCheckBox m_cApplyToAll;
    private JCheckBox m_cDoNotAskAgain;
    private JButton m_cCancelBtn;
    private RESULT m_Result;
    private boolean m_bConfirmClose;
    private CConfirmCloseDlg m_cConfirmCloseDlg;
    private boolean m_bInitialized;
    private boolean m_bIsMove;

    public CRhinoOverwriteDlg(Component rOwner, String sTitle, boolean bIsMove) {
        this._CRhinoOverwriteDlg(rOwner, sTitle, bIsMove);
    }

    private void _CRhinoOverwriteDlg(Component rOwner, String sTitle, boolean bIsMove) {
        Font fFont;
        ImageIcon ico32;
        this.m_bIsMove = bIsMove;
        ArrayList<Image> aImages = new ArrayList<Image>();
        ImageIcon ico16 = CMainFrame.GetJARImage("TransferQuestion.png");
        if (ico16 != null) {
            aImages.add(ico16.getImage());
        }
        if ((ico32 = CMainFrame.GetJARImage("TransferQuestion32.png")) != null) {
            aImages.add(ico32.getImage());
        }
        if (aImages != null && aImages.size() > 0) {
            this.setIconImages(aImages);
        } else {
            this.setIconImage(ico16.getImage());
        }
        this.m_rOwner = rOwner;
        this.m_bInitialized = false;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(0);
        this.m_bConfirmClose = true;
        this.m_Result = RESULT.CANCELLED;
        this.m_clrBlue = new Color(0, 51, 153);
        this.setTitle(sTitle);
        this.addWindowListener(this);
        this.m_cTitle = new JLabel(CString.LoadString("IDS_OVERWRITE_DLG_HEADER"));
        if (this.CanChangeFont()) {
            fFont = this.m_cTitle.getFont();
            if (fFont != null) {
                fFont = new Font(fFont.getName(), 0, 16);
            }
            this.m_cTitle.setFont(fFont);
        }
        this.m_cTitle.setForeground(this.m_clrBlue);
        this.m_cDesc = new JLabel(CString.LoadString("IDS_OVERWRITE_DLG_DESC"));
        if (this.CanChangeFont()) {
            fFont = this.m_cDesc.getFont();
            if (fFont != null) {
                fFont = new Font(fFont.getName(), 0, fFont.getSize());
            }
            this.m_cDesc.setFont(fFont);
        }
        String sTemp = CString.LoadString("IDS_OVERWRITE_BTN_REPLACE_TITLE");
        if (this.m_bIsMove) {
            sTemp = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_REPLACE_TITLE");
        }
        String sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_REPLACE_DESC");
        if (this.m_bIsMove) {
            sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_REPLACE_DESC");
        }
        this.m_cOverwriteTargetBtn = new CRhinoOverwriteFileBtn(sTemp, sTemp2);
        sTemp = CString.LoadString("IDS_OVERWRITE_BTN_DO_NOTHING_TITLE");
        if (this.m_bIsMove) {
            sTemp = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_DO_NOTHING_TITLE");
        }
        sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_DO_NOTHING_DESC");
        this.m_cDoNothingBtn = new CRhinoOverwriteFileBtn(sTemp, sTemp2);
        sTemp = CString.LoadString("IDS_OVERWRITE_BTN_RESUME_TITLE");
        sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_RESUME_DESC");
        if (this.m_bIsMove) {
            sTemp2 = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_RESUME_DESC");
        }
        this.m_cResumeSourceBtn = new CRhinoOverwriteBtn(sTemp, sTemp2);
        sTemp = CString.LoadString("IDS_OVERWRITE_BTN_RENAME_TITLE");
        if (this.m_bIsMove) {
            sTemp = CString.LoadString("IDS_OVERWRITE_BTN_MOVE_RENAME_TITLE");
        }
        sTemp2 = CString.LoadString("IDS_FMT_OVERWRITE_BTN_RENAME_DESC");
        if (this.m_bIsMove) {
            sTemp2 = CString.LoadString("IDS_FMT_OVERWRITE_BTN_MOVE_RENAME_DESC");
        }
        this.m_cRenameTargetBtn = new CRhinoOverwriteBtn(sTemp, sTemp2);
        this.m_cApplyToAll = new JCheckBox(CString.LoadString("IDS_APPLY_TO_ALL"));
        this.m_cDoNotAskAgain = new JCheckBox(CString.LoadString("IDS_DO_NOT_ASK_AGAIN"));
        this.m_cCancelBtn = new JButton(CString.LoadString("IDS_CANCEL"));
        AbstractButton[] aBtns = new AbstractButton[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn, this.m_cCancelBtn};
        for (int nIdx = 0; nIdx < aBtns.length; ++nIdx) {
            aBtns[nIdx].addActionListener(this);
        }
        CRhinoOverwriteBtn[] aOverwriteBtns = new CRhinoOverwriteBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < aOverwriteBtns.length; ++nIdx) {
            aOverwriteBtns[nIdx].addMouseListener(this);
        }
        Color clr = Color.WHITE;
        clr = UIDefaultsLookup.getColor("TextField.background");
        JPanel rCenter = new JPanel();
        rCenter.setBackground(clr);
        GroupLayout layout = new GroupLayout(rCenter);
        rCenter.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.m_cTitle, -1, -2, -2).addComponent(this.m_cDesc, -1, -2, -2).addComponent(this.m_cOverwriteTargetBtn, -1, -2, Short.MAX_VALUE).addComponent(this.m_cDoNothingBtn, -1, -2, Short.MAX_VALUE).addComponent(this.m_cResumeSourceBtn, -1, -2, Short.MAX_VALUE).addComponent(this.m_cRenameTargetBtn, -1, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.m_cTitle, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.m_cDesc, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.m_cOverwriteTargetBtn, -1, -2, -2).addComponent(this.m_cDoNothingBtn, -1, -2, -2).addComponent(this.m_cResumeSourceBtn, -1, -2, -2).addComponent(this.m_cRenameTargetBtn, -1, -2, -2));
        JPanel rBottom = new JPanel();
        layout = new GroupLayout(rBottom);
        rBottom.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cApplyToAll, -1, -2, -2).addComponent(this.m_cDoNotAskAgain, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.m_cCancelBtn, -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cApplyToAll, -1, -2, -2).addComponent(this.m_cDoNotAskAgain, -1, -2, -2)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.m_cCancelBtn, -1, -2, -2))));
        rBottom.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        this.setLayout(new BorderLayout());
        this.add((Component)rCenter, "Center");
        this.add((Component)rBottom, "South");
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.m_cCancelBtn);
        }
        this.m_cConfirmCloseDlg = new CConfirmCloseDlg((Component)this);
        this.m_cConfirmCloseDlg.ShowDoNotShowAgain(false);
        this.addKeyListener(this);
        this.AddEscapeKeyListener(this.m_cTitle);
        this.AddEscapeKeyListener(this.m_cDesc);
        this.AddEscapeKeyListener(this.m_cOverwriteTargetBtn);
        this.AddEscapeKeyListener(this.m_cDoNothingBtn);
        this.AddEscapeKeyListener(this.m_cResumeSourceBtn);
        this.AddEscapeKeyListener(this.m_cRenameTargetBtn);
        this.AddEscapeKeyListener(this.m_cApplyToAll);
        this.AddEscapeKeyListener(this.m_cDoNotAskAgain);
        this.AddEscapeKeyListener(this.m_cCancelBtn);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        RESULT result = RESULT.CANCELLED;
        if (event.getSource() == this.m_cOverwriteTargetBtn) {
            result = RESULT.OVERWRITE_TARGET;
        } else if (event.getSource() == this.m_cDoNothingBtn) {
            result = RESULT.DO_NOTHING;
        } else if (event.getSource() == this.m_cResumeSourceBtn) {
            result = RESULT.RESUME_SOURCE;
        } else if (event.getSource() == this.m_cRenameTargetBtn) {
            result = RESULT.RENAME_TARGET;
        }
        this.OnClose(result);
    }

    private void SetResult(RESULT result) {
        this.m_Result = result;
    }

    public RESULT GetResult() {
        return this.m_Result;
    }

    public void OnClose(RESULT result) {
        if (result == RESULT.CLOSED && this.m_bConfirmClose) {
            this.m_cConfirmCloseDlg.setVisible(true);
            int nResult = this.m_cConfirmCloseDlg.GetResult();
            boolean bDoNotShowAgain = this.m_cConfirmCloseDlg.GetDoNotShowAgain();
            boolean bl = this.m_bConfirmClose = !bDoNotShowAgain;
            if (nResult == 0) {
                this.OnClose(RESULT.CANCELLED);
            }
        } else {
            this.SetResult(result);
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.OnClose(RESULT.CLOSED);
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible && !this.m_bInitialized) {
            this.m_bInitialized = true;
            this.pack();
            if (this.m_rOwner != null) {
                this.setLocationRelativeTo(this.m_rOwner);
            }
        }
        super.setVisible(bVisible);
    }

    public void ShowResumeBtn(boolean bShowResume) {
        this.m_cResumeSourceBtn.setVisible(bShowResume);
    }

    public void ShowApplyToAllBtn(boolean bShowApplyToAll) {
        this.m_cApplyToAll.setVisible(bShowApplyToAll);
    }

    public void ShowDoNotAskAgain(boolean bShowDoNotAskAgain) {
        this.m_cDoNotAskAgain.setVisible(bShowDoNotAskAgain);
    }

    public boolean GetApplyToAll() {
        boolean bIsSelected = false;
        if (this.m_cApplyToAll != null) {
            bIsSelected = this.m_cApplyToAll.isSelected();
        }
        return bIsSelected;
    }

    public void SetSource(CPath rSource) {
        if (this.m_cOverwriteTargetBtn != null) {
            this.m_cOverwriteTargetBtn.SetPath(rSource);
        }
    }

    public void SetTarget(CPath rTarget) {
        if (this.m_cDoNothingBtn != null) {
            this.m_cDoNothingBtn.SetPath(rTarget);
        }
    }

    public void SetAbsRenameTo(String sAbsRenameTo) {
        String sTemp = CString.LoadString("IDS_FMT_OVERWRITE_BTN_RENAME_DESC");
        if (this.m_bIsMove) {
            sTemp = CString.LoadString("IDS_FMT_OVERWRITE_BTN_MOVE_RENAME_DESC");
        }
        this.m_cRenameTargetBtn.SetDesc(String.format(sTemp, CString.GetFileName(sAbsRenameTo)));
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        this.OnMessage(event);
        JComponent[] arComps = new JComponent[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            arComps[nIdx].dispatchEvent(event);
        }
    }

    protected void OnMessage(AWTEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        CRhinoOverwriteBtn[] aOverwriteBtns = new CRhinoOverwriteBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < aOverwriteBtns.length; ++nIdx) {
            aOverwriteBtns[nIdx].SetPaintFocusRolloverEffect(false);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        CRhinoOverwriteBtn[] aOverwriteBtns = new CRhinoOverwriteBtn[]{this.m_cOverwriteTargetBtn, this.m_cDoNothingBtn, this.m_cResumeSourceBtn, this.m_cRenameTargetBtn};
        for (int nIdx = 0; nIdx < aOverwriteBtns.length; ++nIdx) {
            aOverwriteBtns[nIdx].SetPaintFocusRolloverEffect(true);
        }
    }

    protected boolean CanChangeFont() {
        boolean bCanChangeFont = true;
        if (CMainFrame.GET_APP() != null) {
            bCanChangeFont = CMainFrame.GET_APP().CanChangeFont();
        }
        return bCanChangeFont;
    }

    public void AddEscapeKeyListener(JComponent rTextCtrl) {
        if (rTextCtrl != null) {
            rTextCtrl.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent rKeyEvent) {
                    Component rCompSource;
                    CRhinoOverwriteDlg rMainPanel;
                    Object rSource;
                    if (rKeyEvent != null && rKeyEvent.getKeyCode() == 27 && (rSource = rKeyEvent.getSource()) instanceof Component && (rMainPanel = (CRhinoOverwriteDlg)SwingUtilities.getAncestorOfClass(CRhinoOverwriteDlg.class, rCompSource = (Component)rSource)) != null) {
                        rMainPanel.dispatchEvent(new KeyEvent(rMainPanel, rKeyEvent.getID(), rKeyEvent.getWhen(), rKeyEvent.getModifiers(), rKeyEvent.getKeyCode(), rKeyEvent.getKeyChar(), rKeyEvent.getKeyLocation()));
                    }
                }
            });
        }
    }

    @Override
    public void keyTyped(KeyEvent rKeyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rKeyEvent) {
        if (rKeyEvent != null && rKeyEvent.getKeyCode() == 27) {
            this.OnClose(RESULT.CANCELLED);
            rKeyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent rKeyEvent) {
    }

    public static enum RESULT {
        OVERWRITE_TARGET,
        DO_NOTHING,
        RESUME_SOURCE,
        RENAME_TARGET,
        CANCELLED,
        CLOSED;

    }
}

