/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JLabel;

public class CRhinoOverwriteBtn
extends AbstractButton
implements MouseListener,
FocusListener,
KeyListener {
    private Color m_clrBlue;
    private String m_sTitle;
    private String m_sDesc;
    private JLabel m_cArrow;
    private JLabel m_cTitle;
    private JLabel m_cDesc;
    private Insets m_Insets;
    private boolean m_bPaintMouseRolloverEffect;
    private Color m_MouseRolloverBorderClr;
    private Color m_MouseRolloverClr1;
    private Color m_MouseRolloverClr2;
    private boolean m_bPaintFocusRolloverEffect;
    private Color m_KeyboardRolloverBorderClr;
    private Color m_KeyboardRolloverClr1;
    private Color m_KeyboardRolloverClr2;

    public CRhinoOverwriteBtn() {
        this._CRhinoOverwriteBtn(null, null);
    }

    public CRhinoOverwriteBtn(String sTitle, String sDesc) {
        this._CRhinoOverwriteBtn(sTitle, sDesc);
    }

    private void _CRhinoOverwriteBtn(String sTitle, String sDesc) {
        this.m_bPaintMouseRolloverEffect = false;
        this.m_bPaintFocusRolloverEffect = true;
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.m_MouseRolloverBorderClr = new Color(185, 215, 252);
        this.m_MouseRolloverClr1 = new Color(237, 245, 255);
        this.m_MouseRolloverClr2 = new Color(253, 254, 255);
        this.m_KeyboardRolloverBorderClr = new Color(218, 218, 218);
        this.m_KeyboardRolloverClr1 = new Color(251, 251, 252);
        this.m_KeyboardRolloverClr2 = new Color(230, 230, 230);
        this.m_sTitle = sTitle;
        this.m_sDesc = sDesc;
        this.setOpaque(false);
        this.setFocusable(true);
        this.m_clrBlue = new Color(0, 51, 153);
        this.m_cArrow = new JLabel();
        this.m_cArrow.setIcon(CMainFrame.GetJARImage("ArrowEast16.png"));
        this.m_cArrow.setVerticalAlignment(3);
        this.m_cTitle = new JLabel(this.m_sTitle);
        this.m_cTitle.setForeground(this.m_clrBlue);
        this.m_cDesc = new JLabel(this.m_sDesc);
        this.m_cDesc.setForeground(this.m_clrBlue);
        if (this.CanChangeFont()) {
            Font font = this.m_cTitle.getFont();
            font = new Font(font.getName(), 0, 16);
            this.m_cTitle.setFont(font);
            font = this.m_cDesc.getFont();
            font = new Font(font.getName(), 0, font.getSize());
            this.m_cDesc.setFont(font);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        this.m_cArrow.setPreferredSize(new Dimension(this.m_cArrow.getPreferredSize().width, this.m_cTitle.getPreferredSize().height));
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.m_cArrow, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTitle, -1, -2, Short.MAX_VALUE).addComponent(this.m_cDesc, -1, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cArrow, -1, -2, -2).addComponent(this.m_cTitle, -1, -2, -2)).addComponent(this.m_cDesc, -1, -2, -2));
    }

    @Override
    public Insets getInsets() {
        if (this.m_Insets == null) {
            this.m_Insets = new Insets(5, 5, 5, 5);
        }
        return this.m_Insets;
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected Color GetBlueClr() {
        return this.m_clrBlue;
    }

    protected JLabel GetArrowLabel() {
        return this.m_cArrow;
    }

    protected JLabel GetTitleLabel() {
        return this.m_cTitle;
    }

    protected JLabel GetDescLabel() {
        return this.m_cDesc;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.FireEvent();
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.m_bPaintMouseRolloverEffect = true;
        this.m_bPaintFocusRolloverEffect = false;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.m_bPaintMouseRolloverEffect = false;
        this.m_bPaintFocusRolloverEffect = true;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        RoundRectangle2D.Float roundedRectangle;
        GradientPaint gradient;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isFocusOwner() && this.m_bPaintFocusRolloverEffect) {
            gradient = new GradientPaint(2.0f, 2.0f, this.m_KeyboardRolloverClr1, 2.0f, this.getHeight() - 2, this.m_KeyboardRolloverClr2);
            g2.setPaint(gradient);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setPaint(this.m_KeyboardRolloverBorderClr);
            roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 5.0f, 5.0f);
            g2.draw(roundedRectangle);
        }
        if (this.m_bPaintMouseRolloverEffect) {
            gradient = new GradientPaint(2.0f, 2.0f, this.m_MouseRolloverClr2, 2.0f, this.getHeight() - 2, this.m_MouseRolloverClr1);
            g2.setPaint(gradient);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setPaint(this.m_MouseRolloverBorderClr);
            roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 5.0f, 5.0f);
            g2.draw(roundedRectangle);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 32) {
            event.consume();
            this.FireEvent();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    private void FireEvent() {
        if (this.getModel() != null) {
            this.getModel().setArmed(true);
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, ""));
    }

    public void SetPath(CPath rSource) {
        if (rSource != null) {
            CFile fChild;
            CFile fRoot = null;
            fRoot = rSource.IsLocal() ? CMainFrame.GET_APP().GetLocalRoot() : CMainFrame.GET_APP().GetRemoteRoot();
            if (fRoot == null || (fChild = fRoot.FindFile(rSource.GetPath(), true)) != null) {
                // empty if block
            }
        }
    }

    public void SetDesc(String sDesc) {
        this.m_sDesc = sDesc;
        if (this.m_cDesc != null) {
            this.m_cDesc.setText(sDesc);
        }
    }

    public void SetPaintFocusRolloverEffect(boolean bPaint) {
        this.m_bPaintFocusRolloverEffect = bPaint;
        this.repaint();
    }

    protected boolean CanChangeFont() {
        boolean bCanChangeFont = true;
        if (CMainFrame.GET_APP() != null) {
            bCanChangeFont = CMainFrame.GET_APP().CanChangeFont();
        }
        return bCanChangeFont;
    }
}

