/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class CRhinoMessageBox
extends JDialog
implements ActionListener,
WindowListener {
    private int m_nDlgType = -1;
    private int m_nImageType = -1;
    private int m_nResult = -1;
    private JLabel m_cImage;
    private String m_sMessage;
    private JTextPane m_cMessage;
    private JButton m_cYes;
    private JButton m_cNo;
    private JButton m_cCancel;
    private JCheckBox m_cDoNotShowAgain;
    private boolean m_bInitialized;
    private Component m_rOwner;

    public CRhinoMessageBox(Component rOwner, String sTitle, Image imgWindow, int nDlgType, int nImageType, String sMessage) {
        this._CRhinoMessageBox(rOwner, sTitle, imgWindow, nDlgType, nImageType, sMessage);
    }

    private void _CRhinoMessageBox(Component rOwner, String sTitle, Image imgWindow, int nDlgType, int nImageType, String sMessage) {
        JButton rBtn;
        int nIdx;
        ImageIcon ico32;
        this.setTitle(sTitle);
        ArrayList<Image> aImages = new ArrayList<Image>();
        ImageIcon ico16 = CMainFrame.GetJARImage("FVJV_16x16.png");
        if (ico16 != null) {
            aImages.add(ico16.getImage());
        }
        if ((ico32 = CMainFrame.GetJARImage("FVJV_32x32.png")) != null) {
            aImages.add(ico32.getImage());
        }
        if (ico16 != null) {
            this.setIconImage(ico16.getImage());
        }
        this.m_rOwner = rOwner;
        this.setDefaultCloseOperation(0);
        this.m_bInitialized = false;
        this.setModal(true);
        this.setIconImage(imgWindow);
        this.addWindowListener(this);
        this.m_cImage = new JLabel();
        this.m_sMessage = sMessage;
        this.m_cMessage = new JTextPane();
        JScrollPane rScrollText = new JScrollPane(this.m_cMessage);
        this.SetMessage(sMessage);
        this.m_cMessage.setEditable(false);
        this.m_cMessage.setBorder(BorderFactory.createEmptyBorder());
        rScrollText.setBorder(BorderFactory.createEmptyBorder());
        Color clr = UIDefaultsLookup.getColor("Label.background");
        this.m_cMessage.setBackground(clr);
        this.m_cYes = new JButton(CString.LoadString("IDS_YES"));
        this.m_cNo = new JButton(CString.LoadString("IDS_NO"));
        this.m_cCancel = new JButton(CString.LoadString("IDS_CANCEL"));
        this.m_cDoNotShowAgain = new JCheckBox(CString.LoadString("IDS_DO_NOT_ASK_AGAIN"));
        JPanel rPanel = new JPanel();
        GroupLayout layout = new GroupLayout(rPanel);
        rPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        Dimension dimSize = this.m_cYes.getPreferredSize();
        JButton[] aBtns = new JButton[]{this.m_cYes, this.m_cNo, this.m_cCancel};
        for (nIdx = 0; nIdx < aBtns.length; ++nIdx) {
            rBtn = aBtns[nIdx];
            Dimension dimTemp = rBtn.getPreferredSize();
            dimSize.width = Math.max(dimSize.width, dimTemp.width);
            dimSize.height = Math.max(dimSize.height, dimTemp.height);
        }
        for (nIdx = 0; nIdx < aBtns.length; ++nIdx) {
            rBtn = aBtns[nIdx];
            rBtn.setPreferredSize(dimSize);
            rBtn.addActionListener(this);
        }
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cImage, -1, -2, -2).addComponent(rScrollText, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE).addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE)).addComponent(this.m_cDoNotShowAgain, -1, -2, -2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cImage, -1, -2, -2).addComponent(rScrollText, -1, -2, Short.MAX_VALUE)).addGroup(layout.createParallelGroup().addComponent(this.m_cYes, -1, -2, -2).addComponent(this.m_cNo, -1, -2, -2).addComponent(this.m_cCancel, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, -2).addComponent(this.m_cDoNotShowAgain, -1, -2, -2).addGap(5));
        this.add(rPanel);
        this.SetDialogType(nDlgType);
        this.SetImageType(nImageType);
        rScrollText.setMinimumSize(new Dimension(60, 50));
        rScrollText.setPreferredSize(new Dimension(60, 50));
        this.setMinimumSize(new Dimension(300, 150));
        this.setMaximumSize(new Dimension(600, 500));
        this.setPreferredSize(new Dimension(300, 150));
    }

    public int GetImageType() {
        return this.m_nImageType;
    }

    public void SetImageType(int nImageType) {
        this.m_nImageType = nImageType;
        this.InitImage();
    }

    protected void InitImage() {
        Icon icon = null;
        switch (this.GetImageType()) {
            case 3: {
                icon = UIManager.getIcon("OptionPane.questionIcon");
                break;
            }
            case 1: {
                icon = UIManager.getIcon("OptionPane.informationIcon");
                break;
            }
            case 2: {
                icon = UIManager.getIcon("OptionPane.warningIcon");
                break;
            }
            case 0: {
                icon = UIManager.getIcon("OptionPane.errorIcon");
                break;
            }
            default: {
                icon = null;
            }
        }
        this.m_cImage.setIcon(icon);
    }

    protected JCheckBox GetDoNotAskAgainCheckBox() {
        return this.m_cDoNotShowAgain;
    }

    public boolean GetDoNotShowAgain() {
        return this.m_cDoNotShowAgain.isSelected();
    }

    public void ShowDoNotShowAgain(boolean bIsVisible) {
        if (this.m_cDoNotShowAgain != null) {
            this.m_cDoNotShowAgain.setVisible(bIsVisible);
        }
    }

    public int GetResult() {
        return this.m_nResult;
    }

    private void SetResult(int nResult) {
        this.m_nResult = nResult;
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.OnClose(-1);
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int nResult = -1;
        if (event.getSource() == this.m_cNo) {
            nResult = 1;
        } else if (event.getSource() == this.m_cCancel) {
            nResult = 2;
        } else if (event.getSource() == this.m_cYes) {
            nResult = 0;
        }
        this.OnClose(nResult);
    }

    public void OnClose(int nResult) {
        this.SetResult(nResult);
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible) {
            this.SetResult(-1);
            if (!this.m_bInitialized) {
                this.m_bInitialized = true;
                this.pack();
                if (this.m_rOwner != null) {
                    this.setLocationRelativeTo(this.m_rOwner);
                }
            }
        }
        super.setVisible(bVisible);
    }

    public void SetDialogType(int nDlgType) {
        boolean bShowYes = true;
        boolean bShowNo = false;
        boolean bShowCancel = false;
        String sYes = CString.LoadString("IDS_YES");
        String sNo = CString.LoadString("IDS_NO");
        String sCancel = CString.LoadString("IDS_CANCEL");
        switch (nDlgType) {
            case 0: {
                bShowYes = true;
                bShowNo = true;
                bShowCancel = false;
                sYes = CString.LoadString("IDS_YES");
                sNo = CString.LoadString("IDS_NO");
                sCancel = CString.LoadString("IDS_CANCEL");
                break;
            }
            case 1: {
                bShowYes = true;
                bShowNo = true;
                bShowCancel = true;
                sYes = CString.LoadString("IDS_YES");
                sNo = CString.LoadString("IDS_NO");
                sCancel = CString.LoadString("IDS_CANCEL");
                break;
            }
            case 2: {
                bShowYes = true;
                bShowNo = false;
                bShowCancel = true;
                sYes = CString.LoadString("IDS_OK");
                sNo = CString.LoadString("IDS_NO");
                sCancel = CString.LoadString("IDS_CANCEL");
                break;
            }
            default: {
                bShowYes = true;
                bShowNo = false;
                bShowCancel = false;
                sYes = CString.LoadString("IDS_OK");
                sNo = CString.LoadString("IDS_NO");
                sCancel = CString.LoadString("IDS_CANCEL");
            }
        }
        this.m_cYes.setVisible(bShowYes);
        this.m_cNo.setVisible(bShowNo);
        this.m_cCancel.setVisible(bShowCancel);
        this.m_cYes.setText(sYes);
        this.m_cNo.setText(sNo);
        this.m_cCancel.setText(sCancel);
    }

    public void SetMessage(String sMessage) {
        this.m_sMessage = sMessage;
        if (this.m_cMessage != null) {
            this.m_cMessage.setText(sMessage);
        }
    }
}

