/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CConfirmRenameReadOnlyDlg;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CRenameDlgMainPanel
extends CDialogMainPanel
implements ActionListener {
    private JLabel m_cRenameLabel;
    private JTextField m_cRenameField;
    private JButton m_cOKBtn;
    private JButton m_cCancelBtn;
    private CFile m_rRenameFile;
    private String m_sRenameDir;
    private String m_sRenameName;
    private boolean m_bWarnOnReadOnly;
    private Component m_rOwner;
    private CBaseThread m_rThread;

    public CRenameDlgMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
        Boolean bPromptReadOnly;
        this.m_rRenameFile = null;
        this.m_sRenameDir = null;
        this.m_sRenameName = null;
        this.m_bWarnOnReadOnly = true;
        IArchive rArchive = this.GetArchive();
        if (rArchive != null && (bPromptReadOnly = rArchive.GetValueBool("ConfirmFileReadOnly", true)) != null) {
            this.m_bWarnOnReadOnly = bPromptReadOnly;
        }
    }

    protected IArchive GetArchive() {
        IArchive rArchive = null;
        if (CMainFrame.GET_APP() != null) {
            rArchive = CMainFrame.GET_APP().GetArchive();
        }
        return rArchive;
    }

    protected JLabel GetRenameLabel() {
        return this.m_cRenameLabel;
    }

    protected JTextField GetRenameField() {
        return this.m_cRenameField;
    }

    protected JButton GetOKBtn() {
        return this.m_cOKBtn;
    }

    protected JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    private void UpdateMsg() {
        String sMsg = CString.LoadString("IDS_RENAME_DLG_MSG_FILE");
        if (this.IsDir()) {
            sMsg = CString.LoadString("IDS_RENAME_DLG_MSG_FOLDER");
        }
        if (this.GetRenameLabel() != null) {
            this.GetRenameLabel().setText(sMsg);
        }
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        this.m_cRenameLabel = new JLabel();
        this.m_cRenameField = new JTextField();
        if (this.GetRenameField() != null) {
            this.AddEscapeKeyListener(this.GetRenameField());
        }
        this.LoadName();
        this.UpdateMsg();
        if (this.GetRenameField() != null) {
            this.GetRenameField().selectAll();
        }
        this.m_cOKBtn = new JButton(CString.LoadString("IDS_OK"));
        this.SetBtnTxt(this.m_cOKBtn, CString.LoadString("IDS_OK", false));
        if (this.GetOKBtn() != null) {
            this.GetOKBtn().addActionListener(this);
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            if (rDlg != null && rDlg.getRootPane() != null) {
                rDlg.getRootPane().setDefaultButton(this.GetOKBtn());
            }
            this.GetOKBtn().requestFocus();
        }
        this.m_cCancelBtn = new JButton(CString.LoadString("IDS_CANCEL"));
        this.SetBtnTxt(this.m_cCancelBtn, CString.LoadString("IDS_CANCEL", false));
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().addActionListener(this);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetRenameLabel(), -1, -2, -2).addComponent(this.GetRenameField(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetRenameLabel(), -1, -2, -2).addComponent(this.GetRenameField(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent != null) {
            CDialog rDlg;
            if (rEvent.getSource() == this.GetOKBtn()) {
                CDialog rDlg2;
                int nRc = this.OnChangeName();
                if ((nRc == 0 || nRc == 0) && this.GetRenameField() != null) {
                    String sNewName = this.GetRenameField().getText();
                    this.CommitNewFileName(sNewName);
                }
                if ((rDlg2 = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
                    rDlg2.OnClose(0);
                }
            } else if (rEvent.getSource() == this.GetCancelBtn() && (rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
                rDlg.OnClose(2);
            }
        }
    }

    private String GetRenameDir() {
        if (this.m_sRenameDir == null && this.GetRenameFile() != null) {
            this.m_sRenameDir = this.GetRenameFile().GetParentPath(true);
        }
        return this.m_sRenameDir;
    }

    private String GetRenameName() {
        return this.m_sRenameName;
    }

    private void SetRenameName(String sName) {
        this.m_sRenameName = sName;
    }

    private boolean IsDir() {
        boolean bIsDir = false;
        if (this.GetRenameFile() != null) {
            bIsDir = this.GetRenameFile().IsDir();
        }
        return bIsDir;
    }

    private CFile GetRenameFile() {
        return this.m_rRenameFile;
    }

    public void SetRenameFile(CFile rRenameFile) {
        this.m_rRenameFile = rRenameFile;
        String sAbsRenamePath = this.m_rRenameFile.GetPath();
        String sDir = this.GetRenameDir();
        int nStart = sDir.length();
        if (nStart >= 0) {
            String sName = sAbsRenamePath.substring(nStart);
            if (rRenameFile.IsDir()) {
                sName = CString.EnsureNotLastChar(Character.valueOf(rRenameFile.GetFileSeparatorChar()), sName);
            }
            this.SetRenameName(sName);
        }
        this.LoadName();
        this.LoadLabel();
    }

    private void LoadName() {
        if (this.GetRenameField() != null) {
            this.GetRenameField().setText(this.GetRenameName());
        }
    }

    private void LoadLabel() {
        String sLabel = CString.LoadString("IDS_RENAME_DLG_MSG_FILE");
        if (this.IsDir()) {
            sLabel = CString.LoadString("IDS_RENAME_DLG_MSG_FOLDER");
        }
        if (this.GetRenameLabel() != null) {
            this.GetRenameLabel().setText(sLabel);
        }
    }

    public String GetAbsRenameToPath() {
        String sAbsRenameTo = this.GetRenameDir();
        if (this.GetRenameField() != null) {
            sAbsRenameTo = sAbsRenameTo + this.GetRenameField().getText();
        }
        return sAbsRenameTo;
    }

    private int OnChangeName() {
        int nRc = 0;
        if (this.GetRenameFile() != null) {
            String sOriginalName = this.GetRenameName();
            String sNewName = this.GetRenameField().getText();
            if (this.GetRenameFile() != null && this.GetRenameFile().IsDir()) {
                sNewName = CString.EnsureLastChar(Character.valueOf(this.GetRenameFile().GetFileSeparatorChar()), sNewName);
            }
            boolean bIsReadOnly = this.GetRenameFile().IsReadOnly();
            if (this.m_bWarnOnReadOnly && bIsReadOnly) {
                String sMsg = String.format(CString.LoadString("IDS_CONFIRM_RENAME_READ_ONLY_MSG"), sOriginalName, sNewName);
                CConfirmRenameReadOnlyDlg dlg = new CConfirmRenameReadOnlyDlg((Frame)CMainFrame.GET_APP(), true, -1L);
                dlg.SetMainMsg(sMsg);
                dlg.setVisible(true);
                nRc = dlg.GetExitCode();
                if (nRc != 0 && this.GetRenameField() != null) {
                    this.GetRenameField().setText(this.GetRenameName());
                    this.GetRenameField().selectAll();
                }
            }
        }
        return nRc;
    }

    private CBaseThread GetThread() {
        return this.m_rThread;
    }

    private boolean CommitNewFileName(String sRenameTo) {
        boolean bCommitted = false;
        if (this.GetRenameFile() != null) {
            if (!this.GetRenameFile().IsLocal() || CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                sRenameTo = sRenameTo.trim();
            }
            String sAbsRenameTo = CString.ConvertRelativePath(this.GetRenameFile().GetParentPath(false), sRenameTo);
            if (this.m_rOwner != null && CMainFrame.GET_APP() != null) {
                this.GetRenameFile().Rename(this.GetThread(), this.m_rOwner, sRenameTo);
                bCommitted = true;
            }
        }
        return bCommitted;
    }

    public void SetOwner(Component rOwner) {
        this.m_rOwner = rOwner;
    }

    public void SetThread(CBaseThread rThread) {
        this.m_rThread = rThread;
    }
}

