/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CPropertiesDlg;
import com.rhinosoft.fvjv.gui.dialogs.CPropertiesDlgTabPanel;
import com.rhinosoft.fvjv.gui.dialogs.CPropertiesGeneral;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CPropertiesDlgMainPanel
extends CDialogMainPanel
implements ActionListener {
    public static final int TAB_IDX_GENERAL = 0;
    private JTabbedPane m_cTabbedPane;
    private CPropertiesGeneral m_Tab1;
    private JButton m_cOk;
    private JButton m_cCancel;
    private JButton m_cApply;
    private ArrayList<CFile> m_afFiles = new ArrayList();

    @Override
    public void OnCreate() {
        this.m_cTabbedPane = new JTabbedPane();
        this.m_cTabbedPane.addKeyListener(this);
        this.m_cOk = new JButton(CString.LoadString("IDS_OK"));
        this.SetBtnTxt(this.m_cOk, CString.LoadString("IDS_OK", false));
        this.m_cCancel = new JButton(CString.LoadString("IDS_CANCEL"));
        this.SetBtnTxt(this.m_cCancel, CString.LoadString("IDS_CANCEL", false));
        this.m_cApply = new JButton(CString.LoadString("IDS_APPLY"));
        this.SetBtnTxt(this.m_cApply, CString.LoadString("IDS_APPLY", false));
        this.m_cOk.addActionListener(this);
        this.m_cCancel.addActionListener(this);
        this.m_cApply.addActionListener(this);
        CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
        if (rDlg != null && rDlg.getRootPane() != null) {
            rDlg.getRootPane().setDefaultButton(this.m_cOk);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.m_cTabbedPane, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetOk()).addComponent(this.GetCancel()).addComponent(this.GetApply())));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.m_cTabbedPane)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetOk()).addComponent(this.GetCancel()).addComponent(this.GetApply()))));
        this.m_Tab1 = new CPropertiesGeneral();
        if (this.GetTabbedPane() != null && this.m_Tab1 != null) {
            this.GetTabbedPane().insertTab(CString.LoadString("IDS_FILE_PROPS_TAB_TITLE_GENERAL"), null, this.m_Tab1, CString.LoadString("IDS_FILE_PROPS_TAB_TITLE_GENERAL"), 0);
            this.m_Tab1.OnCreate();
        }
        this.SetApplyBtnEnabled(false);
    }

    private void SetApplyBtnEnabled(boolean bEnabled) {
        if (this.GetApply() != null) {
            this.GetApply().setEnabled(bEnabled);
            this.GetApply().setVisible(bEnabled);
        }
    }

    @Override
    public void OnInitialUpdate() {
        if (this.GetTabbedPane() != null) {
            for (int nIdx = 0; nIdx < this.GetTabbedPane().getTabCount(); ++nIdx) {
                CPropertiesDlgTabPanel rPanel = (CPropertiesDlgTabPanel)this.GetTabbedPane().getTabComponentAt(nIdx);
                if (rPanel == null) continue;
                rPanel.OnInitialUpdate();
            }
        }
    }

    @Override
    public void OnDestroy() {
        if (this.GetTabbedPane() != null) {
            for (int nIdx = 0; nIdx < this.GetTabbedPane().getTabCount(); ++nIdx) {
                CPropertiesDlgTabPanel rPanel = (CPropertiesDlgTabPanel)this.GetTabbedPane().getTabComponentAt(nIdx);
                if (rPanel == null) continue;
                rPanel.OnDestroy();
            }
        }
    }

    @Override
    public boolean ValidatePage() {
        boolean bIsValid = super.ValidatePage();
        if (this.GetTabbedPane() != null) {
            for (int nIdx = 0; nIdx < this.GetTabbedPane().getTabCount(); ++nIdx) {
                Component rNext = this.GetTabbedPane().getTabComponentAt(nIdx);
                if (rNext == null || !(rNext instanceof CPropertiesDlgTabPanel)) continue;
                CPropertiesDlgTabPanel rPanel = (CPropertiesDlgTabPanel)rNext;
                bIsValid = rPanel.ValidatePage() && bIsValid;
            }
        }
        return bIsValid;
    }

    protected ArrayList<CFile> GetFileList() {
        return this.m_afFiles;
    }

    protected JTabbedPane GetTabbedPane() {
        return this.m_cTabbedPane;
    }

    protected Component GetTabPanel(int nIdx) {
        Component rComp = null;
        if (this.GetTabbedPane() != null) {
            rComp = this.GetTabbedPane().getTabComponentAt(nIdx);
        }
        return rComp;
    }

    protected JButton GetOk() {
        return this.m_cOk;
    }

    protected JButton GetCancel() {
        return this.m_cCancel;
    }

    protected JButton GetApply() {
        return this.m_cApply;
    }

    public void AddFile(CFile fFile) {
        if (fFile != null && this.GetFileList() != null) {
            this.GetFileList().add(fFile.clone());
        }
    }

    public int GetFileCount() {
        int nCount = 0;
        if (this.GetFileList() != null) {
            nCount = this.GetFileList().size();
        }
        return nCount;
    }

    public CFile GetFile(int nIdx) {
        CFile fFile = null;
        if (this.GetFileList() != null) {
            fFile = this.GetFileList().get(nIdx);
        }
        return fFile;
    }

    @Override
    public void actionPerformed(ActionEvent rActionEvent) {
        if (rActionEvent.getSource() == this.GetOk()) {
            this.OnOk();
        } else if (rActionEvent.getSource() == this.GetCancel()) {
            this.OnCancel();
        } else if (rActionEvent.getSource() == this.GetApply()) {
            this.OnApply();
        }
    }

    private void OnOk() {
        this.OnApply();
        CPropertiesDlg rDlg = (CPropertiesDlg)SwingUtilities.getAncestorOfClass(CPropertiesDlg.class, this);
        if (rDlg != null) {
            rDlg.OnClose(0);
        }
    }

    private void OnCancel() {
        CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
        if (rDlg != null) {
            rDlg.OnClose(2);
        }
    }

    private void OnApply() {
        this.SetApplyBtnEnabled(false);
        this.PostUpdateAttrs();
    }

    private void PostUpdateAttrs() {
        Object objSource;
        CPropertiesDlg rPropDlg = (CPropertiesDlg)SwingUtilities.getAncestorOfClass(CPropertiesDlg.class, this);
        if (rPropDlg == null || (objSource = rPropDlg.GetEventSource()) != null) {
            // empty if block
        }
    }

    public void EnableApply() {
        this.SetApplyBtnEnabled(true);
    }

    @Override
    protected void OnEvent(CRhinoEvent rEvent) {
        super.OnEvent(rEvent);
        if (this.m_Tab1 != null) {
            this.m_Tab1.dispatchEvent(rEvent);
        }
    }
}

