/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.fvjv.gui.dialogs.COptionsToolbarTableItem;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class COptionsToolbarTableModel
extends AbstractTableModel {
    public static final int ICON_INDEX = 0;
    public static final int ACTIVE_INDEX = 1;
    private String[] m_asColHeaders;
    private int[] m_anDefToolbarItems;
    private Vector<COptionsToolbarTableItem> m_Data;
    private int m_nSelRow;

    COptionsToolbarTableModel(String[] asColumnNames, int[] anDefToolbarItems) {
        this.m_asColHeaders = asColumnNames;
        this.m_anDefToolbarItems = anDefToolbarItems;
        this.m_Data = new Vector();
        this.m_nSelRow = -1;
    }

    @Override
    public int getRowCount() {
        return this.m_Data.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_asColHeaders.length;
    }

    public Vector<COptionsToolbarTableItem> getData() {
        return this.m_Data;
    }

    @Override
    public String getColumnName(int nColumn) {
        return this.m_asColHeaders[nColumn];
    }

    @Override
    public Object getValueAt(int nRow, int nColumn) {
        return this.m_Data.get(nRow);
    }

    public int GetSelRow() {
        return this.m_nSelRow;
    }

    public void SetSelRow(int nRow) {
        this.m_nSelRow = nRow;
    }

    public Class getColumnClass(int nColumn) {
        Class cColumn;
        switch (nColumn) {
            case 0: {
                cColumn = Icon.class;
                break;
            }
            case 1: {
                cColumn = Boolean.class;
                break;
            }
            default: {
                cColumn = null;
            }
        }
        return cColumn;
    }

    @Override
    public void setValueAt(Object oItem, int nRow, int nColumn) {
        switch (nColumn) {
            case 0: {
                this.m_Data.get(nRow).setIcon((Icon)oItem);
                break;
            }
            case 1: {
                if (!this.m_Data.get(nRow).getActive().booleanValue()) {
                    this.m_Data.get(nRow).setActive(new Boolean(true));
                    break;
                }
                this.m_Data.get(nRow).setActive(new Boolean(false));
                break;
            }
            default: {
                System.out.printf("Column outside of scope of table\n", new Object[0]);
            }
        }
        this.fireTableCellUpdated(nRow, nColumn);
    }

    @Override
    public void fireTableCellUpdated(int nRow, int nColumn) {
        super.fireTableCellUpdated(nRow, nColumn);
    }

    public void ShuffleTable(int nIndex, int nDestination) {
        this.m_nSelRow = nDestination;
        if (nIndex != nDestination) {
            COptionsToolbarTableItem cHolder = this.m_Data.get(nDestination);
            this.m_Data.set(nDestination, this.m_Data.get(nIndex));
            if (nIndex - 1 == nDestination || nIndex + 1 == nDestination) {
                this.m_Data.set(nIndex, cHolder);
            } else if (nIndex < nDestination) {
                for (int nIdx = nDestination - 1; nIdx >= nIndex; --nIdx) {
                    COptionsToolbarTableItem cHolder2 = this.m_Data.get(nIdx);
                    this.m_Data.set(nIdx, cHolder);
                    cHolder = cHolder2;
                }
            } else {
                for (int nIdx = nDestination + 1; nIdx <= nIndex; ++nIdx) {
                    COptionsToolbarTableItem cHolder2 = this.m_Data.get(nIdx);
                    this.m_Data.set(nIdx, cHolder);
                    cHolder = cHolder2;
                }
            }
            this.fireTableDataChanged();
        }
    }

    private COptionsToolbarTableItem GetItem(int nEventID, Vector<COptionsToolbarTableItem> aData) {
        COptionsToolbarTableItem rItem = null;
        if (aData != null) {
            Iterator<COptionsToolbarTableItem> itr = aData.iterator();
            while (itr.hasNext() && rItem == null) {
                COptionsToolbarTableItem rNextItem = itr.next();
                if (rNextItem == null || rNextItem.getAction() != nEventID) continue;
                rItem = rNextItem;
            }
        }
        return rItem;
    }

    public void ResetTable() {
        if (this.m_Data != null) {
            int nIdx;
            COptionsToolbarTableItem rItem = null;
            Vector<COptionsToolbarTableItem> aData = new Vector<COptionsToolbarTableItem>();
            aData.setSize(this.m_Data.size());
            for (nIdx = 0; nIdx < this.m_Data.size(); ++nIdx) {
                aData.set(nIdx, this.m_Data.get(nIdx));
            }
            this.m_Data.removeAllElements();
            for (nIdx = 0; nIdx < this.m_anDefToolbarItems.length; nIdx += 2) {
                int nID = this.m_anDefToolbarItems[nIdx];
                int nCheck = this.m_anDefToolbarItems[nIdx + 1];
                rItem = this.GetItem(nID, aData);
                if (rItem == null) continue;
                boolean bCheck = nCheck != 0;
                rItem.setActive(bCheck);
                this.m_Data.add(rItem);
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public boolean isCellEditable(int nRow, int nColumn) {
        boolean bEdit = false;
        if (nColumn == 1) {
            bEdit = true;
        }
        return bEdit;
    }

    public void addItem(COptionsToolbarTableItem rObj) {
        this.m_Data.add(rObj);
    }
}

