/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.gui.CSoundMachine;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.dialogs.CFVJVPrefsTreePanel;
import com.rhinosoft.fvjv.gui.dialogs.CFileChooser;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class COptionsSounds
extends CFVJVPrefsTreePanel
implements ActionListener {
    private String m_sAbsSoundLookinDir;
    private JLabel m_cTransferDoneLabel;
    private JTextField m_cTransferDoneField;
    private JButton m_cTransferDoneBtn;
    private JLabel m_cTransferErrorLabel;
    private JTextField m_cTransferErrorField;
    private JButton m_cTransferErrorBtn;

    public COptionsSounds(String sTitle, CMainFrame rMainFrame) {
        super(sTitle, rMainFrame);
        this.InitVars();
    }

    private void InitVars() {
        this.m_sAbsSoundLookinDir = this.GetDefaultBrowsePath();
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        if (this.GetHeaderIconCtrl() != null) {
            this.GetHeaderIconCtrl().setVisible(false);
        }
        if (this.GetHeaderMsgCtrl() != null) {
            this.GetHeaderMsgCtrl().setText(String.format(CString.LoadString("IDS_OPTIONS_SOUNDS_PANEL_INTRO"), "FTP Voyager JV", "FTP Voyager JV"));
        }
        this.m_cTransferDoneLabel = new JLabel(CString.LoadString("IDS_OPTIONS_SOUND_FILE_TRANSFER_DONE"));
        this.m_cTransferDoneField = new JTextField();
        this.m_cTransferDoneBtn = new JButton(CString.LoadString("IDS_BROWSE_DOTS"));
        this.m_cTransferErrorLabel = new JLabel(CString.LoadString("IDS_OPTIONS_SOUND_FILE_TRANSFER_FAILED"));
        this.m_cTransferErrorField = new JTextField();
        this.m_cTransferErrorBtn = new JButton(CString.LoadString("IDS_BROWSE_DOTS"));
        this.m_cTransferDoneBtn.addActionListener(this);
        this.m_cTransferErrorBtn.addActionListener(this);
        this.AddEscapeKeyListener(this.m_cTransferDoneField);
        this.AddEscapeKeyListener(this.m_cTransferDoneBtn);
        this.AddEscapeKeyListener(this.m_cTransferErrorField);
        this.AddEscapeKeyListener(this.m_cTransferErrorBtn);
        Dimension dimSize = this.m_cTransferDoneField.getPreferredSize();
        if (dimSize != null) {
            Dimension dimSize2 = this.m_cTransferDoneBtn.getPreferredSize();
            if (dimSize2 != null) {
                dimSize.width = dimSize2.width;
            }
            this.m_cTransferDoneBtn.setPreferredSize(dimSize);
            this.m_cTransferDoneBtn.setMinimumSize(dimSize);
            this.m_cTransferDoneBtn.setMaximumSize(dimSize);
            this.m_cTransferErrorBtn.setPreferredSize(dimSize);
            this.m_cTransferErrorBtn.setMinimumSize(dimSize);
            this.m_cTransferErrorBtn.setMaximumSize(dimSize);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetTitleCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetHeaderSeparator(), -1, -2, Short.MAX_VALUE).addComponent(this.m_cTransferDoneLabel, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_cTransferDoneField, -1, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, 4).addComponent(this.m_cTransferDoneBtn, -1, -2, -2)).addComponent(this.m_cTransferErrorLabel, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_cTransferErrorField, -1, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 4, 4).addComponent(this.m_cTransferErrorBtn, -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetTitleCtrl(), -1, -2, -2).addGap(10).addGroup(layout.createParallelGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addComponent(this.GetHeaderSeparator(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addComponent(this.m_cTransferDoneLabel, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTransferDoneField, -1, -2, -2).addComponent(this.m_cTransferDoneBtn, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 5, 5).addComponent(this.m_cTransferErrorLabel, -1, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.m_cTransferErrorField, -1, -2, -2).addComponent(this.m_cTransferErrorBtn, -1, -2, -2)));
        this.LoadPage();
    }

    private void LoadPage() {
        if (this.GetMainFrame() != null && this.GetMainFrame().GetArchive() != null) {
            String sVal = null;
            String sDefDir = this.GetDefaultBrowsePath();
            this.m_sAbsSoundLookinDir = this.GetMainFrame().GetArchive().GetValue("SoundFileLookinDir", sDefDir);
            sVal = this.GetMainFrame().GetArchive().GetValue("SoundFileTransferDone", "");
            if (sVal != null && !sVal.isEmpty() && this.m_cTransferDoneField != null) {
                this.m_cTransferDoneField.setText(sVal);
            }
            if ((sVal = this.GetMainFrame().GetArchive().GetValue("SoundFileTransferError", "")) != null && !sVal.isEmpty() && this.m_cTransferErrorField != null) {
                this.m_cTransferErrorField.setText(sVal);
            }
        }
    }

    private String GetDefaultBrowsePath() {
        File fDefDir;
        String sDefaultDir = null;
        if (FileSystemView.getFileSystemView() != null && (fDefDir = FileSystemView.getFileSystemView().getDefaultDirectory()) != null) {
            sDefaultDir = fDefDir.getAbsolutePath();
        }
        return sDefaultDir;
    }

    @Override
    public void SavePage() {
        super.SavePage();
        if (this.GetMainFrame() != null && this.GetMainFrame().GetArchive() != null) {
            String sVal = null;
            String sDefDir = this.GetDefaultBrowsePath();
            this.GetMainFrame().GetArchive().SetValue("SoundFileLookinDir", this.m_sAbsSoundLookinDir, sDefDir);
            sVal = null;
            if (this.m_cTransferDoneField != null) {
                sVal = this.m_cTransferDoneField.getText();
            }
            if (sVal != null) {
                sVal = sVal.trim();
            }
            this.GetMainFrame().GetArchive().SetValue("SoundFileTransferDone", sVal, "");
            sVal = null;
            if (this.m_cTransferErrorField != null) {
                sVal = this.m_cTransferErrorField.getText();
            }
            if (sVal != null) {
                sVal = sVal.trim();
            }
            this.GetMainFrame().GetArchive().SetValue("SoundFileTransferError", sVal, "");
        }
    }

    @Override
    public void OnHelp() {
        if (this.GetMainFrame() != null) {
            String[] asInfo = new String[]{"Help-Dlg-Prefs-Sounds.htm", "none"};
            CRhinoEvent rEvent = new CRhinoEvent(this.GetMainFrame(), 7000, asInfo);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_cTransferDoneBtn || e.getSource() == this.m_cTransferErrorBtn) {
            File fSelFile;
            CFileChooser rFileChooser = new CFileChooser(this, new File(this.m_sAbsSoundLookinDir));
            rFileChooser.setMultiSelectionEnabled(false);
            rFileChooser.setFileSelectionMode(0);
            rFileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File fPathname) {
                    boolean bAccept = false;
                    if (fPathname != null) {
                        if (!fPathname.isDirectory()) {
                            String sAbsPath = fPathname.getAbsolutePath();
                            String sFileExt = CString.GetFileExtension(sAbsPath, fPathname.isDirectory(), false);
                            if (sFileExt != null && !sFileExt.isEmpty()) {
                                bAccept = CSoundMachine.IsSupportedSoundExt(sFileExt);
                            }
                        } else {
                            bAccept = true;
                        }
                    }
                    return bAccept;
                }

                @Override
                public String getDescription() {
                    return CString.LoadString("IDS_OPTIONS_SOUND_FILE_FILTER");
                }
            });
            File fCurDir = new File(this.m_sAbsSoundLookinDir);
            if (fCurDir != null && fCurDir.exists()) {
                rFileChooser.setCurrentDirectory(fCurDir);
            }
            String sSelFile = null;
            if (e.getSource() == this.m_cTransferDoneBtn) {
                if (this.m_cTransferDoneField != null) {
                    sSelFile = this.m_cTransferDoneField.getText();
                }
            } else if (this.m_cTransferErrorField != null) {
                sSelFile = this.m_cTransferErrorField.getText();
            }
            if (sSelFile != null) {
                sSelFile.trim();
            }
            if (sSelFile != null && !sSelFile.isEmpty()) {
                rFileChooser.setSelectedFile(new File(sSelFile));
            }
            rFileChooser.setDialogTitle(CString.LoadString("IDS_OPTIONS_SOUND_FILE_LOOKIN_TITLE"));
            int nResultCode = rFileChooser.showDialog(this, CString.LoadString("IDS_OK"));
            if (nResultCode == 0 && (fSelFile = rFileChooser.getSelectedFile()) != null && fSelFile.exists()) {
                String sParentPath = CString.GetFilePath(fSelFile.getAbsolutePath(), true);
                if (sParentPath != null && !sParentPath.isEmpty()) {
                    this.m_sAbsSoundLookinDir = sParentPath;
                }
                if (e.getSource() == this.m_cTransferDoneBtn) {
                    if (this.m_cTransferDoneField != null) {
                        this.m_cTransferDoneField.setText(fSelFile.getAbsolutePath());
                    }
                } else if (this.m_cTransferErrorField != null) {
                    this.m_cTransferErrorField.setText(fSelFile.getAbsolutePath());
                }
            }
        }
    }
}

