/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CMsgBoxMainPanel
extends CDialogMainPanel
implements ActionListener {
    private int m_nDlgType;
    private int m_nImageType;
    private JLabel m_cMainImage;
    private Icon m_icoMainIcon;
    private JTextPane m_cMainMsg;
    private String m_sMainMsg;
    private JScrollPane m_cMainMsgScroll;
    private JLabel m_cBtnMsg;
    private String m_sBtnMsg;
    private JButton m_cYesBtn;
    private JButton m_cNoBtn;
    private JButton m_cCancelBtn;
    private float m_fBtnAlignment;
    private int m_nDefBtnOption;

    public CMsgBoxMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_nDlgType = -1;
        this.m_nImageType = -1;
        this.m_nDefBtnOption = 0;
        this.m_sMainMsg = "";
        this.m_icoMainIcon = null;
        this.m_sBtnMsg = "";
        this.m_fBtnAlignment = 0.5f;
    }

    protected JLabel GetMainImageCtrl() {
        return this.m_cMainImage;
    }

    protected JTextPane GetMainMsgCtrl() {
        return this.m_cMainMsg;
    }

    protected JLabel GetBtnMsgCtrl() {
        return this.m_cBtnMsg;
    }

    protected JButton GetYesBtn() {
        return this.m_cYesBtn;
    }

    protected JButton GetNoBtn() {
        return this.m_cNoBtn;
    }

    protected JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    @Override
    public void OnCreate() {
        boolean bShow;
        super.OnCreate();
        this.m_cMainImage = new JLabel();
        this.UpdateImage(this.m_nImageType);
        this.m_cMainMsg = new JTextPane();
        if (this.GetMainMsgCtrl() != null) {
            this.GetMainMsgCtrl().setCaretPosition(0);
            this.GetMainMsgCtrl().setMargin(new Insets(5, 5, 5, 5));
            this.GetMainMsgCtrl().setBorder(null);
            this.GetMainMsgCtrl().setOpaque(false);
            this.GetMainMsgCtrl().setEditable(false);
            this.GetMainMsgCtrl().setText(this.m_sMainMsg);
            this.GetMainMsgCtrl().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent rKeyEvent) {
                    CMsgBoxMainPanel rMainPanel = (CMsgBoxMainPanel)SwingUtilities.getAncestorOfClass(CMsgBoxMainPanel.class, (JComponent)rKeyEvent.getSource());
                    if (rMainPanel != null) {
                        KeyEvent rEvt = new KeyEvent(rMainPanel, 401, System.currentTimeMillis(), rKeyEvent.getModifiers(), rKeyEvent.getKeyCode(), rKeyEvent.getKeyChar());
                        rMainPanel.dispatchEvent(rEvt);
                    }
                }
            });
        }
        this.m_cBtnMsg = new JLabel();
        if (this.GetBtnMsgCtrl() != null) {
            this.GetBtnMsgCtrl().setText(this.m_sBtnMsg);
        }
        this.m_cYesBtn = new JButton(CString.LoadString("IDS_YES"));
        if (this.GetYesBtn() != null) {
            this.UpdateYesTxt(this.m_nDlgType);
            this.GetYesBtn().addActionListener(this);
            this.GetYesBtn().addKeyListener(this);
        }
        this.m_cNoBtn = new JButton(CString.LoadString("IDS_NO"));
        if (this.GetNoBtn() != null) {
            this.SetBtnTxt(this.GetNoBtn(), CString.LoadString("IDS_NO", false));
            this.GetNoBtn().addActionListener(this);
            this.GetNoBtn().addKeyListener(this);
            bShow = false;
            if (this.m_nDlgType == 0 || this.m_nDlgType == 1) {
                bShow = true;
            }
            this.GetNoBtn().setVisible(bShow);
        }
        this.m_cCancelBtn = new JButton(CString.LoadString("IDS_CANCEL"));
        if (this.GetCancelBtn() != null) {
            this.SetBtnTxt(this.GetCancelBtn(), CString.LoadString("IDS_CANCEL", false));
            this.GetCancelBtn().addActionListener(this);
            this.GetCancelBtn().addKeyListener(this);
            bShow = false;
            if (this.m_nDlgType == 2 || this.m_nDlgType == 1) {
                bShow = true;
            }
            this.GetCancelBtn().setVisible(bShow);
        }
        this.SetDefaultBtn(this.m_nDefBtnOption);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.m_cMainMsgScroll = new JScrollPane(this.GetMainMsgCtrl());
        if (this.GetMainMsgScrollCtrl() != null) {
            this.GetMainMsgScrollCtrl().setBorder(null);
        }
        this.RecalcLayout();
    }

    protected void RecalcLayout() {
        LayoutManager rLayout = this.getLayout();
        if (rLayout instanceof GroupLayout) {
            GroupLayout layout = (GroupLayout)rLayout;
            if (this.GetBtnAlignment() == 0.5f) {
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetMainImageCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addComponent(this.GetMainMsgScrollCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetBtnMsgCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetYesBtn(), -1, -2, -2).addComponent(this.GetNoBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)));
            } else if (this.GetBtnAlignment() == 0.0f) {
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetMainImageCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addComponent(this.GetMainMsgScrollCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetBtnMsgCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.GetYesBtn(), -1, -2, -2).addComponent(this.GetNoBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)));
            } else {
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetMainImageCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addComponent(this.GetMainMsgScrollCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetBtnMsgCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetYesBtn(), -1, -2, -2).addComponent(this.GetNoBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
            }
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.GetMainImageCtrl(), -1, -2, -2).addComponent(this.GetMainMsgScrollCtrl(), -1, -2, Short.MAX_VALUE)).addComponent(this.GetBtnMsgCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 10).addGroup(layout.createParallelGroup().addComponent(this.GetYesBtn(), -1, -2, -2).addComponent(this.GetNoBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        }
    }

    public void SetMainMsg(String sMsg) {
        if (this.GetMainMsgCtrl() != null) {
            this.GetMainMsgCtrl().setText(sMsg);
        } else {
            this.m_sMainMsg = sMsg;
        }
    }

    public String GetMainMsg() {
        String sTemp;
        String sMainMsg = this.m_sMainMsg;
        if ((sMainMsg == null || sMainMsg.isEmpty()) && this.GetMainMsgCtrl() != null && (sTemp = this.GetMainMsgCtrl().getText()) != null && !sTemp.isEmpty()) {
            sMainMsg = sTemp;
        }
        return sMainMsg;
    }

    protected JScrollPane GetMainMsgScrollCtrl() {
        return this.m_cMainMsgScroll;
    }

    public void SetMainImage(Icon icon) {
        if (this.GetMainImageCtrl() != null) {
            this.GetMainImageCtrl().setIcon(icon);
        } else {
            this.m_icoMainIcon = icon;
        }
    }

    public void SetBtnMsg(String sBtnMsg) {
        if (this.GetBtnMsgCtrl() != null) {
            this.GetBtnMsgCtrl().setText(sBtnMsg);
        } else {
            this.m_sBtnMsg = sBtnMsg;
        }
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent != null) {
            CDialog rDlg;
            int nCloseOpt = -1;
            if (rEvent.getSource() == this.GetYesBtn()) {
                nCloseOpt = 0;
            } else if (rEvent.getSource() == this.GetNoBtn()) {
                nCloseOpt = 1;
            } else if (rEvent.getSource() == this.GetCancelBtn()) {
                nCloseOpt = 2;
            }
            if (nCloseOpt != -1 && (rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
                rDlg.OnClose(nCloseOpt);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent rKeyEvent) {
        boolean bHandled = false;
        if (rKeyEvent != null) {
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            if (rDlg != null) {
                if (this.GetYesBtn() != null && this.GetYesBtn().getMnemonic() == rKeyEvent.getKeyCode()) {
                    this.GetYesBtn().doClick();
                    bHandled = true;
                } else if (this.GetNoBtn() != null && this.GetNoBtn().getMnemonic() == rKeyEvent.getKeyCode()) {
                    this.GetNoBtn().doClick();
                    bHandled = true;
                } else if (this.GetCancelBtn() != null && this.GetCancelBtn().getMnemonic() == rKeyEvent.getKeyCode()) {
                    this.GetCancelBtn().doClick();
                    bHandled = true;
                }
            }
            if (!bHandled) {
                if (rKeyEvent.getKeyCode() == 37) {
                    if (this.GetCancelBtn() != null && this.GetCancelBtn().hasFocus()) {
                        if (this.GetNoBtn() != null) {
                            this.GetNoBtn().requestFocus();
                        } else if (this.GetYesBtn() != null) {
                            this.GetYesBtn().requestFocus();
                        }
                        bHandled = true;
                    }
                    if (this.GetNoBtn() != null && this.GetNoBtn().hasFocus()) {
                        if (this.GetYesBtn() != null) {
                            this.GetYesBtn().requestFocus();
                        }
                        bHandled = true;
                    } else if (this.GetYesBtn() != null) {
                        this.GetYesBtn().requestFocus();
                    } else if (this.GetNoBtn() != null) {
                        this.GetNoBtn().requestFocus();
                    } else if (this.GetCancelBtn() != null) {
                        this.GetCancelBtn().requestFocus();
                    }
                } else if (rKeyEvent.getKeyCode() == 39) {
                    if (this.GetYesBtn() != null && this.GetYesBtn().hasFocus()) {
                        if (this.GetNoBtn() != null) {
                            this.GetNoBtn().requestFocus();
                        } else if (this.GetCancelBtn() != null) {
                            this.GetCancelBtn().requestFocus();
                        }
                        bHandled = true;
                    }
                    if (this.GetNoBtn() != null && this.GetNoBtn().hasFocus()) {
                        if (this.GetCancelBtn() != null) {
                            this.GetCancelBtn().requestFocus();
                        }
                        bHandled = true;
                    } else if (this.GetCancelBtn() != null) {
                        this.GetCancelBtn().requestFocus();
                    } else if (this.GetNoBtn() != null) {
                        this.GetNoBtn().requestFocus();
                    } else if (this.GetYesBtn() != null) {
                        this.GetYesBtn().requestFocus();
                    }
                }
            }
        }
        if (!bHandled) {
            super.keyPressed(rKeyEvent);
        } else {
            rKeyEvent.consume();
        }
    }

    public void SetDlgType(int nDlgType) {
        this.m_nDlgType = nDlgType;
    }

    public void SetImageType(int nImageType) {
        this.m_nImageType = nImageType;
    }

    private void UpdateImage(int nImageType) {
        if (this.GetMainImageCtrl() != null) {
            Icon icon = null;
            switch (nImageType) {
                case 3: {
                    icon = UIManager.getIcon("OptionPane.questionIcon");
                    break;
                }
                case 1: {
                    icon = UIManager.getIcon("OptionPane.informationIcon");
                    break;
                }
                case 2: {
                    icon = UIManager.getIcon("OptionPane.warningIcon");
                    break;
                }
                case 0: {
                    icon = UIManager.getIcon("OptionPane.errorIcon");
                    break;
                }
                default: {
                    icon = null;
                }
            }
            this.m_icoMainIcon = icon;
            this.GetMainImageCtrl().setIcon(icon);
        }
    }

    private void UpdateYesTxt(int nDlgType) {
        String sTxt = CString.LoadString("IDS_YES", false);
        if (this.GetYesBtn() != null) {
            if (nDlgType == -1 || nDlgType == 2) {
                sTxt = CString.LoadString("IDS_OK", false);
            }
            this.SetBtnTxt(this.GetYesBtn(), sTxt);
        }
    }

    public void SetBtnAlignment(float fAlignment) {
        if (this.m_fBtnAlignment != fAlignment) {
            this.m_fBtnAlignment = fAlignment;
            this.RecalcLayout();
            this.repaint();
        }
    }

    protected float GetBtnAlignment() {
        return this.m_fBtnAlignment;
    }

    public void SetDefaultBtn(int nBtnOption) {
        this.m_nDefBtnOption = nBtnOption;
        this.UpdateDefaultBtn(this.m_nDefBtnOption);
    }

    private void UpdateDefaultBtn(int nBtnOption) {
        JButton rDefBtn = this.GetYesBtn();
        if (nBtnOption == 1) {
            rDefBtn = this.GetNoBtn();
        } else if (nBtnOption == 2) {
            rDefBtn = this.GetCancelBtn();
        }
        CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
        if (rDlg != null && rDlg.getRootPane() != null) {
            rDlg.getRootPane().setDefaultButton(rDefBtn);
        }
    }
}

