/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CLoginDlgMainPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.net.CLogin;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class CLoginDlg
extends CDialog {
    public static void main(String[] asArguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.pack();
                CLoginDlg dlg = new CLoginDlg(frame);
                dlg.SetIsChangeEmail(true);
                dlg.setVisible(true);
                frame.setVisible(true);
            }
        });
    }

    public CLoginDlg(Frame wndOwner) {
        super(wndOwner, true, -1L);
        this.InitVars();
    }

    public CLoginDlg(Dialog wndOwner) {
        super(wndOwner, true, -1L);
        this.InitVars();
    }

    private void InitVars() {
        this.setTitle(CString.LoadString("IDS_LOGIN_DLG_TITLE"));
        if (CMainFrame.GET_APP() != null) {
            ImageIcon ico32;
            ArrayList<Image> aImages = new ArrayList<Image>();
            ImageIcon ico16 = CMainFrame.GetJARImage("FVJV_16x16.png");
            if (ico16 != null) {
                aImages.add(ico16.getImage());
            }
            if ((ico32 = CMainFrame.GetJARImage("FVJV_32x32.png")) != null) {
                aImages.add(ico32.getImage());
            }
            if (aImages != null && aImages.size() > 0) {
                this.setIconImages(aImages);
            } else {
                this.setIconImage(ico16.getImage());
            }
        }
        this.SetRecalcLayout(true);
    }

    @Override
    protected CLoginDlgMainPanel CreateMainPanel() {
        return new CLoginDlgMainPanel();
    }

    @Override
    public CLoginDlgMainPanel GetMainPanel() {
        CLoginDlgMainPanel rRet = null;
        CDialogMainPanel rMainPanel = super.GetMainPanel();
        if (rMainPanel != null && rMainPanel instanceof CLoginDlgMainPanel) {
            rRet = (CLoginDlgMainPanel)rMainPanel;
        }
        return rRet;
    }

    @Override
    protected Dimension CreateInitialSize() {
        Dimension dimSize = new Dimension(350, 300);
        if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
            dimSize.width += 100;
            dimSize.height += 50;
        }
        return dimSize;
    }

    public void SetConnectionInfo(boolean bIsSecure, String sHost, long lPort, String sUserID, String sLanguage, String sLocale, CLogin rLogin) {
        if (sHost != null && !sHost.isEmpty()) {
            this.setTitle(String.format(CString.LoadString("IDS_LOGIN_DLG_TITLE_FMT"), sHost));
        }
        if (this.GetMainPanel() != null) {
            this.GetMainPanel().SetConnectionInfo(bIsSecure, sHost, lPort, sUserID, sLanguage, sLocale);
        }
        this.SetLogin(rLogin);
    }

    public void SetIsChangeLogin(boolean bIsChangeLogin) {
        if (this.GetMainPanel() != null) {
            this.GetMainPanel().SetIsChangeLogin(bIsChangeLogin);
        }
    }

    public void SetIsChangeEmail(boolean bIsChangeLogin) {
        if (this.GetMainPanel() != null) {
            this.GetMainPanel().SetIsChangeEmail(bIsChangeLogin);
        }
    }

    public void SetLogin(CLogin rLogin) {
        if (this.GetMainPanel() != null) {
            this.GetMainPanel().SetLogin(rLogin);
        }
    }

    public String GetUserID() {
        String sUserID = null;
        if (this.GetMainPanel() != null) {
            sUserID = this.GetMainPanel().GetUser(true);
        }
        return sUserID;
    }

    public String GetPassword() {
        String sPassword = null;
        if (this.GetMainPanel() != null) {
            sPassword = this.GetMainPanel().GetPassword(true);
        }
        return sPassword;
    }

    public String GetNewPassword() {
        String sPassword = null;
        if (this.GetMainPanel() != null) {
            sPassword = this.GetMainPanel().GetNewPassword();
        }
        return sPassword;
    }

    public void SetPassword(String sPassword) {
        if (this.GetMainPanel() != null) {
            this.GetMainPanel().SetPassword(sPassword);
        }
    }
}

