/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;

public abstract class CDialog
extends JDialog
implements WindowListener,
ComponentListener {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_METHODS = DEBUG;
    private long m_nDlgID;
    private Dimension m_dimInitialSize;
    private CDialogMainPanel m_MainPanel;
    private boolean m_bCreated;
    private boolean m_bInitialUpdate;
    private int m_nExitCode;
    private boolean m_bInitPreferredSize;
    private boolean m_bRecalcLayout;

    public CDialog(Frame wndOwner, boolean bIsModal, long nDlgID) {
        super(wndOwner, bIsModal);
        this.InitVars(nDlgID);
    }

    public CDialog(Dialog wndOwner, boolean bIsModal, long nDlgID) {
        super(wndOwner, bIsModal);
        this.InitVars(nDlgID);
    }

    protected abstract CDialogMainPanel CreateMainPanel();

    private void InitVars(long nDlgID) {
        this.m_nExitCode = 2;
        this.m_nDlgID = nDlgID;
        this.m_bCreated = false;
        this.m_bInitialUpdate = false;
        this.m_bInitPreferredSize = true;
        this.m_bRecalcLayout = false;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.m_MainPanel = this.CreateMainPanel();
        this.setContentPane(this.GetMainPanel());
        this.m_dimInitialSize = this.CreateInitialSize();
    }

    public long GetDlgID() {
        return this.m_nDlgID;
    }

    protected boolean GetCreated() {
        return this.m_bCreated;
    }

    protected boolean GetInitialUpdate() {
        return this.m_bInitialUpdate;
    }

    public CDialogMainPanel GetMainPanel() {
        return this.m_MainPanel;
    }

    @Override
    public void windowOpened(WindowEvent rWndEvent) {
    }

    @Override
    public void windowClosing(WindowEvent rWndEvent) {
        this.OnClose(-1);
    }

    @Override
    public void windowClosed(WindowEvent rWndEvent) {
    }

    @Override
    public void windowIconified(WindowEvent rWndEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent rWndEvent) {
    }

    @Override
    public void windowActivated(WindowEvent rWndEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent rWndEvent) {
    }

    protected Dimension CreateInitialSize() {
        return new Dimension(800, 600);
    }

    public Dimension GetInitialSize() {
        return this.m_dimInitialSize;
    }

    public void SetInitialSize(Dimension dimSize) {
        this.m_dimInitialSize = dimSize;
    }

    protected Point GetInitialLocation() {
        return null;
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (!this.m_bCreated) {
            Point ptLoc;
            this.m_bCreated = true;
            if (this.GetInitPreferredSize()) {
                this.setPreferredSize(this.GetInitialSize());
            }
            this.pack();
            this.OnCreate();
            if (this.GetRecalcLayout()) {
                this.RecalcLayout();
            }
            if ((ptLoc = this.GetInitialLocation()) != null) {
                this.setLocation(ptLoc);
            } else {
                this.setLocationRelativeTo(this.getOwner());
            }
        }
        super.setVisible(bVisible);
    }

    protected void OnCreate() {
        if (this.GetMainPanel() != null) {
            this.GetMainPanel().OnCreate();
            this.setJMenuBar(this.GetMainPanel().GetMainMenu());
        }
    }

    protected void OnDestroy() {
        if (this.GetMainPanel() != null) {
            this.GetMainPanel().OnDestroy();
        }
    }

    @Override
    public void componentResized(ComponentEvent rCompEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent rCompEvent) {
    }

    @Override
    public void componentShown(ComponentEvent rCompEvent) {
        if (!this.m_bInitialUpdate) {
            this.m_bInitialUpdate = true;
            if (this.GetMainPanel() != null) {
                this.GetMainPanel().OnInitialUpdate();
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent rCompEvent) {
    }

    public void OnClose(int nExitCode) {
        this.SetExitCode(nExitCode);
        this.setVisible(false);
        this.OnDestroy();
        this.dispose();
    }

    public int GetExitCode() {
        return this.m_nExitCode;
    }

    protected void SetExitCode(int nExitCode) {
        this.m_nExitCode = nExitCode;
    }

    public Object GetEventSource() {
        CMainFrame objRet = CMainFrame.GET_APP();
        return objRet;
    }

    protected CMainFrame GetMainFrame() {
        CMainFrame rMainFrame = CMainFrame.GET_APP();
        return rMainFrame;
    }

    @Override
    protected void processEvent(AWTEvent rAWTEvent) {
        if (rAWTEvent instanceof CRhinoEvent) {
            if (this.GetMainPanel() != null) {
                this.GetMainPanel().dispatchEvent(rAWTEvent);
            }
        } else {
            super.processEvent(rAWTEvent);
        }
    }

    @Override
    public void setPreferredSize(Dimension dimSize) {
        this.SetInitPreferredSize(false);
        super.setPreferredSize(dimSize);
    }

    protected void SetInitPreferredSize(boolean bVal) {
        this.m_bInitPreferredSize = bVal;
    }

    protected boolean GetInitPreferredSize() {
        return this.m_bInitPreferredSize;
    }

    protected int GetPreferredWidth() {
        int nWidth = 800;
        Dimension dimSize = this.CreateInitialSize();
        if (dimSize != null) {
            nWidth = dimSize.width;
        }
        return nWidth;
    }

    public void RecalcLayout() {
        if (this.GetRecalcLayout()) {
            this.setPreferredSize(null);
            this.validate();
            Dimension dimPrefSize = this.getPreferredSize();
            if (dimPrefSize != null && dimPrefSize.width > this.GetPreferredWidth()) {
                dimPrefSize.width = this.GetPreferredWidth();
                this.setPreferredSize(dimPrefSize);
            }
            this.pack();
        }
    }

    private boolean GetRecalcLayout() {
        return this.m_bRecalcLayout;
    }

    protected void SetRecalcLayout(boolean bRecalcLayout) {
        this.m_bRecalcLayout = bRecalcLayout;
    }
}

