/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.fvjv.gui.dialogs.CDialog;
import com.rhinosoft.fvjv.gui.dialogs.CDialogMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CMsgBox;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class CChangeEmailDlgMainPanel
extends CDialogMainPanel
implements ActionListener {
    private JTextField m_cNewEmail;
    private JTextField m_cNewEmailEx;
    private JButton m_cOKBtn;
    private JButton m_cCancelBtn;
    private String m_sCancelText;
    private boolean m_bIsLogoutOnCancel;

    public CChangeEmailDlgMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_bIsLogoutOnCancel = false;
        this.m_sCancelText = CString.LoadString("IDS_CANCEL", false);
    }

    protected JTextField GetNewEmailCtrl() {
        return this.m_cNewEmail;
    }

    protected JTextField GetNewEmailExCtrl() {
        return this.m_cNewEmailEx;
    }

    protected JButton GetOKBtn() {
        return this.m_cOKBtn;
    }

    protected JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        JLabel cNewEmailLabel = new JLabel(CString.LoadString("IDS_NEW_EMAIL_LABEL"));
        JLabel cNewEmailLabelEx = new JLabel(CString.LoadString("IDS_VERIFY_NEW_EMAIL_LABEL"));
        this.m_cNewEmail = new JTextField();
        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null) {
            this.m_cNewEmail.setText(CMainFrame.GET_APP().GetClientInfo().GetUserEmailAddress());
        }
        this.m_cNewEmailEx = new JTextField();
        this.AddEscapeKeyListener(this.m_cNewEmail);
        this.AddEscapeKeyListener(this.m_cNewEmailEx);
        this.m_cOKBtn = new JButton(CString.LoadString("IDS_OK"));
        this.SetBtnTxt(this.GetOKBtn(), CString.LoadString("IDS_OK", false));
        if (this.GetOKBtn() != null) {
            this.GetOKBtn().addActionListener(this);
            this.GetOKBtn().addKeyListener(this);
            CDialog rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
            if (rDlg != null && rDlg.getRootPane() != null) {
                rDlg.getRootPane().setDefaultButton(this.GetOKBtn());
            }
            this.GetOKBtn().requestFocus();
        }
        this.m_cCancelBtn = new JButton(this.m_sCancelText);
        this.SetBtnTxt(this.GetCancelBtn(), this.m_sCancelText);
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().addActionListener(this);
            this.GetCancelBtn().addKeyListener(this);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(cNewEmailLabel, -1, -2, Short.MAX_VALUE).addComponent(this.GetNewEmailCtrl(), -1, -2, Short.MAX_VALUE).addComponent(cNewEmailLabelEx, -1, -2, Short.MAX_VALUE).addComponent(this.GetNewEmailExCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(cNewEmailLabel, -1, -2, -2).addComponent(this.GetNewEmailCtrl(), -1, -2, -2).addComponent(cNewEmailLabelEx, -1, -2, -2).addComponent(this.GetNewEmailExCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        String sOldEmail = this.m_cNewEmail.getText();
        if (sOldEmail != null && !(sOldEmail = sOldEmail.trim()).isEmpty() && this.m_cNewEmailEx != null) {
            this.m_cNewEmailEx.requestFocusInWindow();
        }
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent != null) {
            CDialog rDlg;
            if (rEvent.getSource() == this.GetOKBtn()) {
                boolean bNewEmailsValid = this.AreNewEmailsValid();
                if (bNewEmailsValid) {
                    CDialog rDlg2 = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
                    if (rDlg2 != null) {
                        rDlg2.OnClose(0);
                    }
                } else {
                    CDialog rDlg3 = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this);
                    CMsgBox dlg = new CMsgBox(rDlg3, true, -1L, -1, 0);
                    dlg.setTitle(CString.LoadString("IDS_CHANGE_EMAILS_FAILED_TITLE"));
                    if (rDlg3 != null && rDlg3.getIconImages() != null && rDlg3.getIconImages().size() > 0) {
                        dlg.setIconImage(rDlg3.getIconImages().get(0));
                    }
                    String sMainMsg = CString.LoadString("IDS_NEW_EMAILS_DIFFER_MSG");
                    dlg.SetMainMsg(sMainMsg);
                    Dimension dimSize = new Dimension(320, 120);
                    if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                        dimSize.width += 100;
                        dimSize.height += 50;
                    }
                    dlg.setPreferredSize(dimSize);
                    dlg.setResizable(false);
                    dlg.setVisible(true);
                    if (this.GetNewEmailExCtrl() != null) {
                        this.GetNewEmailExCtrl().selectAll();
                    }
                }
            } else if (rEvent.getSource() == this.GetCancelBtn() && (rDlg = (CDialog)SwingUtilities.getAncestorOfClass(CDialog.class, this)) != null) {
                rDlg.OnClose(2);
            }
        }
    }

    public String GetNewEmail() {
        String sRet = "";
        if (this.GetNewEmailCtrl() != null) {
            sRet = this.GetNewEmailCtrl().getText();
        }
        return sRet;
    }

    private boolean AreNewEmailsValid() {
        boolean bIsValid = false;
        if (this.GetNewEmailCtrl() != null && this.GetNewEmailExCtrl() != null) {
            String sTemp1 = this.GetNewEmailCtrl().getText();
            String sTemp2 = this.GetNewEmailExCtrl().getText();
            bIsValid = this.VerifyNewEmails(sTemp1, sTemp2);
        }
        return bIsValid;
    }

    private boolean VerifyNewEmails(String sNewPword, String sVerifyPword) {
        boolean bIsValid = false;
        if (sNewPword != null && sVerifyPword != null && sNewPword.equals(sVerifyPword)) {
            bIsValid = true;
        } else if (sNewPword == null && sVerifyPword == null) {
            bIsValid = true;
        }
        return bIsValid;
    }

    public boolean IsLogoutOnCancel() {
        return this.m_bIsLogoutOnCancel;
    }

    public void SetIsLogoutOnCancel(boolean bIsLogoutOnCancel) {
        this.m_bIsLogoutOnCancel = bIsLogoutOnCancel;
        this.m_sCancelText = CString.LoadString("IDS_CANCEL", false);
        if (this.m_bIsLogoutOnCancel) {
            this.m_sCancelText = CString.LoadString("IDS_LOGOUT", false);
        }
        this.SetBtnTxt(this.GetCancelBtn(), this.m_sCancelText);
    }
}

