/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.rhinosoft.fvjv.gui.dialogs.CAllFramesDlgListModel;
import com.rhinosoft.fvjv.gui.dialogs.CAllFramesDlgListRenderer;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class CAllFramesDlgPanel
extends JPanel
implements ActionListener,
KeyListener {
    private JLabel m_cListLabel;
    private CAllFramesDlgListModel m_cListModel;
    private CAllFramesDlgListRenderer m_cListRenderer;
    private JList m_cList;
    private JButton m_cOK;
    private JButton m_cCancel;
    private int m_nDlgRetCode;
    private DockingManager m_cDockingManager;

    public CAllFramesDlgPanel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_nDlgRetCode = 2;
        this.m_cListLabel = new JLabel(this.GetLabelTxt());
        this.m_cListModel = this.CreateListModel();
        this.m_cListRenderer = new CAllFramesDlgListRenderer();
        this.m_cList = this.InitList(this.m_cListModel, this.m_cListRenderer);
        JScrollPane cScrollPane = new JScrollPane(this.m_cList);
        this.m_cOK = this.InitOKBtn();
        this.m_cCancel = this.InitCancelBtn();
        this.AddEscapeKeyListener(this.m_cListLabel);
        this.AddEscapeKeyListener(this.m_cList);
        this.AddEscapeKeyListener(this.m_cOK);
        this.AddEscapeKeyListener(this.m_cCancel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetListLabel(), -1, -2, Short.MAX_VALUE).addComponent(cScrollPane, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetListLabel(), -1, -2, -2).addComponent(cScrollPane, -1, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(this.GetOKBtn(), -1, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2)));
        this.addKeyListener(this);
    }

    protected CAllFramesDlgListModel CreateListModel() {
        return new CAllFramesDlgListModel();
    }

    protected String GetLabelTxt() {
        return CString.LoadString("IDS_ACTIVATE_FRAME_DLG_LIST_LABEL");
    }

    private JList InitList(ListModel rModel, ListCellRenderer rRenderer) {
        JList rList = new JList(rModel);
        if (rList != null) {
            rList.setSelectionMode(0);
            rList.setCellRenderer(rRenderer);
        }
        return rList;
    }

    private JLabel GetListLabel() {
        return this.m_cListLabel;
    }

    protected JList GetList() {
        return this.m_cList;
    }

    private JButton GetOKBtn() {
        return this.m_cOK;
    }

    private JButton GetCancelBtn() {
        return this.m_cCancel;
    }

    private JButton CreateButton(String sText, boolean bAddActionListener) {
        JButton rBtn = new JButton(sText);
        if (rBtn != null && bAddActionListener) {
            rBtn.addActionListener(this);
        }
        return rBtn;
    }

    private JButton InitOKBtn() {
        return this.CreateButton(CString.LoadString("IDS_OK"), true);
    }

    private JButton InitCancelBtn() {
        return this.CreateButton(CString.LoadString("IDS_CANCEL"), true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean bClose = false;
        if (event.getSource() == this.GetOKBtn()) {
            this.m_nDlgRetCode = 0;
            bClose = true;
        } else if (event.getSource() == this.GetCancelBtn()) {
            bClose = true;
        }
        if (bClose) {
            JDialog rDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            rDlg.setVisible(false);
            rDlg.dispose();
        }
    }

    public int GetDlgRetCode() {
        return this.m_nDlgRetCode;
    }

    protected CAllFramesDlgListModel GetListModel() {
        return this.m_cListModel;
    }

    public void SetDockingManager(DockingManager dockManager) {
        this.m_cDockingManager = dockManager;
        if (this.GetListModel() != null) {
            this.GetListModel().SetDockingManager(dockManager);
        }
    }

    protected DockingManager GetDockingManager() {
        return this.m_cDockingManager;
    }

    public void UpdateActiveFrames() {
        if (this.GetListModel() != null) {
            this.GetListModel().InitFrames();
        }
        if (this.GetListModel() != null && this.GetList() != null && this.GetDockingManager() != null) {
            DockableFrame rActiveFrame = this.GetDockingManager().getFrame(this.GetDockingManager().getActiveFrameKey());
            int nSelIdx = this.GetListModel().indexOf(rActiveFrame);
            if (nSelIdx >= 0 && nSelIdx < this.GetList().getModel().getSize()) {
                this.GetList().setSelectedIndex(nSelIdx);
            }
        }
    }

    public DockableFrame GetSelectedFrame() {
        Object obj;
        int nIndex;
        DockableFrame rFrame = null;
        if (this.GetList() != null && this.GetListModel() != null && (nIndex = this.GetList().getSelectedIndex()) >= 0 && nIndex < this.GetListModel().getSize() && (obj = this.GetListModel().get(nIndex)) instanceof DockableFrame) {
            rFrame = (DockableFrame)obj;
        }
        return rFrame;
    }

    public void AddEscapeKeyListener(JComponent rTextCtrl) {
        if (rTextCtrl != null) {
            rTextCtrl.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent rKeyEvent) {
                    Component rCompSource;
                    CAllFramesDlgPanel rMainPanel;
                    Object rSource;
                    if (rKeyEvent != null && rKeyEvent.getKeyCode() == 27 && (rSource = rKeyEvent.getSource()) instanceof Component && (rMainPanel = (CAllFramesDlgPanel)SwingUtilities.getAncestorOfClass(CAllFramesDlgPanel.class, rCompSource = (Component)rSource)) != null) {
                        rMainPanel.dispatchEvent(new KeyEvent(rMainPanel, rKeyEvent.getID(), rKeyEvent.getWhen(), rKeyEvent.getModifiers(), rKeyEvent.getKeyCode(), rKeyEvent.getKeyChar(), rKeyEvent.getKeyLocation()));
                    }
                }
            });
        }
    }

    @Override
    public void keyTyped(KeyEvent rKeyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rKeyEvent) {
        if (rKeyEvent != null && rKeyEvent.getKeyCode() == 27) {
            rKeyEvent.consume();
            this.m_nDlgRetCode = -1;
            JDialog rDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
            rDlg.setVisible(false);
            rDlg.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent rKeyEvent) {
    }
}

