/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.FilePanel.CFilePanel;
import com.rhinosoft.FilePanel.CFileTableCellRenderer;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.dialogs.CFVJVPrefsTreePanel;
import com.rhinosoft.fvjv.gui.dialogs.CLinkLabel;
import com.rhinosoft.fvjv.gui.dialogs.CSeparator;
import com.rhinosoft.fvjv.gui.dialogs.CSeparatorLink;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;

public class CAboutProgInfoPanel
extends CFVJVPrefsTreePanel {
    public static final String HTML_FMT_BOLD = CFilePanel.HTML_FMT_BOLD;
    private static final String IDS_WWW_RHINOSOFT_COM = "www.RhinoSoft.com";
    private static final String IDS_RHINOSOFT = "RhinoSoft";
    private static final String IDS_ADDRESS1 = "P.O. Box 53";
    private static final String IDS_ADDRESS2 = "Helenville, WI  53137  USA";
    private CLinkLabel m_cSmallLogo;
    private JLabel m_jlblName;
    private JLabel m_jlblVersion1;
    private JLabel m_jlblVersion2;
    private JLabel m_jlblBuildDate1;
    private JLabel m_jlblBuildDate2;
    private Date m_dtBuildDate;
    private CSeparatorLink m_cContactCtrl;
    private JLabel m_cCompanyName;
    private JLabel m_cCompanyAddress1;
    private JLabel m_cCompanyAddress2;
    private CLinkLabel m_cCompanyLink;
    private JLabel m_cResellerCompanyName;
    private JLabel m_cResellerCompanyAddress1;
    private JLabel m_cResellerCompanyAddress2;
    private CLinkLabel m_cResellerLink;
    private CSeparator m_cDevelopmentSep;
    private JLabel m_cDevelopedByTitle;
    private CLinkLabel m_cDevelopedByMsg;
    private JLabel m_cResellerDevelopedByTitle;
    private CLinkLabel m_cResellerDevelopedByMsg;
    private JLabel m_cCopyright;
    private CSeparator m_cUserInterfaceSep;
    private JLabel m_cPoweredByTitle;
    private JLabel m_cCompanyJIDE;
    private static final String URL_JIDESOFT = "http://www.jidesoft.com/";
    private CSeparator m_cLegalSep;
    private JScrollPane m_cLegal;
    private JTextArea m_cLegalEditor;

    public CAboutProgInfoPanel(String sTitle, CMainFrame rMainFrame) {
        super(sTitle, rMainFrame);
        this.SetIcon(CMainFrame.GetJARImage("ProgramInformation.png"));
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        this.m_cSmallLogo = new CLinkLabel(this.GetMainFrame(), "http://FVJV.Serv-U.com/");
        if (this.GetSmallLogoCtrl() != null) {
            this.GetSmallLogoCtrl().setIcon(this.GetMainFrame().GetJarImage("FVJV_36x36.png"));
            this.GetSmallLogoCtrl().setBorder(BorderFactory.createLoweredBevelBorder());
            this.GetSmallLogoCtrl().setOpaque(true);
            this.GetSmallLogoCtrl().setBackground(new Color(255, 255, 255));
        }
        this.m_jlblName = new JLabel();
        this.m_jlblVersion1 = new JLabel();
        this.m_jlblVersion2 = new JLabel();
        this.m_jlblBuildDate1 = new JLabel();
        this.m_jlblBuildDate2 = new JLabel();
        this.m_cContactCtrl = new CSeparatorLink(this.GetMainFrame(), "http://www.RhinoSoft.com/contact.asp?prod=su", CString.LoadString("IDS_CONTACT_INFORMATION"));
        this.m_cCompanyName = new JLabel();
        this.m_cCompanyAddress1 = new JLabel();
        this.m_cCompanyAddress2 = new JLabel();
        this.m_cCompanyLink = new CLinkLabel(this.GetMainFrame(), "http://www.RhinoSoft.com/", IDS_WWW_RHINOSOFT_COM);
        this.m_cResellerCompanyName = new JLabel(CString.LoadString("IDS_RESELLER_COMPANY_NAME"));
        this.m_cResellerCompanyAddress1 = new JLabel(CString.LoadString("IDS_RESELLER_COMPANY_ADDRESS1"));
        this.m_cResellerCompanyAddress2 = new JLabel(CString.LoadString("IDS_RESELLER_COMPANY_ADDRESS2"));
        this.m_cResellerLink = new CLinkLabel(this.GetMainFrame(), CString.LoadString("IDS_RESELLER_COMPANY_URL"), CString.LoadString("IDS_RESELLER_COMPANY_NAME"));
        this.m_cDevelopmentSep = new CSeparator();
        this.m_cDevelopedByTitle = new JLabel();
        this.m_cDevelopedByMsg = new CLinkLabel(this.GetMainFrame(), "http://www.RhinoSoft.com/", IDS_RHINOSOFT);
        this.m_cResellerDevelopedByTitle = new JLabel(CString.LoadString("IDS_RESELLER_TRANSLATEDBY_TITLE"));
        this.m_cResellerDevelopedByMsg = new CLinkLabel(this.GetMainFrame(), CString.LoadString("IDS_RESELLER_TRANSLATEDBY_URL"), CString.LoadString("IDS_RESELLER_TRANSLATEDBY_MSG"));
        this.m_cCopyright = new JLabel();
        this.m_cUserInterfaceSep = new CSeparator();
        this.m_cPoweredByTitle = new JLabel();
        this.m_cCompanyJIDE = new CLinkLabel(this.GetMainFrame(), URL_JIDESOFT, CString.LoadString("IDS_COMPANY_JIDESOFT"));
        this.m_cLegalSep = new CSeparator();
        this.m_cLegalEditor = new JTextArea();
        this.m_cLegal = new JScrollPane(this.m_cLegalEditor);
        this.AddEscapeKeyListener(this.m_cLegalEditor);
        this.m_jlblName.setText("FTP Voyager JV");
        this.m_jlblVersion1.setText(CString.LoadString("IDS_VERSION"));
        this.m_jlblVersion2.setText(String.format("%d.%d.%d.%d", CMainFrame.VERSION_MAJOR_1, CMainFrame.VERSION_MAJOR_2, CMainFrame.VERSION_MINOR_1, CMainFrame.VERSION_MINOR_2));
        Border cMargin = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        this.m_jlblName.setBorder(cMargin);
        this.m_jlblVersion1.setBorder(cMargin);
        this.m_jlblVersion2.setBorder(cMargin);
        this.m_jlblBuildDate1.setBorder(cMargin);
        this.m_jlblBuildDate2.setBorder(cMargin);
        this.m_jlblBuildDate1.setText(CString.LoadString("IDS_BUILD_PANEL_BUILD_DATE"));
        this.SetBuildDate(this.m_dtBuildDate);
        this.m_cCompanyName.setText(IDS_RHINOSOFT);
        this.m_cCompanyAddress1.setText(IDS_ADDRESS1);
        this.m_cCompanyAddress2.setText(IDS_ADDRESS2);
        this.m_cDevelopmentSep.setText(CString.LoadString("IDS_DEVELOPMENT"));
        this.m_cDevelopedByTitle.setText(CString.LoadString("IDS_DEVELOPED_BY"));
        this.m_cUserInterfaceSep.setText(CString.LoadString("IDS_USER_INTERFACE"));
        this.m_cPoweredByTitle.setText(CString.LoadString("IDS_POWERED_BY"));
        GregorianCalendar awtCalendar = new GregorianCalendar();
        int nYear = awtCalendar.get(1);
        String sCopyright = String.format(CString.LoadString("IDS_COPYRIGHT"), nYear);
        this.m_cCopyright.setText(sCopyright);
        this.m_cLegalSep.setText(CString.LoadString("IDS_LEGAL"));
        this.m_cLegal.setVerticalScrollBarPolicy(20);
        this.m_cLegal.setHorizontalScrollBarPolicy(31);
        this.m_cLegal.setPreferredSize(new Dimension(100, 72));
        this.m_cLegalEditor.setEditable(false);
        this.m_cLegalEditor.setText(CString.LoadString("IDS_LEGAL_EXT"));
        this.m_cLegalEditor.setBackground(this.getBackground());
        this.m_cLegalEditor.setMargin(new Insets(1, 2, 0, 1));
        this.m_cLegalEditor.setLineWrap(true);
        this.m_cLegalEditor.setWrapStyleWord(true);
        this.m_cLegalEditor.setCaretPosition(0);
        JLabel[] arComps = new JLabel[]{this.m_jlblName, this.m_jlblVersion1, this.m_jlblVersion2, this.m_jlblBuildDate2};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            JLabel rNext = arComps[nIdx];
            if (rNext == null) continue;
            String sText = String.format(CFilePanel.HTML_FMT_BOLD, rNext.getText());
            rNext.setText(sText);
        }
        JSeparator cSep1 = new JSeparator();
        JPanel cSpacer = new JPanel();
        if (this.GetSmallLogoCtrl() != null) {
            Dimension dimSize = this.GetSmallLogoCtrl().getMinimumSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setMinimumSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getPreferredSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setPreferredSize(dimSize);
            dimSize = this.GetSmallLogoCtrl().getMaximumSize();
            dimSize.height = dimSize.height / 4 * 3;
            cSpacer.setMaximumSize(dimSize);
        }
        this.m_cLegal.setBorder(BorderFactory.createEtchedBorder(1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        int nCompanyCtrlWidth = 150;
        int nDevelopedSize = 100;
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.GetTitleCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addGroup(layout.createParallelGroup().addComponent(this.m_jlblName, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_jlblVersion1, -2, -2, -2).addComponent(this.m_jlblVersion2, -2, -2, -2)))).addGroup(layout.createSequentialGroup().addComponent(cSpacer, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 10, 10).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addComponent(cSep1, -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.m_jlblBuildDate1, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, 15).addComponent(this.m_jlblBuildDate2, -2, -2, Short.MAX_VALUE)))).addComponent(this.GetContactCtrl(), -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyName, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerCompanyName, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyAddress1, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerCompanyAddress1, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyAddress2, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerCompanyAddress2, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cCompanyLink, nCompanyCtrlWidth, nCompanyCtrlWidth, nCompanyCtrlWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 30, 30).addComponent(this.m_cResellerLink, -1, -2, -2)).addComponent(this.m_cDevelopmentSep, -1, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.m_cDevelopedByTitle, nDevelopedSize, nDevelopedSize, nDevelopedSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, 15).addComponent(this.m_cDevelopedByMsg, -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.m_cResellerDevelopedByTitle, nDevelopedSize, nDevelopedSize, nDevelopedSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, 15).addComponent(this.m_cResellerDevelopedByMsg, -1, -2, -2)).addComponent(this.m_cUserInterfaceSep, -1, -2, Short.MAX_VALUE).addComponent(this.m_cCopyright, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_cPoweredByTitle, nDevelopedSize, nDevelopedSize, nDevelopedSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, 15).addComponent(this.m_cCompanyJIDE, -1, -2, -2)).addComponent(this.m_cLegalSep, -1, -2, Short.MAX_VALUE).addComponent(this.m_cLegal, -1, -2, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.GetTitleCtrl(), -1, -2, -2).addGap(10).addGroup(layout.createParallelGroup().addComponent(this.GetHeaderIconCtrl(), -1, -2, -2).addComponent(this.GetHeaderMsgCtrl(), -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.GetSmallLogoCtrl(), -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.m_jlblName, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addGroup(layout.createParallelGroup().addComponent(this.m_jlblVersion1, -1, -2, -2).addComponent(this.m_jlblVersion2, -1, -2, -2)))).addGroup(layout.createParallelGroup().addComponent(cSpacer, -1, -2, -2).addGroup(layout.createSequentialGroup().addComponent(cSep1, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addGroup(layout.createParallelGroup().addComponent(this.m_jlblBuildDate1, -1, -2, -2).addComponent(this.m_jlblBuildDate2, -1, -2, -2)))).addComponent(this.GetContactCtrl(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyName, -1, -2, -2).addComponent(this.m_cResellerCompanyName, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyAddress1, -1, -2, -2).addComponent(this.m_cResellerCompanyAddress1, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyAddress2, -1, -2, -2).addComponent(this.m_cResellerCompanyAddress2, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.m_cCompanyLink, -1, -2, -2).addComponent(this.m_cResellerLink, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 8, 8).addComponent(this.m_cDevelopmentSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.m_cDevelopedByTitle, -1, -2, -2).addComponent(this.m_cDevelopedByMsg, -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.m_cResellerDevelopedByTitle, -1, -2, -2).addComponent(this.m_cResellerDevelopedByMsg, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.m_cCopyright, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 8, 8).addComponent(this.m_cUserInterfaceSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.m_cPoweredByTitle, -1, -2, -2).addComponent(this.m_cCompanyJIDE, -1, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 8, 8).addComponent(this.m_cLegalSep, -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent(this.m_cLegal, -1, -2, Short.MAX_VALUE));
        JLabel[] aResellerCtrls = new JLabel[]{this.m_cResellerCompanyName, this.m_cResellerCompanyAddress1, this.m_cResellerCompanyAddress2, this.m_cResellerLink, this.m_cResellerDevelopedByTitle, this.m_cResellerDevelopedByMsg};
        for (int nIdx = 0; nIdx < aResellerCtrls.length; ++nIdx) {
            String sTxt;
            JLabel rNext = aResellerCtrls[nIdx];
            if (rNext == null || (sTxt = rNext.getText()) != null && !sTxt.isEmpty()) continue;
            rNext.setVisible(false);
        }
        if (this.GetHeaderIconCtrl() != null) {
            this.GetHeaderIconCtrl().setVisible(false);
        }
        if (this.GetHeaderMsgCtrl() != null) {
            this.GetHeaderMsgCtrl().setVisible(false);
        }
    }

    protected CSeparatorLink GetContactCtrl() {
        return this.m_cContactCtrl;
    }

    protected JLabel GetSmallLogoCtrl() {
        return this.m_cSmallLogo;
    }

    @Override
    public void OnHelp() {
        if (this.GetMainFrame() != null) {
            String[] asInfo = new String[]{"Help-Dlg-About-ProgramInfo.htm", "none"};
            CRhinoEvent rEvent = new CRhinoEvent(this.GetMainFrame(), 7000, asInfo);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
        }
    }

    public void SetBuildDate(Date dtBuildDate) {
        String sDate = CString.LoadString("IDS_NOT_AVAILABLE");
        this.m_dtBuildDate = dtBuildDate;
        if (this.m_dtBuildDate != null) {
            sDate = CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetArchive() != null ? CFileTableCellRenderer.FmtDisplayDate(dtBuildDate, CMainFrame.GET_APP().GetArchive(), true) : DateFormat.getInstance().format(this.m_dtBuildDate);
        }
        if (this.m_jlblBuildDate2 != null) {
            this.m_jlblBuildDate2.setText(String.format(CFilePanel.HTML_FMT_BOLD, sDate));
        }
    }
}

