/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.dialogs;

import com.rhinosoft.fvjv.gui.dialogs.CAboutComputerInfoPanel;
import com.rhinosoft.fvjv.gui.dialogs.CAboutProgInfoPanel;
import com.rhinosoft.fvjv.gui.dialogs.CFVJVPrefsDlgMainPanel;
import com.rhinosoft.fvjv.gui.dialogs.CLinkLabel;
import com.rhinosoft.fvjv.gui.dialogs.CRhinoPrefsTreePanel;
import com.rhinosoft.fvjv.gui.dialogs.CTreeCtrlModel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class CAboutDlgMainPanel
extends CFVJVPrefsDlgMainPanel {
    private Date m_dtBuildDate;

    public CAboutDlgMainPanel() {
        this.InitVars();
    }

    private void InitVars() {
    }

    @Override
    protected void InitTreePanels() {
        CMainFrame rMainFrame = this.GetMainFrame();
        if (rMainFrame != null) {
            CAboutProgInfoPanel rPanel = new CAboutProgInfoPanel(CString.LoadString("IDS_PROGRAM_INFO"), rMainFrame);
            rPanel.SetBuildDate(this.m_dtBuildDate);
            this.AddTreePanel(CString.LoadString("IDS_PROGRAM_INFO"), rPanel);
            this.AddTreePanel(CString.LoadString("IDS_COMPUTER_INFO"), new CAboutComputerInfoPanel(CString.LoadString("IDS_COMPUTER_INFO"), rMainFrame));
        }
    }

    protected JLabel CreateLogoCtrl() {
        return new CLinkLabel(this.GetMainFrame(), "http://www.Serv-U.com/");
    }

    @Override
    public void OnCreate() {
        super.OnCreate();
        if (this.GetTreeCtrl() != null) {
            this.GetTreeCtrl().SetShowCellIcons(true);
        }
        if (this.GetOkBtn() != null) {
            this.GetOkBtn().setVisible(false);
        }
        this.SetBtnTxt(this.GetCancelBtn(), CString.LoadString("IDS_CLOSE", false));
        JDialog rDlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        if (rDlg != null) {
            rDlg.getRootPane().setDefaultButton(this.GetCancelBtn());
        }
        if (this.GetMainFrame() != null) {
            this.SetResellerLogo(this.GetMainFrame().GetResellerLogo());
            this.SetLogo(this.GetMainFrame().GetJarImage("RhinoSoft-Logo.png"));
        }
        if (this.GetFooterTitleCtrl() != null) {
            this.GetFooterTitleCtrl().setText(String.format("%s %d.%d.%d.%d", "FTP Voyager JV", CMainFrame.VERSION_MAJOR_1, CMainFrame.VERSION_MAJOR_2, CMainFrame.VERSION_MINOR_1, CMainFrame.VERSION_MINOR_2));
        }
    }

    @Override
    protected String GetStoredTreePath() {
        String sTreePath = null;
        if (this.GetMainFrame() != null && this.GetMainFrame().GetArchive() != null) {
            String sDefault = CTreeCtrlModel.FormatTreePath(CString.LoadString("IDS_PROGRAM_INFO"), "DEFAULT_ROOT");
            sTreePath = this.GetMainFrame().GetArchive().GetValue("StartupNodeAboutDlg", sDefault);
        }
        return sTreePath;
    }

    @Override
    protected void SetStoredTreePath(String sTreePath) {
        if (this.GetMainFrame() != null && this.GetMainFrame().GetArchive() != null) {
            String sDefault = CTreeCtrlModel.FormatTreePath(CString.LoadString("IDS_PROGRAM_INFO"), "DEFAULT_ROOT");
            this.GetMainFrame().GetArchive().SetValue("StartupNodeAboutDlg", sTreePath, sDefault);
        }
    }

    public void SetBuildDate(Date dtBuildDate) {
        CAboutProgInfoPanel rTreePanel;
        this.m_dtBuildDate = dtBuildDate;
        LinkedHashMap<String, CRhinoPrefsTreePanel> aTreePanels = this.GetTreePanels();
        if (aTreePanels != null && (rTreePanel = (CAboutProgInfoPanel)aTreePanels.get(CString.LoadString("IDS_PROGRAM_INFO"))) != null) {
            rTreePanel.SetBuildDate(dtBuildDate);
        }
    }
}

