/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui.components.files.preview;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.components.files.preview.CFilePreviewPane;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.frames.CBaseMainFrame;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CBrowserPanel;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgThumb;
import com.rhinosoft.fvjv.threads.CThreadMsgTransfer;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class CPreviewPane
extends CFilePreviewPane {
    protected static boolean DEBUG = CMainFrame.DEBUG;

    @Override
    protected String GetTextInitializing() {
        return CString.LoadString("IDS_PREVIEW_INITIALIZING");
    }

    @Override
    protected String GetTextThumbGenerating() {
        return CString.LoadString("IDS_PREVIEW_THUMB_GENERATING");
    }

    @Override
    protected String GetTextThumbReceived() {
        return CString.LoadString("IDS_PREVIEW_THUMB_RECEIVED");
    }

    @Override
    protected String GetTextThumbUnavailable() {
        return CString.LoadString("IDS_PREVIEW_THUMB_UNAVAILABLE");
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (rEvent.getID()) {
                case 6009: {
                    Object[] aItems;
                    if (!this.IsEventSource(rEvent.getSource()) || (aItems = (Object[])rEvent.GetEventObj()) == null || aItems.length != 3 || !(aItems[0] instanceof CFile)) break;
                    CFile fFile = (CFile)aItems[0];
                    Integer nThumbWidth = (Integer)aItems[1];
                    Integer nThumbHeight = (Integer)aItems[2];
                    if (fFile == null || nThumbWidth == null || nThumbHeight == null || this.GetFile() == null) break;
                    String sInternalFilePath = this.GetFile().GetPath();
                    String sFilePath = fFile.GetPath();
                    if (sInternalFilePath != null && sFilePath != null && sInternalFilePath.equals(sFilePath)) {
                        this.OnRecvThumb(fFile, nThumbWidth, nThumbHeight);
                        break;
                    }
                    if (!CBaseMainFrame.DEBUG) break;
                    System.out.printf("CFilePreviewPane.processEvent(ON_UPDATE_GUI_FILE_THUMB) - Thread:  %s | Do NOT update thumb b/c we have the wrong file:   %s\r\n", Thread.currentThread().getName(), fFile.GetDisplayName());
                    break;
                }
                case 2115: {
                    this.ShowThumb(true);
                    break;
                }
                case 3021: {
                    if (!this.IsEventSource(rEvent.getSource()) || !(rEvent.GetEventObj() instanceof CThreadMsg)) break;
                    CThreadMsg rThreadMsg = (CThreadMsg)rEvent.GetEventObj();
                    this.OnRecvThreadOpItemDone(rEvent, rThreadMsg);
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    protected void OnRecvThumb(CFile fFile, int nThumbWidth, int nThumbHeight) {
        boolean bHasThumb = false;
        if (fFile != null) {
            ImageIcon icoThumb;
            if (DEBUG_TRACK_THUMBNAILS) {
                System.out.printf("Requested thumbnail: %s (%d x %d)\r\n", fFile.GetPath(), nThumbWidth, nThumbHeight);
            }
            if (fFile.IsThumbSupported(this.GetResolveLinks())) {
                bHasThumb = true;
            }
            if ((icoThumb = fFile.GetIconThumb(nThumbWidth, nThumbHeight)) == null) {
                icoThumb = (ImageIcon)fFile.GetIcon32();
            } else if (DEBUG_TRACK_THUMBNAILS) {
                System.out.printf("Actual thumbnail: (%d x %d)\r\n", icoThumb.getIconWidth(), icoThumb.getIconHeight());
            }
            if (this.GetThumbLabel() != null) {
                this.GetThumbLabel().setIcon(icoThumb);
            }
        }
        if (bHasThumb) {
            this.SetState(4);
        } else {
            this.SetState(2);
        }
    }

    @Override
    public void keyPressed(KeyEvent rEvent) {
        int nKeyCode = rEvent.getKeyCode();
        switch (nKeyCode) {
            case 65: {
                if (!rEvent.isControlDown()) break;
                CRhinoEvent Event2 = new CRhinoEvent(this, 2021);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(Event2);
                rEvent.consume();
                break;
            }
            case 73: {
                if (!rEvent.isControlDown()) break;
                CRhinoEvent Event3 = new CRhinoEvent(this, 2022);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(Event3);
                rEvent.consume();
                break;
            }
        }
    }

    protected void OnRecvThreadOpItemDone(CRhinoEvent rEvent, CThreadMsg rThreadMsg) {
        if (rThreadMsg != null) {
            switch (rThreadMsg.GetMsgID()) {
                case 22: {
                    this.OnRecvThumb(rEvent, rThreadMsg);
                    break;
                }
            }
        }
    }

    private void OnRecvThumb(CRhinoEvent rEvent, CThreadMsg rThreadMsg) {
        CBrowserPanel rPanel = (CBrowserPanel)SwingUtilities.getAncestorOfClass(CBrowserPanel.class, this);
        if (rPanel != null && rPanel.IsEventSource(rEvent.getSource()) && rThreadMsg != null && rThreadMsg instanceof CThreadMsgTransfer) {
            CThreadMsgTransfer rMsg = (CThreadMsgTransfer)rThreadMsg;
            String sPath = null;
            boolean bIsDir = true;
            CPath rFromPath = rMsg.GetFromPath(rMsg.GetPathIndex());
            sPath = rFromPath.GetPath();
            bIsDir = rFromPath.IsDir();
            if (sPath != null && !sPath.isEmpty()) {
                if (DEBUG_TRACK_THUMBNAILS) {
                    System.out.printf("CPreviewPane.OnRecvThumb - Thread:  %s | Event file: %s | UI file: %s\r\n", Thread.currentThread().getName(), rFromPath.GetPath(), this.GetFile() != null ? this.GetFile().GetPath() : "null");
                }
                if (rFromPath.IsLink()) {
                    sPath = rFromPath.GetPrevPath();
                }
                if (rMsg instanceof CThreadMsgThumb) {
                    CThreadMsgThumb rThumbMsg = (CThreadMsgThumb)rMsg;
                    if (this.GetFile() != null && this.GetFile().GetPath() != null && this.GetFile().GetPath().equals(sPath)) {
                        this.GetFile().SetIconThumb(this, rThumbMsg.GetThumbWidth(), rThumbMsg.GetThumbHeight(), rThumbMsg.GetThumbImage(), false);
                        this.OnRecvThumb(this.GetFile(), rThumbMsg.GetThumbWidth(), rThumbMsg.GetThumbHeight());
                    } else if (DEBUG) {
                        CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Preview's UI file doesn't match event's file!", false);
                    }
                }
            }
        }
    }
}

