/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.gui;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.util.Locale;

public class CClientInfo {
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final int DEF_PORT = -1;
    public static final String DEF_USER = "DefaultUser";
    public static final String DEF_LANGUAGE_CODE = "en";
    public static final String DEF_COUNTRY_CODE = "US";
    public static final boolean DEF_SECURE = false;
    public static final boolean DEF_CAN_CHANGE_PASSWORD = false;
    public static final boolean DEF_IS_LOCAL_ADMIN = false;
    public static final boolean DEF_REQUIRE_EMAIL_ADDRESS = false;
    public static final boolean DEF_CAN_SET_EMAIL_ADDRESS = false;
    public static final boolean DEF_CASE_SENSITIVE_OS = true;
    public static final String LOOPBACK_LOCALHOST = "localhost";
    public static final String LOOPBACK_IPv6 = "[::1]";
    public static final String LOOPBACK_IPv6_EXPANDED = "0000:0000:0000:0000:0000:0000:0000:0001";
    public static final String LOOPBACK_IPv4 = "127.0.0.1";
    private String m_sHost;
    private long m_lPort;
    private long m_lHeaderPort;
    private String m_sEncSessionID;
    private String m_sSessionID;
    private String m_sLoginID;
    private String m_sLanguageCode;
    private String m_sCountryCode;
    private String m_sTechSupportURL;
    private boolean m_bIsSecure;
    private boolean m_bCanChangePassword;
    private boolean m_bIsLocalTrayAdmin;
    private String m_sEmailAddress;
    private boolean m_bRequireEmailAddress;
    private boolean m_bUserCanSetEmailAddress;
    private boolean m_bIsCaseSensitiveOS;
    private boolean m_bIsLocalhost = false;

    public CClientInfo() {
        this.InitVars();
    }

    public CClientInfo(CClientInfo rCopyFrom) {
        this.InitVars();
        if (rCopyFrom != null) {
            if (rCopyFrom.GetHost() != null) {
                this.SetHost(new String(rCopyFrom.GetHost()));
            }
            this.m_bIsLocalhost = rCopyFrom.m_bIsLocalhost;
            this.SetPort(rCopyFrom.GetPort());
            this.SetHeaderPort(rCopyFrom.GetHeaderPort());
            if (rCopyFrom.GetEncSessionID() != null) {
                this.SetEncSessionID(new String(rCopyFrom.GetEncSessionID()));
            }
            if (rCopyFrom.GetSessionID() != null) {
                this.SetSessionID(new String(rCopyFrom.GetSessionID()));
            }
            if (rCopyFrom.GetLoginID() != null) {
                this.SetLoginID(new String(rCopyFrom.GetLoginID()));
            }
            if (rCopyFrom.GetLanguageCode() != null) {
                this.SetLanguageCode(new String(rCopyFrom.GetLanguageCode()));
            }
            if (rCopyFrom.GetCountryCode() != null) {
                this.SetCountryCode(new String(rCopyFrom.GetCountryCode()));
            }
            if (rCopyFrom.GetTechSupportURL() != null) {
                this.SetTechSupportURL(new String(rCopyFrom.GetTechSupportURL()));
            }
            this.SetIsSecure(rCopyFrom.IsSecure());
            this.SetCanChangePassword(rCopyFrom.CanChangePassword());
            this.SetIsLocalTrayAdmin(rCopyFrom.IsLocalTrayAdmin());
            this.SetUserEmailAddress(rCopyFrom.GetUserEmailAddress());
            this.SetRequireEmailAddress(rCopyFrom.GetRequireEmailAddress());
            this.SetUserCanSetEmailAddress(rCopyFrom.GetUserCanSetEmailAddress());
            this.SetCaseSensitiveOS(rCopyFrom.IsCaseSensitiveOS());
        }
    }

    private void InitVars() {
        this.m_bIsSecure = false;
        this.m_lPort = -1L;
        this.m_lHeaderPort = -1L;
        this.m_sLoginID = DEF_USER;
        this.m_sLanguageCode = DEF_LANGUAGE_CODE;
        this.m_sCountryCode = DEF_COUNTRY_CODE;
        this.m_bCanChangePassword = false;
        this.m_bIsLocalTrayAdmin = false;
        this.m_bRequireEmailAddress = false;
        this.m_bUserCanSetEmailAddress = false;
        this.m_bIsCaseSensitiveOS = true;
    }

    public boolean SetLanguageCode(String sNewVal) {
        Object[] aItems = new Object[]{false, sNewVal, this.m_sLanguageCode, DEF_LANGUAGE_CODE};
        String sTemp = this.GetValueString(aItems);
        if (sTemp != null && !sTemp.isEmpty()) {
            if (sTemp.toLowerCase().equals("jp")) {
                sTemp = Locale.JAPANESE.getLanguage();
            }
            this.m_sLanguageCode = sTemp;
        }
        return (Boolean)aItems[0];
    }

    public String GetLanguageCode() {
        return this.m_sLanguageCode;
    }

    public boolean SetCountryCode(String sVal) {
        Object[] aItems = new Object[]{false, sVal, this.m_sCountryCode, DEF_COUNTRY_CODE};
        String sTemp = this.GetValueString(aItems);
        if (sTemp != null && !sTemp.isEmpty()) {
            this.m_sCountryCode = sTemp;
        }
        return (Boolean)aItems[0];
    }

    public String GetCountryCode() {
        return this.m_sCountryCode;
    }

    public boolean SetTechSupportURL(String sURL) {
        Object[] aItems = new Object[]{false, sURL, this.m_sTechSupportURL, ""};
        String sTemp = this.GetValueString(aItems);
        if (sTemp != null && !sTemp.isEmpty()) {
            this.m_sTechSupportURL = sTemp;
        }
        return (Boolean)aItems[0];
    }

    public String GetTechSupportURL() {
        return this.m_sTechSupportURL;
    }

    public boolean SetEncSessionID(String sVal) {
        Object[] aItems = new Object[]{false, sVal, this.m_sEncSessionID, ""};
        String sTemp = this.GetValueString(aItems);
        if (sTemp != null && !sTemp.isEmpty()) {
            this.m_sEncSessionID = sTemp;
        }
        return (Boolean)aItems[0];
    }

    public String GetEncSessionID() {
        return this.m_sEncSessionID;
    }

    public boolean SetSessionID(String sVal) {
        Object[] aItems = new Object[]{false, sVal, this.m_sSessionID, ""};
        String sTemp = this.GetValueString(aItems);
        if (sTemp != null && !sTemp.isEmpty()) {
            this.m_sSessionID = sTemp;
        }
        return (Boolean)aItems[0];
    }

    public String GetSessionID() {
        return this.m_sSessionID;
    }

    public boolean SetLoginID(String sVal) {
        Object[] aItems = new Object[]{false, sVal, this.m_sLoginID, DEF_USER};
        String sTemp = this.GetValueString(aItems);
        if (sTemp != null && !sTemp.isEmpty()) {
            this.m_sLoginID = sTemp;
        }
        return (Boolean)aItems[0];
    }

    public String GetLoginID() {
        return this.m_sLoginID;
    }

    public boolean SetIsSecure(boolean bVal) {
        Object[] aItems = new Object[]{false, bVal, this.m_bIsSecure, false};
        Boolean bTemp = this.GetValueBool(aItems);
        if (bTemp != null) {
            this.m_bIsSecure = bTemp;
        }
        return (Boolean)aItems[0];
    }

    public boolean IsSecure() {
        return this.m_bIsSecure;
    }

    public boolean SetHost(String sVal) {
        Object[] aItems = new Object[]{false, sVal, this.m_sHost, ""};
        String sTemp = this.GetValueString(aItems);
        if (sTemp != null && !sTemp.isEmpty()) {
            this.m_sHost = sTemp;
            if (CClientInfo.CheckForLocalhost(this.m_sHost)) {
                this.m_bIsLocalhost = true;
            }
        }
        return (Boolean)aItems[0];
    }

    public boolean IsLocalhost() {
        return this.m_bIsLocalhost;
    }

    public String GetHost() {
        return this.GetHost(false);
    }

    public String GetHost(boolean bRemoveInvalidPathChars) {
        String sRetHost = this.m_sHost;
        if (bRemoveInvalidPathChars) {
            sRetHost = CClientInfo.FormatHostForPath(this.m_sHost);
        }
        return sRetHost;
    }

    public static String FormatHostForPath(String sHost) {
        String sRetHost = sHost;
        if (sHost != null && !sHost.isEmpty()) {
            StringBuilder sCompiledHost = new StringBuilder();
            char[] achExcludedChars = new char[]{':', '*', '?', '\"', '<', '>', '|'};
            for (int nIdx = 0; nIdx < sHost.length(); ++nIdx) {
                char chNext = sHost.charAt(nIdx);
                boolean bIsExcludedChar = false;
                for (int nIdx2 = 0; nIdx2 < achExcludedChars.length; ++nIdx2) {
                    if (chNext != achExcludedChars[nIdx2]) continue;
                    bIsExcludedChar = true;
                    break;
                }
                if (!bIsExcludedChar) {
                    sCompiledHost.append(chNext);
                    continue;
                }
                sCompiledHost.append('_');
            }
            if (sCompiledHost != null && sCompiledHost.length() > 0) {
                sRetHost = sCompiledHost.toString();
            }
        }
        return sRetHost;
    }

    public boolean SetPort(long lVal) {
        Object[] aItems = new Object[]{false, lVal, this.m_lPort, -1};
        Long lTemp = this.GetValueLong(aItems);
        if (lTemp != null) {
            this.m_lPort = lTemp;
        }
        return (Boolean)aItems[0];
    }

    public long GetPort() {
        return this.m_lPort;
    }

    public boolean SetHeaderPort(long lVal) {
        Object[] aItems = new Object[]{false, lVal, this.m_lHeaderPort, -1};
        Long lTemp = this.GetValueLong(aItems);
        if (lTemp != null) {
            this.m_lHeaderPort = lTemp;
        }
        return (Boolean)aItems[0];
    }

    public long GetHeaderPort() {
        return this.m_lHeaderPort;
    }

    public long GetPublicPort() {
        long lPublicPort = this.GetPort();
        if (this.GetPort() != this.GetHeaderPort() && this.GetHeaderPort() > 0L) {
            lPublicPort = this.GetHeaderPort();
        }
        return lPublicPort;
    }

    public boolean SetCanChangePassword(boolean bVal) {
        Object[] aItems = new Object[]{false, bVal, this.m_bCanChangePassword, false};
        Boolean bTemp = this.GetValueBool(aItems);
        if (bTemp != null) {
            this.m_bCanChangePassword = bTemp;
        }
        return (Boolean)aItems[0];
    }

    public boolean CanChangePassword() {
        return this.m_bCanChangePassword;
    }

    public String toString() {
        StringBuilder sbTemp = new StringBuilder();
        sbTemp.append(String.format("ClassName=%s\r\n", this.getClass().getName()));
        sbTemp.append(String.format("\t%s=%s\r\n", "Host", this.GetHost()));
        sbTemp.append(String.format("\t%s=%s\r\n", "Port", Long.toString(this.GetPort())));
        sbTemp.append(String.format("\t%s=%s\r\n", "HeaderPort", Long.toString(this.GetHeaderPort())));
        sbTemp.append(String.format("\t%s=%s\r\n", "EncSessionID", this.GetEncSessionID()));
        sbTemp.append(String.format("\t%s=%s\r\n", "SessionID", this.GetSessionID()));
        sbTemp.append(String.format("\t%s=%s\r\n", "LoginID", this.GetLoginID()));
        sbTemp.append(String.format("\t%s=%s\r\n", "LanguageCode", this.GetLanguageCode()));
        sbTemp.append(String.format("\t%s=%s\r\n", "CountryCode", this.GetCountryCode()));
        sbTemp.append(String.format("\t%s=%s\r\n", "SupportURL", this.GetTechSupportURL()));
        sbTemp.append(String.format("\t%s=%s\r\n", "IsSecure", Boolean.toString(this.IsSecure())));
        sbTemp.append(String.format("\t%s=%s\r\n", "CanChangePassword", Boolean.toString(this.CanChangePassword())));
        sbTemp.append(String.format("\t%s=%s\r\n", "IsLocalAdmin", Boolean.toString(this.IsLocalTrayAdmin())));
        return sbTemp.toString();
    }

    private Object GetValue(Object[] aItems) {
        Object rRet = null;
        if (aItems != null && aItems.length == 4) {
            aItems[0] = false;
            rRet = aItems[3];
            if (aItems[1] != null) {
                if (!aItems[1].equals(aItems[2])) {
                    rRet = aItems[1];
                    aItems[0] = true;
                } else {
                    rRet = aItems[1];
                }
            } else if (!aItems[3].equals(aItems[2])) {
                rRet = aItems[3];
                aItems[0] = true;
            }
        }
        return rRet;
    }

    private Boolean GetValueBool(Object[] aItems) {
        Boolean bRet = false;
        Object rRet = this.GetValue(aItems);
        if (rRet instanceof Boolean) {
            bRet = (Boolean)rRet;
        }
        return bRet;
    }

    private Integer GetValueInt(Object[] aItems) {
        Integer nRet = null;
        Object rRet = this.GetValue(aItems);
        if (rRet instanceof Integer) {
            nRet = (Integer)rRet;
        }
        return nRet;
    }

    private Long GetValueLong(Object[] aItems) {
        Long lRet = null;
        Object rRet = this.GetValue(aItems);
        if (rRet instanceof Long) {
            lRet = (Long)rRet;
        }
        return lRet;
    }

    private String GetValueString(Object[] aItems) {
        String sRet = null;
        Object rRet = this.GetValue(aItems);
        if (rRet instanceof String) {
            sRet = (String)rRet;
        }
        return sRet;
    }

    public Object clone() {
        return new CClientInfo(this);
    }

    public boolean HasMinimumRequirements() {
        boolean bHasMinimumRequirements = true;
        if (this.GetHost() == null || this.GetHost().isEmpty() || this.GetPort() < 0L || this.GetEncSessionID() == null || this.GetEncSessionID().isEmpty() || this.GetLoginID() == null || this.GetLoginID().isEmpty()) {
            bHasMinimumRequirements = false;
        }
        return bHasMinimumRequirements;
    }

    public boolean SetIsLocalTrayAdmin(boolean bVal) {
        Object[] aItems = new Object[]{false, bVal, this.m_bIsLocalTrayAdmin, false};
        Boolean bTemp = this.GetValueBool(aItems);
        if (bTemp != null) {
            this.m_bIsLocalTrayAdmin = bTemp;
        }
        return (Boolean)aItems[0];
    }

    public boolean IsLocalTrayAdmin() {
        return this.m_bIsLocalTrayAdmin;
    }

    public boolean SetPortParsed(String sArg) {
        boolean bChanged;
        block3: {
            bChanged = false;
            if (sArg != null && !sArg.isEmpty()) {
                try {
                    bChanged = this.SetPort(Integer.parseInt(sArg));
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return bChanged;
    }

    public boolean SetLoginIDParsed(String sArg) {
        String sTemp;
        String[] asItems;
        boolean bChanged = false;
        if (sArg != null && !sArg.isEmpty() && (asItems = (sTemp = sArg).split(",")).length == 2 && (sTemp = asItems[1]) != null) {
            sTemp = sTemp.trim();
            bChanged = this.SetLoginID(sTemp);
        }
        return bChanged;
    }

    public boolean SetLangLocaleParsed(String sArg) {
        String sTemp;
        String[] asItems;
        boolean bChanged = false;
        if (sArg != null && !sArg.isEmpty() && (asItems = (sTemp = sArg).split(",")).length == 2) {
            sTemp = asItems[0];
            if (sTemp != null) {
                sTemp = sTemp.trim();
                bChanged = this.SetLanguageCode(sTemp);
            }
            if ((sTemp = asItems[1]) != null) {
                bChanged = this.SetCountryCode(sTemp = sTemp.trim()) && bChanged;
            }
        }
        return bChanged;
    }

    public boolean SetTechSupportURLParsed(String sArg) {
        String sTemp;
        String[] asItems;
        boolean bChanged = false;
        if (sArg != null && !sArg.isEmpty() && (asItems = (sTemp = sArg).split(",")).length == 2 && (sTemp = asItems[1]) != null) {
            sTemp = sTemp.trim();
            bChanged = this.SetTechSupportURL(sTemp);
        }
        return bChanged;
    }

    public boolean SetHeaderURLParsed(String sArg) {
        boolean bChanged = false;
        if (sArg == null || !sArg.isEmpty()) {
            // empty if block
        }
        return bChanged;
    }

    public boolean SetIsSecureParsed(String sArg) {
        boolean bChanged = false;
        if (sArg != null && !sArg.isEmpty()) {
            boolean bIsSecure;
            block4: {
                bIsSecure = false;
                try {
                    int nVal = Integer.parseInt(sArg);
                    if (nVal == 1) {
                        bIsSecure = true;
                    }
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            bChanged = this.SetIsSecure(bIsSecure);
        }
        return bChanged;
    }

    public boolean SetCanChangePasswordParsed(String sArg) {
        boolean bChanged = false;
        if (sArg != null && !sArg.isEmpty()) {
            boolean bCanChangePassword;
            block4: {
                String sTemp = sArg;
                bCanChangePassword = false;
                try {
                    int nVal = Integer.parseInt(sArg);
                    if (nVal == 1) {
                        bCanChangePassword = true;
                    }
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            bChanged = this.SetCanChangePassword(bCanChangePassword);
        }
        return bChanged;
    }

    public boolean SetIsLocalAdminParsed(String sArg) {
        boolean bChanged = false;
        if (sArg != null && !sArg.isEmpty()) {
            boolean bIsLocalTrayAdmin;
            block4: {
                bIsLocalTrayAdmin = false;
                try {
                    int nVal = Integer.parseInt(sArg);
                    if (nVal == 1) {
                        bIsLocalTrayAdmin = true;
                    }
                }
                catch (Exception e) {
                    if (!CMainFrame.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            bChanged = this.SetIsLocalTrayAdmin(bIsLocalTrayAdmin);
        }
        return bChanged;
    }

    public void SetUserEmailAddress(String sEmailAddress) {
        this.m_sEmailAddress = sEmailAddress;
    }

    public final String GetUserEmailAddress() {
        return this.m_sEmailAddress;
    }

    public void SetRequireEmailAddress(boolean bRequireEmailAddress) {
        this.m_bRequireEmailAddress = bRequireEmailAddress;
    }

    public boolean GetRequireEmailAddress() {
        return this.m_bRequireEmailAddress;
    }

    public void SetUserCanSetEmailAddress(boolean bUserCanSetEmailAddress) {
        this.m_bUserCanSetEmailAddress = bUserCanSetEmailAddress;
    }

    public boolean GetUserCanSetEmailAddress() {
        return this.m_bUserCanSetEmailAddress;
    }

    public void SetCaseSensitiveOS(boolean bIsCaseSensitiveOS) {
        this.m_bIsCaseSensitiveOS = bIsCaseSensitiveOS;
    }

    public boolean IsCaseSensitiveOS() {
        return this.m_bIsCaseSensitiveOS;
    }

    public static boolean CheckForLocalhost(String sHost) {
        boolean bIsLocalhost = false;
        if (sHost != null && (sHost = sHost.toLowerCase()).equals(LOOPBACK_LOCALHOST)) {
            bIsLocalhost = true;
        }
        return bIsLocalhost;
    }
}

