/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.files;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgListRemote;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CRemoteFile
extends CFile {
    private boolean m_bUpDirEnabled;
    private boolean m_bIsImage;
    private String m_sAttrs;
    private int m_nDriveType;
    private String m_sDriveLabel;
    private static StringBuilder m_sFileSep;

    public CRemoteFile(String sPath, boolean bIsDir) {
        super(sPath, bIsDir, false);
        this.InitVars();
    }

    public CRemoteFile(CRemoteFile fCopyFrom) {
        super(fCopyFrom);
        this.InitVars();
        if (fCopyFrom != null) {
            if (fCopyFrom.m_sDriveLabel != null) {
                this.m_sDriveLabel = new String(fCopyFrom.m_sDriveLabel);
            }
            if (fCopyFrom.m_sAttrs != null) {
                this.m_sAttrs = new String(fCopyFrom.m_sAttrs);
            }
            this.m_bUpDirEnabled = fCopyFrom.m_bUpDirEnabled;
            this.m_bIsImage = fCopyFrom.m_bIsImage;
            this.m_nDriveType = fCopyFrom.m_nDriveType;
        }
        this.InitDisplayName();
    }

    public static CRemoteFile CreateFile(String sAbsFileName, CRemoteFile fParent) {
        CRemoteFile fFile = new CRemoteFile(sAbsFileName, false);
        fFile.SetParent(fParent);
        return fFile;
    }

    public void UpdateFileInfoFromLocal(CPath LocalFile) {
        this.UpdateFileInfo(CRemoteFile.CreateJavaFile(LocalFile.GetPath()));
    }

    private void InitVars() {
        this.m_bUpDirEnabled = false;
        this.m_bIsImage = false;
        this.m_sAttrs = "";
        this.m_nDriveType = 0;
        this.m_sDriveLabel = "";
    }

    @Override
    public String GetAbsFileName() {
        String sAbsFileName = super.GetAbsFileName();
        sAbsFileName = CString.MakeForwardSlashes(sAbsFileName);
        return sAbsFileName;
    }

    @Override
    public void SetAbsFileName(String sAbsFileName) {
        super.SetAbsFileName(CString.MakeForwardSlashes(sAbsFileName));
    }

    @Override
    protected void InitDisplayName() {
        super.InitDisplayName();
        if (this.IsDrive()) {
            String sDisplayName = this.GetPath();
            sDisplayName = CString.EnsureFirstCharIsNotASlash(sDisplayName);
            sDisplayName = CString.EnsureLastCharIsNotASlash(sDisplayName);
            String sDriveLabel = this.GetDriveLabel();
            if (sDriveLabel != null && !sDriveLabel.isEmpty()) {
                sDriveLabel = CUtils.UrlDecode(sDriveLabel);
                sDisplayName = String.format("%s (%s)", sDriveLabel, this.GetDisplayName());
                this.SetDisplayName(sDisplayName);
            }
        }
    }

    @Override
    public String GetParentPath(boolean bIncludeLastSlash) {
        String sTemp = CString.EnsureNotLastChar(Character.valueOf(this.GetFileSeparatorChar()), this.GetPath());
        String sAbsParentDir = CString.GetFilePath(sTemp, bIncludeLastSlash);
        if (sAbsParentDir.isEmpty()) {
            sAbsParentDir = "/";
        }
        return sAbsParentDir;
    }

    @Override
    public CRemoteFile clone() {
        return new CRemoteFile(this);
    }

    @Override
    public boolean IsThumbSupported(boolean bResolveLinks) {
        return this.IsImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon GetIcon16() {
        Icon rRet = null;
        if (this.IsDrive()) {
            rRet = this.GetDriveIcon(16);
        } else {
            boolean bFoundDrive = false;
            CRemoteFile cRemoteFile = this;
            synchronized (cRemoteFile) {
                Set<String> aKeys = this.GetChildMap().keySet();
                Iterator<String> itr = aKeys.iterator();
                while (itr.hasNext() && !bFoundDrive) {
                    CFile fFile;
                    String sChildPath = itr.next();
                    if (sChildPath == null || sChildPath.isEmpty() || (fFile = this.GetChildMap().get(sChildPath)) == null || !fFile.IsDrive()) continue;
                    bFoundDrive = true;
                }
            }
            rRet = bFoundDrive ? CMainFrame.GetJARImage("Computer.png") : super.GetIcon16();
        }
        return rRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon GetIcon32() {
        Icon rRet = null;
        if (this.IsDrive()) {
            rRet = this.GetDriveIcon(32);
        } else {
            boolean bFoundDrive = false;
            CRemoteFile cRemoteFile = this;
            synchronized (cRemoteFile) {
                Set<String> aKeys = this.GetChildMap().keySet();
                Iterator<String> itr = aKeys.iterator();
                while (itr.hasNext() && !bFoundDrive) {
                    CFile fFile;
                    String sChildPath = itr.next();
                    if (sChildPath == null || sChildPath.isEmpty() || (fFile = this.GetChildMap().get(sChildPath)) == null || !fFile.IsDrive()) continue;
                    bFoundDrive = true;
                }
            }
            rRet = bFoundDrive ? CMainFrame.GetJARImage("Computer.png") : super.GetIcon32();
        }
        return rRet;
    }

    @Override
    public String GetType() {
        String sType = "";
        sType = this.IsDrive() ? this.GetDriveTypeText() : super.GetType(false);
        return sType;
    }

    public String GetDriveTypeText() {
        String sDriveType = "";
        int nDriveType = this.GetDriveType();
        switch (nDriveType) {
            case 1: {
                sDriveType = CString.LoadString("IDS_DRIVE_NO_ROOT_DIR");
                break;
            }
            case 2: {
                sDriveType = CString.LoadString("IDS_DRIVE_REMOVABLE");
                break;
            }
            case 3: {
                sDriveType = CString.LoadString("IDS_DRIVE_FIXED");
                break;
            }
            case 4: {
                sDriveType = CString.LoadString("IDS_DRIVE_REMOTE");
                break;
            }
            case 5: {
                sDriveType = CString.LoadString("IDS_DRIVE_CDROM");
                break;
            }
            case 6: {
                sDriveType = CString.LoadString("IDS_DRIVE_RAMDISK");
                break;
            }
            default: {
                sDriveType = CString.LoadString("IDS_DRIVE_UNKNOWN");
            }
        }
        return sDriveType;
    }

    @Override
    public boolean SetIsDrive(boolean bVal) {
        boolean bIsDirty = super.SetIsDrive(bVal);
        this.InitDisplayName();
        return bIsDirty;
    }

    protected ImageIcon GetDriveIcon(int nSize) {
        return this.GetDriveIcon(nSize, this.GetDriveType());
    }

    protected ImageIcon GetDriveIcon(int nSize, int nType) {
        ImageIcon rRet = null;
        if (CMainFrame.GET_APP() != null) {
            switch (nType) {
                case 2: {
                    if (nSize == 32) {
                        rRet = CMainFrame.GET_APP().GetJarImage("DriveRemovable32.png");
                        break;
                    }
                    rRet = CMainFrame.GET_APP().GetJarImage("DriveRemovable16.png");
                    break;
                }
                case 0: 
                case 1: 
                case 3: {
                    if (nSize == 32) {
                        rRet = CMainFrame.GET_APP().GetJarImage("DriveFixed32.png");
                        break;
                    }
                    rRet = CMainFrame.GET_APP().GetJarImage("DriveFixed16.png");
                    break;
                }
                case 4: {
                    if (nSize == 32) {
                        rRet = CMainFrame.GET_APP().GetJarImage("DriveRemote32.png");
                        break;
                    }
                    rRet = CMainFrame.GET_APP().GetJarImage("DriveRemote16.png");
                    break;
                }
                case 5: {
                    if (nSize == 32) {
                        rRet = CMainFrame.GET_APP().GetJarImage("DriveCDROM32.png");
                        break;
                    }
                    rRet = CMainFrame.GET_APP().GetJarImage("DriveCDROM16.png");
                    break;
                }
                case 6: {
                    if (nSize == 32) {
                        rRet = CMainFrame.GET_APP().GetJarImage("DriveRAMDisk32.png");
                        break;
                    }
                    rRet = CMainFrame.GET_APP().GetJarImage("DriveRAMDisk16.png");
                    break;
                }
                default: {
                    rRet = nSize == 32 ? CMainFrame.GET_APP().GetJarImage("DriveUnknown32.png") : CMainFrame.GET_APP().GetJarImage("DriveUnknown16.png");
                }
            }
        }
        return rRet;
    }

    @Override
    public URL GetPreviewURL(boolean bIsThumb, int nThumbWidth, int nThumbHeight) {
        URL rURL = null;
        if (CMainFrame.GET_APP() != null) {
            rURL = CMainFrame.GET_APP().GetPreviewURL(this.GetPath());
        }
        return rURL;
    }

    @Override
    public char GetFileSeparatorChar() {
        return CRemoteFile.GetFileSeparatorCharStatic();
    }

    @Override
    public String GetFileSeparator() {
        return CRemoteFile.GetFileSeparatorStatic();
    }

    public static char GetFileSeparatorCharStatic() {
        return '/';
    }

    public static String GetFileSeparatorStatic() {
        if (m_sFileSep == null) {
            m_sFileSep = new StringBuilder();
            m_sFileSep.append(CRemoteFile.GetFileSeparatorCharStatic());
        }
        return m_sFileSep.toString();
    }

    @Override
    protected CFile CreateFile(String sAbsPath, boolean bIsDir) {
        return new CRemoteFile(sAbsPath, bIsDir);
    }

    @Override
    protected boolean UpdateParentData(CPath rUpdateFrom) {
        boolean bUpdated = super.UpdateParentData(rUpdateFrom);
        if (rUpdateFrom instanceof CRemoteFile) {
            CRemoteFile fFrom = (CRemoteFile)rUpdateFrom;
            if (this.SetUpDirEnabled(fFrom.IsUpDirEnabled())) {
                bUpdated = true;
            }
            if (this.SetDriveType(fFrom.GetDriveType())) {
                bUpdated = true;
            }
            if (this.SetDriveLabel(fFrom.GetDriveLabel())) {
                bUpdated = true;
            }
        }
        return bUpdated;
    }

    @Override
    protected boolean UpdateData(CPath rUpdateFrom) {
        boolean bUpdated = super.UpdateData(rUpdateFrom);
        if (rUpdateFrom instanceof CRemoteFile) {
            CRemoteFile fFrom = (CRemoteFile)rUpdateFrom;
            if (this.SetUpDirEnabled(fFrom.IsUpDirEnabled())) {
                bUpdated = true;
            }
            if (this.SetIsImage(fFrom.IsImage())) {
                bUpdated = true;
            }
            if (this.SetAttrs(fFrom.GetAttrs())) {
                bUpdated = true;
            }
            if (this.SetDriveType(fFrom.GetDriveType())) {
                bUpdated = true;
            }
            if (this.SetDriveLabel(fFrom.GetDriveLabel())) {
                bUpdated = true;
            }
        }
        return bUpdated;
    }

    @Override
    public boolean IsUpDirEnabled() {
        CRemoteFile fRoot;
        boolean bEnabled = true;
        if (CMainFrame.GET_APP() != null && (fRoot = CMainFrame.GET_APP().GetRemoteRoot()) != null && fRoot.GetPath() != null && fRoot.GetPath().equals(this.GetPath())) {
            bEnabled = false;
        }
        return bEnabled;
    }

    public boolean SetUpDirEnabled(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bUpDirEnabled != bVal) {
            this.m_bUpDirEnabled = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsImage() {
        return this.m_bIsImage;
    }

    public boolean SetIsImage(boolean bVal) {
        boolean bChanged = false;
        if (this.m_bIsImage != bVal) {
            this.m_bIsImage = bVal;
            bChanged = true;
        }
        return bChanged;
    }

    public String GetAttrs() {
        return this.m_sAttrs;
    }

    public boolean SetAttrs(String sAttrs) {
        boolean bChanged = false;
        if (this.m_sAttrs != null && !this.m_sAttrs.equals(sAttrs)) {
            this.m_sAttrs = sAttrs;
            bChanged = true;
        } else {
            this.m_sAttrs = sAttrs;
        }
        return bChanged;
    }

    public int GetDriveType() {
        return this.m_nDriveType;
    }

    public boolean SetDriveType(int nDriveType) {
        boolean bChanged = false;
        if (this.m_nDriveType != nDriveType) {
            this.m_nDriveType = nDriveType;
            bChanged = true;
        }
        return bChanged;
    }

    public String GetDriveLabel() {
        return this.m_sDriveLabel;
    }

    public boolean SetDriveLabel(String sDriveLabel) {
        boolean bChanged = false;
        if (this.m_sDriveLabel != null && !this.m_sDriveLabel.equals(sDriveLabel)) {
            this.m_sDriveLabel = sDriveLabel;
            bChanged = true;
        } else {
            this.m_sDriveLabel = sDriveLabel;
        }
        this.InitDisplayName();
        return bChanged;
    }

    @Override
    public boolean AddChildFile(CFile fChild, boolean bFireGUIEvent, boolean bSendEvent) {
        boolean bChildIsDrive = false;
        String sAbsChildPath = fChild.GetPath();
        if ((sAbsChildPath = CString.EnsureLastCharIsNotASlash(sAbsChildPath)) != null && sAbsChildPath.endsWith(":")) {
            bChildIsDrive = true;
        }
        if (bChildIsDrive) {
            fChild.SetIsDrive(bChildIsDrive);
        }
        return super.AddChildFile(fChild, bFireGUIEvent, bSendEvent);
    }

    @Override
    protected CThreadMsgList CreateListMsg(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        return new CThreadMsgListRemote(tThread, 5, rSource, rClientInfo, nCompressionType);
    }

    @Override
    public void CreateNewFolder(CBaseThread rtThread, Object objSource, boolean bWhenDoneEnterRename) {
        String sAbsNewFolder;
        String sAbsFileName;
        String sNewFolderName = this.GetNewFolderName();
        String sAbsNewDir = sAbsFileName = this.GetAbsFileName();
        sAbsNewDir = CString.EnsureLastCharIsAForwardSlash(sAbsNewDir);
        sAbsNewDir = sAbsNewDir + sNewFolderName;
        if (CMainFrame.GET_APP() != null && (sAbsNewFolder = CMainFrame.GET_APP().LaunchCreateDirDlg(sAbsNewDir)) != null && !sAbsNewFolder.isEmpty() && rtThread != null) {
            CPath[] arCreateDirs = new CPath[]{new CPath(sAbsNewFolder, true, false)};
            rtThread.PostCreateDirs(objSource, this.GetClientInfo(), this.GetCompressionType(), arCreateDirs, bWhenDoneEnterRename);
        }
    }

    @Override
    protected void OpenFile(String sOpenPath) {
        if (DEBUG) {
            System.out.println("CRemoteFile.OpenFile was called...this should never get called.");
        }
    }

    @Override
    public boolean IsTreeRoot() {
        boolean bIsTreeRoot = false;
        if (CMainFrame.GET_APP() != null) {
            if (CMainFrame.GET_APP().GetRemoteRoot() == this) {
                bIsTreeRoot = true;
            } else {
                CRemoteFile fTreeRoot = CMainFrame.GET_APP().GetRemoteRoot();
                if (fTreeRoot != null && fTreeRoot.GetPath() != null && fTreeRoot.GetPath().equals(this.GetPath())) {
                    bIsTreeRoot = true;
                }
            }
        }
        return bIsTreeRoot;
    }

    @Override
    public boolean IsARoot() {
        boolean bIsARoot = false;
        if (this.IsTreeRoot() || this.GetPath() != null && this.GetPath().equals("~")) {
            bIsARoot = true;
        }
        return bIsARoot;
    }
}

