/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.fvjv.files;

import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.files.WindowsLink.CWindowsLink;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgList;
import com.rhinosoft.fvjv.threads.CThreadMsgRename;
import com.rhinosoft.fvjv.threads.local.CThreadMsgListLocal;
import java.awt.Desktop;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;

public class CLocalFile
extends CFile {
    public static final boolean DEBUG_TRACK_OPEN;
    private File m_fFile;
    private boolean m_bIsComputer = false;

    public CLocalFile(File fJavaFile) {
        super(fJavaFile.getAbsolutePath(), fJavaFile.isDirectory(), true);
        this.SetJavaFile(fJavaFile);
    }

    private CLocalFile(CLocalFile fCopyFrom) {
        super(fCopyFrom);
        this.m_fFile = CLocalFile.CreateJavaFile(fCopyFrom.m_fFile.getAbsolutePath());
    }

    public static CLocalFile CreateFile(String sAbsFileName) {
        return CLocalFile.CreateFile(CLocalFile.CreateJavaFile(sAbsFileName));
    }

    public static CLocalFile CreateFile(File fJavaFile) {
        CLocalFile fFile = new CLocalFile(fJavaFile);
        if (fFile != null) {
            fFile.InitDisplayName();
        }
        return fFile;
    }

    private void SetJavaFile(File fJavaFile) {
        this.m_fFile = fJavaFile;
        if (this.m_fFile != null) {
            this.UpdateFileInfo(this.m_fFile);
            this.InitDisplayName();
        }
    }

    @Override
    public String GetAbsFileName() {
        String sAbsFileName = super.GetAbsFileName();
        sAbsFileName = CString.MakeBackSlashes(sAbsFileName);
        sAbsFileName = sAbsFileName.replace('\\', File.separatorChar);
        return sAbsFileName;
    }

    @Override
    protected void InitDisplayName() {
        String sLnk;
        String sTemp;
        String sDisplayName;
        block6: {
            super.InitDisplayName();
            sDisplayName = super.GetDisplayName();
            if (this.m_fFile != null) {
                FileSystemView fileSysView;
                File fTemp = this.m_fFile;
                if (CFileSystemUtils.GetFileSysUtils() != null) {
                    fTemp = CFileSystemUtils.GetFileSysUtils().GetJavaFile(this.m_fFile.getAbsolutePath());
                }
                if ((fileSysView = FileSystemView.getFileSystemView()) != null) {
                    try {
                        sDisplayName = fileSysView.getSystemDisplayName(fTemp);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block6;
                        CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Failed to get display name.", false);
                    }
                }
            }
        }
        if (sDisplayName != null && this.m_fFile != null && CPath.IsWindowsLink(this.m_fFile.getAbsolutePath()) && (sTemp = sDisplayName.toLowerCase()).endsWith(sLnk = ".lnk")) {
            sDisplayName = sDisplayName.substring(0, sDisplayName.length() - sLnk.length());
        }
        this.SetDisplayName(sDisplayName);
    }

    @Override
    public Object GetSource() {
        return this.m_fFile;
    }

    @Override
    public Vector CloneFileList(boolean bGetUpToDateFileList) {
        if (bGetUpToDateFileList) {
            this.LoadFileList();
        }
        return super.CloneFileList(bGetUpToDateFileList);
    }

    public void LoadFileList() {
        super.RemoveAllChildFiles(false, true);
        File[] Files = this.m_fFile.listFiles();
        if (Files != null) {
            for (int nIdx = 0; nIdx < Files.length; ++nIdx) {
                File fNextFile = Files[nIdx];
                CLocalFile fNewFile = new CLocalFile(fNextFile);
                super.AddChildFile(fNewFile, true, false);
            }
        }
    }

    @Override
    public String GetParentPath(boolean bIncludeLastSlash) {
        String sAbsParentPath = null;
        File fParentJavaFile = this.m_fFile.getParentFile();
        if (fParentJavaFile != null) {
            sAbsParentPath = fParentJavaFile.getAbsolutePath();
            sAbsParentPath = bIncludeLastSlash ? CString.EnsureLastCharIsAFileSeparator(sAbsParentPath) : CString.EnsureLastCharIsNotASlash(sAbsParentPath);
        }
        return sAbsParentPath;
    }

    @Override
    public boolean IsUpDirEnabled() {
        CLocalFile fRoot;
        boolean bEnabled = true;
        if (CMainFrame.GET_APP() != null && (fRoot = CMainFrame.GET_APP().GetLocalRoot()) != null && fRoot.GetPath() != null && fRoot.GetPath().equals(this.GetPath())) {
            bEnabled = false;
        }
        return bEnabled;
    }

    @Override
    public CLocalFile clone() {
        CLocalFile LocalFile = new CLocalFile(this);
        LocalFile.SetDisplayName(this.GetDisplayName());
        return LocalFile;
    }

    @Override
    public boolean IsThumbSupported(boolean bResolveLinks) {
        File fLinkTarget;
        boolean bIsSupported = false;
        CPath rPath = this;
        if (bResolveLinks && this.IsLink() && (fLinkTarget = this.GetLinkTarget()) != null && fLinkTarget.exists()) {
            rPath = new CPath(fLinkTarget.getAbsolutePath(), fLinkTarget.isDirectory(), true);
        }
        if (CFileSystemUtils.GetFileSysUtils() != null) {
            bIsSupported = CFileSystemUtils.GetFileSysUtils().IsThumbSupported(rPath);
        }
        return bIsSupported;
    }

    private File GetFile() {
        return this.m_fFile;
    }

    @Override
    public String GetType() {
        return super.GetType(true);
    }

    public static CLocalFile GetLocalRoot(boolean bLoadImages) {
        File[] afShellRoots;
        CFileSystemUtils fsu = CFileSystemUtils.GetFileSysUtils();
        FileSystemView fsv = FileSystemView.getFileSystemView();
        CLocalFile fLocalRoot = null;
        File fRoot = null;
        File[] afRoots = fsv.getRoots();
        if (afRoots != null && afRoots.length > 0) {
            fRoot = afRoots[0];
            fLocalRoot = new CLocalFile(fRoot);
            fLocalRoot.SetDisplayName(fsv.getSystemDisplayName(fRoot));
            if (bLoadImages) {
                fLocalRoot.SetIcon16(CFileSystemUtils.GetImage16(fRoot));
                fLocalRoot.SetIcon32(CFileSystemUtils.GetImage32(fRoot));
            }
        }
        if ((afShellRoots = fsu.GetRoots()) != null) {
            File fDesktop = null;
            File fComputer = null;
            for (int nIdx = 0; nIdx < afShellRoots.length; ++nIdx) {
                CLocalFile fNew;
                String sNextPath;
                File fNext = afShellRoots[nIdx];
                if (fNext == null || (sNextPath = fNext.getAbsolutePath()) == null || sNextPath.isEmpty()) continue;
                if (sNextPath.equals(fRoot.getAbsolutePath())) {
                    fDesktop = fNext;
                    fLocalRoot = new CLocalFile(fDesktop);
                    fLocalRoot.SetDisplayName(fsv.getSystemDisplayName(fDesktop));
                    if (!bLoadImages) continue;
                    fLocalRoot.SetIcon16(CFileSystemUtils.GetImage16(fDesktop));
                    fLocalRoot.SetIcon32(CFileSystemUtils.GetImage32(fDesktop));
                    continue;
                }
                if (sNextPath.endsWith("::{20D04FE0-3AEA-1069-A2D8-08002B30309D}")) {
                    fComputer = fNext;
                    if (fLocalRoot == null) continue;
                    fNew = new CLocalFile(fComputer);
                    fNew.SetDisplayName(fsv.getSystemDisplayName(fComputer));
                    fNew.SetIsComputer(true);
                    fLocalRoot.AddChildFile(fNew, true, false);
                    if (!bLoadImages) continue;
                    fNew.SetIcon16(CFileSystemUtils.GetImage16(fComputer));
                    fNew.SetIcon32(CFileSystemUtils.GetImage32(fComputer));
                    continue;
                }
                if (fsv.isDrive(fNext)) {
                    String sFindFile;
                    CFile fLocalComputer;
                    if (fComputer == null || (fLocalComputer = fLocalRoot.GetChildFile(sFindFile = CString.EnsureLastCharIsAFileSeparator(fComputer.getAbsolutePath()))) == null) continue;
                    CLocalFile fNew2 = new CLocalFile(fNext);
                    fNew2.SetDisplayName(fsv.getSystemDisplayName(fNext));
                    fLocalComputer.AddChildFile(fNew2, true, false);
                    if (!bLoadImages) continue;
                    fNew2.SetIcon16(CFileSystemUtils.GetImage16(fNext));
                    fNew2.SetIcon32(CFileSystemUtils.GetImage32(fNext));
                    continue;
                }
                if (fLocalRoot == null) continue;
                fNew = new CLocalFile(fNext);
                fNew.SetDisplayName(fsv.getSystemDisplayName(fNext));
                fLocalRoot.AddChildFile(fNew, true, false);
                if (!bLoadImages) continue;
                fNew.SetIcon16(CFileSystemUtils.GetImage16(fNext));
                fNew.SetIcon32(CFileSystemUtils.GetImage32(fNext));
            }
        }
        return fLocalRoot;
    }

    @Override
    public URL GetPreviewURL(boolean bIsThumb, int nThumbWidth, int nThumbHeight) {
        URL rURL;
        block3: {
            rURL = null;
            if (this.GetFile() != null) {
                try {
                    rURL = this.GetFile().toURI().toURL();
                }
                catch (MalformedURLException mue) {
                    if (!DEBUG) break block3;
                    mue.printStackTrace();
                }
            }
        }
        return rURL;
    }

    @Override
    public char GetFileSeparatorChar() {
        return CLocalFile.GetFileSeparatorCharStatic();
    }

    @Override
    public String GetFileSeparator() {
        return CLocalFile.GetFileSeparatorStatic();
    }

    public static char GetFileSeparatorCharStatic() {
        return File.separatorChar;
    }

    public static String GetFileSeparatorStatic() {
        return File.separator;
    }

    @Override
    protected CFile CreateFile(String sAbsPath, boolean bIsDir) {
        return new CLocalFile(new File(sAbsPath));
    }

    @Override
    protected boolean UpdateData(CPath rUpdateFrom) {
        boolean bUpdated = super.UpdateData(rUpdateFrom);
        if (rUpdateFrom instanceof CLocalFile) {
            CLocalFile fFrom = (CLocalFile)rUpdateFrom;
            if (this.m_fFile.getPath() != null && fFrom.GetFile().getPath() != null && this.m_fFile.getPath().equals(fFrom.GetFile().getPath())) {
                this.m_fFile = fFrom.GetFile();
                bUpdated = true;
            }
        }
        return bUpdated;
    }

    @Override
    public boolean IsDirectory() {
        File fLinkTarget;
        boolean bIsDir = super.IsDirectory();
        if (!bIsDir && (fLinkTarget = this.GetLinkTarget()) != null && fLinkTarget.exists()) {
            bIsDir = fLinkTarget.isDirectory();
        }
        return bIsDir;
    }

    public File GetLinkTarget() {
        CWindowsLink link;
        String sResolvedPath;
        File fTargetFile = null;
        if (this.IsLink() && CLocalFile.IsWindowsLink(this.GetPath()) && (sResolvedPath = (link = new CWindowsLink(this.GetFile().getAbsolutePath())).GetResolvedPath()) != null && !sResolvedPath.isEmpty()) {
            fTargetFile = new File(sResolvedPath);
        }
        return fTargetFile;
    }

    public boolean IsComputer() {
        return this.m_bIsComputer;
    }

    public void SetIsComputer(boolean bIsComputer) {
        this.m_bIsComputer = bIsComputer;
    }

    @Override
    protected int GetMaxTreeDepth(String sAbsPath, String sFileSep) {
        int nMaxDepth = super.GetMaxTreeDepth(sAbsPath, sFileSep);
        if (CMainFrame.GET_APP() != null && CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsWindows()) {
            nMaxDepth += this.GetTreeDriveDepth();
        }
        return nMaxDepth;
    }

    private int GetTreeDriveDepth() {
        int nMaxDepth = 0;
        if (CMainFrame.GET_APP() != null) {
            CLocalFile fRoot = CMainFrame.GET_APP().GetLocalRoot();
            nMaxDepth = this.GetTreeDriveDepth(fRoot, 0);
        }
        return nMaxDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int GetTreeDriveDepth(CFile fParent, int nCurDepth) {
        int nMaxDepth = 0;
        if (fParent != null) {
            if (fParent.IsDrive()) {
                nMaxDepth = nCurDepth;
            } else if (fParent instanceof CLocalFile) {
                CLocalFile fParentEx;
                CLocalFile cLocalFile = fParentEx = (CLocalFile)fParent;
                synchronized (cLocalFile) {
                    if (fParentEx.GetChildMap() != null) {
                        Set<String> aKeys = fParentEx.GetChildMap().keySet();
                        Iterator<String> itr = aKeys.iterator();
                        while (itr.hasNext() && nMaxDepth < 1) {
                            String sPath = itr.next();
                            if (sPath == null || sPath.isEmpty()) continue;
                            CFile fChild = fParentEx.GetChildMap().get(sPath);
                            nMaxDepth = this.GetTreeDriveDepth(fChild, nCurDepth + 1);
                        }
                    }
                }
            }
        }
        return nMaxDepth;
    }

    @Override
    protected CThreadMsgList CreateListMsg(Thread tThread, Object rSource, CClientInfo rClientInfo, int nCompressionType) {
        return new CThreadMsgListLocal(tThread, 5, rSource, rClientInfo, nCompressionType);
    }

    @Override
    public void CreateNewFolder(CBaseThread rtThread, Object objSource, boolean bWhenDoneEnterRename) {
        String sAbsNewFolder;
        String sAbsFileName;
        String sNewFolderName = this.GetNewFolderName();
        String sAbsNewDir = sAbsFileName = this.GetAbsFileName();
        sAbsNewDir = CString.EnsureLastCharIsAFileSeparator(sAbsNewDir);
        sAbsNewDir = sAbsNewDir + sNewFolderName;
        if (CMainFrame.GET_APP() != null && (sAbsNewFolder = CMainFrame.GET_APP().LaunchCreateDirDlg(sAbsNewDir)) != null && !sAbsNewFolder.isEmpty() && rtThread != null) {
            CPath[] arCreateDirs = new CPath[]{new CPath(sAbsNewFolder, true, true)};
            rtThread.PostCreateDirs(objSource, this.GetClientInfo(), this.GetCompressionType(), arCreateDirs, bWhenDoneEnterRename);
        }
    }

    @Override
    public void Rename(String sToPath, boolean bUpdateUI, boolean bSendError) {
        File fPrevFile = this.GetFile();
        this.m_fFile = new File(sToPath);
        this.InitDisplayName();
        if (this.SetPath(sToPath)) {
            CFile fParent = this.GetParent();
            if (fParent == null && CMainFrame.GET_APP() != null) {
                fParent = this.IsLocal() ? CMainFrame.GET_APP().GetLocalRoot() : CMainFrame.GET_APP().GetRemoteRoot();
            }
            if (bUpdateUI) {
                if (bSendError) {
                    this.OnUpdateGUI(fParent, 6007, this);
                } else {
                    this.OnUpdateGUI(fParent, 6006, this);
                }
            }
        } else {
            this.SetJavaFile(fPrevFile);
        }
    }

    @Override
    protected void OpenFile(String sOpenPath) {
        CLocalFile fOpenLink;
        CWindowsLink link;
        String sResolvedPath;
        CLocalFile fOpenFile = CLocalFile.CreateFile(sOpenPath);
        String sTemp = fOpenFile.GetPath();
        if ((sTemp = sTemp.toUpperCase()).endsWith(".LNK") && (sResolvedPath = (link = new CWindowsLink(fOpenFile.GetFile().getAbsolutePath())).GetResolvedPath()) != null && !sResolvedPath.isEmpty() && (fOpenLink = CLocalFile.CreateFile(sResolvedPath)) != null) {
            if (!fOpenLink.IsDir()) {
                fOpenFile = fOpenLink;
            } else if (DEBUG) {
                System.out.println("Failed to open a shortcut that is pointing to a directory.");
            }
        }
        if (fOpenFile != null) {
            boolean bDesktopWorked;
            boolean bShowOpenError;
            String sAbsPath;
            block20: {
                sAbsPath = fOpenFile.GetPath();
                sAbsPath = CString.MakeBackSlashes(sAbsPath);
                sAbsPath = sAbsPath.replace('\\', File.separatorChar);
                bShowOpenError = false;
                bDesktopWorked = false;
                try {
                    if (Desktop.isDesktopSupported()) {
                        if (DEBUG_TRACK_OPEN) {
                            System.out.println("Desktop.getDesktop --> pre-call");
                        }
                        Desktop.getDesktop().open(new File(sAbsPath));
                        bDesktopWorked = true;
                        if (DEBUG_TRACK_OPEN) {
                            System.out.println("Desktop.getDesktop --> post-call");
                        }
                    } else if (DEBUG_TRACK_OPEN) {
                        System.out.println("Desktop.isDesktopSupported = FALSE");
                    }
                }
                catch (Exception e) {
                    if (!DEBUG_TRACK_OPEN) break block20;
                    System.out.printf("CLocalFile.OpenFile | JDesktop.open failed | %s", e.getMessage());
                }
            }
            if (!bDesktopWorked) {
                if (CFileSystemUtils.GetFileSysUtils() != null && CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                    try {
                        String sCmnd = String.format("rundll32 url.dll, FileProtocolHandler \"%s\"", sAbsPath);
                        if (DEBUG_TRACK_OPEN) {
                            System.out.printf("CLocalFile.OpenFile | getRuntime().exec(%s)", sCmnd);
                        }
                        Runtime.getRuntime().exec(sCmnd);
                    }
                    catch (Exception e) {
                        bShowOpenError = true;
                        if (DEBUG_TRACK_OPEN) {
                            System.out.printf("CLocalFile.OpenFile | rundll failed | %s", e.getMessage());
                        }
                    }
                } else {
                    bShowOpenError = true;
                }
            }
            if (bShowOpenError && CMainFrame.GET_APP() != null) {
                CRhinoEvent rEvent = new CRhinoEvent(this, 9145, sOpenPath);
                CMainFrame.GET_APP().dispatchEvent(rEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void OnUpdateChildPath(CFile rParent, CFile rChildFile) {
        if (rParent != null && rChildFile != null) {
            String sNewParentPath = rParent.GetPath();
            String sPrevParentPath = rChildFile.GetParentPath(true);
            String sPath = rChildFile.GetPath();
            String sNewPath = sNewParentPath;
            sNewPath = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sNewPath);
            String sTemp = CString.MakeForwardSlashes(sPath);
            sTemp = CString.EnsureNotLastChar(Character.valueOf('/'), sTemp);
            String sFileName = CString.GetFileName(sTemp);
            sNewPath = sNewPath + sFileName;
            if (rChildFile.IsDir()) {
                sNewPath = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), sNewPath);
            }
            this.m_fFile = new File(sNewPath);
            rChildFile.SetPath(this.m_fFile.getAbsolutePath());
            rChildFile.SetParent(rParent);
            this.OnUpdateGUI(rParent, 6006, rChildFile);
            if (rChildFile.IsDir() && rChildFile instanceof CLocalFile) {
                CLocalFile rLocalChild;
                CLocalFile cLocalFile = rLocalChild = (CLocalFile)rChildFile;
                synchronized (cLocalFile) {
                    Set<String> aKeys = rLocalChild.GetChildMap().keySet();
                    for (String sChildPath : aKeys) {
                        if (sChildPath == null || sChildPath.isEmpty()) continue;
                        CFile rNextChild = rLocalChild.GetChildMap().get(sChildPath);
                        this.OnUpdateChildPath(rChildFile, rNextChild);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void OnRecvRename(CThreadMsg rThreadMsg) {
        CThreadMsgRename rMsg;
        CPath rDestinationPath;
        CFile fUpdate;
        this.SetIcon16(null);
        this.SetIcon32(null);
        this.GetIcon16();
        this.GetIcon32();
        if (rThreadMsg instanceof CThreadMsgRename && (fUpdate = this.FindFile((rDestinationPath = (rMsg = (CThreadMsgRename)rThreadMsg).GetToPath(rMsg.GetPathIndex())).GetPath(), rDestinationPath.IsDir())) != null && fUpdate instanceof CLocalFile) {
            CLocalFile fLocal = (CLocalFile)fUpdate;
            fLocal.UpdateFileInfo(fLocal.m_fFile);
            CLocalFile cLocalFile = fLocal;
            synchronized (cLocalFile) {
                Set<String> aKeys = fLocal.GetChildMap().keySet();
                for (String sChildPath : aKeys) {
                    if (sChildPath == null || sChildPath.isEmpty()) continue;
                    CFile fChild = fLocal.GetChildMap().get(sChildPath);
                    this.OnUpdateChildPath(fLocal, fChild);
                }
            }
            this.OnUpdateGUI(fLocal.GetParent(), 6006, this);
        }
        super.OnRecvRename(rThreadMsg);
    }

    @Override
    public boolean IsTreeRoot() {
        boolean bIsTreeRoot = false;
        if (CMainFrame.GET_APP() != null && this == CMainFrame.GET_APP().GetLocalRoot()) {
            bIsTreeRoot = true;
        }
        return bIsTreeRoot;
    }

    @Override
    public boolean IsARoot() {
        boolean bIsARoot = false;
        if (this.IsTreeRoot() || this.IsComputer()) {
            bIsARoot = true;
        }
        if (!bIsARoot && CFileSystemUtils.GetFileSysUtils() != null) {
            String sPath = this.GetPath();
            sPath = CString.EnsureLastCharIsNotASlash(sPath);
            if (CFileSystemUtils.GetFileSysUtils().IsRoot(sPath)) {
                bIsARoot = true;
            }
        }
        return bIsARoot;
    }

    @Override
    protected String FormatRenamePath(CPath rPath, String sNewName) {
        String sExt;
        boolean bIsWindowsLink = false;
        if (this.IsLink()) {
            bIsWindowsLink = CLocalFile.IsWindowsLink(rPath.GetPath());
        }
        CPath rTemp = rPath.clone();
        if (bIsWindowsLink) {
            rTemp.SetIsDir(false);
        }
        String sRenameTo = super.FormatRenamePath(rTemp, sNewName);
        if (rPath != null && sRenameTo != null && bIsWindowsLink && (sExt = CString.GetFileExtension(rPath.GetPath(), false, true)) != null && !sExt.isEmpty()) {
            sRenameTo = sRenameTo + sExt;
        }
        return sRenameTo;
    }

    @Override
    public CPath CreatePath(boolean bResolveLinks) {
        File fTarget;
        CWindowsLink link;
        String sPath;
        CPath rPath = null;
        if (bResolveLinks && this.IsLink() && CLocalFile.IsWindowsLink(this.GetPath()) && (sPath = (link = new CWindowsLink(this.GetPath())).GetResolvedPath()) != null && !sPath.isEmpty() && (fTarget = new File(sPath)) != null) {
            rPath = new CPath(this.GetPath(), fTarget.isDirectory(), true);
            rPath.SetPath(fTarget.getAbsolutePath());
            rPath.SetSize(fTarget.length());
            rPath.SetIsReadOnly(!fTarget.canWrite());
            rPath.SetLastModified(fTarget.lastModified());
            rPath.SetIsLink(true);
        }
        if (rPath == null) {
            rPath = super.CreatePath(bResolveLinks);
        }
        return rPath;
    }

    @Override
    public boolean IsRenameAllowed() {
        boolean bIsRenameAllowed = true;
        if (this.IsARoot()) {
            bIsRenameAllowed = false;
        }
        if (this.IsDrive()) {
            bIsRenameAllowed = false;
        }
        return bIsRenameAllowed;
    }

    public long GetSize(boolean bResolveLinks) {
        File fTarget;
        long lSize = this.GetSize();
        if (bResolveLinks && this.IsLink() && (fTarget = this.GetLinkTarget()) != null && fTarget.exists()) {
            lSize = fTarget.length();
        }
        return lSize;
    }

    public Date GetModifiedDate(boolean bResolveLinks) {
        return new Date(this.GetLastModified(bResolveLinks));
    }

    public long GetLastModified(boolean bResolveLinks) {
        File fTarget;
        long lLastModified = super.GetLastModified();
        if (bResolveLinks && this.IsLink() && (fTarget = this.GetLinkTarget()) != null && fTarget.exists()) {
            lLastModified = fTarget.lastModified();
        }
        return lLastModified;
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_OPEN = false;
    }
}

