/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.rhinosoft.FilePanel.CFileTableSorter;
import com.rhinosoft.FilePanel.ITableSorter;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.util.Comparator;

public class CSyncTableSorter
implements Comparator<CSyncTableRow>,
ITableSorter {
    public static final int SORT_OFF = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    public static final boolean DEBUG = CMainFrame.DEBUG;
    public static final boolean DEBUG_TRACE_METHODS;
    private boolean m_bIsLocal;
    private int m_nSortModelCol;
    private int m_nSortDirection = 1;

    public CSyncTableSorter(int nSortModelCol, boolean bIsLocal) {
        this.m_bIsLocal = bIsLocal;
        this.m_nSortModelCol = nSortModelCol;
    }

    @Override
    public final int GetSortModelCol() {
        return this.m_nSortModelCol;
    }

    @Override
    public boolean SetSortModelCol(int nSortModelCol) {
        boolean bDirty = false;
        if (this.m_nSortModelCol != nSortModelCol) {
            bDirty = true;
            this.m_nSortModelCol = nSortModelCol;
        }
        return bDirty;
    }

    @Override
    public boolean IsAscending() {
        return this.m_nSortDirection == 1;
    }

    @Override
    public boolean IsDescending() {
        return this.m_nSortDirection == 2;
    }

    @Override
    public int GetSortDirection() {
        return this.m_nSortDirection;
    }

    @Override
    public boolean SetSortDirection(int nSortDirection) {
        boolean bDirty = false;
        if (this.m_nSortDirection != nSortDirection) {
            bDirty = true;
            this.m_nSortDirection = nSortDirection;
        }
        return bDirty;
    }

    private boolean IsLocal() {
        return this.m_bIsLocal;
    }

    @Override
    public int compare(CSyncTableRow f1, CSyncTableRow f2) {
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFileTableSorter.compare -->");
        }
        int nRet = 0;
        if (f1 != null && f2 != null) {
            int nSortCol = this.GetSortModelCol();
            switch (nSortCol) {
                case 0: {
                    nRet = this.SortName(f1, f2);
                    break;
                }
                case 1: {
                    nRet = this.SortResults(f1, f2);
                    break;
                }
                case 2: {
                    nRet = this.SortActions(f1, f2);
                    break;
                }
                case 4: {
                    nRet = this.SortSize(f1, f2, true);
                    break;
                }
                case 3: {
                    nRet = this.SortSize(f1, f2, false);
                    break;
                }
                case 6: {
                    nRet = this.SortDateModified(f1, f2, true);
                    break;
                }
                case 5: {
                    nRet = this.SortDateModified(f1, f2, false);
                    break;
                }
            }
        }
        if (DEBUG_TRACE_METHODS) {
            System.out.println("CFileTableSorter.compare <--");
        }
        return nRet;
    }

    private int SortName(CSyncTableRow rRow1, CSyncTableRow rRow2) {
        CFile rFile2;
        int nRet = 0;
        CFile rFile1 = rRow1.GetLocalFile();
        if (rFile1 == null) {
            rFile1 = rRow1.GetRemoteFile();
        }
        if ((rFile2 = rRow2.GetLocalFile()) == null) {
            rFile2 = rRow2.GetRemoteFile();
        }
        String sName1 = rRow1.GetFileName();
        String sName2 = rRow2.GetFileName();
        boolean bIsDir1 = false;
        boolean bIsDir2 = false;
        boolean bIsDrive1 = false;
        boolean bIsDrive2 = false;
        if (rFile1 != null) {
            bIsDir1 = rFile1.IsDirectory();
            bIsDrive1 = rFile1.IsDrive();
        }
        if (rFile2 != null) {
            bIsDir2 = rFile2.IsDirectory();
            bIsDrive2 = rFile2.IsDirectory();
        }
        nRet = this.SortName(sName1, sName2, bIsDir1, bIsDir2, bIsDrive1, bIsDrive2);
        return nRet;
    }

    private int SortName(String sName1, String sName2, boolean bIsDir1, boolean bIsDir2, boolean bIsDrive1, boolean bIsDrive2) {
        int nRet = 0;
        boolean bIsAscending = this.IsAscending();
        nRet = bIsDir1 && !bIsDir2 ? (bIsAscending ? -1 : 1) : (!bIsDir1 && bIsDir2 ? (bIsAscending ? 1 : -1) : CFileTableSorter.Compare(bIsAscending, sName1, sName2));
        return nRet;
    }

    private int SortResults(CSyncTableRow rRow1, CSyncTableRow rRow2) {
        int nRet = 0;
        String s1 = rRow1.GetResultAsString();
        String s2 = rRow2.GetResultAsString();
        if (s1 != null && s2 != null) {
            nRet = CFileTableSorter.Compare(this.IsAscending(), s1, s2);
        } else if (s1 == null) {
            nRet = -1;
        } else if (s2 == null) {
            nRet = 1;
        }
        if (nRet == 0) {
            nRet = this.SortName(rRow1, rRow2);
        }
        return nRet;
    }

    private int SortActions(CSyncTableRow rRow1, CSyncTableRow rRow2) {
        int nRet = 0;
        String s1 = rRow1.GetActionAsString();
        String s2 = rRow2.GetActionAsString();
        if (s1 != null && s2 != null) {
            nRet = CFileTableSorter.Compare(this.IsAscending(), s1, s2);
        } else if (s1 == null) {
            nRet = -1;
        } else if (s2 == null) {
            nRet = 1;
        }
        if (nRet == 0) {
            nRet = this.SortName(rRow1, rRow2);
        }
        return nRet;
    }

    private int SortSize(CSyncTableRow rRow1, CSyncTableRow rRow2, boolean bCheckLocal) {
        int nRet = 0;
        CFile rFile1 = null;
        CFile rFile2 = null;
        if (bCheckLocal) {
            rFile1 = rRow1.GetLocalFile();
            rFile2 = rRow2.GetLocalFile();
        } else {
            rFile1 = rRow1.GetRemoteFile();
            rFile2 = rRow2.GetRemoteFile();
        }
        String sName1 = rRow1.GetFileName();
        String sName2 = rRow2.GetFileName();
        boolean bIsDir1 = false;
        boolean bIsDir2 = false;
        boolean bIsDrive1 = false;
        boolean bIsDrive2 = false;
        long lSize1 = -1L;
        long lSize2 = -1L;
        if (rFile1 != null) {
            bIsDir1 = rFile1.IsDirectory();
            bIsDrive1 = rFile1.IsDrive();
            lSize1 = rFile1.GetSize();
        }
        if (rFile2 != null) {
            bIsDir2 = rFile2.IsDirectory();
            bIsDrive2 = rFile2.IsDirectory();
            lSize2 = rFile2.GetSize();
        }
        nRet = this.SortSize(sName1, sName2, bIsDir1, bIsDir2, bIsDrive1, bIsDrive2, lSize1, lSize2);
        return nRet;
    }

    private int SortSize(String sName1, String sName2, boolean bIsDir1, boolean bIsDir2, boolean bIsDrive1, boolean bIsDrive2, long lSize1, long lSize2) {
        int nRet = 0;
        boolean bIsAscending = this.IsAscending();
        if (bIsDir1 && !bIsDir2) {
            nRet = bIsAscending ? -1 : 1;
        } else if (!bIsDir1 && bIsDir2) {
            nRet = bIsAscending ? 1 : -1;
        } else {
            nRet = lSize1 < lSize2 ? (bIsAscending ? -1 : 1) : (lSize1 > lSize2 ? (bIsAscending ? 1 : -1) : 0);
            if (nRet == 0) {
                nRet = this.SortName(sName1, sName2, bIsDir1, bIsDir2, bIsDrive1, bIsDrive2);
            }
        }
        return nRet;
    }

    private int SortDateModified(CSyncTableRow rRow1, CSyncTableRow rRow2, boolean bCheckLocal) {
        int nRet = 0;
        CFile rFile1 = null;
        CFile rFile2 = null;
        if (bCheckLocal) {
            rFile1 = rRow1.GetLocalFile();
            rFile2 = rRow2.GetLocalFile();
        } else {
            rFile1 = rRow1.GetRemoteFile();
            rFile2 = rRow2.GetRemoteFile();
        }
        String sName1 = rRow1.GetFileName();
        String sName2 = rRow2.GetFileName();
        boolean bIsDir1 = false;
        boolean bIsDir2 = false;
        boolean bIsDrive1 = false;
        boolean bIsDrive2 = false;
        long lDateModified1 = -1L;
        long lDateModified2 = -1L;
        if (rFile1 != null) {
            bIsDir1 = rFile1.IsDirectory();
            bIsDrive1 = rFile1.IsDrive();
            if (rFile1.GetModifiedDate() != null) {
                lDateModified1 = rFile1.GetModifiedDate().getTime();
            }
        }
        if (rFile2 != null) {
            bIsDir2 = rFile2.IsDirectory();
            bIsDrive2 = rFile2.IsDirectory();
            if (rFile2.GetModifiedDate() != null) {
                lDateModified2 = rFile2.GetModifiedDate().getTime();
            }
        }
        nRet = this.SortDate(sName1, sName2, bIsDir1, bIsDir2, bIsDrive1, bIsDrive2, lDateModified1, lDateModified2);
        return nRet;
    }

    private int SortDate(String sName1, String sName2, boolean bIsDir1, boolean bIsDir2, boolean bIsDrive1, boolean bIsDrive2, long lDate1, long lDate2) {
        int nRet = 0;
        boolean bIsAscending = this.IsAscending();
        if (bIsDir1 && !bIsDir2) {
            nRet = bIsAscending ? -1 : 1;
        } else if (!bIsDir1 && bIsDir2) {
            nRet = bIsAscending ? 1 : -1;
        } else {
            nRet = lDate1 < lDate2 ? (bIsAscending ? -1 : 1) : (lDate1 > lDate2 ? (bIsAscending ? 1 : -1) : 0);
            if (nRet == 0) {
                nRet = this.SortName(sName1, sName2, bIsDir1, bIsDir2, bIsDrive1, bIsDrive2);
            }
        }
        return nRet;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
    }
}

