/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.fvjv.strings.CString;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class CSyncTableModel
implements TableModel {
    private String[] m_saColHeaders;
    private Vector<CSyncTableRow> m_aRows;
    protected EventListenerList m_jListenerList;

    public CSyncTableModel() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_aRows = new Vector();
        this.m_saColHeaders = new String[7];
        this.m_saColHeaders[0] = CString.LoadString("IDS_SYNC_COL_NAME");
        this.m_saColHeaders[1] = CString.LoadString("IDS_SYNC_COL_RESULTS");
        this.m_saColHeaders[2] = CString.LoadString("IDS_SYNC_COL_ACTION");
        this.m_saColHeaders[3] = CString.LoadString("IDS_SYNC_COL_REMOTE_SIZE");
        this.m_saColHeaders[4] = CString.LoadString("IDS_SYNC_COL_LOCAL_SIZE");
        this.m_saColHeaders[5] = CString.LoadString("IDS_SYNC_COL_REMOTE_DATE_MODIFIED");
        this.m_saColHeaders[6] = CString.LoadString("IDS_SYNC_COL_LOCAL_DATE_MODIFIED");
        this.m_jListenerList = new EventListenerList();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int nColIndex) {
        return this.m_saColHeaders[nColIndex];
    }

    @Override
    public Class<?> getColumnClass(int nColIndex) {
        Class<String> cRetClass = String.class;
        return cRetClass;
    }

    @Override
    public boolean isCellEditable(int nRowIndex, int nColIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object rValue, int nRowIndex, int nColIndex) {
        if (nColIndex == 2) {
            String sVal = (String)rValue;
            CSyncTableRow rRow = this.GetRow(nRowIndex);
            if (rRow != null) {
                rRow.SetAction(sVal);
                this.fireTableCellUpdated(nRowIndex, nColIndex);
            }
        }
    }

    public Object getElementAt(int nIndex) {
        CSyncTableRow objRet = null;
        if (this.m_aRows != null && nIndex > -1 && nIndex < this.m_aRows.size()) {
            objRet = this.m_aRows.get(nIndex);
        }
        return objRet;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getElementAt(rowIndex);
    }

    public CSyncTableRow GetRow(int nRow) {
        Object objRet = this.getElementAt(nRow);
        CSyncTableRow rRowObj = null;
        if (objRet instanceof CSyncTableRow) {
            rRowObj = (CSyncTableRow)objRet;
        }
        return rRowObj;
    }

    public boolean IsValidRow(int nRow) {
        boolean bIsValid = false;
        if (nRow >= 0 && nRow < this.m_aRows.size()) {
            bIsValid = true;
        }
        return bIsValid;
    }

    public void AddRow(CSyncTableRow rRow) {
        if (rRow != null) {
            this.m_aRows.add(rRow);
            int nInserted = this.m_aRows.size() - 1;
            this.fireTableRowsInserted(nInserted, nInserted);
        }
    }

    public void RemoveRow(int nRowIdx) {
        if (this.IsValidRow(nRowIdx)) {
            this.m_aRows.remove(nRowIdx);
            this.fireTableRowsDeleted(nRowIdx, nRowIdx);
        }
    }

    public int getSize() {
        int nSize = 0;
        if (this.m_aRows != null) {
            nSize = this.m_aRows.size();
        }
        return nSize;
    }

    @Override
    public int getRowCount() {
        return this.getSize();
    }

    @Override
    public void addTableModelListener(TableModelListener jListener) {
        this.m_jListenerList.add(TableModelListener.class, jListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener jListener) {
        this.m_jListenerList.remove(TableModelListener.class, jListener);
    }

    public void fireTableDataChanged() {
        this.fireTableDataChanged(true);
    }

    protected void fireTableDataChanged(boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableStructureChanged(true);
    }

    private void fireTableStructureChanged(boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableRowsInserted(firstRow, lastRow, true);
    }

    private void fireTableRowsInserted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableRowsUpdated(firstRow, lastRow, true);
    }

    private void fireTableRowsUpdated(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableRowsDeleted(firstRow, lastRow, true);
    }

    private void fireTableRowsDeleted(int firstRow, int lastRow, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
        if (bFireListEvent) {
            // empty if block
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableCellUpdated(row, column, true);
    }

    private void fireTableCellUpdated(int row, int column, boolean bFireListEvent) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.m_jListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.fireContentsChanged(source, index0, index1, true);
    }

    protected void fireContentsChanged(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 0, index0, index1));
        if (bFireTableEvent) {
            this.fireTableStructureChanged(false);
        }
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        this.fireIntervalAdded(source, index0, index1, true);
    }

    private void fireIntervalAdded(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 1, index0, index1));
        if (bFireTableEvent) {
            this.fireTableRowsInserted(index0, index1, false);
        }
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        this.fireIntervalRemoved(source, index0, index1, true);
    }

    private void fireIntervalRemoved(Object source, int index0, int index1, boolean bFireTableEvent) {
        this.fireListEvent(new ListDataEvent(source, 2, index0, index1));
        if (bFireTableEvent) {
            this.fireTableRowsDeleted(index0, index1, false);
        }
    }

    private void fireListEvent(ListDataEvent jEvent) {
        Object[] listeners = this.m_jListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (jEvent.getType() == 0) {
                ((ListDataListener)listeners[i + 1]).contentsChanged(jEvent);
                continue;
            }
            if (jEvent.getType() == 1) {
                ((ListDataListener)listeners[i + 1]).intervalAdded(jEvent);
                continue;
            }
            if (jEvent.getType() != 2) continue;
            ((ListDataListener)listeners[i + 1]).intervalRemoved(jEvent);
        }
    }

    public void RemoveAllRows() {
        this.m_aRows.removeAllElements();
    }

    public void Sort(Comparator rComparator) {
        if (rComparator != null && this.m_aRows != null) {
            Collections.sort(this.m_aRows, rComparator);
        }
    }

    public void GetData(Vector<CSyncTableRow> aRows) {
        if (aRows != null) {
            for (int nRow = 0; nRow < this.getRowCount(); ++nRow) {
                CSyncTableRow rRow = this.GetRow(nRow);
                if (rRow == null) continue;
                aRows.add(rRow);
            }
        }
    }

    public void RemoveRow(String sAbsPath, boolean bGetLocal) {
        for (int nRow = this.getRowCount() - 1; nRow >= 0; --nRow) {
            String sAbsFilePath;
            CSyncTableRow rRow = this.GetRow(nRow);
            if (rRow == null) continue;
            CFile rFile = null;
            rFile = bGetLocal ? rRow.GetLocalFile() : rRow.GetRemoteFile();
            if (rFile == null || (sAbsFilePath = rFile.GetPath()) == null || sAbsPath == null || !sAbsFilePath.equals(sAbsPath)) continue;
            this.RemoveRow(nRow);
        }
    }
}

