/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.event.DockableFrameDropListener;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.swing.JideButton;
import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.docking.fvjv.syncFolders.CBaseFrame;
import com.rhinosoft.docking.fvjv.syncFolders.CConfirmDuplicateFileNameDlg;
import com.rhinosoft.docking.fvjv.syncFolders.CLocalFrame;
import com.rhinosoft.docking.fvjv.syncFolders.COptionsFrame;
import com.rhinosoft.docking.fvjv.syncFolders.CRemoteFrame;
import com.rhinosoft.docking.fvjv.syncFolders.CSentToTransferQueueDlg;
import com.rhinosoft.docking.fvjv.syncFolders.CStatusBar;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableModel;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.fvjv.gui.CClientInfo;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.IArchive;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import com.rhinosoft.fvjv.threads.CThreadMsgCreateDir;
import com.rhinosoft.fvjv.threads.remote.CRemoteThread;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgSyncFoldersCompare;
import com.rhinosoft.fvjv.threads.remote.CThreadMsgSyncFoldersExecute;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CSyncFolderPanel
extends CDockablePanel
implements DockableFrameDropListener,
ActionListener,
KeyListener {
    private static boolean DEBUG = CMainFrame.DEBUG;
    private static boolean DEBUG_TRACK_DOCKED;
    private static final String KEY_MAIN_TOOLBAR = "MainToolbar";
    private static final String KEY_LOCAL = "Local";
    private static final String KEY_REMOTE = "Remote";
    private static final String KEY_OPTIONS = "Options";
    private CLocalFrame m_cLocalFrame;
    private CRemoteFrame m_cRemoteFrame;
    private COptionsFrame m_cOptionsFrame;
    private String m_sSyncLocalToRemote;
    private String m_sSyncRemoteToLocal;
    private boolean m_bSkipDockEvent = false;
    private CRemoteThread m_tComparisonThread;
    private CStatusBar m_rStatusBar;
    private CPath m_rLocalPath;
    private CPath m_rRemotePath;
    private int m_nCompareDelay = 1000;
    private Timer m_CompareTimer;
    private int m_nTimerTickMax = 3;
    private int m_nTimerTickMin = 0;
    private int m_nTimerTickCur = 3;
    private boolean m_bDoNotShowAgain = false;
    private CSentToTransferQueueDlg m_SentToTransferQueueDlg;
    private CThreadMsgSyncFoldersCompare m_rCompareMsg;
    private String m_sArchiveKeyLocalColWidths;
    private String m_sArchiveKeyRemoteColWidths;

    public CSyncFolderPanel(RootPaneContainer rootPaneContainer, JComponent rParent, File fInitialLayout, File fStoredLayout, String sArchiveKeyLocalColWidths, String sArchiveKeyRemoteColWidths) {
        super(rootPaneContainer, rParent, fInitialLayout, fStoredLayout);
        this.InitVars(sArchiveKeyLocalColWidths, sArchiveKeyRemoteColWidths);
    }

    private void InitVars(String sArchiveKeyLocalColWidths, String sArchiveKeyRemoteColWidths) {
        this.SetArchiveKeyLocalColWidths(sArchiveKeyLocalColWidths);
        this.SetArchiveKeyRemoteColWidths(sArchiveKeyRemoteColWidths);
        this.m_sSyncLocalToRemote = String.format(CString.LoadString("IDS_SYNC_DIRECTION"), CString.LoadString("IDS_SYNC_LOCAL"), CString.LoadString("IDS_SYNC_REMOTE"));
        this.m_sSyncRemoteToLocal = String.format(CString.LoadString("IDS_SYNC_DIRECTION"), CString.LoadString("IDS_SYNC_REMOTE"), CString.LoadString("IDS_SYNC_LOCAL"));
        this.m_cLocalFrame = new CLocalFrame(KEY_LOCAL, this, 4, 1, sArchiveKeyLocalColWidths);
        this.m_cRemoteFrame = new CRemoteFrame(KEY_REMOTE, this, 4, 2, sArchiveKeyRemoteColWidths);
        this.m_cOptionsFrame = new COptionsFrame(KEY_OPTIONS, this, 4, 4);
        if (this.GetLocalFrame() != null) {
            this.GetLocalFrame().addKeyListener(this);
        }
        if (this.GetRemoteFrame() != null) {
            this.GetRemoteFrame().addKeyListener(this);
        }
        int nDefWidth = this.GetDefOptionsDockWidth();
        int nDefHeight = this.GetDefOptionsDockHeight();
        if (this.GetOptionsFrame() != null) {
            this.GetOptionsFrame().setDockedWidth(nDefWidth);
            this.GetOptionsFrame().setPreferredSize(new Dimension(nDefWidth, nDefHeight));
            this.GetOptionsFrame().addKeyListener(this);
        }
        if (this.getDockingManager() != null) {
            this.getDockingManager().setInitSplitPriority(0);
            this.getDockingManager().setShowWorkspace(false);
            this.getDockingManager().getWorkspace().setAcceptDockableFrame(false);
            this.getDockingManager().setAllowedDockSides(15);
            this.getDockingManager().setFloatable(false);
            this.getDockingManager().setDoubleClickAction(-1);
            this.getDockingManager().addFrame(this.GetLocalFrame());
            this.getDockingManager().addFrame(this.GetRemoteFrame());
            this.getDockingManager().addFrame(this.GetOptionsFrame());
            this.getDockingManager().addDockableFrameDropListener(this);
        }
        if (this.GetLocalFrame() != null) {
            if (CMainFrame.GET_APP() != null) {
                this.GetLocalFrame().SetRootNode(CMainFrame.GET_APP().GetLocalRoot());
            }
            this.GetLocalFrame().AddSyncBtnListener(this);
            this.GetLocalFrame().RequestInitialFocus();
        }
        if (this.GetRemoteFrame() != null) {
            if (CMainFrame.GET_APP() != null) {
                this.GetRemoteFrame().SetRootNode(CMainFrame.GET_APP().GetRemoteRoot());
            }
            this.GetRemoteFrame().AddSyncBtnListener(this);
        }
        if (this.GetOptionsFrame() != null) {
            this.GetOptionsFrame().SetChangeListener(this);
            this.GetOptionsFrame().AddCompareListener(this);
        }
        this.m_tComparisonThread = this.CreateComparisonThread();
        this.m_CompareTimer = new Timer(this.m_nCompareDelay, this);
        this.m_SentToTransferQueueDlg = new CSentToTransferQueueDlg(this);
    }

    protected CLocalFrame GetLocalFrame() {
        return this.m_cLocalFrame;
    }

    protected CRemoteFrame GetRemoteFrame() {
        return this.m_cRemoteFrame;
    }

    protected COptionsFrame GetOptionsFrame() {
        return this.m_cOptionsFrame;
    }

    private boolean IsLocalBeforeRemote() {
        boolean bIsLocalBeforeRemote = true;
        if (this.GetLocalFrame() != null && this.GetRemoteFrame() != null && (this.GetRemoteFrame().getContext().getCurrentDockSide() == 8 || this.GetRemoteFrame().getContext().getCurrentDockSide() == 1)) {
            bIsLocalBeforeRemote = false;
        }
        return bIsLocalBeforeRemote;
    }

    private boolean IsVertSplit() {
        boolean bIsVertSplit = true;
        if (this.GetLocalFrame() != null && this.GetRemoteFrame() != null && (this.GetLocalFrame().getContext().getCurrentDockSide() == 1 || this.GetLocalFrame().getContext().getCurrentDockSide() == 2 || this.GetRemoteFrame().getContext().getCurrentDockSide() == 1 || this.GetRemoteFrame().getContext().getCurrentDockSide() == 2)) {
            bIsVertSplit = false;
        }
        return bIsVertSplit;
    }

    private String GetSyncLocalToRemoteString() {
        return this.m_sSyncLocalToRemote;
    }

    private String GetSyncRemoteToLocalString() {
        return this.m_sSyncRemoteToLocal;
    }

    @Override
    public void dockableFrameDocked(DockableFrameEvent event) {
        super.dockableFrameDocked(event);
        if (this.GetOptionsFrame() != null) {
            this.GetOptionsFrame().dockableFrameDocked(event);
        }
        if (!this.m_bSkipDockEvent) {
            if (this.GetLocalFrame() != null && this.GetRemoteFrame() != null) {
                CBaseFrame rJustMoved = null;
                CBaseFrame rNeedToMove = null;
                if (event.getDockableFrame() == this.GetLocalFrame()) {
                    rJustMoved = this.GetLocalFrame();
                    rNeedToMove = this.GetRemoteFrame();
                } else if (event.getDockableFrame() == this.GetRemoteFrame()) {
                    rJustMoved = this.GetRemoteFrame();
                    rNeedToMove = this.GetLocalFrame();
                }
                if (rJustMoved != null && rNeedToMove != null) {
                    this.m_bSkipDockEvent = true;
                    if (rJustMoved.getContext().getCurrentDockSide() == 4) {
                        this.getDockingManager().dockFrame(rNeedToMove.getKey(), 8, 0);
                    } else if (rJustMoved.getContext().getCurrentDockSide() == 8) {
                        this.getDockingManager().dockFrame(rNeedToMove.getKey(), 4, 0);
                    } else if (rJustMoved.getContext().getCurrentDockSide() == 2) {
                        this.getDockingManager().dockFrame(rNeedToMove.getKey(), 1, 0);
                    } else if (rJustMoved.getContext().getCurrentDockSide() == 1) {
                        this.getDockingManager().dockFrame(rNeedToMove.getKey(), 2, 0);
                    }
                    boolean bIsLocalBeforeRemote = this.IsLocalBeforeRemote();
                    boolean bIsVertSplit = this.IsVertSplit();
                    if (DEBUG_TRACK_DOCKED) {
                        System.out.println("bIsLocalBeforeRemote = " + bIsLocalBeforeRemote);
                        System.out.println("bIsVertSplit = " + bIsVertSplit);
                    }
                }
            }
        } else {
            this.m_bSkipDockEvent = false;
        }
    }

    @Override
    public boolean isDockingAllowed(DockableFrame rSource, Component cTarget, int nSide) {
        boolean bIsDockAllowed = true;
        if (cTarget == this.getDockingManager().getWorkspace()) {
            bIsDockAllowed = false;
        } else if (nSide == 16) {
            bIsDockAllowed = false;
        } else if (cTarget instanceof DockableFrame) {
            bIsDockAllowed = false;
        }
        return bIsDockAllowed;
    }

    @Override
    public void dockableFrameActivated(DockableFrameEvent event) {
        super.dockableFrameActivated(event);
        if (event.getDockableFrame() instanceof CDockableFrame) {
            CDockableFrame rFrame = (CDockableFrame)event.getDockableFrame();
            rFrame.TurnOnFocusClrs();
        }
    }

    @Override
    public void dockableFrameDeactivated(DockableFrameEvent event) {
        super.dockableFrameDeactivated(event);
        if (event.getDockableFrame() instanceof CDockableFrame) {
            CDockableFrame rFrame = (CDockableFrame)event.getDockableFrame();
            rFrame.TurnOffFocusClrs();
            if (rFrame.GetDockPanel() != null && rFrame.GetDockPanel().getDockingManager() != null) {
                rFrame.GetDockPanel().getDockingManager().activateWorkspace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JideButton rLocalSync = null;
        if (this.GetLocalFrame() != null) {
            rLocalSync = this.GetLocalFrame().GetDoActionsBtn();
        }
        JideButton rRemoteSync = null;
        if (this.GetRemoteFrame() != null) {
            rRemoteSync = this.GetRemoteFrame().GetDoActionsBtn();
        }
        if (event.getSource() == this.GetCompareBtn()) {
            this.StartComparison();
        } else if (event.getSource() == this.GetOptionsFrame()) {
            this.StartCompareTimer();
        } else if (event.getSource() == this.m_CompareTimer) {
            this.SetTickCount(this.GetTickCount() - 1);
            if (this.IsTickExpired()) {
                this.StartComparison();
            }
        } else if (rLocalSync != null && event.getSource() == rLocalSync) {
            this.OnSyncLocal();
        } else if (rRemoteSync != null && event.getSource() == rRemoteSync) {
            this.OnSyncRemote();
        }
    }

    private CPath GetLocalPath() {
        return this.m_rLocalPath;
    }

    private CPath GetRemotePath() {
        return this.m_rRemotePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void RelayEvent(AWTEvent event) {
        super.RelayEvent(event);
        switch (event.getID()) {
            case 5000: {
                this.OnSaveAttrs();
                return;
            }
            case 5001: {
                this.OnLoadAttrs();
                return;
            }
            case 6008: {
                CRhinoEvent rEvent;
                Object[] arObjs;
                if (event instanceof CRhinoEvent && !this.IsEventSource((arObjs = (Object[])(rEvent = (CRhinoEvent)event).GetEventObj())[1])) return;
            }
            case 3020: {
                CThreadMsg rMsg;
                CRhinoEvent rEvent;
                if (!(event instanceof CRhinoEvent) || !this.IsEventSource((rEvent = (CRhinoEvent)event).getSource()) || !(rEvent.GetEventObj() instanceof CThreadMsg) || (rMsg = (CThreadMsg)rEvent.GetEventObj()).GetMsgID() != 40 || this.GetStatusBar() == null) return;
                this.GetStatusBar().HideProgress();
                return;
            }
            case 3022: {
                CRhinoEvent rEvent;
                if (!(event instanceof CRhinoEvent) || !this.IsEventSource((rEvent = (CRhinoEvent)event).getSource()) || !(rEvent.GetEventObj() instanceof CThreadMsg)) return;
                CThreadMsg rMsg = (CThreadMsg)rEvent.GetEventObj();
                switch (rMsg.GetMsgID()) {
                    case 40: {
                        if (rMsg == this.m_rCompareMsg) {
                            this.m_rCompareMsg = null;
                        }
                        if (this.GetStatusBar() != null) {
                            this.GetStatusBar().HideProgress();
                        }
                        boolean bHasError = false;
                        if (rMsg.GetErrorID() != 0) {
                            bHasError = true;
                        }
                        if (this.GetLocalFrame() != null) {
                            this.GetLocalFrame().CheckIsSynchronized(bHasError);
                            this.GetLocalFrame().OnSort();
                        }
                        if (this.GetRemoteFrame() == null) return;
                        this.GetRemoteFrame().CheckIsSynchronized(bHasError);
                        this.GetRemoteFrame().OnSort();
                        return;
                    }
                    case 41: {
                        this.StartComparison();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3021: {
                CRhinoEvent rEvent;
                if (!(event instanceof CRhinoEvent) || !this.IsEventSource((rEvent = (CRhinoEvent)event).getSource())) return;
                CPath rFromPath = null;
                if (rEvent.GetEventObj() instanceof CThreadMsgSyncFoldersCompare) {
                    CThreadMsgSyncFoldersCompare rCompareMsg = (CThreadMsgSyncFoldersCompare)rEvent.GetEventObj();
                } else if (rEvent.GetEventObj() instanceof CThreadMsgSyncFoldersExecute) {
                    CThreadMsgSyncFoldersExecute rExecuteMsg = (CThreadMsgSyncFoldersExecute)rEvent.GetEventObj();
                    CSyncTableRow rRow = rExecuteMsg.GetSyncTableRow(rExecuteMsg.GetPathIndex());
                    if (rRow != null && rRow.GetAction() == CSyncTableRow.ROW_ACTION.DELETE) {
                        if (rRow.GetResult() == CSyncTableRow.ROW_RESULT.NOT_ON_LOCAL) {
                            rFromPath = rRow.GetRemoteFile();
                        } else if (rRow.GetResult() == CSyncTableRow.ROW_RESULT.NOT_ON_REMOTE) {
                            rFromPath = rRow.GetLocalFile();
                        }
                    }
                    if (rFromPath == null) {
                        rFromPath = rExecuteMsg.GetFromPath(rExecuteMsg.GetPathIndex());
                    }
                } else if (rEvent.GetEventObj() instanceof CThreadMsgCreateDir) {
                    CThreadMsgCreateDir rCreateDirMsg = (CThreadMsgCreateDir)rEvent.GetEventObj();
                    rFromPath = rCreateDirMsg.GetToPath(0);
                }
                if (this.GetLocalFrame() != null) {
                    this.GetLocalFrame().RemoveRow(rFromPath);
                }
                if (this.GetRemoteFrame() == null) return;
                this.GetRemoteFrame().RemoveRow(rFromPath);
                return;
            }
            case 9601: {
                if (!(event instanceof CRhinoEvent)) return;
                CRhinoEvent rEvent = (CRhinoEvent)event;
                this.OnRecvLocalRow(rEvent);
                return;
            }
            case 9602: {
                if (!(event instanceof CRhinoEvent)) return;
                CRhinoEvent rEvent = (CRhinoEvent)event;
                this.OnRecvRemoteRow(rEvent);
                return;
            }
            case 9600: {
                if (!(event instanceof CRhinoEvent)) return;
                CRhinoEvent rEvent = (CRhinoEvent)event;
                this.OnRecvConfirmDuplicates(rEvent);
                return;
            }
            case 9025: {
                this.OnLoadAttrs();
                if (this.GetLocalFrame() != null) {
                    this.GetLocalFrame().RequestInitialFocus();
                    return;
                }
                if (this.GetRemoteFrame() == null) return;
                this.GetRemoteFrame().RequestInitialFocus();
                return;
            }
            case 6054: {
                CRhinoEvent rEvent;
                Object objEvent;
                if (!this.IsEventSource(event.getSource()) || !(event instanceof CRhinoEvent) || !((objEvent = (rEvent = (CRhinoEvent)event).GetEventObj()) instanceof CThreadMsgSyncFoldersExecute)) return;
                ((CThreadMsgSyncFoldersExecute)objEvent).OnFailedToPrepareTransfer();
                return;
            }
        }
    }

    private CClientInfo GetClientInfo() {
        CClientInfo rInfo = null;
        if (CMainFrame.GET_APP() != null) {
            rInfo = CMainFrame.GET_APP().GetClientInfo();
        }
        return rInfo;
    }

    private void StartComparison() {
        this.OnCancelCompare();
        this.StopCompareTimer();
        if (this.GetLocalFrame() != null) {
            this.GetLocalFrame().ClearTable();
        }
        if (this.GetRemoteFrame() != null) {
            this.GetRemoteFrame().ClearTable();
        }
        if (this.GetComparisonThread() != null && this.GetLocalPath() != null && this.GetRemotePath() != null) {
            boolean bCompareSize = true;
            boolean bCompareDateModified = true;
            boolean bDelete = true;
            boolean bIncludeSubfolders = true;
            if (this.GetOptionsFrame() != null) {
                bCompareSize = this.GetOptionsFrame().IsCompareSize();
                bCompareDateModified = this.GetOptionsFrame().IsCompareDateModified();
                bDelete = this.GetOptionsFrame().IsDelete();
                bIncludeSubfolders = this.GetOptionsFrame().IsIncludeSubfolders();
            }
            CThreadMsgSyncFoldersCompare[] arRetMsg = new CThreadMsgSyncFoldersCompare[1];
            if (this.GetComparisonThread().PostSyncFoldersCompare(this, this.GetClientInfo(), this.GetCompressionType(), this.GetLocalPath(), this.GetRemotePath(), bCompareSize, bCompareDateModified, bDelete, bIncludeSubfolders, arRetMsg)) {
                if (arRetMsg != null && arRetMsg.length > 0) {
                    this.m_rCompareMsg = arRetMsg[0];
                }
                this.ShowProgressInStatusBar(true);
            }
        } else if (DEBUG) {
            CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Check your parameters.", true);
        }
    }

    private CRemoteThread CreateComparisonThread() {
        CRemoteThread tThread = null;
        if (CMainFrame.GET_APP() != null) {
            tThread = CMainFrame.GET_APP().CreateRemoteThread("SyncFoldersComparisonThread");
        }
        return tThread;
    }

    private CRemoteThread GetComparisonThread() {
        return this.m_tComparisonThread;
    }

    private void ShowProgressInStatusBar(boolean bShow) {
        if (this.GetStatusBar() != null) {
            if (bShow) {
                this.GetStatusBar().ShowProgress();
            } else {
                this.GetStatusBar().HideProgress();
            }
        }
    }

    public void SetStatusBar(CStatusBar rStatusBar) {
        if (this.m_rStatusBar != null) {
            this.m_rStatusBar.RemoveCancelBtnListener(this);
        }
        this.m_rStatusBar = rStatusBar;
        this.m_rStatusBar.AddCancelBtnListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CSyncFolderPanel.this.OnCancelCompare();
            }
        });
    }

    public CStatusBar GetStatusBar() {
        return this.m_rStatusBar;
    }

    private void OnCancelCompare() {
        if (this.m_rCompareMsg != null) {
            this.m_rCompareMsg.SetSuppressError(true);
            this.m_rCompareMsg = null;
        }
        if (this.GetComparisonThread() != null) {
            this.GetComparisonThread().Cancel();
        }
    }

    private void OnRecvConfirmDuplicates(CRhinoEvent rEvent) {
        if (rEvent != null && this.IsEventSource(rEvent.getSource()) && rEvent.GetEventObj() instanceof CThreadMsgSyncFoldersCompare) {
            CThreadMsgSyncFoldersCompare rMsg = (CThreadMsgSyncFoldersCompare)rEvent.GetEventObj();
            if (this.GetStatusBar() != null) {
                this.GetStatusBar().ShowConfirming();
            }
            Frame owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
            CConfirmDuplicateFileNameDlg dlg = new CConfirmDuplicateFileNameDlg(owner, true, -1L);
            dlg.setVisible(true);
            int nRc = dlg.GetExitCode();
            if (nRc == 0 || nRc == 1) {
                this.ShowProgressInStatusBar(true);
                rMsg.SetApplyToAllDuplicates(dlg.GetApplyToAll());
                if (nRc == 0) {
                    rMsg.SetActionForMultipleLocalFile(CThreadMsgSyncFoldersCompare.MULTIPLE_LOCAL_FILE_ACTION.RENAME);
                } else if (nRc == 1) {
                    rMsg.SetActionForMultipleLocalFile(CThreadMsgSyncFoldersCompare.MULTIPLE_LOCAL_FILE_ACTION.EXCLUDE);
                }
            } else {
                this.ShowProgressInStatusBar(false);
                if (this.GetComparisonThread() != null) {
                    this.GetComparisonThread().Cancel();
                }
                rMsg.SetCancel(true);
            }
            rMsg.ResumeFromConfirmDuplicates();
        }
    }

    private void OnRecvLocalRow(CRhinoEvent rEvent) {
        this.OnRecvRow(rEvent, true);
    }

    private void OnRecvRemoteRow(CRhinoEvent rEvent) {
        this.OnRecvRow(rEvent, false);
    }

    private void OnRecvRow(CRhinoEvent rEvent, boolean bIsLocal) {
        if (rEvent != null && this.IsEventSource(rEvent.getSource()) && rEvent.GetEventObj() instanceof CSyncTableRow) {
            CSyncTableRow rRow = (CSyncTableRow)rEvent.GetEventObj();
            if (rRow != null) {
                CSyncTableModel rModel = null;
                if (bIsLocal) {
                    if (this.GetLocalFrame() != null && this.GetLocalFrame().GetModel() != null) {
                        rModel = this.GetLocalFrame().GetModel();
                    }
                } else if (this.GetRemoteFrame() != null && this.GetRemoteFrame().GetModel() != null) {
                    rModel = this.GetRemoteFrame().GetModel();
                }
                if (rModel != null) {
                    rModel.AddRow(rRow);
                }
            } else {
                JOptionPane.showMessageDialog(this, "ASSERT:  Local/Remote rows are invalid");
            }
        }
    }

    private JButton GetCompareBtn() {
        JButton rBtn = null;
        if (this.GetOptionsFrame() != null) {
            rBtn = this.GetOptionsFrame().GetCompareBtn();
        }
        return rBtn;
    }

    public boolean SetLocalPath(CPath rLocalPath) {
        boolean bChanged = false;
        if (this.m_rLocalPath != rLocalPath) {
            this.m_rLocalPath = rLocalPath;
            bChanged = true;
            if (this.GetLocalFrame() != null) {
                this.GetLocalFrame().UpdateTitleBarText(rLocalPath);
            }
        }
        return bChanged;
    }

    public boolean SetRemotePath(CPath rRemotePath) {
        boolean bChanged = false;
        if (this.m_rRemotePath != rRemotePath) {
            this.m_rRemotePath = rRemotePath;
            bChanged = true;
            if (this.GetRemoteFrame() != null) {
                this.GetRemoteFrame().UpdateTitleBarText(rRemotePath);
            }
        }
        return bChanged;
    }

    public void OnCompare() {
        this.StartComparison();
    }

    private void OnSyncLocal() {
        Vector<CSyncTableRow> aActionList = new Vector<CSyncTableRow>();
        if (this.GetLocalFrame() != null) {
            this.GetLocalFrame().GetSortedActionList(aActionList, 3);
        }
        this.ExecuteActions(aActionList);
    }

    private void OnSyncRemote() {
        Vector<CSyncTableRow> aActionList = new Vector<CSyncTableRow>();
        if (this.GetRemoteFrame() != null) {
            this.GetRemoteFrame().GetSortedActionList(aActionList, 4);
        }
        this.ExecuteActions(aActionList);
    }

    private void ExecuteActions(Vector<CSyncTableRow> aActionList) {
        if (aActionList != null) {
            CRemoteThread rThread;
            boolean bPromptOverwrite = true;
            boolean bPromptDelete = true;
            int nNumOfThreads = 4;
            if (this.GetOptionsFrame() != null) {
                bPromptOverwrite = this.GetOptionsFrame().IsPromptOverwrite();
                bPromptDelete = this.GetOptionsFrame().IsPromptDelete();
                nNumOfThreads = this.GetOptionsFrame().GetNumOfThreads();
            }
            if (CMainFrame.GET_APP() != null && (rThread = CMainFrame.GET_APP().CreateRemoteThread("SyncFoldersExecuteThread")) != null) {
                if (this.GetLocalFrame() != null) {
                    this.GetLocalFrame().ActivateActionsBtn(false);
                }
                if (this.GetRemoteFrame() != null) {
                    this.GetRemoteFrame().ActivateActionsBtn(false);
                }
                rThread.PostSyncFoldersExecute(this, this.GetClientInfo(), this.GetCompressionType(), this.GetLocalPath(), this.GetRemotePath(), aActionList, bPromptOverwrite, bPromptDelete);
                if (!this.m_bDoNotShowAgain) {
                    this.m_SentToTransferQueueDlg.setVisible(true);
                    int nResult = this.m_SentToTransferQueueDlg.GetResult();
                    this.m_bDoNotShowAgain = this.m_SentToTransferQueueDlg.GetDoNotShowAgain();
                }
                this.OnSaveAttrs();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 116: {
                if (!this.IsEventSource(event.getSource())) break;
                this.StartComparison();
                break;
            }
        }
    }

    private int GetCompareDelay() {
        return this.m_nCompareDelay;
    }

    private void StartCompareTimer() {
        this.SetTickCount(this.GetTickMax());
        if (this.m_CompareTimer != null) {
            if (!this.IsCompareTimerRunning()) {
                this.m_CompareTimer.setInitialDelay(this.GetCompareDelay());
                this.m_CompareTimer.setDelay(this.GetCompareDelay());
                this.m_CompareTimer.start();
            } else {
                this.m_CompareTimer.restart();
            }
        }
    }

    private void StopCompareTimer() {
        this.SetTickCount(this.GetTickMax());
        if (this.m_CompareTimer != null && this.m_CompareTimer.isRunning()) {
            this.m_CompareTimer.stop();
        }
    }

    private boolean IsCompareTimerRunning() {
        boolean bIsRunning = false;
        if (this.m_CompareTimer != null && this.m_CompareTimer.isRunning()) {
            bIsRunning = true;
        }
        return bIsRunning;
    }

    private int GetTickMax() {
        return this.m_nTimerTickMax;
    }

    private int GetTickMin() {
        return this.m_nTimerTickMin;
    }

    private int GetTickCount() {
        return this.m_nTimerTickCur;
    }

    private boolean SetTickCount(int nTickCount) {
        boolean bChanged = false;
        if (this.m_nTimerTickCur != nTickCount) {
            this.m_nTimerTickCur = nTickCount;
            bChanged = true;
        }
        if (bChanged) {
            this.OnUpdateTickCount();
        }
        return bChanged;
    }

    private void OnUpdateTickCount() {
        String sCompareBtnText = CString.LoadString("IDS_SYNC_COMPARE");
        if (this.GetTickCount() >= this.GetTickMin() && this.GetTickCount() < this.GetTickMax()) {
            sCompareBtnText = String.format("%s (%s)", sCompareBtnText, Integer.toString(this.GetTickCount()));
        }
        if (this.GetOptionsFrame() != null) {
            this.GetOptionsFrame().SetCompareBtnText(sCompareBtnText);
        }
    }

    private boolean IsTickExpired() {
        boolean bExpired = false;
        if (this.GetTickCount() <= this.GetTickMin()) {
            bExpired = true;
        }
        return bExpired;
    }

    public int GetCompressionType() {
        int nCompressionType = 0;
        if (CMainFrame.GET_APP() != null) {
            nCompressionType = CMainFrame.GET_APP().GetCompressionType();
        }
        return nCompressionType;
    }

    private void OnSaveAttrs() {
        IArchive rArchive = CMainFrame.GET_APP().GetArchive();
        if (rArchive != null) {
            rArchive.SetValue("DoNotShowSyncFolderExecute", this.m_bDoNotShowAgain, false);
        }
    }

    private void OnLoadAttrs() {
        IArchive rArchive = CMainFrame.GET_APP().GetArchive();
        if (rArchive != null) {
            this.m_bDoNotShowAgain = rArchive.GetValueBool("DoNotShowSyncFolderExecute", false);
        }
    }

    public void InitEscapeListeners() {
        if (this.m_cLocalFrame != null) {
            this.m_cLocalFrame.InitEscapeListeners();
        }
        if (this.m_cRemoteFrame != null) {
            this.m_cRemoteFrame.InitEscapeListeners();
        }
        if (this.m_cOptionsFrame != null) {
            this.m_cOptionsFrame.InitEscapeListeners();
        }
    }

    public void AddCloseListener(ActionListener rListener) {
        if (this.m_cOptionsFrame != null) {
            this.m_cOptionsFrame.AddCloseListener(rListener);
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 9025: {
                    this.OnInitialUpdate();
                    break;
                }
            }
        }
    }

    private void OnInitialUpdate() {
    }

    private int GetDefOptionsDockWidth() {
        String sLang;
        CClientInfo rClientInfo;
        int nDefWidth = 170;
        if (CMainFrame.GET_APP() != null && (rClientInfo = CMainFrame.GET_APP().GetClientInfo()) != null && (sLang = rClientInfo.GetLanguageCode()) != null && !sLang.isEmpty()) {
            sLang = sLang.toLowerCase();
            if (CFileSystemUtils.GetFileSysUtils().IsWindows()) {
                if (sLang.equals("ru")) {
                    nDefWidth += 30;
                }
            } else if (CFileSystemUtils.GetFileSysUtils().IsNIX()) {
                if (sLang.equals("ru")) {
                    nDefWidth += 50;
                }
            } else if (CFileSystemUtils.GetFileSysUtils().IsMac()) {
                if (sLang.equals("it")) {
                    nDefWidth += 30;
                } else if (sLang.equals("es") || sLang.equals("sr")) {
                    nDefWidth += 50;
                } else if (sLang.equals("ru")) {
                    nDefWidth += 80;
                }
            }
        }
        return nDefWidth;
    }

    private int GetDefOptionsDockHeight() {
        return 200;
    }

    public void SetArchiveKeyLocalColWidths(String sArchiveKey) {
        this.m_sArchiveKeyLocalColWidths = sArchiveKey;
    }

    public String GetArchiveKeyLocalColWidths() {
        return this.m_sArchiveKeyLocalColWidths;
    }

    public void SetArchiveKeyRemoteColWidths(String sArchiveKey) {
        this.m_sArchiveKeyRemoteColWidths = sArchiveKey;
    }

    public String GetArchiveKeyRemoteColWidths() {
        return this.m_sArchiveKeyRemoteColWidths;
    }

    public void OnWindowClosing() {
        CRhinoEvent event = new CRhinoEvent(this, 9400);
        this.processEvent(event);
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DOCKED = false;
    }
}

