/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.fvjv.syncFolders.CStatusBar;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncFolderPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class CSyncFolderFrame
extends CDockableFrame {
    private CSyncFolderPanel m_rSyncDockPanel;
    private CStatusBar m_cStatusBar;

    public CSyncFolderFrame(String sKey, DockableHolder rDockableHolderParent, int nInitMode, int nInitSide, File fInitialLayout, File fStoredLayout, String sArchiveKeyLocalColWidths, String sArchiveKeyRemoteColWidths) {
        super(sKey, rDockableHolderParent, nInitMode, nInitSide);
        this.InitVars(fInitialLayout, fStoredLayout, sArchiveKeyLocalColWidths, sArchiveKeyRemoteColWidths);
    }

    private void InitVars(File fInitialLayout, File fStoredLayout, String sArchiveKeyLocalColWidths, String sArchiveKeyRemoteColWidths) {
        String sTitle = CString.LoadString("IDS_SYNC_FOLDERS_MENU");
        this.setTitle(sTitle);
        this.setTabTitle(sTitle);
        this.setSideTitle(sTitle);
        this.setFrameIcon(CMainFrame.GetJARImage("FolderSync16.png"));
        this.m_cStatusBar = new CStatusBar();
        this.add((Component)this.m_cStatusBar, "South");
        this.InitDockPanel(fInitialLayout, fStoredLayout, sArchiveKeyLocalColWidths, sArchiveKeyRemoteColWidths);
        this.addDockableFrameListener(this);
        this.setDefaultCloseAction(2);
        if (this.GetDockPanel() != null) {
            this.GetDockPanel().SetStatusBar(this.GetStatusBar());
        }
    }

    private void InitDockPanel(File rInitialLayoutFile, File rStoredLayoutFile, String sArchiveKeyLocalColWidths, String sArchiveKeyRemoteColWidths) {
        RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this));
        this.m_rSyncDockPanel = new CSyncFolderPanel(rpc, this, rInitialLayoutFile, rStoredLayoutFile, sArchiveKeyLocalColWidths, sArchiveKeyRemoteColWidths);
        this.SetDockPanel(this.m_rSyncDockPanel);
        this.add(this.m_rSyncDockPanel);
    }

    @Override
    public CSyncFolderPanel GetDockPanel() {
        return (CSyncFolderPanel)super.GetDockPanel();
    }

    @Override
    public void dockableFrameActivated(DockableFrameEvent event) {
        super.dockableFrameActivated(event);
    }

    @Override
    public void dockableFrameDeactivated(DockableFrameEvent event) {
        super.dockableFrameDeactivated(event);
        if (this.GetDockPanel() != null) {
            this.GetDockPanel().getDockingManager().activateWorkspace();
        }
    }

    private CStatusBar GetStatusBar() {
        return this.m_cStatusBar;
    }

    public boolean SetLocalPath(CPath rLocalPath) {
        boolean bChanged = false;
        if (this.GetDockPanel() != null) {
            this.GetDockPanel().SetLocalPath(rLocalPath);
        }
        return bChanged;
    }

    public boolean SetRemotePath(CPath rRemotePath) {
        boolean bChanged = false;
        if (this.GetDockPanel() != null) {
            this.GetDockPanel().SetRemotePath(rRemotePath);
        }
        return bChanged;
    }

    public void OnCompare() {
        if (this.GetDockPanel() != null) {
            this.GetDockPanel().OnCompare();
        }
    }

    public void InitEscapeListeners() {
        if (this.m_rSyncDockPanel != null) {
            this.m_rSyncDockPanel.InitEscapeListeners();
        }
    }

    public void AddCloseListener(ActionListener rListener) {
        if (this.m_rSyncDockPanel != null) {
            this.m_rSyncDockPanel.AddCloseListener(rListener);
        }
    }

    public void OnWindowClosing() {
        if (this.m_rSyncDockPanel != null) {
            this.m_rSyncDockPanel.OnWindowClosing();
        }
    }
}

