/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.rhinosoft.base.gui.frames.CBaseStatusBar;
import com.rhinosoft.fvjv.gui.frames.CLookAndFeels;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class CStatusBar
extends CBaseStatusBar {
    private JProgressBar m_cProgressBar;
    private JButton m_cCancelBtn;

    public CStatusBar() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_cProgressBar = new JProgressBar();
        this.m_cCancelBtn = new JButton(CString.LoadString("IDS_CANCEL"));
        if (this.GetResizeArea() != null) {
            this.GetResizeArea().setIcon(CMainFrame.GetJARImage("Resize.png"));
        }
        this.LayoutControls();
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
        this.HideProgress();
    }

    private JProgressBar GetProgressBar() {
        return this.m_cProgressBar;
    }

    private JButton GetCancelBtn() {
        return this.m_cCancelBtn;
    }

    @Override
    protected void LayoutControls() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.GetStatusArea(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.GetProgressBar(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.GetCancelBtn(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Short.MAX_VALUE).addComponent(this.GetResizeArea(), -1, -2, -2));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetStatusArea(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetProgressBar(), 20, 20, 20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetCancelBtn(), 20, 20, 20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 22, 22)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetResizeArea(), -1, -2, -2)));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.IsWindowsOfficeLnF()) {
            Office2003Painter.getInstance().paintStatusBarBackground(this, g, rect, 0, 0);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.GetBackClr());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private boolean IsWindowsOfficeLnF() {
        return CLookAndFeels.IsWindowsOffice();
    }

    private Color GetBackClr() {
        Color clr = UIDefaultsLookup.getColor("Panel.background");
        if (clr == null) {
            clr = Color.LIGHT_GRAY;
        }
        return clr;
    }

    public void HideProgress() {
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setIndeterminate(false);
            this.GetProgressBar().setValue(0);
            this.GetProgressBar().setVisible(false);
        }
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().setVisible(false);
        }
        this.SetStatus("");
    }

    public void ShowProgress() {
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setIndeterminate(true);
            this.GetProgressBar().setVisible(true);
        }
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().setVisible(true);
        }
        this.SetStatus(CString.LoadString("IDS_SYNC_FOLDERS_COMPARING"));
    }

    public void ShowConfirming() {
        if (this.GetProgressBar() != null) {
            this.GetProgressBar().setIndeterminate(false);
            this.GetProgressBar().setVisible(true);
        }
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().setVisible(true);
        }
        this.SetStatus(CString.LoadString("IDS_SYNC_FOLDERS_CONFIRMING"));
    }

    public void AddCancelBtnListener(ActionListener rListener) {
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().addActionListener(rListener);
        }
    }

    public void RemoveCancelBtnListener(ActionListener rListener) {
        if (this.GetCancelBtn() != null) {
            this.GetCancelBtn().removeActionListener(rListener);
        }
    }
}

