/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.syncFolders;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.swing.JideButton;
import com.rhinosoft.base.CUtils;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.files.CPath;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.docking.CDockableBar;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.docking.fvjv.fileTree.CFileTree;
import com.rhinosoft.docking.fvjv.fileTree.CFileTreeEvent;
import com.rhinosoft.docking.fvjv.fileTree.IFileTreeListener;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncFoldersDlg;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTable;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableModel;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableRow;
import com.rhinosoft.docking.fvjv.syncFolders.CSyncTableSorter;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import com.rhinosoft.fvjv.threads.CBaseThread;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class CBaseFrame
extends CDockableFrame
implements IFileTreeListener,
ActionListener,
KeyListener {
    private static final String KEY_MAIN_TOOLBAR = "MainToolbar";
    public static final String KEY_TREE = "Tree";
    public static boolean DEBUG = CMainFrame.DEBUG;
    public static boolean DEBUG_ENABLE_TREE;
    private CDockableBar m_cMainToolbar;
    private JideButton m_cDoActionsBtn;
    private JideButton m_cRemoveBtn;
    private JPanel m_cPanel;
    private CDockableFrame m_cTreeFrame;
    private CFileTree m_cTree;
    private CSyncTable m_cTable;
    private CBaseThread m_tThread;
    private JLabel m_cTitleBarLabel;
    private String m_sArchiveKeyColWidths;

    public CBaseFrame(String sKey, DockableHolder rDockableHolderParent, int nInitMode, int nInitSide, boolean bIsLocal, String sArchiveKeyColWidths) {
        super(sKey, rDockableHolderParent, nInitMode, nInitSide);
        this.InitVars(bIsLocal, sArchiveKeyColWidths);
    }

    private void InitVars(boolean bIsLocal, String sArchiveKeyColWidths) {
        this.m_sArchiveKeyColWidths = sArchiveKeyColWidths;
        this.InitTitleBarComponent();
        this.m_tThread = this.CreateThread();
        this.m_cPanel = new JPanel();
        this.m_cPanel.setOpaque(false);
        this.setContentPane(this.m_cPanel);
        RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this));
        CDockablePanel cDockPanel = new CDockablePanel(rpc, this.m_cPanel);
        this.SetDockPanel(cDockPanel);
        this.m_cPanel.setLayout(new BorderLayout());
        this.m_cPanel.add((Component)this.GetDockPanel(), "Center");
        if (this.GetDockPanel().getDockingManager() != null) {
            this.GetDockPanel().getDockingManager().setShowWorkspace(true);
            this.GetDockPanel().getDockingManager().addDockableFrameListener(this);
        }
        if (DEBUG_ENABLE_TREE) {
            this.m_cTreeFrame = new CDockableFrame(KEY_TREE, this, 4, 8);
            if (this.GetDockPanel().getDockingManager() != null) {
                this.GetDockPanel().getDockingManager().addFrame(this.m_cTreeFrame);
            }
            this.m_cTree = new CFileTree();
            if (this.GetTree() != null) {
                this.GetTree().SetThread(this.GetThread());
                this.AddFileTreeListener(this);
            }
            this.m_cTreeFrame.add(this.m_cTree);
        }
        this.m_cTable = new CSyncTable(bIsLocal);
        if (this.GetDockPanel().getDockingManager() != null && this.GetDockPanel().getDockingManager().getWorkspace() != null) {
            this.GetDockPanel().getDockingManager().getWorkspace().add(this.m_cTable);
        }
        this.InitMainToolbar();
        this.addKeyListener(this);
    }

    protected void OnInitialUpdate() {
        if (this.GetTable() != null) {
            this.GetTable().OnInitialUpdate();
        }
    }

    protected CBaseThread CreateThread() {
        return null;
    }

    protected CBaseThread GetThread() {
        return this.m_tThread;
    }

    protected CDockableFrame GetTreeFrame() {
        return this.m_cTreeFrame;
    }

    public CFileTree GetTree() {
        return this.m_cTree;
    }

    public void SetTree(CFileTree rTree) {
        this.m_cTree = rTree;
        if (this.GetTree() != null) {
            // empty if block
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        if (this.GetTree() != null) {
            this.GetTree().dispatchEvent(event);
        }
    }

    public void SetRootNode(CFile fFile) {
        if (this.GetTree() != null) {
            this.GetTree().SetRootNode(fFile);
        }
    }

    public void SelectNode(CFile fFile, boolean bExpandTreeNode) {
        if (this.GetTree() != null) {
            this.GetTree().SelectNode(fFile, bExpandTreeNode);
        }
    }

    @Override
    public void TurnOnFocusClrs() {
        this.TurnOnTableFocusClrs();
    }

    @Override
    public void TurnOffFocusClrs() {
        this.TurnOffTableFocusClrs();
    }

    public void TurnOnTableFocusClrs() {
        if (this.GetTable() != null) {
            this.GetTable().TurnOnFocusClrs();
        }
    }

    public void TurnOffTableFocusClrs() {
        if (this.GetTable() != null) {
            this.GetTable().TurnOffFocusClrs();
        }
    }

    private CSyncTable GetTable() {
        return this.m_cTable;
    }

    @Override
    public void dockableFrameActivated(DockableFrameEvent event) {
        super.dockableFrameActivated(event);
        DockableFrame rActivated = event.getDockableFrame();
        if (rActivated != null) {
            this.TurnOffTableFocusClrs();
            if (rActivated == this.GetTreeFrame() && this.GetTree() != null) {
                this.GetTree().TurnOnFocusClrs();
            }
        }
    }

    @Override
    public void dockableFrameDeactivated(DockableFrameEvent event) {
        super.dockableFrameDeactivated(event);
        DockableFrame rDeactivated = event.getDockableFrame();
        if (rDeactivated != null) {
            boolean bIsWkspActive = rDeactivated.getDockingManager().isWorkspaceActive();
            DockableFrame rOpposite = event.getOppositeDockableFrame();
            if (rOpposite == null || bIsWkspActive) {
                boolean bIsActive;
                if (this.GetTreeFrame() != null) {
                    this.GetTree().TurnOffFocusClrs();
                }
                if (bIsActive = this.isActive()) {
                    this.TurnOnTableFocusClrs();
                }
            }
        }
    }

    @Override
    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = super.IsEventSource(objSource);
        if (!bIsEventSource && this.GetTree() != null && this.GetTree() == objSource) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.GetTable() != null) {
            bIsEventSource = this.GetTable().IsEventSource(objSource);
        }
        return bIsEventSource;
    }

    @Override
    protected void RelayEvent(AWTEvent event) {
        super.RelayEvent(event);
        switch (event.getID()) {
            case 6008: {
                CRhinoEvent rEvent;
                Object[] arObjs;
                if (!(event instanceof CRhinoEvent) || !this.IsEventSource((arObjs = (Object[])(rEvent = (CRhinoEvent)event).GetEventObj())[1])) break;
                if (this.GetTree() != null) {
                    this.GetTree().dispatchEvent(event);
                }
                if (!(arObjs[0] instanceof CFile)) break;
                CFile fWorkingDir = (CFile)arObjs[0];
                this.UpdateTitleBarText(fWorkingDir);
                break;
            }
            case 9025: {
                this.OnInitialUpdate();
                break;
            }
            case 6001: 
            case 6002: 
            case 6003: 
            case 6004: 
            case 6005: 
            case 6006: 
            case 6007: {
                if (this.GetTree() == null) break;
                this.GetTree().dispatchEvent(event);
                break;
            }
        }
    }

    @Override
    public void OnFileSelected(CFileTreeEvent rEvent) {
        if (rEvent.GetSelectedFile() != null) {
            this.UpdateTitleBarText(rEvent.GetSelectedFile());
        }
        this.ClearTable();
    }

    public void ClearTable() {
        if (this.GetTable() != null) {
            this.GetTable().ClearTable();
        }
    }

    protected CSyncTableModel GetModel() {
        CSyncTableModel rModel = null;
        if (this.GetTable() != null) {
            rModel = this.GetTable().GetModel();
        }
        return rModel;
    }

    public CPath GetCurrentWorkingPath() {
        CFile rPath = null;
        if (DEBUG_ENABLE_TREE) {
            if (this.GetTree() != null) {
                rPath = this.GetTree().GetSelectedFile();
            }
        } else if (CMainFrame.DEBUG) {
            CUtils.ASSERT(this.getClass().getName(), CUtils.GetLineNumber(), "Tree use is not enabled.  Therefore, this method should not be called to get the current working directory.", true);
        }
        return rPath;
    }

    public void AddFileTreeListener(IFileTreeListener rListener) {
        if (this.GetTree() != null) {
            this.GetTree().AddFileTreeListener(rListener);
        }
    }

    public void RemoveFileTreeListener(IFileTreeListener rListener) {
        if (this.GetTree() != null) {
            this.GetTree().RemoveFileTreeListener(rListener);
        }
    }

    protected void InitTitleBarComponent() {
        this.m_cTitleBarLabel = new JLabel(this.GetTitleBarText());
        this.setTitleLabelComponent(this.GetTitleBarComponent());
        this.setAvailableButtons(0);
    }

    protected String GetTitleBarText() {
        return "";
    }

    protected JLabel GetTitleBarComponent() {
        return this.m_cTitleBarLabel;
    }

    public void UpdateTitleBarText(CPath rPath) {
        String sText = this.GetTitleBarText();
        if (sText != null && rPath != null) {
            sText = String.format("%s - %s", sText, rPath.GetPath());
        }
        if (this.GetTitleBarComponent() != null) {
            this.GetTitleBarComponent().setText(sText);
        }
    }

    private void InitMainToolbar() {
        if (this.GetDockPanel() != null) {
            this.m_cMainToolbar = new CDockableBar(KEY_MAIN_TOOLBAR, this.GetDockPanel());
            if (this.GetMainToolbar() != null) {
                this.GetMainToolbar().setInitSide(1);
                this.GetDockPanel().getDockableBarManager().addDockableBar(this.GetMainToolbar());
                this.m_cRemoveBtn = new JideButton(CString.LoadString("IDS_SYNC_REMOVE_BTN"));
                if (this.GetRemoveBtn() != null) {
                    this.GetRemoveBtn().setToolTipText(CString.LoadString("IDS_SYNC_REMOVE_TIP"));
                    this.GetRemoveBtn().setIcon(CMainFrame.GetJARImage("Delete.png"));
                    this.GetRemoveBtn().addActionListener(this);
                    this.GetMainToolbar().add(this.GetRemoveBtn());
                }
                this.m_cDoActionsBtn = new JideButton(CString.LoadString("IDS_SYNC_EXECUTE_ACTIONS"));
                if (this.GetDoActionsBtn() != null) {
                    this.GetDoActionsBtn().setToolTipText(CString.LoadString("IDS_SYNC_EXECUTE_ACTIONS"));
                    this.GetDoActionsBtn().setIcon(this.GetSyncBtnIcon());
                    this.GetMainToolbar().add(this.GetDoActionsBtn());
                }
            }
        }
        this.ActivateActionsBtn(false);
    }

    private CDockableBar GetMainToolbar() {
        return this.m_cMainToolbar;
    }

    public JideButton GetDoActionsBtn() {
        return this.m_cDoActionsBtn;
    }

    private JideButton GetRemoveBtn() {
        return this.m_cRemoveBtn;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.GetRemoveBtn()) {
            this.RemoveSelectedRows();
        }
    }

    protected Icon GetSyncBtnIcon() {
        return null;
    }

    public void OnSort() {
        if (this.GetTable() != null) {
            this.GetTable().SortModel();
        }
    }

    public void AddSyncBtnListener(ActionListener rListener) {
        if (this.GetDoActionsBtn() != null) {
            this.GetDoActionsBtn().addActionListener(rListener);
        }
    }

    public void RemoveSyncBtnListener(ActionListener rListener) {
        if (this.GetDoActionsBtn() != null) {
            this.GetDoActionsBtn().removeActionListener(rListener);
        }
    }

    public void GetSortedActionList(Vector<CSyncTableRow> aActionList, int nSortCol) {
        if (aActionList != null) {
            if (this.GetTable() != null) {
                this.GetTable().GetData(aActionList);
            }
            CSyncTableSorter rSorter = new CSyncTableSorter(nSortCol, false);
            Collections.sort(aActionList, rSorter);
        }
    }

    public void CheckIsSynchronized(boolean bHasError) {
        if (this.GetModel() != null) {
            int nRowCount = this.GetModel().getRowCount();
            if (nRowCount < 1) {
                this.ActivateActionsBtn(false);
                CSyncTableRow rRow = new CSyncTableRow();
                if (!bHasError) {
                    rRow.SetFileName(CString.LoadString("IDS_SYNC_ACTION_SYNCHRONIZED"));
                    rRow.SetAction(CSyncTableRow.ROW_ACTION.SYNCHRONIZED);
                    rRow.SetResult(CSyncTableRow.ROW_RESULT.SYNCHRONIZED);
                } else {
                    rRow.SetFileName(CString.LoadString("IDS_SYNC_ACTION_ERROR"));
                    rRow.SetAction(CSyncTableRow.ROW_ACTION.ERROR);
                    rRow.SetResult(CSyncTableRow.ROW_RESULT.ERROR);
                }
                this.GetModel().AddRow(rRow);
            } else {
                this.ActivateActionsBtn(true);
            }
        }
    }

    @Override
    public void addKeyListener(KeyListener rListener) {
        super.addKeyListener(rListener);
        if (this.GetTable() != null) {
            this.GetTable().addKeyListener(rListener);
        }
    }

    public void RequestInitialFocus() {
        if (this.GetTable() != null) {
            this.GetTable().requestFocus();
        }
    }

    public void ActivateActionsBtn(boolean bActivate) {
        if (this.GetDoActionsBtn() != null) {
            this.GetDoActionsBtn().setEnabled(bActivate);
        }
    }

    public void RemoveRow(CPath rFromPath) {
        if (rFromPath != null && this.GetModel() != null) {
            this.GetModel().RemoveRow(rFromPath.GetPath(), rFromPath.IsLocal());
        }
    }

    public void RemoveSelectedRows() {
        if (this.GetTable() != null) {
            this.GetTable().RemoveSelectedRows();
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 127: {
                this.RemoveSelectedRows();
                break;
            }
        }
    }

    public void InitEscapeListeners() {
        CSyncFoldersDlg rDlg = (CSyncFoldersDlg)SwingUtilities.getAncestorOfClass(CSyncFoldersDlg.class, this);
        if (rDlg != null) {
            rDlg.AddEscapeKeyListener(this.m_cMainToolbar);
            rDlg.AddEscapeKeyListener(this.m_cRemoveBtn);
            rDlg.AddEscapeKeyListener(this.m_cPanel);
            rDlg.AddEscapeKeyListener(this.m_cTreeFrame);
            rDlg.AddEscapeKeyListener(this.m_cTree);
            rDlg.AddEscapeKeyListener(this.m_cTable);
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ENABLE_TREE = false;
    }
}

