/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.search;

import com.rhinosoft.base.files.CFileSystemUtils;
import com.rhinosoft.docking.fvjv.search.CDatePicker;
import com.rhinosoft.docking.fvjv.search.CSearchEvent;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class CSearchPopup
extends JDialog
implements ActionListener,
KeyListener {
    public static boolean DEBUG = CMainFrame.DEBUG;
    public static boolean DEBUG_PARSE_EXCEPTIONS;
    public static final int BITMASK_FILE_ATTRIB_NONE = 0;
    public static final int BITMASK_FILE_ATTRIB_READONLY = 2;
    public static final int BITMASK_FILE_ATTRIB_HIDDEN = 4;
    public static final int BITMASK_FILE_ATTRIB_COMPRESSED = 8;
    public static final int BITMASK_FILE_ATTRIB_ENCRYPTED = 16;
    public static final int BITMASK_FILE_ATTRIB_ALL = 30;
    public static final int INCLUDE_TYPE_DIRS_AND_FILES = 0;
    public static final int INCLUDE_TYPE_DIRS_ONLY = 1;
    public static final int INCLUDE_TYPE_FILES_ONLY = 2;
    private JPanel m_cSearchPanel;
    private boolean m_bFileDatesAllowed;
    private JComboBox m_cDateType;
    private JLabel m_cDateTypeLbl;
    private JComboBox m_cDateContext;
    private CDatePicker m_cDatePicker;
    private JLabel m_cSizeLbl;
    private JComboBox m_cSizeContext;
    private JTextField m_cSizeField;
    private JComboBox m_cSizeUnits;
    private JLabel m_cFileAttribLbl;
    private JCheckBox m_cFileAny;
    private JCheckBox m_cFileReadOnly;
    private JCheckBox m_cFileHidden;
    private JCheckBox m_cFileCompressed;
    private JCheckBox m_cFileEncrypted;
    private int m_nBitmaskFileAttribs;
    private JLabel m_cDirAndFilesLbl;
    private JComboBox m_cDirAndFiles;
    private JButton m_cSearchBtn;

    public CSearchPopup(boolean bIsRemote, ActionListener rSearchListener) {
        this.InitVars(bIsRemote, rSearchListener);
    }

    private void InitVars(boolean bIsRemote, ActionListener rSearchListener) {
        this.m_bFileDatesAllowed = bIsRemote;
        this.setUndecorated(true);
        this.InitSearchPanel(bIsRemote, rSearchListener);
        this.setContentPane(this.GetSearchPanel());
        this.addKeyListener(this);
        this.m_nBitmaskFileAttribs |= 0x1E;
        this.UpdateAttribCheckBoxes();
    }

    private JPanel GetSearchPanel() {
        return this.m_cSearchPanel;
    }

    private JComboBox GetDateTypeCombo() {
        return this.m_cDateType;
    }

    private JLabel GetDateTypeLabel() {
        return this.m_cDateTypeLbl;
    }

    private JComboBox GetDateContextCombo() {
        return this.m_cDateContext;
    }

    private CDatePicker GetDatePicker() {
        return this.m_cDatePicker;
    }

    private JLabel GetSizeLabel() {
        return this.m_cSizeLbl;
    }

    private JComboBox GetSizeContextCombo() {
        return this.m_cSizeContext;
    }

    private JTextField GetSizeField() {
        return this.m_cSizeField;
    }

    private JComboBox GetSizeUnitsCombo() {
        return this.m_cSizeUnits;
    }

    private JLabel GetFileAttribLabel() {
        return this.m_cFileAttribLbl;
    }

    private JCheckBox GetFileAnyCheckBox() {
        return this.m_cFileAny;
    }

    private JCheckBox GetFileReadOnlyCheckBox() {
        return this.m_cFileReadOnly;
    }

    private JCheckBox GetFileHiddenCheckBox() {
        return this.m_cFileHidden;
    }

    private JCheckBox GetFileCompressedCheckBox() {
        return this.m_cFileCompressed;
    }

    private JCheckBox GetFileEncryptedCheckBox() {
        return this.m_cFileEncrypted;
    }

    private JLabel GetDirAndFilesLabel() {
        return this.m_cDirAndFilesLbl;
    }

    private JComboBox GetDirAndFilesCombo() {
        return this.m_cDirAndFiles;
    }

    private JButton GetSearchBtn() {
        return this.m_cSearchBtn;
    }

    private void InitSearchPanel(boolean bIsRemote, ActionListener rSearchListener) {
        this.m_cSearchPanel = new JPanel();
        this.GetSearchPanel().setBorder(BorderFactory.createEtchedBorder(0));
        if (bIsRemote) {
            String[] asItems1 = new String[]{CString.LoadString("IDS_SEARCH_POPUP_DATE_MODIFIED"), CString.LoadString("IDS_SEARCH_POPUP_DATE_CREATED"), CString.LoadString("IDS_SEARCH_POPUP_DATE_LAST_ACCESSED")};
            this.m_cDateType = new JComboBox<String>(asItems1);
        } else {
            this.m_cDateTypeLbl = new JLabel(CString.LoadString("IDS_SEARCH_POPUP_DATE_MODIFIED"));
        }
        String[] asItems2 = new String[]{CString.LoadString("IDS_SEARCH_POPUP_DATE_ANY"), CString.LoadString("IDS_SEARCH_POPUP_DATE_IS"), CString.LoadString("IDS_SEARCH_POPUP_DATE_IS_AFTER"), CString.LoadString("IDS_SEARCH_POPUP_DATE_IS_BEFORE")};
        this.m_cDateContext = new JComboBox<String>(asItems2);
        this.GetDateContextCombo().addActionListener(this);
        if (CMainFrame.GET_APP() != null && CMainFrame.GET_APP().GetClientInfo() != null) {
            Locale locale = new Locale(CMainFrame.GET_APP().GetClientInfo().GetLanguageCode(), CMainFrame.GET_APP().GetClientInfo().GetCountryCode());
            this.m_cDatePicker = new CDatePicker(DateFormat.getDateInstance(3, locale));
        }
        if (this.m_cDatePicker == null) {
            this.m_cDatePicker = new CDatePicker(DateFormat.getDateInstance());
        }
        this.m_cSizeLbl = new JLabel(CString.LoadString("IDS_SEARCH_POPUP_SIZE"));
        String[] asItems3 = new String[]{CString.LoadString("IDS_SEARCH_POPUP_SIZE_ANY"), CString.LoadString("IDS_SEARCH_POPUP_SIZE_EQUALS"), CString.LoadString("IDS_SEARCH_POPUP_SIZE_IS_GREATER_THAN"), CString.LoadString("IDS_SEARCH_POPUP_SIZE_IS_LESS_THAN")};
        this.m_cSizeContext = new JComboBox<String>(asItems3);
        this.GetSizeContextCombo().addActionListener(this);
        this.m_cSizeField = new JTextField();
        String[] asItems4 = new String[]{CString.LoadString("IDS_SEARCH_POPUP_SIZE_BYTES"), CString.LoadString("IDS_SEARCH_POPUP_SIZE_KBS"), CString.LoadString("IDS_SEARCH_POPUP_SIZE_MBS"), CString.LoadString("IDS_SEARCH_POPUP_SIZE_GBS"), CString.LoadString("IDS_SEARCH_POPUP_SIZE_TBS")};
        this.m_cSizeUnits = new JComboBox<String>(asItems4);
        this.m_cFileAttribLbl = new JLabel(CString.LoadString("IDS_SEARCH_POPUP_FILE_ATTRIB"));
        this.m_cFileAny = new JCheckBox(CString.LoadString("IDS_SEARCH_POPUP_FILE_ATTRIB_ANY"));
        this.m_cFileReadOnly = new JCheckBox(CString.LoadString("IDS_SEARCH_POPUP_FILE_ATTRIB_READ_ONLY"));
        this.m_cFileHidden = new JCheckBox(CString.LoadString("IDS_SEARCH_POPUP_FILE_ATTRIB_HIDDEN"));
        this.m_cFileCompressed = new JCheckBox(CString.LoadString("IDS_SEARCH_POPUP_FILE_ATTRIB_COMPRESSED"));
        this.m_cFileEncrypted = new JCheckBox(CString.LoadString("IDS_SEARCH_POPUP_FILE_ATTRIB_ENCRYPTED"));
        this.m_cFileAny.addActionListener(this);
        this.m_cFileReadOnly.addActionListener(this);
        this.m_cFileHidden.addActionListener(this);
        this.m_cFileCompressed.addActionListener(this);
        this.m_cFileEncrypted.addActionListener(this);
        this.m_cDirAndFilesLbl = new JLabel(CString.LoadString("IDS_SEARCH_POPUP_DIR_AND_FILES_LBL"));
        String[] asItems6 = new String[]{CString.LoadString("IDS_SEARCH_POPUP_DIR_AND_FILES"), CString.LoadString("IDS_SEARCH_POPUP_DIR_ONLY"), CString.LoadString("IDS_SEARCH_POPUP_FILE_ONLY")};
        this.m_cDirAndFiles = new JComboBox<String>(asItems6);
        this.m_cSearchBtn = new JButton(CString.LoadString("IDS_SEARCH_POPUP_SEARCH_BTN"));
        if (this.GetSearchBtn() != null) {
            this.GetSearchBtn().addActionListener(rSearchListener);
        }
        this.EnableDateControls(false);
        this.EnableSizeControls(false);
        GroupLayout layout = new GroupLayout(this.GetSearchPanel());
        this.GetSearchPanel().setLayout(layout);
        layout.setAutoCreateGaps(true);
        Dimension dimSize = this.GetDatePicker().getPreferredSize();
        if (!CFileSystemUtils.GetFileSysUtils().IsWindows()) {
            dimSize = this.GetDateContextCombo().getPreferredSize();
        }
        JComponent[] arComps = new JComponent[]{this.GetDateContextCombo(), this.GetDateTypeCombo(), this.GetDateTypeLabel(), this.GetDatePicker(), this.GetSizeLabel(), this.GetSizeContextCombo(), this.GetSizeField(), this.GetSizeUnitsCombo()};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            JComponent rSizeComp = arComps[nIdx];
            if (rSizeComp == null) continue;
            Dimension dimAdjSize = new Dimension(rSizeComp.getPreferredSize().width, dimSize.height);
            rSizeComp.setPreferredSize(dimAdjSize);
        }
        JComponent[] arComps2 = new JComponent[]{this.GetDatePicker(), this.GetSizeContextCombo(), this.GetSizeField(), this.GetSizeUnitsCombo()};
        for (int nIdx = 0; nIdx < arComps2.length; ++nIdx) {
            JComponent rSizeComp = arComps2[nIdx];
            if (rSizeComp == null) continue;
            Dimension dimAdjSize = new Dimension(60, dimSize.height);
            rSizeComp.setMinimumSize(dimAdjSize);
        }
        JComponent[] arComps3 = new JComponent[]{this.GetDateContextCombo(), this.GetDateTypeCombo(), this.GetDatePicker(), this.GetSizeContextCombo(), this.GetSizeField(), this.GetSizeUnitsCombo(), this.GetSearchBtn()};
        for (int nIdx = 0; nIdx < arComps3.length; ++nIdx) {
            JComponent rNextComp = arComps3[nIdx];
            if (rNextComp == null) continue;
            rNextComp.addKeyListener(this);
        }
        JComponent[] arComps4 = new JComponent[]{this.GetFileAttribLabel(), this.GetFileReadOnlyCheckBox(), this.GetFileHiddenCheckBox(), this.GetFileCompressedCheckBox(), this.GetFileEncryptedCheckBox()};
        for (int nIdx = 0; nIdx < arComps4.length; ++nIdx) {
            JComponent rSizeComp = arComps4[nIdx];
            if (rSizeComp == null) continue;
            Dimension dimAdjSize = new Dimension(60, dimSize.height);
            rSizeComp.setMinimumSize(dimAdjSize);
        }
        JComponent[] arComps5 = new JComponent[]{this.GetDirAndFilesLabel(), this.GetDirAndFilesCombo()};
        for (int nIdx = 0; nIdx < arComps5.length; ++nIdx) {
            JComponent rSizeComp = arComps5[nIdx];
            if (rSizeComp == null) continue;
            Dimension dimAdjSize = new Dimension(60, dimSize.height);
            rSizeComp.setMinimumSize(dimAdjSize);
        }
        layout.setHorizontalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.GetFileDatesAllowed() ? this.GetDateTypeCombo() : this.GetDateTypeLabel(), -1, -2, -2).addComponent(this.GetDateContextCombo(), -1, -2, -2).addComponent(this.GetDatePicker(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.GetSizeLabel(), -1, -2, -2).addComponent(this.GetSizeContextCombo(), -1, -2, -2).addComponent(this.GetSizeField(), -1, -2, Short.MAX_VALUE).addComponent(this.GetSizeUnitsCombo(), -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.GetFileAttribLabel(), -1, -2, -2).addComponent(this.GetFileAnyCheckBox(), -1, -2, -2).addComponent(this.GetFileReadOnlyCheckBox(), -1, -2, -2).addComponent(this.GetFileHiddenCheckBox(), -1, -2, Short.MAX_VALUE).addComponent(this.GetFileCompressedCheckBox(), -1, -2, -2).addComponent(this.GetFileEncryptedCheckBox(), -1, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(this.GetDirAndFilesLabel(), -1, -2, -2).addComponent(this.GetDirAndFilesCombo(), -1, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(this.GetSearchBtn(), -1, -2, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5));
        layout.setVerticalGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addGroup(layout.createParallelGroup().addComponent(this.GetFileDatesAllowed() ? this.GetDateTypeCombo() : this.GetDateTypeLabel(), -1, -2, -2).addComponent(this.GetDateContextCombo(), -1, -2, -2).addComponent(this.GetDatePicker(), -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.GetSizeLabel(), -1, -2, -2).addComponent(this.GetSizeContextCombo(), -1, -2, -2).addComponent(this.GetSizeField(), -1, -2, -2).addComponent(this.GetSizeUnitsCombo(), -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.GetFileAttribLabel(), -1, -2, -2).addComponent(this.GetFileAnyCheckBox(), -1, -2, -2).addComponent(this.GetFileReadOnlyCheckBox(), -1, -2, -2).addComponent(this.GetFileHiddenCheckBox(), -1, -2, -2).addComponent(this.GetFileCompressedCheckBox(), -1, -2, -2).addComponent(this.GetFileEncryptedCheckBox(), -1, -2, -2)).addGroup(layout.createParallelGroup().addComponent(this.GetDirAndFilesLabel(), -1, -2, -2).addComponent(this.GetDirAndFilesCombo(), -1, -2, -2)).addComponent(this.GetSearchBtn(), -1, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5));
        if (CFileSystemUtils.GetFileSysUtils().IsWindows() && !bIsRemote) {
            this.GetFileCompressedCheckBox().setVisible(false);
            this.GetFileEncryptedCheckBox().setVisible(false);
        }
    }

    private boolean GetFileDatesAllowed() {
        return this.m_bFileDatesAllowed;
    }

    private void EnableDateControls(boolean bEnable) {
        JComponent[] aComps = new JComponent[]{this.GetDatePicker()};
        for (int nIdx = 0; nIdx < aComps.length; ++nIdx) {
            JComponent rComp = aComps[nIdx];
            if (rComp == null) continue;
            rComp.setEnabled(bEnable);
        }
        if (this.GetDatePicker() != null) {
            if (bEnable) {
                this.GetDatePicker().ShowDefaultDate();
            } else {
                this.GetDatePicker().ClearText();
            }
        }
    }

    private void EnableSizeControls(boolean bEnable) {
        JComponent[] aComps = new JComponent[]{this.GetSizeField(), this.GetSizeUnitsCombo()};
        for (int nIdx = 0; nIdx < aComps.length; ++nIdx) {
            JComponent rComp = aComps[nIdx];
            if (rComp == null) continue;
            rComp.setEnabled(bEnable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.GetDateContextCombo()) {
            boolean bEnableControls = this.GetDateContextCombo().getSelectedIndex() != 0;
            this.EnableDateControls(bEnableControls);
        } else if (event.getSource() == this.GetSizeContextCombo()) {
            boolean bEnableControls = this.GetSizeContextCombo().getSelectedIndex() != 0;
            this.EnableSizeControls(bEnableControls);
        } else if (event.getSource() == this.GetFileAnyCheckBox()) {
            this.GetFileAnyCheckBox().setSelected(true);
            if (this.GetFileReadOnlyCheckBox() != null) {
                this.GetFileReadOnlyCheckBox().setSelected(false);
            }
            if (this.GetFileHiddenCheckBox() != null) {
                this.GetFileHiddenCheckBox().setSelected(false);
            }
            if (this.GetFileCompressedCheckBox() != null) {
                this.GetFileCompressedCheckBox().setSelected(false);
            }
            if (this.GetFileEncryptedCheckBox() != null) {
                this.GetFileEncryptedCheckBox().setSelected(false);
            }
            this.UpdateAttribVar();
        } else if (event.getSource() == this.GetFileReadOnlyCheckBox() || event.getSource() == this.GetFileHiddenCheckBox() || event.getSource() == this.GetFileCompressedCheckBox() || event.getSource() == this.GetFileEncryptedCheckBox()) {
            if (this.GetFileAnyCheckBox() != null) {
                this.GetFileAnyCheckBox().setSelected(false);
            }
            if (!(this.GetFileReadOnlyCheckBox().isSelected() || this.GetFileHiddenCheckBox().isSelected() || this.GetFileCompressedCheckBox().isSelected() || this.GetFileEncryptedCheckBox().isSelected())) {
                this.GetFileAnyCheckBox().setSelected(true);
            }
            this.UpdateAttribVar();
        }
    }

    public boolean CanDeactivate() {
        boolean bCanDeactivate = true;
        if (this.GetDatePicker() != null && !this.GetDatePicker().CanDeactivate()) {
            bCanDeactivate = false;
        }
        return bCanDeactivate;
    }

    public CSearchEvent CreateSearchEvent(Object objSource) {
        this.UpdateAttribVar();
        CSearchEvent SearchEvent = new CSearchEvent(objSource);
        SearchEvent.SetDateType(this.GetDateType());
        SearchEvent.SetDateContext(this.GetDateContext());
        SearchEvent.SetFileDate(this.GetSearchDate());
        SearchEvent.SetSizeContext(this.GetSizeContext());
        SearchEvent.SetFileSize(this.GetSearchFileSize());
        SearchEvent.SetDirAndFilesOpt(this.GetDirAndFilesOpt());
        SearchEvent.SetBitmaskFileAttribs(this.GetBitmaskFileAttribs());
        return SearchEvent;
    }

    private CSearchEvent.DATE_TYPE GetDateType() {
        CSearchEvent.DATE_TYPE nDateType = CSearchEvent.DATE_TYPE.MODIFIED;
        if (this.GetFileDatesAllowed() && this.GetDateContextCombo() != null) {
            switch (this.GetDateContextCombo().getSelectedIndex()) {
                case 0: {
                    nDateType = CSearchEvent.DATE_TYPE.MODIFIED;
                    break;
                }
                case 1: {
                    nDateType = CSearchEvent.DATE_TYPE.CREATED;
                    break;
                }
                case 2: {
                    nDateType = CSearchEvent.DATE_TYPE.ACCESSED;
                    break;
                }
            }
        }
        return nDateType;
    }

    private CSearchEvent.DATE_CONTEXT GetDateContext() {
        CSearchEvent.DATE_CONTEXT nContext = CSearchEvent.DATE_CONTEXT.ANY;
        if (this.GetDateContextCombo() != null) {
            switch (this.GetDateContextCombo().getSelectedIndex()) {
                case 0: {
                    nContext = CSearchEvent.DATE_CONTEXT.ANY;
                    break;
                }
                case 1: {
                    nContext = CSearchEvent.DATE_CONTEXT.EQUALS;
                    break;
                }
                case 2: {
                    nContext = CSearchEvent.DATE_CONTEXT.IS_BEFORE;
                    break;
                }
                case 3: {
                    nContext = CSearchEvent.DATE_CONTEXT.IS_AFTER;
                    break;
                }
            }
        }
        return nContext;
    }

    private long GetSearchDate() {
        long lSearchDate = -1L;
        if (this.GetDatePicker() != null) {
            lSearchDate = this.GetDatePicker().GetDate();
        }
        return lSearchDate;
    }

    private CSearchEvent.SIZE_CONTEXT GetSizeContext() {
        CSearchEvent.SIZE_CONTEXT nContext = CSearchEvent.SIZE_CONTEXT.ANY;
        if (this.GetSizeContextCombo() != null) {
            switch (this.GetSizeContextCombo().getSelectedIndex()) {
                case 0: {
                    nContext = CSearchEvent.SIZE_CONTEXT.ANY;
                    break;
                }
                case 1: {
                    nContext = CSearchEvent.SIZE_CONTEXT.EQUALS;
                    break;
                }
                case 2: {
                    nContext = CSearchEvent.SIZE_CONTEXT.IS_GREATER_THAN;
                    break;
                }
                case 3: {
                    nContext = CSearchEvent.SIZE_CONTEXT.IS_LESS_THAN;
                    break;
                }
            }
        }
        return nContext;
    }

    private long GetSearchFileSize() {
        long lSearchFileSize = -1L;
        if (this.GetSizeField() != null && this.GetSizeUnitsCombo() != null) {
            long lValue;
            block12: {
                lValue = -1L;
                try {
                    Long lTemp = Long.parseLong(this.GetSizeField().getText());
                    if (lTemp != null) {
                        lValue = lTemp;
                    }
                }
                catch (Exception e) {
                    if (!DEBUG_PARSE_EXCEPTIONS) break block12;
                    e.printStackTrace();
                }
            }
            if (lValue > -1L) {
                int nMultiplier = this.GetSizeUnitsCombo().getSelectedIndex();
                switch (nMultiplier) {
                    case 0: {
                        lSearchFileSize = lValue;
                        break;
                    }
                    case 1: {
                        lSearchFileSize = lValue * 1024L;
                        break;
                    }
                    case 2: {
                        lSearchFileSize = lValue * 0x100000L;
                        break;
                    }
                    case 3: {
                        lSearchFileSize = lValue * 0x40000000L;
                        break;
                    }
                    case 4: {
                        lSearchFileSize = lValue * 0x40000000L * 1024L;
                        break;
                    }
                }
            }
        }
        return lSearchFileSize;
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            if (this.GetSearchBtn() != null) {
                this.GetSearchBtn().doClick();
            }
        } else if (event.getKeyCode() == 27) {
            boolean bHidePopup = true;
            if (event.getSource() instanceof JComboBox) {
                JComboBox rCombo = (JComboBox)event.getSource();
                boolean bl = bHidePopup = !rCombo.isPopupVisible();
            }
            if (bHidePopup) {
                this.setVisible(false);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    public void EnableSearchBtn() {
        if (this.GetSearchBtn() != null) {
            this.GetSearchBtn().setEnabled(true);
        }
    }

    public void DisableSearchBtn() {
        if (this.GetSearchBtn() != null) {
            this.GetSearchBtn().setEnabled(false);
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource) {
            for (int nIdx = 0; nIdx < this.getComponentCount(); ++nIdx) {
                Component rComp = this.getComponent(nIdx);
                if (rComp == null || rComp != objSource) continue;
                bIsEventSource = true;
                break;
            }
        }
        if (!bIsEventSource && this.GetDatePicker() != null) {
            bIsEventSource = this.GetDatePicker().IsEventSource(objSource);
        }
        return bIsEventSource;
    }

    private void UpdateAttribCheckBoxes() {
        if (this.GetFileAnyCheckBox() != null && this.GetFileReadOnlyCheckBox() != null && this.GetFileHiddenCheckBox() != null && this.GetFileCompressedCheckBox() != null && this.GetFileEncryptedCheckBox() != null) {
            boolean bAny;
            this.GetFileAnyCheckBox().setSelected(false);
            this.GetFileReadOnlyCheckBox().setSelected(false);
            this.GetFileHiddenCheckBox().setSelected(false);
            this.GetFileCompressedCheckBox().setSelected(false);
            this.GetFileEncryptedCheckBox().setSelected(false);
            boolean bl = bAny = (this.m_nBitmaskFileAttribs & 0x1E) == 30;
            if (bAny) {
                this.GetFileAnyCheckBox().setSelected(true);
            } else {
                boolean bReadOnly = (this.m_nBitmaskFileAttribs & 2) == 2;
                boolean bHidden = (this.m_nBitmaskFileAttribs & 4) == 4;
                boolean bCompressed = (this.m_nBitmaskFileAttribs & 8) == 8;
                boolean bEncrypted = (this.m_nBitmaskFileAttribs & 0x10) == 16;
                this.GetFileReadOnlyCheckBox().setSelected(bReadOnly);
                this.GetFileHiddenCheckBox().setSelected(bHidden);
                this.GetFileCompressedCheckBox().setSelected(bCompressed);
                this.GetFileEncryptedCheckBox().setSelected(bEncrypted);
            }
        }
    }

    private void UpdateAttribVar() {
        boolean bAny = true;
        boolean bReadOnly = false;
        boolean bHidden = false;
        boolean bCompressed = false;
        boolean bEncrypted = false;
        if (this.GetFileAnyCheckBox() != null && this.GetFileReadOnlyCheckBox() != null && this.GetFileHiddenCheckBox() != null && this.GetFileCompressedCheckBox() != null && this.GetFileEncryptedCheckBox() != null) {
            bAny = this.GetFileAnyCheckBox().isSelected();
            bReadOnly = this.GetFileReadOnlyCheckBox().isSelected();
            bHidden = this.GetFileHiddenCheckBox().isSelected();
            bCompressed = this.GetFileCompressedCheckBox().isSelected();
            bEncrypted = this.GetFileEncryptedCheckBox().isSelected();
        }
        if (bAny) {
            this.m_nBitmaskFileAttribs |= 0x1E;
        } else {
            this.m_nBitmaskFileAttribs &= 0xFFFFFFE1;
            this.m_nBitmaskFileAttribs = bReadOnly ? (this.m_nBitmaskFileAttribs |= 2) : (this.m_nBitmaskFileAttribs &= 0xFFFFFFFD);
            this.m_nBitmaskFileAttribs = bHidden ? (this.m_nBitmaskFileAttribs |= 4) : (this.m_nBitmaskFileAttribs &= 0xFFFFFFFB);
            this.m_nBitmaskFileAttribs = bCompressed ? (this.m_nBitmaskFileAttribs |= 8) : (this.m_nBitmaskFileAttribs &= 0xFFFFFFF7);
            this.m_nBitmaskFileAttribs = bEncrypted ? (this.m_nBitmaskFileAttribs |= 0x10) : (this.m_nBitmaskFileAttribs &= 0xFFFFFFEF);
        }
    }

    private int GetBitmaskFileAttribs() {
        return this.m_nBitmaskFileAttribs;
    }

    private int GetDirAndFilesOpt() {
        int nOpt = 0;
        if (this.GetDirAndFilesCombo() != null) {
            nOpt = this.GetDirAndFilesCombo().getSelectedIndex();
        }
        return nOpt;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PARSE_EXCEPTIONS = false;
    }
}

