/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.media;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.listing.CFileListTableModel;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.renderers.files.CFileTableCellRenderer;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.docking.fvjv.media.CMediaDockPanel;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class CMediaPlaylistFrame
extends CDockableFrame
implements ListSelectionListener,
MouseListener {
    public static boolean DEBUG = CMainFrame.DEBUG;
    private JScrollPane m_Scroller;
    private JTable m_Table;
    private CFileListTableModel m_Model;

    public CMediaPlaylistFrame(String sKey, CMediaDockPanel rDockableFrameHolderParent) {
        super(sKey, rDockableFrameHolderParent, 4, 8);
        this.InitVars();
    }

    private void InitVars() {
        this.m_Model = new CFileListTableModel(false);
        this.m_Table = new JTable(this.m_Model);
        if (this.m_Table.getColumnModel() != null) {
            for (int nCol = this.m_Table.getColumnModel().getColumnCount() - 1; nCol >= 0; --nCol) {
                TableColumn rColumn = this.m_Table.getColumnModel().getColumn(nCol);
                if (rColumn == null) continue;
                rColumn.setCellRenderer(new CFileTableCellRenderer());
                if (nCol != 2 && nCol != 3) continue;
                this.m_Table.removeColumn(rColumn);
            }
        }
        this.m_Table.getSelectionModel().addListSelectionListener(this);
        this.m_Table.addMouseListener(this);
        this.m_Scroller = new JScrollPane(this.m_Table);
        RootPaneContainer rootContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this));
        this.SetDockPanel(new CDockablePanel(rootContainer, this));
        this.setContentPane(this.m_Scroller);
    }

    @Override
    protected CMediaDockPanel GetDockableFrameHolderParent() {
        return (CMediaDockPanel)super.GetDockableFrameHolderParent();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
    }

    private void MoveLeadSelRow(int nSpots, boolean bLoopIndex, boolean bPlay) {
        if (this.m_Table != null) {
            int nSelIdx = this.m_Table.getSelectionModel().getLeadSelectionIndex();
            nSelIdx += nSpots;
            if (bLoopIndex) {
                if (nSelIdx < 0) {
                    nSelIdx = this.m_Table.getRowCount() - 1;
                } else if (nSelIdx > this.m_Table.getRowCount() - 1) {
                    nSelIdx = 0;
                }
            }
            if (nSelIdx >= 0 && nSelIdx < this.m_Table.getRowCount()) {
                this.m_Table.setRowSelectionInterval(nSelIdx, nSelIdx);
            }
            if (bPlay && this.GetFileModel() != null) {
                CFile fFile = (CFile)this.GetFileModel().getValueAt(nSelIdx, 0);
                this.PlayFile(fFile);
            }
        }
    }

    public void OnPreviousBtn() {
        this.MoveLeadSelRow(-1, true, true);
    }

    public void OnNextBtn() {
        this.MoveLeadSelRow(1, true, true);
    }

    private CFileListTableModel GetFileModel() {
        return this.m_Model;
    }

    @Override
    public void processEvent(AWTEvent event) {
        super.processEvent(event);
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 8043: {
                    if (!this.IsEventSourceParent(event.getSource())) break;
                    this.MoveLeadSelRow(1, false, true);
                    break;
                }
                case 8101: {
                    if (!(rEvent.GetEventObj() instanceof CFile[])) break;
                    CFile[] afSelFiles = (CFile[])rEvent.GetEventObj();
                    for (int nIdx = 0; nIdx < afSelFiles.length; ++nIdx) {
                        this.AddFile(afSelFiles[nIdx]);
                    }
                    break;
                }
                case 8020: {
                    if (!this.IsEventSourceParent(event.getSource())) break;
                    this.OnPlaylistRemoveSelItems();
                    break;
                }
            }
        }
    }

    private void AddFile(CFile fFile) {
        if (this.GetFileModel() != null) {
            this.GetFileModel().AddFile(fFile, true);
        }
    }

    public boolean IsEventSourceParent(Object objSource) {
        boolean bIsEventSource = false;
        if (this.GetDockableFrameHolderParent() != null && this.GetDockableFrameHolderParent().GetParent() != null) {
            bIsEventSource = this.GetDockableFrameHolderParent().GetParent().IsEventSource(objSource);
        }
        return bIsEventSource;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Point ptLoc;
        int nRow;
        if (event.getClickCount() == 2 && CMediaPlaylistFrame.IsValid(this.m_Table) && (nRow = this.m_Table.rowAtPoint(ptLoc = event.getPoint())) >= 0 && nRow < this.m_Table.getRowCount() && CMediaPlaylistFrame.IsValid(this.GetFileModel())) {
            CFile fFile = (CFile)this.GetFileModel().getValueAt(nRow, 0);
            this.PlayFile(fFile);
            event.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private void PlayFile(CFile fFile) {
        if (CMediaPlaylistFrame.IsValid(fFile)) {
            URL url = fFile.GetPreviewURL(false, 100, 100);
            try {
                if (this.GetDockableFrameHolderParent() != null) {
                    this.GetDockableFrameHolderParent().OnLoadURI(url.toURI(), true);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to change URL to URI for media");
            }
        }
    }

    public void PlayLeadFile() {
        int nSelRow;
        if (this.m_Table != null && (nSelRow = this.m_Table.getSelectionModel().getLeadSelectionIndex()) >= 0 && nSelRow < this.m_Table.getRowCount() && this.GetFileModel() != null) {
            CFile fFile = (CFile)this.GetFileModel().getValueAt(nSelRow, 0);
            this.PlayFile(fFile);
        }
    }

    private void OnPlaylistRemoveSelItems() {
        int[] anSelRows;
        if (this.m_Table != null && this.GetFileModel() != null && (anSelRows = this.m_Table.getSelectedRows()) != null && anSelRows.length > 0) {
            int nIdx;
            CFile[] aRemoveFiles = new CFile[anSelRows.length];
            for (nIdx = 0; nIdx < anSelRows.length; ++nIdx) {
                aRemoveFiles[nIdx] = (CFile)this.GetFileModel().getValueAt(anSelRows[nIdx], 0);
            }
            for (nIdx = 0; nIdx < aRemoveFiles.length; ++nIdx) {
                this.GetFileModel().RemoveFile(aRemoveFiles[nIdx], true);
            }
        }
    }
}

