/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking.fvjv.media;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.docking.DockableFrame;
import com.rhinosoft.base.gui.CDualSlider;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.docking.CDockablePanel;
import com.rhinosoft.docking.fvjv.media.CMediaDockFrame;
import com.rhinosoft.docking.fvjv.media.CMediaPlaylistFrame;
import com.rhinosoft.docking.fvjv.media.CMediaToolbar;
import com.rhinosoft.media.CMediaThread;
import com.rhinosoft.media.CMediaThreadMsg;
import com.rhinosoft.media.CRhinoMediaPlayer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;

public class CMediaDockPanel
extends CDockablePanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    public static boolean DEBUG = false;
    public static boolean DEBUG_THUMB_TRACK;
    private CommandBar m_Toolbar;
    private CMediaPlaylistFrame m_PlaylistFrame;
    private CMediaThread m_MediaThread;
    private CRhinoMediaPlayer m_MediaPlayer;
    private static final double PERCENT_RANGE = 1000.0;
    private CDualSlider m_DualSlider;
    private Timer m_OnUpdateSliderTimer;
    private Timer m_OnSetMediaTimeTimer;
    private int m_nMousePointX;

    public CMediaDockPanel(RootPaneContainer rootPaneContainer, CMediaDockFrame rParent) {
        super(rootPaneContainer, rParent);
        this.InitVars();
    }

    public CMediaDockPanel(RootPaneContainer rootPaneContainer, JComponent rParent, File rInitialLayout, File rStoredLayout) {
        super(rootPaneContainer, rParent, rInitialLayout, rStoredLayout);
        this.InitVars();
    }

    private void InitVars() {
        this.m_MediaPlayer = new CRhinoMediaPlayer();
        this.m_MediaPlayer.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getDockingManager().getWorkspace().setLayout(new BorderLayout());
        this.getDockingManager().getWorkspace().add((Component)this.m_MediaPlayer, "Center");
        this.m_DualSlider = new CDualSlider(0, 1000, 0, 1000);
        this.getDockingManager().getWorkspace().add((Component)this.m_DualSlider, "South");
        this.m_DualSlider.addMouseListener(this);
        this.m_DualSlider.addMouseMotionListener(this);
        this.m_OnUpdateSliderTimer = new Timer(1000, this);
        this.StartOnUpdateSliderTimer();
        this.m_OnSetMediaTimeTimer = new Timer(1000, this);
        this.m_MediaThread = new CMediaThread(this, "MediaThread");
        this.m_MediaThread.start();
    }

    @Override
    protected CMediaDockFrame GetParent() {
        return (CMediaDockFrame)super.GetParent();
    }

    protected CommandBar GetToolbar() {
        return this.m_Toolbar;
    }

    protected void SetToolbar(CommandBar rToolbar) {
        if (this.m_Toolbar != null && !this.GetUsingLayoutFiles()) {
            this.RemoveDockableBar(this.m_Toolbar);
        }
        this.m_Toolbar = rToolbar;
        if (!this.GetUsingLayoutFiles()) {
            this.AddDockableBar(this.m_Toolbar);
        }
    }

    protected void SetPlaylistFrame(CMediaPlaylistFrame rPlaylistFrame) {
        if (this.m_PlaylistFrame != null && !this.GetUsingLayoutFiles()) {
            this.RemoveDockableFrame(this.m_PlaylistFrame);
        }
        this.m_PlaylistFrame = rPlaylistFrame;
        if (!this.GetUsingLayoutFiles()) {
            this.AddDockableFrame(this.m_PlaylistFrame);
        }
    }

    protected CMediaPlaylistFrame GetPlaylistFrame() {
        return this.m_PlaylistFrame;
    }

    protected CRhinoMediaPlayer GetMediaPlayer() {
        return this.m_MediaPlayer;
    }

    @Override
    protected void RelayEvent(AWTEvent event) {
        super.RelayEvent(event);
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 8040: {
                    CMediaThreadMsg rMsg;
                    if (!this.IsEventSource(event.getSource()) || !(rEvent.GetEventObj() instanceof CMediaThreadMsg) || !(rMsg = (CMediaThreadMsg)rEvent.GetEventObj()).GetPlayWhenLoaded() || !CMediaDockPanel.IsValid(this.GetMediaPlayer())) break;
                    this.GetMediaPlayer().Play();
                    break;
                }
                case 8041: {
                    if (!this.IsEventSource(event.getSource())) break;
                    JOptionPane.showMessageDialog(this, "Media could not be loaded into the MediaPlayer.", "Media Failure", 0);
                    break;
                }
            }
        }
    }

    public void OnLoadURI(URI uri, boolean bPlayWhenLoaded) {
        if (CMediaDockPanel.IsValid(this.m_MediaThread)) {
            this.m_MediaThread.PostLoadURI(this, this.m_MediaPlayer, uri, bPlayWhenLoaded);
        }
    }

    public void OnPlayBtn() {
        if (this.GetMediaPlayer() != null) {
            if (this.GetMediaPlayer().HasSource()) {
                this.GetMediaPlayer().Play();
            } else if (this.GetPlaylistFrame() != null) {
                this.GetPlaylistFrame().PlayLeadFile();
            }
        }
    }

    public void OnPauseBtn() {
        if (this.GetMediaPlayer() != null) {
            this.GetMediaPlayer().Pause();
        }
    }

    public void OnStopBtn() {
        if (this.GetMediaPlayer() != null) {
            this.GetMediaPlayer().Stop();
        }
    }

    public void OnPreviousBtn() {
        if (this.GetPlaylistFrame() != null) {
            this.GetPlaylistFrame().OnPreviousBtn();
        }
    }

    public void OnNextBtn() {
        if (this.GetPlaylistFrame() != null) {
            this.GetPlaylistFrame().OnNextBtn();
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 8042: {
                    if (!this.IsEventSource(event.getSource()) || !(rEvent.GetEventObj() instanceof Double)) break;
                    double dDuration = (Double)rEvent.GetEventObj();
                    if (this.GetSlider() == null) break;
                    double dPercentage = dDuration * 1000.0 / dDuration;
                    dPercentage = Math.floor(dPercentage);
                    this.GetSlider().SetHighExtent((int)dPercentage);
                    break;
                }
                case 8006: 
                case 8008: 
                case 8014: 
                case 8016: {
                    break;
                }
                case 8018: {
                    if (!this.IsEventSource(event.getSource())) break;
                    this.OnShowPlaylistFrame();
                    break;
                }
                case 8010: {
                    if (!this.IsEventSource(event.getSource())) break;
                    this.OnPreviousBtn();
                    break;
                }
                case 8000: {
                    if (!this.IsEventSource(event.getSource())) break;
                    this.OnPlayBtn();
                    break;
                }
                case 8002: {
                    if (!this.IsEventSource(event.getSource())) break;
                    this.OnPauseBtn();
                    break;
                }
                case 8004: {
                    if (!this.IsEventSource(event.getSource())) break;
                    this.OnStopBtn();
                    break;
                }
                case 8012: {
                    if (!this.IsEventSource(event.getSource())) break;
                    this.OnNextBtn();
                    break;
                }
            }
        }
    }

    private CDualSlider GetSlider() {
        return this.m_DualSlider;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.GetOnUpdateSliderTimer()) {
            if (this.GetSlider() != null && this.GetMediaPlayer() != null && this.GetMediaPlayer().IsPlaying()) {
                double dMediaTime = this.GetMediaPlayer().GetMediaTime();
                double dDuration = this.GetMediaPlayer().GetDuration();
                this.OnUpdateSlider(dMediaTime, dDuration);
            }
        } else if (event.getSource() == this.GetOnSetMediaTimeTimer() && this.GetMediaPlayer() != null) {
            double dMediaTime = this.GetMediaPlayer().GetMediaTime();
            double dDuration = this.GetMediaPlayer().GetDuration();
            this.OnSetMediaTime(this.m_nMousePointX);
        }
        this.m_nMousePointX = -1;
    }

    private void OnUpdateSlider(double dMediaTime, double dDuration) {
        if (DEBUG_THUMB_TRACK) {
            System.out.println("CMediaDockPanel.OnUpdateSlider -->");
        }
        if (this.GetSlider() != null) {
            double dPercentage = dMediaTime * 1000.0 / dDuration;
            dPercentage = Math.floor(dPercentage);
            if (DEBUG_THUMB_TRACK) {
                System.out.printf("MediaTime: %s | Percentage: %s\r\n", Double.toString(dMediaTime), Double.toString(dPercentage));
            }
            this.GetSlider().setLowValue((int)dPercentage);
        }
        if (DEBUG_THUMB_TRACK) {
            System.out.println("CMediaDockPanel.OnUpdateSlider <--");
        }
    }

    private void OnSetMediaTime(int nPointX) {
        if (DEBUG_THUMB_TRACK) {
            System.out.println("CMediaDockPanel.OnSetMediaTime -->");
        }
        if (this.m_DualSlider != null) {
            double dPercentage = (double)nPointX * 1000.0 / (double)this.m_DualSlider.getWidth();
            dPercentage = Math.floor(dPercentage);
            if (this.GetMediaPlayer() != null) {
                this.GetMediaPlayer().SetMediaTime((int)dPercentage, 1000.0);
            }
        }
        this.StopOnSetMediaTimeTimer();
        this.StartOnUpdateSliderTimer();
        if (DEBUG_THUMB_TRACK) {
            System.out.println("CMediaDockPanel.OnSetMediaTime <--");
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (DEBUG_THUMB_TRACK) {
            System.out.println("mouseDragged -->");
        }
        this.m_nMousePointX = event.getX();
        this.StopOnUpdateSliderTimer();
        this.StartOnSetMediaTimeTimer();
        if (DEBUG_THUMB_TRACK) {
            System.out.println("mouseDragged <--");
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (DEBUG_THUMB_TRACK) {
            System.out.println("mouseClicked -->");
        }
        this.m_nMousePointX = event.getX();
        this.StopOnUpdateSliderTimer();
        this.StartOnSetMediaTimeTimer();
        if (DEBUG_THUMB_TRACK) {
            System.out.println("mouseClicked <--");
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (DEBUG_THUMB_TRACK) {
            System.out.println("mouseReleased -->");
        }
        if (DEBUG_THUMB_TRACK) {
            System.out.println("mouseReleased <--");
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private void StartTimer(Timer rTimer) {
        if (rTimer != null) {
            if (rTimer.isRunning()) {
                rTimer.restart();
            } else {
                rTimer.start();
            }
        }
    }

    private void StopTimer(Timer rTimer) {
        if (rTimer != null) {
            rTimer.stop();
        }
    }

    private Timer GetOnUpdateSliderTimer() {
        return this.m_OnUpdateSliderTimer;
    }

    private void StartOnUpdateSliderTimer() {
        this.StartTimer(this.GetOnUpdateSliderTimer());
    }

    private void StopOnUpdateSliderTimer() {
        this.StopTimer(this.GetOnUpdateSliderTimer());
    }

    private Timer GetOnSetMediaTimeTimer() {
        return this.m_OnSetMediaTimeTimer;
    }

    private void StartOnSetMediaTimeTimer() {
        this.StartTimer(this.GetOnSetMediaTimeTimer());
    }

    private void StopOnSetMediaTimeTimer() {
        this.StopTimer(this.GetOnSetMediaTimeTimer());
    }

    public void OnShowPlaylistFrame() {
        if (CMediaDockPanel.IsValid(this.GetPlaylistFrame())) {
            boolean bHide = this.GetPlaylistFrame().isVisible();
            if (bHide) {
                this.getDockingManager().hideFrame(this.GetPlaylistFrame().getKey());
            } else {
                this.getDockingManager().showFrame(this.GetPlaylistFrame().getKey());
            }
        }
    }

    @Override
    public DockableFrame CreateDockableFrame(String sKey) {
        CMediaPlaylistFrame frame = null;
        if (sKey.equals("Playlist")) {
            frame = new CMediaPlaylistFrame(sKey, this);
            this.SetPlaylistFrame(frame);
        }
        return frame;
    }

    @Override
    public DockableBar CreateDockableBar(String sKey) {
        CMediaToolbar bar = null;
        if (sKey.equals("Toolbar")) {
            bar = new CMediaToolbar(sKey, this);
            this.getDockableBarManager().addDockableBar(bar);
            this.SetToolbar(bar);
        }
        return bar;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_THUMB_TRACK = false;
    }
}

