/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking;

import com.jidesoft.swing.JideSplitButton;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.fvjv.gui.events.CLockNavInfo;
import com.rhinosoft.fvjv.gui.events.CLockNavMenuItem;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.gui.frames.browser.CNestedBrowserFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.awt.AWTEvent;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class CRhinoSplitBtn
extends JideSplitButton {
    private boolean m_bIsLocal;
    private boolean m_bLocked;
    private CNestedBrowserFrame m_rDockFrameSource;
    private String m_sLockTxt;
    private String m_sUnlockTxt;
    private ImageIcon m_iLockedIcon;
    private ImageIcon m_iUnlockedIcon;

    public CRhinoSplitBtn(Action rAction, boolean bIsLocal, CNestedBrowserFrame rDockFrameSource) {
        super(rAction);
        this.m_sLockTxt = CString.LoadString("IDS_LOCK_NAV_MENU");
        this.m_sUnlockTxt = CString.LoadString("IDS_UNLOCK_NAV_MENU");
        this.m_iLockedIcon = CMainFrame.GetJARImage("LockNavLocked16.png");
        this.m_iUnlockedIcon = CMainFrame.GetJARImage("LockNavUnlocked16.png");
        this.m_bIsLocal = bIsLocal;
        this.m_bLocked = false;
        this.m_rDockFrameSource = rDockFrameSource;
        this.UpdateText();
        this.UpdateIcon();
    }

    public CRhinoSplitBtn(boolean bIsLocal, CNestedBrowserFrame rDockFrameSource) {
        this.setAction(CMainFrame.GET_APP().GetAction(9625));
        this.m_sLockTxt = CString.LoadString("IDS_LOCK_NAV_MENU");
        this.m_sUnlockTxt = CString.LoadString("IDS_UNLOCK_NAV_MENU");
        this.m_iLockedIcon = CMainFrame.GetJARImage("LockNavLocked16.png");
        this.m_iUnlockedIcon = CMainFrame.GetJARImage("LockNavUnlocked16.png");
        this.m_bIsLocal = bIsLocal;
        this.m_bLocked = false;
        this.m_rDockFrameSource = rDockFrameSource;
        this.UpdateText();
        this.UpdateIcon();
    }

    public CNestedBrowserFrame GetDockFrameSource() {
        return this.m_rDockFrameSource;
    }

    public void SetDockFrameSource(CNestedBrowserFrame rDockFrame) {
        this.m_rDockFrameSource = rDockFrame;
        for (int nIdx = 0; nIdx < this.getMenuComponentCount(); ++nIdx) {
            Component rItem = this.getMenuComponent(nIdx);
            if (!(rItem instanceof CLockNavMenuItem)) continue;
            CLockNavMenuItem rLockNavItem = (CLockNavMenuItem)rItem;
            rLockNavItem.SetDockFrameSource(rDockFrame);
        }
    }

    public boolean IsLocal() {
        return this.m_bIsLocal;
    }

    public void SetLocked(boolean bLocked) {
        this.m_bLocked = bLocked;
        this.UpdateIcon();
        this.UpdateText();
    }

    public void UpdateIcon() {
        ImageIcon icon = this.m_iUnlockedIcon;
        if (this.IsLocked()) {
            icon = this.m_iLockedIcon;
        }
        this.setIcon(icon);
    }

    public void UpdateText() {
        String sText = this.m_sLockTxt;
        if (this.IsLocked()) {
            sText = this.m_sUnlockTxt;
        }
        this.setText(sText);
    }

    public boolean IsLocked() {
        return this.m_bLocked;
    }

    public void UpdateTargetInfo() {
        for (int nIdx = 0; nIdx < this.getMenuComponentCount(); ++nIdx) {
            Component rItem = this.getMenuComponent(nIdx);
            if (!(rItem instanceof CLockNavMenuItem)) continue;
            CLockNavMenuItem rLockNavItem = (CLockNavMenuItem)rItem;
            rLockNavItem.UpdateTargetInfo();
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        block8: {
            block7: {
                CRhinoEvent rEvent = null;
                if (event instanceof CRhinoEvent) {
                    rEvent = (CRhinoEvent)event;
                }
                if (rEvent == null) break block7;
                switch (event.getID()) {
                    case 9629: {
                        CLockNavInfo rLockNavInfo = (CLockNavInfo)rEvent.GetEventObj();
                        if (rLockNavInfo != null) {
                            boolean bIsLocked = rLockNavInfo.IsLocked();
                            this.SetLocked(bIsLocked);
                        }
                        this.RelayEvent(rEvent);
                        break;
                    }
                    case 9100: 
                    case 9102: {
                        CLockNavMenuItem rSelItem = this.GetSelectedMenuItem();
                        this.RelayEvent(rEvent);
                        this.removeAll();
                        if (CMainFrame.GET_APP() != null) {
                            CMainFrame.GET_APP().LoadLockNavMenuItems(this);
                            break;
                        }
                        break block8;
                    }
                    default: {
                        super.processEvent(event);
                        break;
                    }
                }
                break block8;
            }
            super.processEvent(event);
        }
    }

    private CLockNavMenuItem GetSelectedMenuItem() {
        CLockNavMenuItem rItem = null;
        for (int nIdx = 0; nIdx < this.getMenuComponentCount() && rItem == null; ++nIdx) {
            CLockNavMenuItem rLockNavItem;
            Component rNextItem = this.getMenuComponent(nIdx);
            if (!(rNextItem instanceof CLockNavMenuItem) || !(rLockNavItem = (CLockNavMenuItem)rNextItem).isSelected()) continue;
            rItem = rLockNavItem;
        }
        return rItem;
    }

    private void RelayEvent(CRhinoEvent rEvent) {
        for (int nIdx = 0; nIdx < this.getMenuComponentCount(); ++nIdx) {
            Component rItem = this.getMenuComponent(nIdx);
            if (!(rItem instanceof CLockNavMenuItem)) continue;
            CLockNavMenuItem rLockNavItem = (CLockNavMenuItem)rItem;
            rLockNavItem.dispatchEvent(rEvent);
        }
    }
}

