/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarDockableHolderPanel;
import com.jidesoft.action.DockableBarFactory;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableFrameFactory;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.docking.CDockableBar;
import com.rhinosoft.docking.CDockableFactory;
import com.rhinosoft.docking.CDockableFrame;
import com.rhinosoft.docking.IDockableFactory;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.AWTEvent;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;

public class CDockablePanel
extends DockableBarDockableHolderPanel
implements IDockableFactory,
DockableFrameListener {
    public static boolean DEBUG_DOCKFRAME_EVENTS;
    private JComponent m_rParent;
    private CDockableFactory m_DockableFactory;
    private File m_rInitialLayoutFile;
    private File m_rStoredLayoutFile;

    public CDockablePanel(RootPaneContainer rootPaneContainer, JComponent rParent) {
        super(rootPaneContainer);
        this.InitVars(rParent, null, null);
    }

    public CDockablePanel(RootPaneContainer rootPaneContainer, JComponent rParent, File rInitialLayout, File rStoredLayout) {
        super(rootPaneContainer);
        this.InitVars(rParent, rInitialLayout, rStoredLayout);
    }

    private void InitVars(JComponent rParent, File rInitialLayout, File rStoredLayout) {
        this.SetParent(rParent);
        if (rInitialLayout == null) {
            this.InitLayout();
        } else {
            this.InitDockableFactory();
            this.SetInitialLayoutFile(rInitialLayout);
            this.SetStoredLayoutFile(rStoredLayout);
            this.LoadInitialLayout();
            this.LoadStoredLayout();
        }
        if (this.getDockingManager() != null) {
            this.getDockingManager().addDockableFrameListener(this);
        }
    }

    private void InitLayout() {
        this.getDockableBarManager().loadLayoutData();
        this.getDockingManager().loadLayoutData();
    }

    public static boolean IsValid(Object rObj) {
        boolean bIsValid = false;
        if (rObj != null) {
            bIsValid = true;
        }
        return bIsValid;
    }

    public static boolean IsValid(String sArg, boolean bCheckEmpty) {
        boolean bIsValid = false;
        if (sArg != null) {
            if (bCheckEmpty) {
                if (sArg.isEmpty()) {
                    bIsValid = true;
                }
            } else {
                bIsValid = true;
            }
        }
        return bIsValid;
    }

    public boolean IsValidDockBarManager() {
        return CDockablePanel.IsValid(this.getDockableBarManager());
    }

    public boolean IsValidDockFrameManager() {
        return CDockablePanel.IsValid(this.getDockingManager());
    }

    public boolean AddDockableBar(CommandBar rDockBar) {
        boolean bAdded = false;
        if (this.IsValidDockBarManager() && rDockBar != null) {
            if (this.getDockableBarManager().getDockableBar(rDockBar.getKey()) == null) {
                this.getDockableBarManager().addDockableBar(rDockBar);
            }
            bAdded = true;
        }
        return bAdded;
    }

    public boolean RemoveDockableBar(CommandBar rDockBar) {
        String sKey;
        boolean bRemoved = false;
        if (this.IsValidDockBarManager() && rDockBar != null && CDockablePanel.IsValid(sKey = rDockBar.getKey(), true)) {
            this.getDockableBarManager().removeDockableBar(sKey);
            bRemoved = true;
        }
        return bRemoved;
    }

    public boolean AddDockableFrame(DockableFrame rDockFrame) {
        boolean bAdded = false;
        if (this.IsValidDockFrameManager() && rDockFrame != null) {
            this.getDockingManager().addFrame(rDockFrame);
            bAdded = true;
        }
        return bAdded;
    }

    public boolean RemoveDockableFrame(DockableFrame rDockFrame) {
        String sKey;
        boolean bRemoved = false;
        if (this.IsValidDockFrameManager() && rDockFrame != null && CDockablePanel.IsValid(sKey = rDockFrame.getKey(), true)) {
            this.getDockingManager().removeFrame(sKey);
            bRemoved = true;
        }
        return bRemoved;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        super.processEvent(event);
        this.RelayEvent(event);
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            switch (event.getID()) {
                case 9400: {
                    this.SaveStoredLayout();
                    break;
                }
            }
        }
    }

    protected void RelayEvent(AWTEvent event) {
        List<String> asDockKeys;
        List<String> asDockBarKeys;
        if (this.getDockableBarManager() != null && (asDockBarKeys = this.getDockableBarManager().getAllDockableBarNames()) != null) {
            for (String sKey : asDockBarKeys) {
                DockableBar rBar;
                if (sKey == null || sKey.isEmpty() || (rBar = this.getDockableBarManager().getDockableBar(sKey)) == null) continue;
                rBar.dispatchEvent(event);
            }
        }
        if (this.getDockingManager() != null && (asDockKeys = this.getDockingManager().getAllFrameNames()) != null) {
            for (String sKey : asDockKeys) {
                DockableFrame rFrame;
                if (sKey == null || sKey.isEmpty() || (rFrame = this.getDockingManager().getFrame(sKey)) == null) continue;
                rFrame.dispatchEvent(event);
            }
        }
    }

    protected JComponent GetParent() {
        return this.m_rParent;
    }

    private void SetParent(JComponent rParent) {
        this.m_rParent = rParent;
    }

    public boolean IsEventSource(Object objSource) {
        List<String> asDockBarKeys;
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (!bIsEventSource && this.getDockableBarManager() != null && (asDockBarKeys = this.getDockableBarManager().getAllDockableBarNames()) != null) {
            for (String sKey : asDockBarKeys) {
                CDockableBar rDockBar;
                DockableBar rBar;
                if (sKey == null || sKey.isEmpty() || (rBar = this.getDockableBarManager().getDockableBar(sKey)) == null || !(rBar instanceof CDockableBar) || !(rDockBar = (CDockableBar)rBar).IsEventSource(objSource)) continue;
                bIsEventSource = true;
                break;
            }
        }
        if (this.getDockingManager() != null) {
            List<String> asDockKeys;
            if (!bIsEventSource && this.getDockingManager().getWorkspace() != null) {
                for (int nIdx = 0; nIdx < this.getDockingManager().getWorkspace().getComponentCount(); ++nIdx) {
                    Component rComp = this.getDockingManager().getWorkspace().getComponent(nIdx);
                    if (rComp == null || rComp != objSource) continue;
                    bIsEventSource = true;
                    break;
                }
            }
            if (!bIsEventSource && (asDockKeys = this.getDockingManager().getAllFrameNames()) != null) {
                for (String sKey : asDockKeys) {
                    CDockableFrame rDockFrame;
                    DockableFrame rFrame;
                    if (sKey == null || sKey.isEmpty() || (rFrame = this.getDockingManager().getFrame(sKey)) == null || !(rFrame instanceof CDockableFrame) || !(rDockFrame = (CDockableFrame)rFrame).IsEventSource(objSource)) continue;
                    bIsEventSource = true;
                    break;
                }
            }
        }
        return bIsEventSource;
    }

    protected void InitDockableFactory() {
        this.SetDockableFactory(this.CreateDockableFactory());
    }

    private CDockableFactory CreateDockableFactory() {
        return new CDockableFactory(this);
    }

    protected CDockableFactory GetDockableFactory() {
        return this.m_DockableFactory;
    }

    protected void SetDockableFactory(CDockableFactory rFactory) {
        this.m_DockableFactory = rFactory;
    }

    private DockableFrameFactory GetDockableFrameFactory() {
        DockableFrameFactory rFactory = null;
        if (this.GetDockableFactory() != null) {
            rFactory = this.GetDockableFactory().GetDockableFrameFactory();
        }
        return rFactory;
    }

    private DockableBarFactory GetDockableBarFactory() {
        DockableBarFactory rFactory = null;
        if (this.GetDockableFactory() != null) {
            rFactory = this.GetDockableFactory().GetDockableBarFactory();
        }
        return rFactory;
    }

    @Override
    public DockableFrame CreateDockableFrame(String sKey) {
        CDockableFrame frame = new CDockableFrame(sKey, this, 4, 4);
        return frame;
    }

    @Override
    public DockableBar CreateDockableBar(String sKey) {
        CDockableBar bar = new CDockableBar(sKey, this);
        return bar;
    }

    public File GetInitialLayoutFile() {
        return this.m_rInitialLayoutFile;
    }

    public void SetInitialLayoutFile(File rFile) {
        this.m_rInitialLayoutFile = rFile;
    }

    public File GetStoredLayoutFile() {
        return this.m_rStoredLayoutFile;
    }

    public void SetStoredLayoutFile(File rFile) {
        this.m_rStoredLayoutFile = rFile;
    }

    private void LoadInitialLayout() {
        if (this.GetDockableFactory() != null) {
            this.GetDockableFactory().LoadInitialLayout(this.GetInitialLayoutFile(), this.getDockingManager(), this.getDockableBarManager());
        }
    }

    public boolean GetUsingLayoutFiles() {
        boolean bUsingLayoutFiles = false;
        if (this.GetDockableFactory() != null) {
            bUsingLayoutFiles = true;
        }
        return bUsingLayoutFiles;
    }

    private void LoadStoredLayout() {
        if (this.GetStoredLayoutFile() != null) {
            this.getLayoutPersistence().loadLayoutDataFromFile(this.GetStoredLayoutFile().getPath());
        }
    }

    private void SaveStoredLayout() {
        if (this.GetStoredLayoutFile() != null) {
            this.getLayoutPersistence().saveLayoutDataToFile(this.GetStoredLayoutFile().getPath());
        }
    }

    @Override
    public void dockableFrameAdded(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameAdded");
        }
    }

    @Override
    public void dockableFrameRemoved(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameRemoved");
        }
    }

    @Override
    public void dockableFrameShown(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameShown");
        }
    }

    @Override
    public void dockableFrameHidden(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameHidden");
        }
    }

    @Override
    public void dockableFrameDocked(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameDocked");
        }
    }

    @Override
    public void dockableFrameFloating(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameFloating");
        }
    }

    @Override
    public void dockableFrameAutohidden(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameAutohidden");
        }
    }

    @Override
    public void dockableFrameAutohideShowing(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameAutohideShowing");
        }
    }

    @Override
    public void dockableFrameActivated(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameActivated");
        }
    }

    @Override
    public void dockableFrameDeactivated(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameDeactivated");
        }
    }

    @Override
    public void dockableFrameTabShown(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameTabShown");
        }
    }

    @Override
    public void dockableFrameTabHidden(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameTabHidden");
        }
    }

    @Override
    public void dockableFrameMaximized(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameMaximized");
        }
    }

    @Override
    public void dockableFrameRestored(DockableFrameEvent event) {
        if (DEBUG_DOCKFRAME_EVENTS) {
            System.out.println("CDockablePanel.dockableFrameRestored");
        }
    }

    static {
        if (CMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_DOCKFRAME_EVENTS = false;
    }
}

