/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.docking;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarFactory;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableFrameFactory;
import com.jidesoft.docking.DockingManager;
import com.rhinosoft.docking.IDockableFactory;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class CDockableFactory {
    public static boolean DEBUG = CMainFrame.DEBUG;
    private IDockableFactory m_rFactoryListener;
    private DockableFrameFactory m_DockFrameFactory;
    private DockableBarFactory m_DockBarFactory;

    public CDockableFactory(IDockableFactory rListener) {
        this.InitVars(rListener);
    }

    private void InitVars(IDockableFactory rListener) {
        this.m_rFactoryListener = rListener;
        this.InitDockableFrameFactory();
        this.InitDockableBarFactory();
    }

    private IDockableFactory GetFactoryListener() {
        return this.m_rFactoryListener;
    }

    protected void InitDockableFrameFactory() {
        this.SetDockableFrameFactory(this.CreateDockableFrameFactory());
    }

    private DockableFrameFactory CreateDockableFrameFactory() {
        DockableFrameFactory factory = new DockableFrameFactory(){

            @Override
            public DockableFrame create(String sKey) {
                return CDockableFactory.this.CreateDockableFrame(sKey);
            }
        };
        return factory;
    }

    protected DockableFrame CreateDockableFrame(String sKey) {
        DockableFrame frame = null;
        if (this.GetFactoryListener() != null) {
            frame = this.GetFactoryListener().CreateDockableFrame(sKey);
        }
        return frame;
    }

    protected DockableFrameFactory GetDockableFrameFactory() {
        return this.m_DockFrameFactory;
    }

    protected void SetDockableFrameFactory(DockableFrameFactory rFactory) {
        this.m_DockFrameFactory = rFactory;
    }

    protected void InitDockableBarFactory() {
        this.SetDockableBarFactory(this.CreateDockableBarFactory());
    }

    private DockableBarFactory CreateDockableBarFactory() {
        DockableBarFactory factory = new DockableBarFactory(){

            @Override
            public DockableBar create(String sKey) {
                return CDockableFactory.this.CreateDockableBar(sKey);
            }
        };
        return factory;
    }

    protected DockableBar CreateDockableBar(String sKey) {
        DockableBar bar = null;
        if (this.GetFactoryListener() != null) {
            bar = this.GetFactoryListener().CreateDockableBar(sKey);
        }
        return bar;
    }

    protected DockableBarFactory GetDockableBarFactory() {
        return this.m_DockBarFactory;
    }

    protected void SetDockableBarFactory(DockableBarFactory rFactory) {
        this.m_DockBarFactory = rFactory;
    }

    public boolean LoadInitialLayout(File fFile, DockingManager dockFrameMgr, DockableBarManager dockBarMgr) {
        boolean bLoaded;
        block3: {
            bLoaded = false;
            if (fFile != null) {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(fFile);
                    this.LoadInitialLayout(document, dockFrameMgr, dockBarMgr);
                    bLoaded = true;
                }
                catch (Exception e) {
                    bLoaded = false;
                    if (!DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return bLoaded;
    }

    private void LoadInitialLayout(Document doc, DockingManager dockFrameMgr, DockableBarManager dockBarMgr) {
        if (dockBarMgr != null) {
            dockBarMgr.setUseFrameState(false);
            dockBarMgr.beginLoadLayoutData();
            dockBarMgr.setDockableBarFactory(this.GetDockableBarFactory());
            if (doc != null) {
                dockBarMgr.loadInitialLayout(doc);
            }
            dockBarMgr.loadLayoutData();
        }
        if (dockFrameMgr != null) {
            dockFrameMgr.setUseFrameState(false);
            dockFrameMgr.beginLoadLayoutData();
            dockFrameMgr.setDockableFrameFactory(this.GetDockableFrameFactory());
            if (doc != null) {
                dockFrameMgr.loadInitialLayout(doc);
            }
            dockFrameMgr.loadLayoutData();
        }
    }
}

