/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.parsers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CXMLTag {
    private boolean m_bIsRoot = false;
    private CXMLTag m_rParent;
    private HashMap<String, CXMLTag> m_aChildTags;
    private String m_sName;
    private String m_sValue;

    public CXMLTag(String sName, boolean bIsRoot) {
        this.m_bIsRoot = bIsRoot;
        this._CXMLTag(sName, null);
    }

    public CXMLTag(String sName, CXMLTag rParent) {
        this._CXMLTag(sName, rParent);
    }

    private void _CXMLTag(String sName, CXMLTag rParent) {
        this.m_sName = sName;
        this.m_rParent = rParent;
        if (this.m_rParent != null) {
            this.m_rParent.AddChild(this);
        }
        this.m_aChildTags = new HashMap();
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public final String GetName() {
        return this.m_sName;
    }

    public final String GetValue() {
        return this.m_sValue;
    }

    public void SetValue(String sValue) {
        this.m_sValue = sValue;
    }

    public void AddChild(CXMLTag rChild) {
        this.m_aChildTags.put(rChild.GetName(), rChild);
    }

    public CXMLTag RemoveChild(String sName) {
        CXMLTag rChildRemoved = this.m_aChildTags.remove(sName);
        return rChildRemoved;
    }

    public boolean RemoveChild(CXMLTag rChild) {
        return rChild == this.RemoveChild(rChild.GetName());
    }

    public void RemoveAll() {
        Set<String> asKeys = this.m_aChildTags.keySet();
        Iterator<String> itr = asKeys.iterator();
        while (itr.hasNext()) {
            CXMLTag rRemove;
            String sKey = itr.next();
            if (sKey == null || sKey.isEmpty() || (rRemove = this.m_aChildTags.get(sKey)) == null) continue;
            rRemove.RemoveAll();
            itr.remove();
        }
    }

    public CXMLTag GetChild(String sName) {
        CXMLTag rFoundTag = null;
        if (sName != null && !sName.isEmpty()) {
            rFoundTag = this.m_aChildTags.get(sName);
        }
        return rFoundTag;
    }

    public String toString() {
        return this.m_sName;
    }
}

