/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.renderers.files;

import com.rhinosoft.base.files.CFile;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class CFileTableCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable rTable, Object rVal, boolean bIsSelected, boolean bHasFocus, int nRow, int nCol) {
        super.getTableCellRendererComponent(rTable, rVal, bIsSelected, bHasFocus, nRow, nCol);
        Font font = (Font)UIManager.get("List.font");
        if (rVal instanceof CFile) {
            CFile fFile = (CFile)rVal;
            String sText = null;
            Icon icoIcon = null;
            int nAlignHorz = 2;
            int nModelCol = rTable.convertColumnIndexToModel(nCol);
            if (nModelCol == 0) {
                icoIcon = fFile.GetIcon16();
                sText = fFile.GetDisplayName();
            } else if (nModelCol == 1) {
                nAlignHorz = 4;
                if (!fFile.IsDirectory()) {
                    sText = CFile.FormatFileSize(fFile.GetSize());
                }
            } else if (nModelCol == 2) {
                sText = fFile.GetType();
            } else if (nModelCol == 3) {
                sText = fFile.GetModifiedDate().toString();
            }
            this.setText(sText);
            this.setIcon(icoIcon);
            this.setHorizontalAlignment(nAlignHorz);
        }
        return this;
    }
}

