/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.images;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class CGraphicsUtilities {
    private static final GraphicsConfiguration CONFIGURATION = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();

    private CGraphicsUtilities() {
    }

    public static BufferedImage CreateColorModelCompatibleImage(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage CreateCompatibleImage(BufferedImage image) {
        return CGraphicsUtilities.CreateCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage CreateCompatibleImage(BufferedImage image, int width, int height) {
        return CONFIGURATION.createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage CreateCompatibleImage(int width, int height) {
        return CONFIGURATION.createCompatibleImage(width, height);
    }

    public static BufferedImage CreateTranslucentCompatibleImage(int width, int height) {
        return CONFIGURATION.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage LoadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return CGraphicsUtilities.ToCompatibleImage(image);
    }

    public static BufferedImage ToCompatibleImage(BufferedImage image) {
        if (image.getColorModel().equals(CONFIGURATION.getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = CONFIGURATION.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage CreateThumbnailFast(BufferedImage image, int newSize) {
        int height;
        int width = image.getWidth();
        if (width > (height = image.getHeight())) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)width / (float)height;
            width = newSize;
            height = (int)((float)newSize / ratio);
        } else {
            if (newSize >= height) {
                throw new IllegalArgumentException("newSize must be lower than the image height");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)height / (float)width;
            height = newSize;
            width = (int)((float)newSize / ratio);
        }
        BufferedImage temp = CGraphicsUtilities.CreateCompatibleImage(image, width, height);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    public static BufferedImage CreateThumbnailFast(BufferedImage image, int newWidth, int newHeight) {
        if (newWidth >= image.getWidth() || newHeight >= image.getHeight()) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage temp = CGraphicsUtilities.CreateCompatibleImage(image, newWidth, newHeight);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    public static BufferedImage CreateThumbnail(BufferedImage image, int newSize) {
        int height;
        boolean isWidthGreater;
        int width = image.getWidth();
        boolean bl = isWidthGreater = width > (height = image.getHeight());
        if (isWidthGreater) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
        } else if (newSize >= height) {
            throw new IllegalArgumentException("newSize must be lower than the image height");
        }
        if (newSize <= 0) {
            throw new IllegalArgumentException("newSize must be greater than 0");
        }
        float ratioWH = (float)width / (float)height;
        float ratioHW = (float)height / (float)width;
        BufferedImage thumb = image;
        do {
            if (isWidthGreater) {
                if ((width /= 2) < newSize) {
                    width = newSize;
                }
                height = (int)((float)width / ratioWH);
            } else {
                if ((height /= 2) < newSize) {
                    height = newSize;
                }
                width = (int)((float)height / ratioHW);
            }
            BufferedImage temp = CGraphicsUtilities.CreateCompatibleImage(image, width, height);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (newSize != (isWidthGreater ? width : height));
        return thumb;
    }

    public static BufferedImage CreateThumbnail(BufferedImage image, int newWidth, int newHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (newWidth >= width || newHeight >= height) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage thumb = image;
        do {
            if (width > newWidth && (width /= 2) < newWidth) {
                width = newWidth;
            }
            if (height > newHeight && (height /= 2) < newHeight) {
                height = newHeight;
            }
            BufferedImage temp = CGraphicsUtilities.CreateCompatibleImage(image, width, height);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (width != newWidth || height != newHeight);
        return thumb;
    }

    public static int[] GetPixels(BufferedImage img, int x, int y, int w, int h, int[] anPixels) {
        if (w == 0 || h == 0) {
            return new int[0];
        }
        if (anPixels == null) {
            anPixels = new int[w * h];
        } else if (anPixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, anPixels);
        }
        return img.getRGB(x, y, w, h, anPixels, 0, w);
    }

    public static void SetPixels(BufferedImage img, int x, int y, int w, int h, int[] anPixels) {
        if (anPixels == null || w == 0 || h == 0) {
            return;
        }
        if (anPixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, anPixels);
        } else {
            img.setRGB(x, y, w, h, anPixels, 0, w);
        }
    }
}

