/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.images;

import com.rhinosoft.base.gui.images.CColorTintFilter;
import com.rhinosoft.base.gui.images.CGraphicsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.IconUIResource;

public class CFilterIcon
implements Icon {
    private CColorTintFilter m_Filter = new CColorTintFilter(Color.WHITE, 0.0f);
    private BufferedImage m_imgCached = null;
    private BufferedImage m_imgOriginal = null;
    private boolean m_bDamaged = false;

    public void SetOriginal(IconUIResource rIconRes) {
        this.m_imgOriginal = new BufferedImage(rIconRes.getIconWidth(), rIconRes.getIconHeight(), 2);
        Graphics2D g2 = this.m_imgOriginal.createGraphics();
        rIconRes.paintIcon(null, g2, 0, 0);
        g2.dispose();
        this.m_imgCached = CGraphicsUtilities.CreateCompatibleImage(CGraphicsUtilities.ToCompatibleImage(this.m_imgOriginal));
        this.m_bDamaged = true;
    }

    public void SetOriginal(ImageIcon rImageIcon) {
        this.m_imgOriginal = new BufferedImage(rImageIcon.getIconWidth(), rImageIcon.getIconHeight(), 2);
        Graphics2D g2 = this.m_imgOriginal.createGraphics();
        rImageIcon.paintIcon(null, g2, 0, 0);
        g2.dispose();
        this.m_imgCached = CGraphicsUtilities.CreateCompatibleImage(CGraphicsUtilities.ToCompatibleImage(this.m_imgOriginal));
        this.m_bDamaged = true;
    }

    public void SetOriginal(Icon rIcon) {
        this.m_imgOriginal = new BufferedImage(rIcon.getIconWidth(), rIcon.getIconHeight(), 2);
        Graphics2D g2 = this.m_imgOriginal.createGraphics();
        rIcon.paintIcon(null, g2, 0, 0);
        g2.dispose();
        this.m_imgCached = CGraphicsUtilities.CreateCompatibleImage(CGraphicsUtilities.ToCompatibleImage(this.m_imgOriginal));
        this.m_bDamaged = true;
    }

    public void SetOriginal(Image rImage) {
        ImageObserver obs = new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        };
        this.m_imgOriginal = new BufferedImage(rImage.getWidth(obs), rImage.getHeight(obs), 2);
        Graphics2D g2 = this.m_imgOriginal.createGraphics();
        g2.drawImage(rImage, 0, 0, null);
        g2.dispose();
        this.m_imgCached = CGraphicsUtilities.CreateCompatibleImage(CGraphicsUtilities.ToCompatibleImage(this.m_imgOriginal));
        this.m_bDamaged = true;
    }

    public void SetColor(Color rMixColor, JComponent rOwner) {
        this.m_Filter.SetMixColor(rMixColor);
        this.m_bDamaged = true;
        if (rOwner != null) {
            rOwner.repaint();
        }
    }

    public void SetMix(float fMixVal, JComponent rOwner) {
        this.m_Filter.SetMixValue(fMixVal);
        this.m_bDamaged = true;
        if (rOwner != null) {
            rOwner.repaint();
        }
    }

    @Override
    public int getIconWidth() {
        int nVal = 0;
        if (this.m_imgOriginal != null) {
            nVal = this.m_imgOriginal.getWidth();
        }
        return nVal;
    }

    @Override
    public int getIconHeight() {
        int nVal = 0;
        if (this.m_imgOriginal != null) {
            nVal = this.m_imgOriginal.getHeight();
        }
        return nVal;
    }

    @Override
    public void paintIcon(Component c2, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.m_imgOriginal != null && this.m_imgCached != null) {
            if (this.m_bDamaged) {
                this.m_Filter.filter(this.m_imgOriginal, this.m_imgCached);
            }
            g2.drawImage((Image)this.m_imgCached, x, y, null);
        }
    }
}

