/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.images;

import com.rhinosoft.base.gui.images.CAbstractFilter;
import com.rhinosoft.base.gui.images.CGraphicsUtilities;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;

public class CColorTintFilter
extends CAbstractFilter {
    private Color m_clrMix = Color.WHITE;
    private float m_fMixValue = 0.0f;
    private int[] m_anPreMultipliedRed = new int[256];
    private int[] m_anPreMultipliedGreen = new int[256];
    private int[] m_anPreMultipliedBlue = new int[256];

    public CColorTintFilter(Color clrMix, float fMixValue) {
        this.SetMixes(clrMix, fMixValue);
    }

    public float GetMixValue() {
        return this.m_fMixValue;
    }

    public void SetMixValue(float fMixVal) {
        this.SetMixes(this.GetMixColor(), fMixVal);
    }

    public Color GetMixColor() {
        return this.m_clrMix;
    }

    public void SetMixColor(Color clrMix) {
        this.SetMixes(clrMix, this.GetMixValue());
    }

    private void SetMixes(Color clrMix, float fMixValue) {
        if (clrMix == null) {
            throw new IllegalArgumentException("clrMix cannot be null");
        }
        this.m_clrMix = clrMix;
        if (fMixValue < 0.0f) {
            fMixValue = 0.0f;
        } else if (fMixValue > 1.0f) {
            fMixValue = 1.0f;
        }
        this.m_fMixValue = fMixValue;
        int nMixRed = (int)((float)clrMix.getRed() * fMixValue);
        int nMixGreen = (int)((float)clrMix.getGreen() * fMixValue);
        int nMixBlue = (int)((float)clrMix.getBlue() * fMixValue);
        float fFactor = 1.0f - fMixValue;
        for (int nIdx = 0; nIdx < 256; ++nIdx) {
            int nValue = (int)((float)nIdx * fFactor);
            this.m_anPreMultipliedRed[nIdx] = nValue + nMixRed;
            this.m_anPreMultipliedGreen[nIdx] = nValue + nMixGreen;
            this.m_anPreMultipliedBlue[nIdx] = nValue + nMixBlue;
        }
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            DirectColorModel directCM = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            dst = this.createCompatibleDestImage(src, directCM);
        }
        int nWidth = src.getWidth();
        int nHeight = src.getHeight();
        int[] anPixels = new int[nWidth * nHeight];
        CGraphicsUtilities.GetPixels(src, 0, 0, nWidth, nHeight, anPixels);
        this.MixColor(anPixels);
        CGraphicsUtilities.SetPixels(dst, 0, 0, nWidth, nHeight, anPixels);
        return dst;
    }

    private void MixColor(int[] anPixels) {
        for (int nIdx = 0; nIdx < anPixels.length; ++nIdx) {
            int nARGB = anPixels[nIdx];
            anPixels[nIdx] = this.MixColor(anPixels[nIdx]);
        }
    }

    public int MixColor(int nARGB) {
        int nColor = nARGB & 0xFF000000 | this.m_anPreMultipliedRed[nARGB >> 16 & 0xFF] << 16 | this.m_anPreMultipliedGreen[nARGB >> 8 & 0xFF] << 8 | this.m_anPreMultipliedBlue[nARGB & 0xFF];
        return nColor;
    }
}

