/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.frames;

import com.rhinosoft.base.CConversionUtils;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class CPopupMenu
extends JPopupMenu {
    private static final boolean DEBUG = CMainFrame.DEBUG;
    public static final int ID_POPUP = -1;
    public static final int ID_SEPARATOR = -2;
    public static final String ITEM_DELIMITER = ",";
    protected HashMap<Integer, JMenuItem> m_aItemMap = new HashMap();
    protected HashMap<Integer, String> m_asShowMap = new HashMap();

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.m_aItemMap != null) {
            Collection<JMenuItem> rMenuItems = this.m_aItemMap.values();
            for (JMenuItem rNextItem : rMenuItems) {
                if (rNextItem == null) continue;
                rNextItem.updateUI();
            }
        }
    }

    public HashMap<Integer, JMenuItem> GetItemMap() {
        return this.m_aItemMap;
    }

    public void AddItem(int nID, JMenuItem rMenuItem) {
        if (rMenuItem != null) {
            rMenuItem.setToolTipText(null);
        }
        this.m_aItemMap.put(nID, rMenuItem);
    }

    public void ShowItems(int nID, int[] anItems) {
        StringBuilder sbItems = new StringBuilder();
        if (anItems != null && anItems.length > 0) {
            for (int nNextID : anItems) {
                sbItems.append(nNextID);
                sbItems.append(ITEM_DELIMITER);
            }
        }
        this.m_asShowMap.put(nID, sbItems.toString());
    }

    public JMenuItem GetItem(int nID) {
        return this.m_aItemMap.get(nID);
    }

    private void BuildItems() {
        this.removeAll();
        this.BuildItems(-1, this);
        this.RemoveSeparators();
    }

    private void BuildItems(int nID, JComponent rAddTo) {
        if (rAddTo != null) {
            String sShowItems = this.m_asShowMap.get(nID);
            if (sShowItems != null) {
                String[] asItems;
                for (String sItem : asItems = sShowItems.split(ITEM_DELIMITER)) {
                    int nNextID = CConversionUtils.ConvertToInt(sItem);
                    if (!CConversionUtils.IsValidInt(nNextID)) continue;
                    if (nNextID == -2) {
                        if (rAddTo instanceof JPopupMenu) {
                            ((JPopupMenu)rAddTo).addSeparator();
                            continue;
                        }
                        if (!(rAddTo instanceof JMenu)) continue;
                        ((JMenu)rAddTo).addSeparator();
                        continue;
                    }
                    JMenuItem rMenuItem = this.GetItem(nNextID);
                    if (rMenuItem == null) continue;
                    rAddTo.add(rMenuItem);
                    this.BuildItems(nNextID, rMenuItem);
                }
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rAddTo = null");
        }
    }

    @Override
    public void show(Component rInvoker, int nXLoc, int nYLoc) {
        this.BuildItems();
        super.show(rInvoker, nXLoc, nYLoc);
    }

    private void RemoveSeparators() {
        Component rNext = this.getComponent(0);
        boolean bIsSep = false;
        if (rNext instanceof JSeparator) {
            bIsSep = true;
        }
        while (bIsSep) {
            bIsSep = false;
            this.remove(0);
            rNext = this.getComponent(0);
            if (!(rNext instanceof JSeparator)) continue;
            bIsSep = true;
        }
        rNext = this.getComponent(this.getComponentCount() - 1);
        if (rNext instanceof JSeparator) {
            bIsSep = true;
        }
        while (bIsSep) {
            bIsSep = false;
            this.remove(this.getComponentCount() - 1);
            rNext = this.getComponent(this.getComponentCount() - 1);
            if (!(rNext instanceof JSeparator)) continue;
            bIsSep = true;
        }
        for (int nIdx = 0; nIdx < this.getComponentCount() - 2; ++nIdx) {
            Component rComp1 = this.getComponent(nIdx);
            Component rComp2 = this.getComponent(nIdx + 1);
            if (!(rComp1 instanceof JSeparator) || !(rComp2 instanceof JSeparator)) continue;
            this.remove(nIdx + 1);
            --nIdx;
        }
    }
}

