/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.frames;

import com.rhinosoft.base.gui.frames.CBaseMainFrame;
import java.io.File;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CLogger {
    private String m_sAbsFileName;
    private String m_sName;

    public CLogger(String sAbsFileName, String sName) {
        this.m_sAbsFileName = sAbsFileName;
        this.m_sName = sName;
    }

    protected void finalize() throws Throwable {
        this.OnDestroy();
        super.finalize();
    }

    public void OnDestroy() {
        File fFile;
        if (this.GetLogger() != null) {
            Handler[] arHandlers = this.GetLogger().getHandlers();
            for (int nIdx = 0; nIdx < arHandlers.length; ++nIdx) {
                Handler rHandler = arHandlers[nIdx];
                if (rHandler == null) continue;
                rHandler.close();
            }
        }
        if ((fFile = new File(this.m_sAbsFileName)) != null && fFile.exists() && !fFile.delete()) {
            fFile.deleteOnExit();
        }
    }

    private String GetName() {
        return this.m_sName;
    }

    private Logger GetLogger() {
        return Logger.getLogger(this.GetName());
    }

    public void Finest(String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().finest(sText);
        }
    }

    public void Finer(String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().finer(sText);
        }
    }

    public void Fine(String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().fine(sText);
        }
    }

    public void Config(String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().config(sText);
        }
    }

    public void Info(String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().info(sText);
        }
    }

    public void Warning(String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().warning(sText);
        }
    }

    public void Severe(String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().severe(sText);
        }
    }

    public void Entering(String sSource, String sMethod) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().entering(sSource, sMethod);
        }
    }

    public void Entering(String sSource, String sMethod, Object rParm) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().entering(sSource, sMethod, rParm);
        }
    }

    public void Entering(String sSource, String sMethod, Object[] arParms) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().entering(sSource, sMethod, arParms);
        }
    }

    public void Exiting(String sSource, String sMethod) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().exiting(sSource, sMethod);
        }
    }

    public void Exiting(String sSource, String sMethod, Object rResult) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().exiting(sSource, sMethod, rResult);
        }
    }

    public void Log(Level rLevel, String sText) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().log(rLevel, sText);
        }
    }

    public void Log(Level rLevel, String sText, Object rParm) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().log(rLevel, sText, rParm);
        }
    }

    public void Log(Level rLevel, String sText, Object[] arParms) {
        if (this.IsDebug() && this.GetLogger() != null) {
            this.GetLogger().log(rLevel, sText, arParms);
        }
    }

    public Level GetLevel() {
        Level rLevel = Level.INFO;
        if (this.GetLogger() != null) {
            rLevel = this.GetLogger().getLevel();
        }
        return rLevel;
    }

    public void SetLevel(Level rLevel) {
        if (this.GetLogger() != null) {
            this.GetLogger().setLevel(rLevel);
        }
    }

    public void SetUseParentHandlers(boolean bUseParentHandler) {
        if (this.GetLogger() != null) {
            this.GetLogger().setUseParentHandlers(bUseParentHandler);
        }
    }

    public void AddHandler(Handler rHandler) {
        if (this.GetLogger() != null) {
            this.GetLogger().addHandler(rHandler);
        }
    }

    private boolean IsDebug() {
        return CBaseMainFrame.DEBUG;
    }
}

