/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.frames;

import com.jidesoft.action.DockableBarDockableHolderPanel;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.rhinosoft.base.gui.frames.CBaseDockBarFactory;
import com.rhinosoft.base.gui.frames.CBaseDockFrameFactory;
import com.rhinosoft.base.gui.frames.CBaseMainFrame;
import java.io.File;
import java.io.IOException;
import javax.swing.RootPaneContainer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class CBaseDockPanel
extends DockableBarDockableHolderPanel {
    public static final boolean DEBUG_CHECK_FRAME_KEYS = false;
    private File m_fInitialLayout;
    private File m_fStoredLayout;

    public CBaseDockPanel(RootPaneContainer rootPaneContainer) {
        super(rootPaneContainer);
        this.InitVars();
    }

    protected abstract CBaseDockFrameFactory CreateDockFrameFactory();

    protected abstract CBaseDockBarFactory CreateDockableBarFactory();

    protected abstract void InitStoredLayout();

    private void InitVars() {
        this.getDockingManager().setFloatingContainerType(1);
    }

    public File GetInitialLayout() {
        return this.m_fInitialLayout;
    }

    public void SetInitialLayout(File fFile) {
        this.m_fInitialLayout = fFile;
    }

    public File GetStoredLayout() {
        return this.m_fStoredLayout;
    }

    public void SetStoredLayout(File fFile) {
        this.m_fStoredLayout = fFile;
    }

    public void LoadInitialLayout() {
        block6: {
            try {
                this.LoadInitialLayout(this.GetInitialLayout());
            }
            catch (ParserConfigurationException pce) {
                if (CBaseMainFrame.DEBUG) {
                    pce.printStackTrace();
                }
            }
            catch (SAXException se) {
                if (CBaseMainFrame.DEBUG) {
                    se.printStackTrace();
                }
            }
            catch (IOException ioe) {
                if (!CBaseMainFrame.DEBUG) break block6;
                ioe.printStackTrace();
            }
        }
    }

    public void LoadStoredLayout() {
        if (this.GetStoredLayout() != null) {
            this.getLayoutPersistence().loadLayoutDataFromFile(this.GetStoredLayout().getAbsolutePath());
        }
    }

    public void SaveStoredLayout() {
        if (this.GetStoredLayout() != null) {
            this.getLayoutPersistence().saveLayoutDataToFile(this.GetStoredLayout().getAbsolutePath());
        }
    }

    private void LoadInitialLayout(File fFile) throws SAXException, ParserConfigurationException, IOException {
        if (fFile != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fFile);
            this.LoadInitialLayout(document);
        }
    }

    private void LoadInitialLayout(Document doc) {
        DockableBarManager barManager;
        DockingManager frameManager = this.getDockingManager();
        if (frameManager != null) {
            frameManager.setUseFrameState(false);
            frameManager.beginLoadLayoutData();
            frameManager.setDockableFrameFactory(this.CreateDockFrameFactory());
            if (doc != null) {
                frameManager.loadInitialLayout(doc);
            }
        }
        if ((barManager = this.getDockableBarManager()) != null) {
            barManager.setUseFrameState(false);
            barManager.beginLoadLayoutData();
            barManager.setDockableBarFactory(this.CreateDockableBarFactory());
            if (doc != null) {
                barManager.loadInitialLayout(doc);
            }
        }
    }

    protected boolean AddDockableFrame(DockableFrame rDockableFrame) {
        boolean bAdded;
        block3: {
            bAdded = false;
            if (rDockableFrame != null && this.getDockingManager() != null) {
                try {
                    this.getDockingManager().addFrame(rDockableFrame);
                    bAdded = true;
                }
                catch (IllegalArgumentException iae) {
                    if (!CBaseMainFrame.DEBUG) break block3;
                    System.out.println(String.format("Most likely a frame already exists with this key:  %s", rDockableFrame.getKey()));
                    iae.printStackTrace();
                }
            }
        }
        return bAdded;
    }

    protected boolean RemoveDockableFrame(DockableFrame rDockableFrame) {
        boolean bRemoved;
        block3: {
            bRemoved = false;
            if (rDockableFrame != null && this.getDockingManager() != null) {
                try {
                    this.getDockingManager().removeFrame(rDockableFrame.getKey());
                    bRemoved = true;
                }
                catch (IllegalArgumentException iae) {
                    if (!CBaseMainFrame.DEBUG) break block3;
                    System.out.println(String.format("Most likely a frame already exists with this key:  %s", rDockableFrame.getKey()));
                    iae.printStackTrace();
                }
            }
        }
        return bRemoved;
    }

    public void RemoveStoredLayout() {
        File fFile = this.GetStoredLayout();
        if (fFile != null && fFile.exists() && !fFile.delete()) {
            fFile.deleteOnExit();
        }
    }

    public void SetDockContainer(RootPaneContainer rContainer) {
        if (this.getDockingManager() != null) {
            this.getDockingManager().switchRootPaneContainer(rContainer);
        }
    }
}

