/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.tree;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.CColorUtils;
import com.rhinosoft.base.gui.components.files.tree.CFileTreeNode;
import com.rhinosoft.base.gui.components.files.tree.CSearchTreeNode;
import com.rhinosoft.base.gui.images.CFilterIcon;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class CFileTreeNodeRenderer
extends DefaultTreeCellRenderer {
    public static final String KEY_DROP_TREEPATH = "DropTreePath";
    public static String HTML_FMT_BOLD = "<html><span style=\"font-weight: bold;\">%s</span></html>";
    private boolean m_bHasFocusClrs = false;
    private CFilterIcon m_Icon = new CFilterIcon();

    private CFile GetFileFromTreePath(TreePath rTreePath) {
        Object rNode;
        CFile fRet = null;
        if (rTreePath != null && (rNode = rTreePath.getLastPathComponent()) != null && rNode instanceof CFileTreeNode) {
            CFileTreeNode rFileNode = (CFileTreeNode)rNode;
            fRet = rFileNode.GetFile();
        }
        return fRet;
    }

    public boolean IsDropDir(JTree rTree, Object rValue, int nRow) {
        boolean bIsDropDir = false;
        if (rTree != null) {
            CFile fRowFile;
            TreePath rDropTreePath;
            Object objDropTreePath = rTree.getClientProperty(KEY_DROP_TREEPATH);
            if (objDropTreePath instanceof TreePath && rTree.getRowForPath(rDropTreePath = (TreePath)objDropTreePath) == nRow && (fRowFile = this.GetFileFromTreePath(rDropTreePath)) != null && fRowFile.IsDirectory() && !fRowFile.IsDrive()) {
                bIsDropDir = true;
            }
        } else if (CMainFrame.GetDebugLogger() != null) {
            CMainFrame.GetDebugLogger().Info("ASSERT:  Programming error, rTable = null");
        }
        return bIsDropDir;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree rTree, Object rValue, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int nRow, boolean bHasFocus) {
        CFileTreeNode rNode;
        CFile fFile;
        if (this.IsDropDir(rTree, rValue, nRow)) {
            bIsSelected = true;
        }
        super.getTreeCellRendererComponent(rTree, rValue, bIsSelected, bIsExpanded, bIsLeaf, nRow, bHasFocus);
        this.UpdateHasFocusColor(bIsSelected, rTree, this);
        if (rValue instanceof CSearchTreeNode) {
            CSearchTreeNode rNode2 = (CSearchTreeNode)rValue;
            this.setIcon(rNode2.GetDisplayIcon());
            this.setText(rNode2.GetDisplayText());
        } else if (rValue instanceof CFileTreeNode && (fFile = (rNode = (CFileTreeNode)rValue).GetFile()) != null) {
            this.setIcon(fFile.GetIcon16());
            this.DullTheIcon(fFile.IsDisplayIconDull());
            this.setText(fFile.GetDisplayName());
            Color clrFore = this.getForeground();
            if (!bIsSelected) {
                clrFore = fFile.GetDisplayColor(this.getForeground());
            }
            this.setForeground(clrFore);
            Font font = this.getFont();
            if (rNode.IsBold()) {
                this.setText(String.format(HTML_FMT_BOLD, this.getText()));
            }
        }
        return this;
    }

    public Rectangle GetEditorRect(JTree rTree, int nRow) {
        Rectangle rScreenCoords = new Rectangle(0, 0, 0, 0);
        if (rTree != null) {
            Icon rIcon;
            Insets rInsets;
            Point ptScreenLoc = new Point(0, 0);
            Rectangle rCellRect = rTree.getRowBounds(nRow);
            ptScreenLoc.setLocation(rCellRect.x, rCellRect.y);
            SwingUtilities.convertPointToScreen(ptScreenLoc, rTree);
            rScreenCoords.x = ptScreenLoc.x;
            rScreenCoords.y = ptScreenLoc.y;
            rScreenCoords.width = rCellRect.width;
            rScreenCoords.height = rCellRect.height;
            int x2 = rScreenCoords.x;
            int nWidth2 = rScreenCoords.width;
            Border rBorder = this.getBorder();
            if (rBorder != null && (rInsets = rBorder.getBorderInsets(this)) != null) {
                x2 += rInsets.left;
                nWidth2 -= rInsets.left;
            }
            if ((rIcon = this.getIcon()) != null) {
                int nImageWidth = rIcon.getIconWidth();
                x2 += nImageWidth;
                nWidth2 -= nImageWidth;
            }
            int nImageGap = 1;
            rScreenCoords.x = x2 += nImageGap;
            if ((nWidth2 -= nImageGap) > 0) {
                rScreenCoords.width = nWidth2;
            }
        }
        return rScreenCoords;
    }

    private void UpdateHasFocusColor(boolean bIsSelected, JTree rTree, Component ... arComps) {
        Color clrTreeFore = UIManager.getColor("Tree.foreground");
        Color clrTreeBack = UIManager.getColor("Tree.background");
        Color clrTreeForeSel = UIManager.getColor("Tree.selectionForeground");
        Color clrTreeBackSel = UIManager.getColor("Tree.selectionBackground");
        Color clrFore = clrTreeFore;
        Color clrBack = clrTreeBack;
        if (bIsSelected) {
            clrFore = clrTreeForeSel;
            clrBack = clrTreeBackSel;
            if (!this.GetHasFocusClrs()) {
                clrBack = Color.LIGHT_GRAY;
                if (!CColorUtils.IsADarkColor(clrFore) && !CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrTreeFore.getRGB() < clrTreeForeSel.getRGB() ? clrTreeFore : clrTreeForeSel;
                } else if (CColorUtils.IsADarkColor(clrFore) && CColorUtils.IsADarkColor(clrBack)) {
                    clrFore = clrTreeFore.getRGB() > clrTreeForeSel.getRGB() ? clrTreeFore : clrTreeForeSel;
                }
            }
        }
        if (arComps != null) {
            for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
                Component rNextComp = arComps[nIdx];
                if (rNextComp == null) continue;
                rNextComp.setForeground(clrFore);
                rNextComp.setBackground(clrBack);
            }
        }
        this.setForeground(clrFore);
        this.setBackgroundSelectionColor(clrBack);
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
        this.m_bHasFocusClrs = bHasFocusClrs;
    }

    public boolean GetHasFocusClrs() {
        return this.m_bHasFocusClrs;
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.m_Icon != null && icon != null) {
            this.m_Icon.SetOriginal(icon);
            super.setIcon(this.m_Icon);
        } else {
            super.setIcon(null);
        }
    }

    protected void DullTheIcon(boolean bDullIt) {
        float fMixVal = 0.0f;
        if (bDullIt) {
            fMixVal = 0.5f;
        }
        this.m_Icon.SetMix(fMixVal, this);
    }
}

