/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.tree;

import com.rhinosoft.base.files.CFile;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CFileTreeNode
extends DefaultMutableTreeNode {
    private TreePath m_cTreePath;
    private boolean m_bBold;

    public CFileTreeNode() {
        this.InitVars();
    }

    public CFileTreeNode(CFile fFile) {
        this.InitVars();
        this.SetFile(fFile);
    }

    private void InitVars() {
        this.m_bBold = false;
    }

    public void SetFile(CFile fFile) {
        this.setUserObject(fFile);
    }

    public CFile GetFile() {
        CFile fFile = null;
        Object obj = this.getUserObject();
        if (obj instanceof CFile) {
            fFile = (CFile)obj;
        }
        return fFile;
    }

    public boolean Matches(String sPath) {
        String sFilePath;
        boolean bMatches = false;
        if (sPath != null && !sPath.isEmpty() && this.GetFile() != null && (sFilePath = this.GetFile().GetPath()) != null && !sFilePath.isEmpty() && sPath.equals(sFilePath)) {
            bMatches = true;
        }
        return bMatches;
    }

    public CFileTreeNode GetChildNode(String sChildPath) {
        CFileTreeNode rNode = null;
        if (sChildPath != null) {
            for (int nIdx = 0; nIdx < this.getChildCount() && rNode == null; ++nIdx) {
                CFileTreeNode rChildNode;
                TreeNode rNextNode = this.getChildAt(nIdx);
                if (!(rNextNode instanceof CFileTreeNode) || !(rChildNode = (CFileTreeNode)rNextNode).Matches(sChildPath)) continue;
                rNode = rChildNode;
            }
        }
        return rNode;
    }

    public TreePath GetTreePath() {
        this.InitTreePath(false);
        return this.m_cTreePath;
    }

    private void SetTreePath(TreePath rTreePath) {
        this.m_cTreePath = rTreePath;
    }

    public void InitTreePath(boolean bReset) {
        if (this.m_cTreePath == null || bReset) {
            this.SetTreePath(new TreePath(this.getPath()));
        }
    }

    public CFileTreeNode GetParent() {
        CFileTreeNode rParent = null;
        TreeNode rTemp = this.getParent();
        if (rTemp instanceof CFileTreeNode) {
            rParent = (CFileTreeNode)rTemp;
        }
        return rParent;
    }

    @Override
    public boolean isLeaf() {
        boolean bIsLeaf = super.isLeaf();
        bIsLeaf = this.GetFile() != null && this.GetFile().IsDir() && this.GetFile().HasListing() && this.GetFile().GetChildFileCount() < 1;
        return bIsLeaf;
    }

    public void SetBold(boolean bBold) {
        this.m_bBold = bBold;
    }

    public boolean IsBold() {
        return this.m_bBold;
    }
}

