/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.preview;

import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.preview.CPlayListPanel;
import com.rhinosoft.media.CMediaThread;
import com.rhinosoft.media.CRhinoMediaPlayer;
import java.net.URL;
import javax.swing.GroupLayout;

public class CMediaPlayer
extends CPlayListPanel {
    private CMediaThread m_tThread;
    private CRhinoMediaPlayer m_cPlayer;

    public CMediaPlayer() {
        this.InitVars();
    }

    private void InitVars() {
        this.m_tThread = new CMediaThread(this, "PreviewMediaThread");
        this.m_tThread.start();
        this.m_cPlayer = new CRhinoMediaPlayer(1);
        if (this.GetMediaPlayer() != null) {
            GroupLayout rLayout = new GroupLayout(this);
            this.setLayout(rLayout);
            rLayout.setHorizontalGroup(rLayout.createParallelGroup().addComponent(this.GetMediaPlayer(), -1, -2, Short.MAX_VALUE));
            rLayout.setVerticalGroup(rLayout.createSequentialGroup().addComponent(this.GetMediaPlayer(), -1, -2, Short.MAX_VALUE));
        }
    }

    private CRhinoMediaPlayer GetMediaPlayer() {
        return this.m_cPlayer;
    }

    @Override
    public void Destroy() {
    }

    @Override
    protected void PlayFile(CFile fFile) {
        if (this.GetMediaPlayer() != null) {
            try {
                URL rURL = fFile.GetPreviewURL(false, 100, 100);
                if (this.m_tThread != null) {
                    this.m_tThread.PostLoadURI(this, this.GetMediaPlayer(), rURL.toURI(), true);
                }
            }
            catch (Exception e) {
                System.out.println("Error opening media" + e);
            }
        }
    }

    @Override
    protected void Play() {
        if (this.GetMediaPlayer() != null) {
            try {
                this.GetMediaPlayer().Play();
            }
            catch (Exception e) {
                System.out.println("Error opening media" + e);
            }
        }
    }

    @Override
    protected void Stop() {
        if (this.GetMediaPlayer() != null) {
            try {
                this.GetMediaPlayer().Stop();
            }
            catch (Exception e) {
                System.out.println("Error opening media" + e);
            }
        }
    }

    @Override
    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = super.IsEventSource(objSource);
        if (this.GetMediaPlayer() != null && this.GetMediaPlayer() == objSource) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }
}

