/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.preview;

import com.jidesoft.docking.DockingManager;
import com.rhinosoft.base.files.CFile;
import com.rhinosoft.base.gui.components.files.preview.CMediaPlayer;
import com.rhinosoft.base.gui.components.files.preview.CPlayListPanel;
import com.rhinosoft.base.gui.events.CRhinoEvent;
import com.rhinosoft.base.gui.frames.CBaseMainFrame;
import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.threads.CBaseThread;
import com.rhinosoft.fvjv.threads.CThreadMsg;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class CFilePreviewPane
extends JPanel
implements ActionListener,
FocusListener,
KeyListener {
    protected static final boolean DEBUG_SET_FILE;
    protected static final boolean DEBUG_MEDIA_SET_SOURCE;
    protected static final boolean DEBUG_TRACK_THUMBNAILS;
    public static final boolean DEBUG_TRACK_PREVIEW_SIZE;
    protected static boolean DEBUG_SHOW_SIZES;
    protected static final int STATE_INIT = -1;
    protected static final int STATE_IS_THUMB = 0;
    protected static final int STATE_IS_MEDIA = 1;
    protected static final int STATE_IS_UNAVAILABLE = 2;
    protected static final int STATE_GENERATING_THUMB = 3;
    protected static final int STATE_RECEIVED_THUMB = 4;
    protected static final int STATE_PLAYING_MEDIA = 5;
    private static final int CHANGE_TIMER = 500;
    private int m_nState;
    private CBaseThread m_rtWorker;
    private CFile m_rPrevFile;
    private CFile m_rCurFile;
    private boolean m_bCheckFiles = true;
    private JPanel m_cThumbPanel;
    private JLabel m_cThumbLabel;
    private JLabel m_cThumbStatusLabel;
    private JProgressBar m_cThumbProgressBar;
    private CPlayListPanel m_cPlayListPanel;
    private Timer m_ChangeTimer;
    private DockingManager m_rDockingManager;
    private String m_sFrameKey;
    private boolean m_bResolveLinks = true;
    private JPanel m_ThumbImgPanel;
    private Dimension m_dimThumbSize;

    public CFilePreviewPane() {
        this.InitVars();
    }

    private void InitVars() {
        this.setLayout(new BorderLayout());
        if (DEBUG_SHOW_SIZES) {
            this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        }
        this.m_cPlayListPanel = this.CreatePlayListPanel();
        this.InitThumbPanel();
        this.SetState(2);
        this.m_ChangeTimer = new Timer(500, this);
    }

    private JPanel GetThumbPanel() {
        return this.m_cThumbPanel;
    }

    private void InitThumbPanel() {
        this.m_cThumbLabel = new JLabel();
        if (this.GetThumbLabel() != null) {
            this.GetThumbLabel().setHorizontalAlignment(0);
            this.GetThumbLabel().setVerticalAlignment(0);
            this.GetThumbLabel().setIconTextGap(0);
            this.GetThumbLabel().addKeyListener(this);
        }
        this.m_cThumbStatusLabel = new JLabel();
        if (this.GetThumbStatusLabel() != null) {
            this.GetThumbStatusLabel().setHorizontalAlignment(0);
            this.GetThumbStatusLabel().setVerticalAlignment(0);
            this.GetThumbStatusLabel().addKeyListener(this);
        }
        this.m_cThumbProgressBar = new JProgressBar();
        if (this.GetThumbProgressBar() != null) {
            this.GetThumbProgressBar().setIndeterminate(true);
            this.GetThumbProgressBar().addKeyListener(this);
        }
        this.m_cThumbPanel = new JPanel();
        if (this.GetThumbPanel() != null) {
            if (DEBUG_SHOW_SIZES && this.GetThumbPanel() != null) {
                this.GetThumbPanel().setBorder(BorderFactory.createLineBorder(Color.YELLOW));
            }
            this.m_ThumbImgPanel = new JPanel();
            GroupLayout groupLayout = new GroupLayout(this.m_ThumbImgPanel);
            this.m_ThumbImgPanel.setLayout(groupLayout);
            groupLayout.setAutoCreateContainerGaps(false);
            groupLayout.setAutoCreateGaps(false);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this.GetThumbLabel(), -1, -2, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this.GetThumbLabel(), -1, -2, Short.MAX_VALUE));
            if (DEBUG_SHOW_SIZES) {
                if (this.GetThumbImgPanel() != null) {
                    this.GetThumbImgPanel().setBorder(BorderFactory.createLineBorder(Color.RED));
                }
                if (this.GetThumbLabel() != null) {
                    this.GetThumbLabel().setBorder(BorderFactory.createLineBorder(Color.GREEN));
                }
            }
            this.GetThumbPanel().addKeyListener(this);
            GroupLayout rLayout = new GroupLayout(this.GetThumbPanel());
            rLayout.setAutoCreateContainerGaps(false);
            rLayout.setAutoCreateGaps(false);
            this.GetThumbPanel().setLayout(rLayout);
            rLayout.setHorizontalGroup(rLayout.createParallelGroup().addComponent(this.m_ThumbImgPanel, -1, -2, Short.MAX_VALUE).addComponent(this.GetThumbStatusLabel(), -1, -2, Short.MAX_VALUE).addComponent(this.GetThumbProgressBar(), -1, -2, Short.MAX_VALUE));
            rLayout.setVerticalGroup(rLayout.createSequentialGroup().addComponent(this.m_ThumbImgPanel, -1, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, -2).addComponent(this.GetThumbStatusLabel(), -1, -2, -2).addComponent(this.GetThumbProgressBar(), -1, -2, -2));
        }
        this.addKeyListener(this);
    }

    protected void SetState(int nState) {
        this.m_nState = nState;
        this.SetLayout(nState);
        this.UpdateStatusLabel(nState);
    }

    private int GetState() {
        return this.m_nState;
    }

    private void SetLayout(int nState) {
        JPanel rShow = this.GetThumbPanel();
        JPanel rHide = this.GetPlayListPanel();
        if (nState == 1 || nState == 5) {
            rShow = this.GetPlayListPanel();
            rHide = this.GetThumbPanel();
        }
        if (nState == 4) {
            if (this.GetThumbStatusLabel() != null) {
                this.GetThumbStatusLabel().setVisible(false);
            }
            if (this.GetThumbProgressBar() != null) {
                this.GetThumbProgressBar().setVisible(false);
            }
        } else {
            if (this.GetThumbStatusLabel() != null) {
                this.GetThumbStatusLabel().setVisible(true);
            }
            if (this.GetThumbProgressBar() != null) {
                boolean bVisible = false;
                if (nState == 3) {
                    bVisible = true;
                }
                this.GetThumbProgressBar().setVisible(bVisible);
            }
        }
        if (rShow != null && rHide != null) {
            rHide.setVisible(false);
            rShow.setVisible(true);
            this.remove(rHide);
            this.add(rShow);
            if (this.GetThumbPanel() != null) {
                this.GetThumbPanel().setPreferredSize(this.getPreferredSize());
                this.GetThumbPanel().setSize(this.getSize());
            }
            this.validate();
            if (rHide == this.GetPlayListPanel()) {
                this.GetPlayListPanel().Stop();
            }
        }
        this.invalidate();
    }

    private JLabel GetThumbStatusLabel() {
        return this.m_cThumbStatusLabel;
    }

    private JProgressBar GetThumbProgressBar() {
        return this.m_cThumbProgressBar;
    }

    protected CPlayListPanel CreatePlayListPanel() {
        return new CMediaPlayer();
    }

    protected CPlayListPanel GetPlayListPanel() {
        return this.m_cPlayListPanel;
    }

    public CBaseThread GetThread() {
        return this.m_rtWorker;
    }

    public void SetThread(CBaseThread tThread) {
        this.m_rtWorker = tThread;
    }

    protected CFile GetFile() {
        return this.m_rCurFile;
    }

    public void SetFile(CFile rFile) {
        this.StartChangeTimer();
        if (this.GetPlayListPanel() != null) {
            this.GetPlayListPanel().Stop();
            this.GetPlayListPanel().RemoveFile(this.GetFile());
        }
        this.m_rPrevFile = this.m_rCurFile;
        this.m_rCurFile = rFile;
        this.m_bCheckFiles = true;
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof CRhinoEvent) {
            CRhinoEvent rEvent = (CRhinoEvent)event;
            block0 : switch (rEvent.getID()) {
                case 9639: {
                    Cursor rCursor = (Cursor)rEvent.GetEventObj();
                    this.setCursor(rCursor);
                    if (this.m_cThumbPanel != null) {
                        this.m_cThumbPanel.setCursor(rCursor);
                    }
                    if (this.m_cThumbLabel != null) {
                        this.m_cThumbLabel.setCursor(rCursor);
                    }
                    if (this.m_cThumbStatusLabel != null) {
                        this.m_cThumbStatusLabel.setCursor(rCursor);
                    }
                    if (this.m_cThumbProgressBar == null) break;
                    this.m_cThumbProgressBar.setCursor(rCursor);
                    break;
                }
                case 8040: {
                    if (!this.IsEventSource(event.getSource())) break;
                    if (DEBUG_MEDIA_SET_SOURCE) {
                        System.out.println("OnRecvPreviewSource: Media supports playback, show MediaPlayer");
                    }
                    this.SetLayout(1);
                    this.SetState(5);
                    break;
                }
                case 8041: {
                    if (!this.IsEventSource(event.getSource()) || !DEBUG_MEDIA_SET_SOURCE) break;
                    System.out.println("OnRecvPreviewSource: Media unsupported, leave as thumbnail");
                    break;
                }
                case 3005: {
                    if (!this.IsEventSource(rEvent.getSource()) || !(rEvent.GetEventObj() instanceof CThreadMsg)) break;
                    CThreadMsg rThreadMsg = (CThreadMsg)rEvent.GetEventObj();
                    switch (rThreadMsg.GetMsgID()) {
                        case 22: {
                            this.SetState(2);
                            break block0;
                        }
                    }
                    break;
                }
                case 6001: 
                case 6005: {
                    Object[] aItems;
                    if (this.GetFile() == null || (aItems = (Object[])rEvent.GetEventObj()) == null) break;
                    CFile fChild = (CFile)aItems[0];
                    boolean bUpdateUI = true;
                    Boolean bVal = (Boolean)aItems[1];
                    if (bVal != null) {
                        bUpdateUI = bVal;
                    }
                    if (fChild == null) break;
                    String sEventFile = fChild.GetPath();
                    String sPreviewFile = this.GetFile().GetPath();
                    if (sEventFile == null || sPreviewFile == null || !sEventFile.equals(sPreviewFile)) break;
                    this.StartChangeTimer();
                    break;
                }
                case 9107: {
                    this.OnResize();
                    break;
                }
                default: {
                    super.processEvent(event);
                }
            }
        }
    }

    public void StopPlayer() {
        if (this.GetPlayListPanel() != null) {
            this.GetPlayListPanel().Stop();
        }
    }

    protected JLabel GetThumbLabel() {
        return this.m_cThumbLabel;
    }

    private void PlayMedia(CFile fFile) {
        this.SetLayout(1);
        if (this.GetPlayListPanel() != null) {
            this.GetPlayListPanel().AddFile(fFile);
            this.SetState(5);
        }
    }

    protected Dimension GetThumbSize() {
        return this.m_dimThumbSize;
    }

    protected void SetThumbSize(Dimension dimSize) {
        this.m_dimThumbSize = dimSize;
    }

    protected Dimension CalcThumbSize() {
        JViewport rViewport;
        Dimension dimSize = new Dimension(100, 100);
        if (DEBUG_TRACK_PREVIEW_SIZE) {
            JViewport rViewport2;
            JScrollPane rScrollPane;
            if (this.getSize() != null) {
                System.out.printf("CFilePreviewPane:Size = %dx%d\r\n", this.getSize().width, this.getSize().height);
            }
            if ((rScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this)) != null && rScrollPane.getSize() != null) {
                System.out.printf("ScrollPane:Size = %dx%d\r\n", rScrollPane.getSize().width, rScrollPane.getSize().height);
            }
            if ((rViewport2 = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this)) != null && rViewport2.getSize() != null) {
                System.out.printf("Viewport:Size = %dx%d\r\n", rViewport2.getSize().width, rViewport2.getSize().height);
            }
            if (this.GetThumbPanel() != null && this.GetThumbPanel().getSize() != null) {
                System.out.printf("ThumbPanel:Size = %dx%d\r\n", this.GetThumbPanel().getSize().width, this.GetThumbPanel().getSize().height);
            }
            if (this.GetThumbImgPanel() != null && this.GetThumbImgPanel().getSize() != null) {
                System.out.printf("ThumbImgPanel:Size = %dx%d\r\n", this.GetThumbImgPanel().getSize().width, this.GetThumbImgPanel().getSize().height);
            }
            if (this.GetThumbLabel() != null && this.GetThumbLabel().getSize() != null) {
                System.out.printf("ThumbLabel:Size = %dx%d\r\n", this.GetThumbLabel().getSize().width, this.GetThumbLabel().getSize().height);
            }
        }
        if ((rViewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this)) != null) {
            Dimension dimViewportSize = rViewport.getSize();
            if (this.GetThumbImgPanel() != null && dimViewportSize != null) {
                this.GetThumbImgPanel().setSize(dimViewportSize);
                this.GetThumbImgPanel().validate();
            }
        }
        dimSize = this.GetThumbLabel().getSize();
        JComponent[] arComps = new JComponent[]{this.GetThumbLabel()};
        for (int nIdx = 0; nIdx < arComps.length; ++nIdx) {
            Insets rInsets;
            Border rBorder;
            JComponent rComp = arComps[nIdx];
            if (rComp == null || (rBorder = rComp.getBorder()) == null || (rInsets = rBorder.getBorderInsets(rComp)) == null) continue;
            dimSize.width -= rInsets.left + rInsets.right;
            dimSize.height -= rInsets.top + rInsets.bottom;
        }
        return dimSize;
    }

    protected String GetTextInitializing() {
        return "Initializing preview information.";
    }

    protected String GetTextThumbGenerating() {
        return "Generating preview.  Please wait.";
    }

    protected String GetTextThumbReceived() {
        return "Received preview image.";
    }

    protected String GetTextThumbUnavailable() {
        return "Preview is not available.";
    }

    private void UpdateStatusLabel(int nState) {
        String sTxt = "";
        if (nState == -1) {
            sTxt = this.GetTextInitializing();
        } else if (nState == 2) {
            sTxt = this.GetTextThumbUnavailable();
        } else if (nState == 3) {
            sTxt = this.GetTextThumbGenerating();
        } else if (nState == 4) {
            sTxt = this.GetTextThumbReceived();
        }
        if (this.GetThumbStatusLabel() != null) {
            this.GetThumbStatusLabel().setText(sTxt);
        }
    }

    public void OnResize() {
        Dimension dimSize;
        if (DEBUG_TRACK_PREVIEW_SIZE && (dimSize = this.getSize()) != null) {
            System.out.printf("CFilePreviewPane.OnResize | Size: %s, %s\r\n", dimSize.width, dimSize.height);
        }
        if (this.GetState() == 0 || this.GetState() == 4) {
            if (this.GetThumbLabel() != null && this.GetThumbLabel().isVisible()) {
                this.ShowThumb(false);
            }
        } else if ((this.GetState() == 1 || this.GetState() == 5) && this.GetPlayListPanel() != null) {
            this.GetPlayListPanel().OnResize();
        }
    }

    public boolean IsEventSource(Object objSource) {
        boolean bIsEventSource = false;
        if (objSource == this) {
            bIsEventSource = true;
        }
        if (this.GetPlayListPanel() != null && this.GetPlayListPanel().IsEventSource(objSource)) {
            bIsEventSource = true;
        }
        return bIsEventSource;
    }

    protected void ShowThumb(boolean bRefresh) {
        this.SetLayout(0);
        if (this.GetFile() != null) {
            this.UpdateThumbSize();
            Icon rPrevImg = null;
            if (this.GetThumbLabel() != null) {
                rPrevImg = this.GetThumbLabel().getIcon();
                this.GetThumbLabel().setIcon(this.GetFile().GetIcon32());
            }
            Dimension dimThumbSize = this.CalcThumbSize();
            if (DEBUG_TRACK_THUMBNAILS) {
                System.out.printf("Request thumbnail: %s (%d x %d)\r\n", this.GetFile().GetPath(), dimThumbSize.width, dimThumbSize.height);
            }
            if (this.GetThumbWillChange(dimThumbSize)) {
                this.SetState(3);
                this.GetFile().GetThumb(this.GetThread(), this, bRefresh, dimThumbSize.width, dimThumbSize.height, true, true, this.GetResolveLinks());
            } else {
                if (this.GetThumbLabel() != null && rPrevImg != null) {
                    this.GetThumbLabel().setIcon(rPrevImg);
                }
                this.SetState(4);
            }
        } else {
            this.SetState(2);
            if (this.GetThumbLabel() != null) {
                this.GetThumbLabel().setIcon(null);
            }
        }
    }

    public void SetHasFocusClrs(boolean bHasFocusClrs) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_ChangeTimer) {
            this.StopChangeTimer();
            if (this.GetFile() != null) {
                this.SetState(-1);
                if (CMainFrame.DEBUG_MEDIA) {
                    this.ShowThumb(false);
                    if (this.GetFile() != null && !this.GetFile().IsDirectory() && this.GetPlayListPanel() != null) {
                        this.GetPlayListPanel().AddFile(this.GetFile());
                    }
                } else if (this.GetFile().IsMediaSupported()) {
                    if (DEBUG_SET_FILE) {
                        System.out.printf("SetFile | PlayMedia: %s\r\n", this.GetFile().GetPath());
                    }
                    this.PlayMedia(this.GetFile());
                } else {
                    if (DEBUG_SET_FILE) {
                        System.out.printf("SetFile | ShowThumb: %s\r\n", this.GetFile().GetPath());
                    }
                    this.ShowThumb(false);
                }
            } else {
                this.ShowThumb(false);
            }
        }
    }

    private void StartChangeTimer() {
        if (this.GetThread() != null) {
            this.GetThread().Cancel();
        }
        if (this.m_ChangeTimer != null && !this.m_ChangeTimer.isRunning()) {
            this.m_ChangeTimer.start();
        } else {
            this.m_ChangeTimer.restart();
        }
    }

    private void StopChangeTimer() {
        if (this.m_ChangeTimer != null && this.m_ChangeTimer.isRunning()) {
            this.m_ChangeTimer.stop();
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    protected DockingManager GetDockingManager() {
        return this.m_rDockingManager;
    }

    public void SetDockingManager(DockingManager rDockingManager) {
        this.m_rDockingManager = rDockingManager;
    }

    protected String GetFrameKey() {
        return this.m_sFrameKey;
    }

    public void SetFrameKey(String sKey) {
        this.m_sFrameKey = sKey;
    }

    @Override
    public void keyTyped(KeyEvent rEvent) {
    }

    @Override
    public void keyPressed(KeyEvent rEvent) {
    }

    @Override
    public void keyReleased(KeyEvent rEvent) {
    }

    protected boolean GetResolveLinks() {
        return this.m_bResolveLinks;
    }

    private JPanel GetThumbImgPanel() {
        return this.m_ThumbImgPanel;
    }

    private boolean GetThumbWillChange(Dimension dimNewSize) {
        boolean bThumbWillChange = true;
        Dimension dimPrevSize = this.GetThumbSize();
        if (dimNewSize != null && dimPrevSize != null) {
            if (DEBUG_TRACK_PREVIEW_SIZE) {
                System.out.printf("PrevSize: %d x %d | NewSize: %d x %d\r\n", dimPrevSize.width, dimPrevSize.height, dimNewSize.width, dimNewSize.height);
            }
            if (dimPrevSize.height == dimNewSize.height) {
                if (dimPrevSize.width <= dimNewSize.width) {
                    bThumbWillChange = false;
                }
            } else if (dimPrevSize.width == dimNewSize.width && dimPrevSize.height <= dimNewSize.height) {
                bThumbWillChange = false;
            }
        }
        if (this.m_bCheckFiles) {
            this.m_bCheckFiles = false;
            if (this.m_rPrevFile != this.m_rCurFile || this.m_rPrevFile.GetAbsFileName() != null && this.m_rCurFile.GetAbsFileName() != null && !this.m_rPrevFile.GetAbsFileName().equals(this.m_rCurFile.GetAbsFileName())) {
                bThumbWillChange = true;
            }
        }
        return bThumbWillChange;
    }

    protected void UpdateThumbSize() {
        Icon rIcon;
        if (this.GetThumbLabel() != null && (rIcon = this.GetThumbLabel().getIcon()) != null) {
            this.SetThumbSize(new Dimension(rIcon.getIconWidth(), rIcon.getIconHeight()));
        }
    }

    static {
        if (CBaseMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_SET_FILE = false;
        if (CMainFrame.DEBUG_MEDIA) {
            // empty if block
        }
        DEBUG_MEDIA_SET_SOURCE = false;
        if (CBaseMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_THUMBNAILS = false;
        if (CBaseMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_PREVIEW_SIZE = false;
        if (CBaseMainFrame.DEBUG) {
            // empty if block
        }
        DEBUG_SHOW_SIZES = false;
    }
}

