/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui.components.files.listing;

import com.rhinosoft.FilePanel.CFileTableSorter;
import com.rhinosoft.base.files.CFile;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class CFileModel {
    private Vector<CFile> m_afFiles;
    protected EventListenerList m_ListenerList;
    private CFileTableSorter m_Comparator;
    private boolean m_bSortWhileAddingItems;

    public CFileModel(boolean bSortWhileAddingItems) {
        this.InitVars(bSortWhileAddingItems);
    }

    private void InitVars(boolean bSortWhileAddingItems) {
        this.m_afFiles = new Vector();
        this.m_ListenerList = new EventListenerList();
        this.m_Comparator = new CFileTableSorter(0);
        this.m_bSortWhileAddingItems = bSortWhileAddingItems;
    }

    protected void finalize() throws Throwable {
        this.m_ListenerList = null;
        if (this.m_afFiles != null) {
            this.m_afFiles.removeAllElements();
        }
        this.m_afFiles = null;
        super.finalize();
    }

    protected Vector<CFile> GetFiles() {
        return this.m_afFiles;
    }

    protected EventListenerList GetListeners() {
        return this.m_ListenerList;
    }

    protected boolean AddListener(Class cClassType, EventListener rListener) {
        boolean bAdded = false;
        if (this.GetListeners() != null) {
            this.GetListeners().add(cClassType, rListener);
            bAdded = true;
        }
        return bAdded;
    }

    protected boolean RemoveListener(Class cClassType, EventListener rListener) {
        boolean bRemoved = false;
        if (this.GetListeners() != null) {
            this.GetListeners().remove(cClassType, rListener);
            bRemoved = true;
        }
        return bRemoved;
    }

    protected EventListener[] GetListeners(Class cClassType) {
        EventListener[] aListeners = null;
        if (this.GetListeners() != null) {
            try {
                aListeners = this.GetListeners().getListeners(cClassType);
            }
            catch (ClassCastException cce) {
                aListeners = null;
            }
        }
        return aListeners;
    }

    public boolean AddFile(CFile fAddFile, boolean bFireGUIEvent) {
        boolean bAdded = false;
        if (fAddFile != null && this.GetFiles() != null && this.GetFile(fAddFile) == null) {
            bAdded = this.GetFiles().add(fAddFile);
            if (this.GetSortWhileAddingItems()) {
                Collections.sort(this.GetFiles(), this.m_Comparator);
            }
        }
        return bAdded;
    }

    public CFile UpdateFile(CFile fUpdated, boolean bFireGUIEvent) {
        CFile fRet = null;
        if (fUpdated != null) {
            int nIndex = this.GetFileIndex(fUpdated);
            fRet = this.UpdateFile(nIndex, bFireGUIEvent);
        }
        return fRet;
    }

    public CFile UpdateFile(int nIndex, boolean bFireGUIEvent) {
        CFile fUpdated = null;
        if (this.GetFiles() == null || nIndex <= -1 || nIndex >= this.GetFileCount() || (fUpdated = this.GetFiles().elementAt(nIndex)) == null || bFireGUIEvent) {
            // empty if block
        }
        return fUpdated;
    }

    public CFile RemoveFile(CFile fRemoved, boolean bFireGUIEvent) {
        CFile fRet = null;
        if (fRemoved != null) {
            int nIndex = this.GetFileIndex(fRemoved);
            fRet = this.RemoveFile(nIndex, bFireGUIEvent);
        }
        return fRet;
    }

    protected CFile RemoveFile(int nIndex, boolean bFireGUIEvent) {
        CFile fRemoved = null;
        if (this.GetFiles() == null || nIndex <= -1 || nIndex >= this.GetFileCount() || (fRemoved = this.GetFiles().remove(nIndex)) == null || bFireGUIEvent) {
            // empty if block
        }
        return fRemoved;
    }

    public boolean RemoveAll(boolean bFireGUIEvent) {
        boolean bRemoved = false;
        if (this.GetFiles() != null) {
            this.GetFiles().removeAllElements();
            bRemoved = true;
        }
        return bRemoved;
    }

    protected CFile GetFile(int nIndex) {
        CFile fRet = null;
        if (nIndex >= 0 && this.GetFiles() != null && nIndex < this.GetFileCount()) {
            fRet = this.GetFiles().get(nIndex);
        }
        return fRet;
    }

    protected CFile GetFile(CFile fFile) {
        CFile fRet = null;
        if (fFile != null) {
            fRet = this.GetFile(fFile.GetPath());
        }
        return fRet;
    }

    protected CFile GetFile(String sAbsPath) {
        CFile fChild = null;
        if (this.GetFiles() != null && sAbsPath != null && !sAbsPath.isEmpty()) {
            Iterator<CFile> itr = this.GetFiles().iterator();
            while (itr.hasNext() && fChild == null) {
                String sNextPath;
                CFile fNext = itr.next();
                if (fNext == null || (sNextPath = fNext.GetPath()) == null || sNextPath.isEmpty() || !sNextPath.equals(sAbsPath)) continue;
                fChild = fNext;
            }
        }
        return fChild;
    }

    protected int GetFileCount() {
        int nCount = 0;
        if (this.GetFiles() != null) {
            nCount = this.GetFiles().size();
        }
        return nCount;
    }

    public int GetFileIndex(String sPath) {
        int nIndex = -1;
        if (sPath != null && !sPath.isEmpty() && this.GetFiles() != null) {
            for (int nIdx = 0; nIdx < this.GetFiles().size() && nIndex == -1; ++nIdx) {
                String sNextPath;
                CFile fNext = this.GetFiles().get(nIdx);
                if (fNext == null || (sNextPath = fNext.GetPath()) == null || sNextPath.isEmpty() || !sPath.equals(sNextPath)) continue;
                nIndex = nIdx;
            }
        }
        return nIndex;
    }

    public int GetFileIndex(CFile fFile) {
        int nIndex = -1;
        if (fFile != null) {
            nIndex = this.GetFileIndex(fFile.GetPath());
        }
        return nIndex;
    }

    public boolean GetSortWhileAddingItems() {
        return this.m_bSortWhileAddingItems;
    }

    public void SetSortWhileAddingItems(boolean bEnable) {
        this.m_bSortWhileAddingItems = bEnable;
    }
}

