/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.base.gui;

import com.rhinosoft.fvjv.gui.frames.CMainFrame;
import com.rhinosoft.fvjv.strings.CString;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class CSoundMachine
implements LineListener,
MetaEventListener {
    public static boolean DEBUG = CMainFrame.DEBUG;
    private File m_fSoundFile;
    private boolean m_bMediaIsRunning = false;
    private Object m_CurrentSound = null;
    private Clip m_Clip = null;
    private Sequencer m_Sequencer = null;

    protected void finalize() throws Throwable {
        this.CloseAll();
        super.finalize();
    }

    public void OnDestroy() {
        this.CloseAll();
    }

    private Sequencer InitSequencer() {
        block3: {
            try {
                this.m_Sequencer = MidiSystem.getSequencer();
            }
            catch (Exception ex) {
                if (!DEBUG) break block3;
                ex.printStackTrace();
            }
        }
        if (this.m_Sequencer != null) {
            this.m_Sequencer.addMetaEventListener(this);
        }
        return this.m_Sequencer;
    }

    private void DestroySequencer() {
        if (this.m_Sequencer != null) {
            this.m_Sequencer.removeMetaEventListener(this);
            this.m_Sequencer = null;
        }
    }

    private Sequencer GetSequencer() {
        return this.m_Sequencer;
    }

    private boolean IsValidSoundFile(String sAbsPathToSoundFile) {
        String sFileExt;
        File fLocalSoundFile;
        boolean bIsValid = false;
        if (sAbsPathToSoundFile != null && !sAbsPathToSoundFile.isEmpty() && (fLocalSoundFile = new File(sAbsPathToSoundFile)).exists() && !fLocalSoundFile.isDirectory() && (sFileExt = CString.GetFileExtension(sAbsPathToSoundFile, false, false)) != null && !sFileExt.isEmpty()) {
            bIsValid = CSoundMachine.IsSupportedSoundExt(sFileExt);
        }
        return bIsValid;
    }

    public static boolean IsSupportedSoundExt(String sFileExt) {
        boolean bIsSupported = false;
        if (sFileExt != null && !sFileExt.isEmpty()) {
            sFileExt = sFileExt.toLowerCase();
            String[] asSupportedExts = new String[]{"wav", "aif", "au", "rmf", "mid"};
            for (int nIdx = 0; nIdx < asSupportedExts.length; ++nIdx) {
                if (!sFileExt.equals(asSupportedExts[nIdx])) continue;
                bIsSupported = true;
                break;
            }
        }
        return bIsSupported;
    }

    private void OpenAudioStream() {
        this.CloseAudioStream();
        if (this.m_fSoundFile != null && this.m_fSoundFile.exists()) {
            try {
                this.m_CurrentSound = AudioSystem.getAudioInputStream(this.m_fSoundFile);
            }
            catch (Exception e1) {
                try {
                    FileInputStream is = new FileInputStream(this.m_fSoundFile);
                    this.m_CurrentSound = new BufferedInputStream(is, 1024);
                }
                catch (Exception e3) {
                    block24: {
                        if (DEBUG) {
                            e3.printStackTrace();
                        }
                        try {
                            if (this.m_CurrentSound instanceof BufferedInputStream) {
                                ((BufferedInputStream)this.m_CurrentSound).close();
                            }
                        }
                        catch (Exception e4) {
                            if (!DEBUG) break block24;
                            e4.printStackTrace();
                        }
                    }
                    this.CloseAudioStream();
                }
            }
            if (this.m_CurrentSound instanceof AudioInputStream) {
                try {
                    AudioInputStream stream = (AudioInputStream)this.m_CurrentSound;
                    AudioFormat format = stream.getFormat();
                    if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                        AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                        stream = AudioSystem.getAudioInputStream(tmp, stream);
                        format = tmp;
                    }
                    DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
                    this.m_Clip = (Clip)AudioSystem.getLine(info);
                    this.m_Clip.addLineListener(this);
                    this.m_Clip.open(stream);
                    this.m_CurrentSound = this.m_Clip;
                }
                catch (Exception ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                    }
                    this.CloseAudioStream();
                }
            } else if (this.m_CurrentSound instanceof Sequence || this.m_CurrentSound instanceof BufferedInputStream) {
                try {
                    Sequencer rSequencer = this.InitSequencer();
                    if (rSequencer != null) {
                        rSequencer.open();
                        if (this.m_CurrentSound instanceof Sequence) {
                            rSequencer.setSequence((Sequence)this.m_CurrentSound);
                        } else {
                            rSequencer.setSequence((BufferedInputStream)this.m_CurrentSound);
                        }
                    }
                }
                catch (InvalidMidiDataException imde) {
                    if (DEBUG) {
                        System.out.println("Unsupported audio file.");
                    }
                    this.CloseAudioStream();
                }
                catch (Exception ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                    }
                    this.CloseAudioStream();
                }
            }
        }
    }

    public boolean PlaySoundFile() {
        this.OpenAudioStream();
        if (this.m_CurrentSound instanceof Sequence || this.m_CurrentSound instanceof BufferedInputStream) {
            Sequencer rSequencer = this.GetSequencer();
            if (rSequencer != null) {
                rSequencer.start();
                this.m_bMediaIsRunning = true;
            }
        } else if (this.m_CurrentSound instanceof Clip) {
            Clip clip = (Clip)this.m_CurrentSound;
            clip.start();
            this.m_bMediaIsRunning = true;
        }
        return this.m_bMediaIsRunning;
    }

    private synchronized void CloseAudioStream() {
        block5: {
            try {
                if (this.m_Clip != null) {
                    if (this.m_Clip.isOpen()) {
                        this.m_Clip.close();
                    }
                    this.m_Clip.removeLineListener(this);
                }
                if (this.m_Sequencer != null && this.m_Sequencer.isOpen()) {
                    this.m_Sequencer.close();
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                e.printStackTrace();
            }
        }
        this.DestroySequencer();
        this.m_Clip = null;
        this.m_CurrentSound = null;
        this.m_bMediaIsRunning = false;
    }

    private void CloseAll() {
        this.CloseAudioStream();
        if (this.m_fSoundFile != null) {
            this.m_fSoundFile = null;
        }
    }

    public boolean SetSoundFile(String sAbsPathToSoundFile) {
        this.CloseAll();
        if (this.IsValidSoundFile(sAbsPathToSoundFile)) {
            this.m_fSoundFile = new File(sAbsPathToSoundFile);
        }
        return this.m_fSoundFile != null;
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP) {
            this.CloseAudioStream();
        }
    }

    @Override
    public void meta(MetaMessage message) {
        if (message.getType() == 47) {
            this.CloseAudioStream();
        }
    }
}

